/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.attcalculate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.license.WTCCertCommonHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuth;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;

public class AttCalculateService
implements IAttCalculateConstants {
    private static final Log logger = LogFactory.getLog(AttCalculateService.class);
    private static final HRBaseServiceHelper RESULT_HELPER = new HRBaseServiceHelper("wtte_calresult");
    private static final HRBaseServiceHelper CALCULATE_RECORD_HELPER = new HRBaseServiceHelper("wtte_calculate_record");

    public static long updateCalResult(DynamicObject pageDy, HRPageCache cache) {
        return AttCalculateService.saveOneCalResult(AttCalculateService.getCalResultDy(pageDy, cache));
    }

    public static long saveOneCalResult(DynamicObject resultObject) {
        DynamicObject resultDy = (DynamicObject)RESULT_HELPER.saveOne(resultObject);
        return resultDy.getLong("id");
    }

    private static DynamicObject getCalResultDy(DynamicObject pageDy, HRPageCache cache) {
        Long id = DB.genGlobalLongId();
        DynamicObject resultObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_calresult"));
        resultObject.set("id", (Object)id);
        resultObject.set("taskid", (Object)id);
        pageDy.set("id", (Object)id);
        resultObject.set("begindate", (Object)pageDy.getDate("startdate"));
        resultObject.set("enddate", (Object)pageDy.getDate("enddate"));
        resultObject.set("version", (Object)pageDy.getString("version"));
        resultObject.set("evaproperty", (Object)"2");
        resultObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        resultObject.set("createtime", (Object)new Date());
        resultObject.set("savestep", pageDy.get("savestep"));
        resultObject.set("desc", pageDy.get("desc"));
        resultObject.set("planid", pageDy.get("planid"));
        resultObject.set("org", pageDy.get("org"));
        return resultObject;
    }

    public static boolean buildPageCache(Object[] attFileIds, HRPageCache pageCache) {
        List attFileIdList;
        List attFileAuthList;
        Map shardingList;
        logger.info("AttCalculateService buildPageCache get ids:{}", attFileIds);
        HashSet set = (HashSet)pageCache.get("ids", Set.class);
        HashSet<Long> boIdSet = (HashSet<Long>)pageCache.get("boids", Set.class);
        if (set == null) {
            set = new HashSet();
        }
        if (boIdSet == null) {
            boIdSet = new HashSet<Long>(16);
        }
        if (CollectionUtils.isEmpty((Map)(shardingList = (Map)pageCache.get("personMap", Map.class)))) {
            shardingList = Maps.newHashMapWithExpectedSize((int)attFileIds.length);
        }
        Map<Object, Object> boid2Fid = Maps.newHashMapWithExpectedSize((int)set.size());
        if (!CollectionUtils.isEmpty(set)) {
            List cacheDyn = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(WTCStringUtils.joinOnComma((String[])new String[]{"boid", "id"}), new ArrayList(set));
            boid2Fid = cacheDyn.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("boid"), Collectors.collectingAndThen(Collectors.toList(), value -> WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).get()).getLong("id") : 0L)));
        }
        if (CollectionUtils.isEmpty((Collection)(attFileAuthList = AttFileF7Utils.getAttFileAuthList(attFileIdList = Arrays.stream(attFileIds).map(info -> (Long)info).collect(Collectors.toList()))))) {
            return true;
        }
        HashMap<Long, AttFileAuth> boId2AttFileAuthCluster = new HashMap<Long, AttFileAuth>(attFileAuthList.size());
        for (AttFileAuth auth : attFileAuthList) {
            Long boId = auth.getAttFile().getBoid();
            boId2AttFileAuthCluster.put(boId, auth);
        }
        HashSet<Long> attFileBaseIds = new HashSet<Long>(attFileAuthList.size());
        HashMap<Long, Map<String, Object>> filePersonMap = new HashMap<Long, Map<String, Object>>(attFileAuthList.size());
        for (Map.Entry entry : boId2AttFileAuthCluster.entrySet()) {
            AttFileAuth attFileAuth = (AttFileAuth)entry.getValue();
            Long boid = attFileAuth.getAttFile().getBoid();
            Long fid = (Long)boid2Fid.get(boid);
            boIdSet.add(boid);
            if (fid != null) {
                set.remove(fid);
                shardingList.remove(boid);
            }
            Map param = HRAuthUtil.getAuthFieldByAttFile((AttFileAuth)attFileAuth);
            filePersonMap.put(boid, param);
            attFileBaseIds.add(attFileAuth.getAttFile().getVid());
        }
        logger.info("AttCalculateService buildPageCache put ids:{}", set);
        logger.info("AttCalculateService buildPageCache put attFileBaseIds:{}", attFileBaseIds);
        pageCache.put("ids", set);
        pageCache.put("personMap", (Object)shardingList);
        AttCalculateService.appendAttFileBaseIds2Cache(attFileBaseIds, pageCache);
        AttCalculateService.appendAttShareCache(filePersonMap, pageCache);
        AttCalculateService.appendAttFileBoIds2Cache(boIdSet, pageCache);
        return false;
    }

    public static void appendAttShareCache(Map<Long, Map<String, Object>> sharding, HRPageCache pageCache) {
        Map shardingList = (Map)pageCache.get("personMap", Map.class);
        if (CollectionUtils.isEmpty((Map)shardingList)) {
            pageCache.put("personMap", sharding);
        } else {
            shardingList.putAll(sharding);
            pageCache.put("personMap", (Object)shardingList);
        }
    }

    public static void appendAttFileBaseIds2Cache(Set<Long> attFileBaseIds, HRPageCache pageCache) {
        Set set = (Set)pageCache.get("ids", Set.class);
        if (CollectionUtils.isEmpty((Collection)set)) {
            pageCache.put("ids", attFileBaseIds);
        } else {
            set.addAll(attFileBaseIds);
            pageCache.put("ids", (Object)set);
        }
    }

    private static void appendAttFileBoIds2Cache(Set<Long> attFileBoIds, HRPageCache pageCache) {
        Set set = (Set)pageCache.get("boids", Set.class);
        if (CollectionUtils.isEmpty((Collection)set)) {
            pageCache.put("boids", attFileBoIds);
        } else {
            set.addAll(attFileBoIds);
            pageCache.put("boids", (Object)set);
        }
    }

    public static Map<String, Object> dynToReqMap(DynamicObject dyn, Long taskId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("number", taskId);
        paramMap.put("name", ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"AttCalculateService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        paramMap.put("saveStep", dyn.getBoolean("savestep"));
        paramMap.put("planId", dyn.getLong("planid.id"));
        return paramMap;
    }

    @Deprecated
    public static void startTask(WTCTaskRequestStd request, IFormView view, CloseCallBack closeCallBack) {
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setCaption(ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"AttCalculateService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        taskForm.setTaskRequest((WTCTaskRequest)request);
        taskForm.setClickClassName("");
        WTCDistributeTaskHelper.showProgress((IFormView)view, (CloseCallBack)closeCallBack, (String)ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"AttCalculateService_0", (String)"wtc-wtte-business", (Object[])new Object[0]), (String)"wtte_tie", (Object)taskForm);
    }

    public static Map<String, Object> checkCertReturnMsg(String appid, String formid, Map<String, List<Long>> idMap) {
        List<Long> disableIds = idMap.get("disabledIds");
        List<Long> effectIds = idMap.get("effectIds");
        logger.info("AttCalculateService effectIds:{}", effectIds);
        Map checkMap = WTCCertCommonHelper.certCheckNoAddByAttPerson((String)"1C8H4/N38LCY", (String)"wtte_evaluationlog", effectIds);
        logger.info("AttCalculateService disabledIds:{}", disableIds);
        WTCCertCommonHelper.certFakeCheckByAttPerson((String)appid, (String)formid, disableIds);
        logger.info("AttCalculateService checkCertReturnMsg:{}", (Object)JSON.toJSONString((Object)checkMap));
        return checkMap;
    }
}

