/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.attcalculate;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.caltask.common.tie.TieDetailStatus;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.common.constants.ExportTaskConstants;

public class TieTaskExportService
implements ExportTaskConstants {
    private static final Log LOGGER = LogFactory.getLog(TieTaskExportService.class);
    public static final String PROPERTIES = "wtc-wtte-business";
    public static final Set<String> DATE_FIELDS = Sets.newHashSet((Object[])new String[]{"accountto", "lockto", "attfile.bsed", "attfile.bsled", "realcalstartdate", "realcalenddate"});
    public static final QFilter SUCCESS_FILTER = new QFilter("tiestatus", "=", (Object)TieDetailStatus.SUCCESS.code);
    public static final QFilter FAIL_FILTER = new QFilter("tiestatus", "=", (Object)TieDetailStatus.FAIL.code);
    public static final QFilter ACCOUNT_FILTER = new QFilter("tiestatus", "in", (Object)TieDetailStatus.allLegalStatusCode());
    public static final QFilter NOT_ACCOUNT_FILTER = new QFilter("tiestatus", "not in", (Object)TieDetailStatus.allLegalStatusCode());
    public static final Set<String> notExit;
    public static final List<String> accountOrder;
    public static final List<String> successOrder;
    public static final List<String> failOrder;
    public static final List<String> notAccountOrder;
    public static final Set<String> accountHideFiled;
    public static final Set<String> successHideFiled;
    public static final Set<String> failHideFiled;
    public static final Set<String> notAccountHideFiled;
    public static final Map<String, String> EXPORT_FILE;
    public static final String WTTE_INFO_PROPERTIES = "id,fileboid,accountto,lockto";

    private static String getTabName(String tabKey) {
        switch (tabKey) {
            case "successaccounttab": {
                return ResManager.loadKDString((String)"\u6210\u529f", (String)"TieTaskExportService_25", (String)PROPERTIES, (Object[])new Object[0]);
            }
            case "failaccounttab": {
                return ResManager.loadKDString((String)"\u5931\u8d25", (String)"TieTaskExportService_26", (String)PROPERTIES, (Object[])new Object[0]);
            }
            case "notaccounttab": {
                return ResManager.loadKDString((String)"\u672a\u6267\u884c\u6863\u6848\u6570", (String)"TieTaskExportService_27", (String)PROPERTIES, (Object[])new Object[0]);
            }
            case "accounttab": {
                return ResManager.loadKDString((String)"\u6267\u884c\u6863\u6848\u6570", (String)"TieTaskExportService_28", (String)PROPERTIES, (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String getFileName(String version, String tabKey) {
        String formatName = "%s_%s_%s_%s";
        String firstName = ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"TieTaskExportService_23", (String)PROPERTIES, (Object[])new Object[0]);
        String nowStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return String.format(Locale.ROOT, formatName, firstName, version, TieTaskExportService.getTabName(tabKey), nowStr);
    }

    public static String getQtFileName(String version, String tabKey) {
        String formatName = "%s_%s_%s_%s";
        String firstName = ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"TieTaskExportService_24", (String)PROPERTIES, (Object[])new Object[0]);
        String nowStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return String.format(Locale.ROOT, formatName, firstName, version, TieTaskExportService.getTabName(tabKey), nowStr);
    }

    public static String getQtDcFileName(String version, String tabKey) {
        String formatName = "%s_%s_%s_%s";
        String firstName = ResManager.loadKDString((String)"\u5b9a\u989d\u6263\u51cf", (String)"TieTaskExportService_30", (String)PROPERTIES, (Object[])new Object[0]);
        String nowStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return String.format(Locale.ROOT, formatName, firstName, version, TieTaskExportService.getTabName(tabKey), nowStr);
    }

    public static List<Map<String, Object>> buildRowToMap(Object[] rows, String taskCategory) {
        DynamicObject[] wtcTaskDetail = WTCTaskServiceHelper.batchLoadTaskDetailDynByPK((String)taskCategory, (Object[])rows);
        List<Map<String, Object>> detailList = Arrays.stream(wtcTaskDetail).map(dyn -> {
            HashMap detailMap = Maps.newHashMapWithExpectedSize((int)16);
            detailMap.put("attPersonId", dyn.getLong("attperson.id"));
            detailMap.put("attFileId", dyn.getLong("attfile.id"));
            detailMap.put("attFileBoId", dyn.getLong("attfileboid.id"));
            detailMap.put("depEmpJobId", dyn.getLong("attpersonjob.id"));
            detailMap.put("attTagId", dyn.getLong("atttag.id"));
            detailMap.put("org", dyn.getLong("org.id"));
            return detailMap;
        }).collect(Collectors.toList());
        return detailList;
    }

    static {
        EXPORT_FILE = Maps.newHashMap();
        EXPORT_FILE.put("attperson.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"TieTaskExportService_0", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attperson.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"TieTaskExportService_1", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.number", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"TieTaskExportService_2", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("org.name", ResManager.loadKDString((String)"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7", (String)"TieTaskExportService_3", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.empgroup.name", ResManager.loadKDString((String)"\u8003\u52e4\u4eba\u5458\u7ec4", (String)"TieTaskExportService_4", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.affiliateadminorg.name", ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"TieTaskExportService_5", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.company.name", ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"TieTaskExportService_6", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.adminorg.name", ResManager.loadKDString((String)"\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7", (String)"TieTaskExportService_7", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.job.name", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"TieTaskExportService_8", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.position.name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"TieTaskExportService_9", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.managingscope.name", ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u8303\u56f4", (String)"TieTaskExportService_10", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.agreedlocation.name", ResManager.loadKDString((String)"\u534f\u8bae\u5de5\u4f5c\u5730", (String)"TieTaskExportService_11", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.dependencytype.name", ResManager.loadKDString((String)"\u5c5e\u5730\u5458\u5de5\u7c7b\u522b", (String)"TieTaskExportService_12", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.workplace.name", ResManager.loadKDString((String)"\u8003\u52e4\u5730\u70b9", (String)"TieTaskExportService_13", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("accountto", ResManager.loadKDString((String)"\u5df2\u6838\u7b97\u81f3", (String)"TieTaskExportService_14", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("lockto", ResManager.loadKDString((String)"\u5df2\u9501\u5b9a\u81f3", (String)"TieTaskExportService_15", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.bsed", ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65e5\u671f", (String)"TieTaskExportService_16", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("attfile.bsled", ResManager.loadKDString((String)"\u6863\u6848\u5931\u6548\u65e5\u671f", (String)"TieTaskExportService_17", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("atttag.attendstatus", ResManager.loadKDString((String)"\u8003\u52e4\u72b6\u6001", (String)"TieTaskExportService_18", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("tiestatus", ResManager.loadKDString((String)"\u6838\u7b97\u72b6\u6001", (String)"TieTaskExportService_19", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("realcalstartdate", ResManager.loadKDString((String)"\u5b9e\u9645\u6838\u7b97\u5f00\u59cb\u65e5\u671f", (String)"TieTaskExportService_20", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("realcalenddate", ResManager.loadKDString((String)"\u5b9e\u9645\u6838\u7b97\u7ed3\u675f\u65e5\u671f", (String)"TieTaskExportService_21", (String)PROPERTIES, (Object[])new Object[0]));
        EXPORT_FILE.put("exinfo", ResManager.loadKDString((String)"\u5f02\u5e38\u539f\u56e0", (String)"TieTaskExportService_22", (String)PROPERTIES, (Object[])new Object[0]));
        notExit = Collections.unmodifiableSet(Stream.of("accountto", "lockto").collect(Collectors.toSet()));
        accountOrder = Collections.unmodifiableList(Arrays.asList("operate", "tiestatus", "attperson.name", "attperson.number", "attfile.number", "org.name", "attfile.managingscope.name", "attfile.company.name", "attfile.adminorg.name", "attfile.affiliateadminorg.name", "attfile.empgroup.name", "attfile.dependency.name", "attfile.dependencytype.name", "attfile.agreedlocation.name", "attfile.workplace.name", "attfile.job.name", "attfile.position.name", "accountto", "lockto", "attfilestartdate", "attfileenddate", "atttag.attendstatus", "allowreaccounttime", "realcalstartdate", "realcalenddate", "exinfo"));
        successOrder = Collections.unmodifiableList(Arrays.asList("operate", "attperson.name", "attperson.number", "attfile.number", "org.name", "attfile.managingscope.name", "attfile.company.name", "attfile.adminorg.name", "attfile.affiliateadminorg.name", "attfile.empgroup.name", "attfile.dependency.name", "attfile.dependencytype.name", "attfile.agreedlocation.name", "attfile.workplace.name", "attfile.job.name", "attfile.position.name", "accountto", "lockto", "attfilestartdate", "attfileenddate", "atttag.attendstatus", "allowreaccounttime", "tiestatus", "realcalstartdate", "realcalenddate", "exinfo"));
        failOrder = Collections.unmodifiableList(Arrays.asList("operate", "attperson.name", "attperson.number", "attfile.number", "org.name", "attfile.managingscope.name", "attfile.company.name", "attfile.adminorg.name", "attfile.affiliateadminorg.name", "attfile.empgroup.name", "attfile.dependency.name", "attfile.dependencytype.name", "attfile.agreedlocation.name", "attfile.workplace.name", "attfile.job.name", "attfile.position.name", "accountto", "lockto", "attfilestartdate", "attfileenddate", "atttag.attendstatus", "allowreaccounttime", "tiestatus", "realcalstartdate", "realcalenddate", "exinfo"));
        notAccountOrder = Collections.unmodifiableList(Arrays.asList("operate", "attperson.name", "attperson.number", "attfile.number", "org.name", "attfile.managingscope.name", "attfile.company.name", "attfile.adminorg.name", "attfile.affiliateadminorg.name", "attfile.empgroup.name", "attfile.dependency.name", "attfile.dependencytype.name", "attfile.agreedlocation.name", "attfile.workplace.name", "attfile.job.name", "attfile.position.name", "accountto", "lockto", "attfilestartdate", "attfileenddate", "atttag.attendstatus", "allowreaccounttime", "exinfo"));
        accountHideFiled = Collections.unmodifiableSet(Arrays.asList("attfile.number", "attfile.managingscope.name", "attfile.affiliateadminorg.name", "attfile.empgroup.name", "attfile.dependency.name", "attfile.dependencytype.name", "attfile.agreedlocation.name", "attfile.workplace.name", "attfilestartdate", "attfileenddate", "atttag.attendstatus", "allowreaccounttime").stream().collect(Collectors.toSet()));
        successHideFiled = accountHideFiled;
        failHideFiled = accountHideFiled;
        notAccountHideFiled = Collections.unmodifiableSet(Arrays.asList("attfile.number", "attfile.managingscope.name", "attfile.dependency.name", "attfile.dependencytype.name", "attfile.agreedlocation.name", "attfile.workplace.name", "attfilestartdate", "attfileenddate", "atttag.attendstatus", "allowreaccounttime").stream().collect(Collectors.toSet()));
    }
}

