/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.attrecord;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class AttRecordSysParamUpgradeService {
    private static final Log LOG = LogFactory.getLog(AttRecordSysParamUpgradeService.class);
    private static final String QUERY_BAS_SYSPARAM_SQL = "select fid,forgid,fdata from t_bas_sysparameter where fparamid in (select fid from t_bas_sysparaconsole where fformid ='wtte_attrecordparam' and fenabled ='1') and fviewtypeid ='26';";
    private static final String UPATE_BAS_SYSPARAM_SQL = "update t_bas_sysparameter set fdata = ? where fid = ?;";
    private static final int DEFAULT_MAX_HIS_VERSION_VALUE = 5;
    private static final String MAX_HIS_VERSION = "maxhisversion";

    public void upgrade() {
        DBRoute sysDbRoute = new DBRoute("sys");
        ArrayList updateParamList = Lists.newArrayListWithExpectedSize((int)16);
        DataSet basSysParamDataSet = HRDBUtil.queryDataSet((String)"bas", (DBRoute)sysDbRoute, (String)QUERY_BAS_SYSPARAM_SQL, null);
        while (basSysParamDataSet.hasNext()) {
            Integer maxHisVersion;
            JSONObject dataObj;
            Row row = basSysParamDataSet.next();
            String data = row.getString("fdata");
            if (!HRStringUtils.isNotEmpty((String)data) || !(dataObj = JSONObject.parseObject((String)data)).containsKey((Object)MAX_HIS_VERSION) || (maxHisVersion = dataObj.getInteger(MAX_HIS_VERSION)) != null && maxHisVersion.compareTo(5) <= 0) continue;
            dataObj.put(MAX_HIS_VERSION, (Object)5);
            updateParamList.add(new Object[]{dataObj.toJSONString(), row.getString("fid")});
        }
        if (WTCCollections.isNotEmpty((Collection)updateParamList)) {
            try {
                HRDBUtil.executeBatch((DBRoute)sysDbRoute, (String)UPATE_BAS_SYSPARAM_SQL, (List)updateParamList);
            }
            catch (Exception ex) {
                LOG.warn("AttRecordSysParamUpgrade.process error", (Throwable)ex);
                throw new KDException((Throwable)ex, new ErrorCode(" AttRecordSysParamUpgrade error", "AttRecordSysParamUpgrade.process error"), new Object[0]);
            }
        }
    }
}

