/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.attreport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.license.WTCCertCommonHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtte.business.attreport.AttReportService;

public class ReportListHelper {
    private static final Log LOGGER = LogFactory.getLog(WTCCertCommonHelper.class);
    public static final ReportListHelper INSTANCE = (ReportListHelper)WTCAppContextHelper.getBean(ReportListHelper.class);
    private final int maxInSize = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtte.attreport.maxInSize", 1000);
    private final int tempTableThreshold = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtte.attreport.tempTableThreshold", 1000);

    public static ReportListHelper getInstance() {
        return INSTANCE;
    }

    private String grouping(Map<String, String> kv, String groupBy) {
        String tmp = groupBy.replaceAll("group|by|GROUP|BY|Group|By", "");
        String[] split = tmp.split(",");
        List fields = Arrays.stream(split).map(s -> (String)kv.get(s.trim().toLowerCase())).collect(Collectors.toList());
        return String.join((CharSequence)", ", fields);
    }

    private String ordering(Map<String, String> kv, String orderBy) {
        String tmp = orderBy.replaceAll("order|by|ORDER|BY|Order|By", "");
        String[] split = tmp.split(",");
        List fields = Arrays.stream(split).map(s -> {
            Object[] fad = s.trim().split(" ");
            if (fad.length != 1 && fad.length != 2) {
                throw new KDBizException(orderBy + " error");
            }
            return fad.length == 1 ? (String)kv.get(s.trim().toLowerCase()) : (String)kv.get(WTCCollectionIndexUtil.getEleFromArr((Object[])fad, (int)0).isPresent() ? ((String)WTCCollectionIndexUtil.getEleFromArr((Object[])fad, (int)0).get()).trim().toLowerCase() : "") + " " + (WTCCollectionIndexUtil.getEleFromArr((Object[])fad, (int)1).isPresent() ? ((String)WTCCollectionIndexUtil.getEleFromArr((Object[])fad, (int)1).get()).toLowerCase() : "");
        }).collect(Collectors.toList());
        return String.join((CharSequence)", ", fields);
    }

    private DataSet ormGroupDataSet(IDataEntityType dataEntityType, String entityNumber, QFilter[] filters, String groupBy, String orderBy) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        DataSet rows = helper.queryDataSet(this.getClass().getName() + ".ormAttRecordDataSet", groupBy, filters, orderBy).distinct();
        return rows;
    }

    private DataSet dbGroupDataSet(IDataEntityType dataEntityType, String entityNumber, QFilter[] filters, String groupBy, String orderBy) {
        KsqlValues kv = QFilterConverter.of(filters).entityType(dataEntityType).convert();
        Map<String, String> fieldMap = dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, IMetadata::getAlias));
        groupBy = this.grouping(fieldMap, groupBy);
        orderBy = this.ordering(fieldMap, orderBy);
        String sql = "select " + groupBy + " from " + dataEntityType.getAlias() + " where " + kv.getKsql() + " group by " + groupBy + " order by " + orderBy;
        DataSet rows = DB.queryDataSet((String)(this.getClass().getName() + ".dbAttrecordDataSet"), (DBRoute)DBRoute.of((String)dataEntityType.getDBRouteKey()), (String)sql, (Object[])kv.getValues().toArray());
        return rows;
    }

    private boolean isFilterCross(IDataEntityType dataEntityType, QFilter filter) {
        if (filter.getProperty().contains(".")) {
            return true;
        }
        List nests = filter.getNests(true);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return false;
        }
        for (QFilter.QFilterNest nest : nests) {
            if (nest.getFilter() == null || !nest.getFilter().getProperty().contains(".")) continue;
            return true;
        }
        return false;
    }

    private boolean isFilterCross(IDataEntityType dataEntityType, QFilter[] filters) {
        for (QFilter filter : filters) {
            if (filter == null || !this.isFilterCross(dataEntityType, filter)) continue;
            return true;
        }
        KsqlValues kv = QFilterConverter.of(filters).entityType(dataEntityType).convert();
        return kv.getValues().size() >= this.maxInSize;
    }

    private void checkFilterEmpty(QFilter[] filters) {
        if (filters == null) {
            throw new KDBizException("filters is null");
        }
        if ((filters = (QFilter[])Arrays.stream(filters).filter(Objects::nonNull).toArray(QFilter[]::new)).length == 0) {
            throw new KDBizException("filters is empty");
        }
    }

    public DataSet batchDataSet(String entityNumber, QFilter[] filters, String groupBy, String orderBy) {
        LOGGER.info("batchDataSet entityNumber:{}, filters:{}, groupBy:{}, orderBy:{}", new Object[]{entityNumber, filters, groupBy, orderBy});
        this.checkFilterEmpty(filters);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        IDataEntityType dataEntityType = helper.generateEmptyDynamicObject().getDataEntityType();
        if (this.isFilterCross(dataEntityType, filters)) {
            return this.ormGroupDataSet(dataEntityType, entityNumber, filters, groupBy, orderBy);
        }
        return this.dbGroupDataSet(dataEntityType, entityNumber, filters, groupBy, orderBy);
    }

    public DataSet queryDataSet(String entityNumber, String selects, QFilter[] filters, String orderBy) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        DataSet dataSet = hrBaseServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet", selects, filters, orderBy);
        return dataSet;
    }

    public DataSet queryDataSetSingleTable(String entityNumber, String selects, QFilter[] filters, Set<Long> mids) {
        LOGGER.info("queryDataSetSingleTable entityNumber:{}, filters:{}, mids.size:{}", new Object[]{selects, filters, mids.size()});
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        IDataEntityType dataEntityType = helper.generateEmptyDynamicObject().getDataEntityType();
        DataSet dataSet = null;
        dataSet = mids.size() >= this.tempTableThreshold ? this.queryDataSetWithTempTable(dataEntityType, selects, filters, mids) : this.queryDataSetWithIn(dataEntityType, selects, filters, mids);
        return dataSet;
    }

    private DataSet queryDataSetWithOrm(IDataEntityType dataEntityType, String selects, QFilter[] filters, Set<Long> mids) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(dataEntityType.getName());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (filters != null && filters.length != 0) {
            qFilters.addAll(Arrays.asList(filters));
        }
        if (mids.size() > 0) {
            qFilters.add(new QFilter("attmain", "in", mids));
        }
        DataSet dataSet = null;
        dataSet = hrBaseServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSetWithOrm", selects, qFilters.toArray(new QFilter[0]));
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet queryDataSetWithTempTable(IDataEntityType dataEntityType, String selects, QFilter[] filters, Set<Long> mids) {
        try (PKTempTable tempTable = null;){
            DataSet dataSet;
            Map<String, String> fieldMap = dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, IMetadata::getAlias));
            selects = selects.toLowerCase();
            List<String> fields = Arrays.asList("attitemid", "valuelong");
            for (String field : fields) {
                String value = fieldMap.get(field);
                selects = selects.replace(field.toLowerCase(), "A." + value.toLowerCase());
            }
            KsqlValues kv = QFilterConverter.of(filters).entityType(dataEntityType).alias("A").convert();
            String sql = "select " + selects + " from " + dataEntityType.getAlias() + " A inner join ";
            tempTable = PKTempTables.createPKLong((DBRoute)DBRoute.of((String)dataEntityType.getDBRouteKey()));
            tempTable.insert(mids);
            sql = sql + tempTable.getName() + " B on A.fmid = B.fid";
            sql = sql + " where " + kv.getKsql();
            DataSet dataSet2 = dataSet = DB.queryDataSet((String)(this.getClass().getName() + ".queryDataSetWithTempTable"), (DBRoute)DBRoute.of((String)dataEntityType.getDBRouteKey()), (String)sql, (Object[])kv.getValues().toArray());
            return dataSet2;
        }
    }

    private DataSet queryDataSetWithIn(IDataEntityType dataEntityType, String selects, QFilter[] filters, Set<Long> mids) {
        try {
            Map<String, String> fieldMap = dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, IMetadata::getAlias));
            selects = selects.toLowerCase();
            List<String> fields = Arrays.asList("attitemid", "valuelong");
            for (String field : fields) {
                String value = fieldMap.get(field);
                if (!WTCStringUtils.isNotEmpty((String)value)) continue;
                selects = selects.replace(field.toLowerCase(), value.toLowerCase());
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            if (filters != null && filters.length != 0) {
                qFilters.addAll(Arrays.asList(filters));
            }
            if (mids.size() > 0) {
                qFilters.add(new QFilter("attmain", "in", mids));
            }
            filters = qFilters.toArray(new QFilter[0]);
            KsqlValues kv = QFilterConverter.of(filters).entityType(dataEntityType).convert();
            String sql = "select " + selects + " from " + dataEntityType.getAlias() + " where " + kv.getKsql();
            DataSet dataSet = DB.queryDataSet((String)(this.getClass().getName() + ".queryDataSetWithIn"), (DBRoute)DBRoute.of((String)dataEntityType.getDBRouteKey()), (String)sql, (Object[])kv.getValues().toArray());
            return dataSet;
        }
        catch (Exception e) {
            LOGGER.warn("queryDataSetWithIn error, " + e.getMessage(), (Throwable)e);
            return this.queryDataSetWithOrm(dataEntityType, selects, filters, mids);
        }
    }

    public String sumAttItemSql(Set<String> itemIds) {
        StringBuilder attItemStr = new StringBuilder();
        for (String item : itemIds) {
            attItemStr.append(" sum ( case when ").append("attitemid").append(" = '").append(AttReportService.attIdDel(item)).append("'".toCharArray()).append(" then valuelong else 0 end ) as ").append(item).append(" ,");
        }
        String string = attItemStr.toString();
        return string.substring(0, string.length() - 1);
    }

    public String sumAttItemOrmSql(Set<String> itemIds) {
        StringBuilder attItemStr = new StringBuilder();
        for (String item : itemIds) {
            attItemStr.append(" sum ( case when ").append("attitemid").append(" = ").append(AttReportService.attIdDel(item)).append(" then valuelong else 0 end ) as ").append(item).append(" ,");
        }
        String string = attItemStr.toString();
        return string.substring(0, string.length() - 1);
    }

    public String sumAttItemSqlDB(Set<String> itemIds) {
        StringBuilder attItemStr = new StringBuilder();
        for (String item : itemIds) {
            attItemStr.append(" sum ( case when ").append("attitemid").append(" = ").append(AttReportService.attIdDel(item)).append(" then valuelong else 0 end ) as \"").append(item).append("\" ,");
        }
        String string = attItemStr.toString();
        return string.substring(0, string.length() - 1);
    }

    public Object[] convertSumRow(RowMeta rowMeta, DataSet sumDataSet) {
        Field field;
        int i;
        Field[] fields;
        Object[] row;
        HashMap<String, BigDecimal> sums = new HashMap<String, BigDecimal>(1);
        while (sumDataSet.hasNext()) {
            row = sumDataSet.next();
            fields = sumDataSet.getRowMeta().getFields();
            for (i = 0; i < fields.length; ++i) {
                field = fields[i];
                sums.put(field.getName(), row.getBigDecimal(i));
            }
        }
        row = new Object[rowMeta.getFields().length];
        fields = rowMeta.getFields();
        for (i = 0; i < fields.length; ++i) {
            field = fields[i];
            BigDecimal value = (BigDecimal)sums.get(field.getName());
            row[i] = value;
        }
        return row;
    }

    public static DataSet localCommonSet(DataSet dataSet, DataSet sumSet, Map<String, String> fieldMap) {
        dataSet = dataSet.addField("''", "seq");
        dataSet = dataSet.addField("1", "rowtype").addField(ResManager.loadKDString((String)"'\u6838\u7b97\u8be6\u60c5'", (String)"ReportListHelper_2", (String)"wtc-wtte-business", (Object[])new Object[0]), "viewDetails");
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            dataSet = dataSet.addField(entry.getValue(), entry.getKey());
        }
        if (sumSet != null) {
            sumSet = ReportListHelper.formatFirstRowSum(sumSet, fieldMap);
            dataSet = sumSet.union(dataSet);
        }
        dataSet = dataSet.orderBy(new String[]{"rowtype desc"});
        return dataSet;
    }

    public static DataSet formatFirstRowSum(DataSet ds, Map<String, String> fieldMap) {
        String msg = ResManager.loadKDString((String)"\u5168\u90e8\u603b\u8ba1", (String)"ReportListHelper_1", (String)"wtc-wtte-business", (Object[])new Object[0]);
        ds = ds.addField("'" + msg + "'", "seq");
        ds = ds.addField("2", "rowtype").addField("''", "viewDetails");
        for (String alias : fieldMap.keySet()) {
            ds = ds.addField("''", alias);
        }
        return ds;
    }

    public boolean checkContainItemFile(QFilter qFilter) {
        boolean flag;
        boolean bl = flag = null != qFilter && (qFilter.toString().contains("attitemid") || qFilter.toString().contains("valuestring") || qFilter.toString().contains("attitemtype") || qFilter.toString().contains("value") || qFilter.toString().contains("valuesecond") || qFilter.toString().contains("valuelong") || qFilter.toString().contains("sourceattitemids"));
        return flag;
    }

    public boolean checkContainItemFile(QFilter[] baseFilters) {
        for (QFilter baseFilter : baseFilters) {
            if (!this.checkContainItemFile(baseFilter)) continue;
            return true;
        }
        return false;
    }

    public QFilter changeToBaseQFilter(QFilter qFilter) {
        if (null == qFilter) {
            return null;
        }
        qFilter.setProperty(qFilter.getProperty().replace("attmain.", ""));
        if (!CollectionUtils.isEmpty((Collection)qFilter.getNests(true))) {
            for (QFilter.QFilterNest nest : qFilter.getNests(true)) {
                QFilter nestFilter = nest.getFilter();
                if (null == nestFilter) continue;
                nestFilter.setProperty(nestFilter.getProperty().replace("attmain.", ""));
            }
        }
        return qFilter;
    }

    public QFilter changeToDetailQFilter(QFilter qFilter) {
        if (null == qFilter) {
            return null;
        }
        qFilter.setProperty("attmain." + qFilter.getProperty());
        if (!CollectionUtils.isEmpty((Collection)qFilter.getNests(true))) {
            for (QFilter.QFilterNest nest : qFilter.getNests(true)) {
                QFilter nestFilter = nest.getFilter();
                if (null == nestFilter) continue;
                nestFilter.setProperty("attmain." + nestFilter.getProperty());
            }
        }
        return qFilter;
    }

    public void clearMain(List<QFilter> qFilters) {
        for (QFilter qFilter : qFilters) {
            this.changeToBaseQFilter(qFilter);
        }
    }

    public void clearMain(QFilter[] qFilters) {
        for (QFilter qFilter : qFilters) {
            this.changeToBaseQFilter(qFilter);
        }
    }

    public List<QFilter> getItemFilters(QFilter[] qFilters) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)10);
        for (QFilter qFilter : qFilters) {
            QFilter qFilterCopy = qFilter.__copy(false);
            if (this.checkContainItemFile(qFilterCopy)) {
                list.add(qFilterCopy);
            }
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter filter = nest.getFilter();
                if (null == filter || !this.checkContainItemFile(filter)) continue;
                list.add(filter);
            }
        }
        return list;
    }

    private static class QFilterConverter {
        private final QFilter baseFilter;
        private List<Object> values;
        private IDataEntityType entityType;
        private Map<String, String> fieldMap;
        private String tableAlias;

        public QFilterConverter(QFilter delegate) {
            this.baseFilter = delegate;
        }

        private static QFilterConverter of(QFilter filter) {
            return new QFilterConverter(filter);
        }

        private static QFilterConverter of(QFilter[] filters) {
            QFilter filter = QFilter.of((String)"1 = ?", (Object[])new Object[]{1});
            for (QFilter qFilter : filters) {
                if (qFilter == null) continue;
                filter.and(qFilter);
            }
            return new QFilterConverter(filter);
        }

        public QFilterConverter entityType(IDataEntityType type) {
            this.entityType = type;
            this.fieldMap = this.entityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, IMetadata::getAlias));
            return this;
        }

        private String toAlias(String name) {
            if ("1".equals(name)) {
                return "1";
            }
            if (WTCStringUtils.isNotEmpty((String)this.tableAlias)) {
                return this.tableAlias + '.' + this.fieldMap.get(name);
            }
            return this.fieldMap.getOrDefault(name, name);
        }

        private void doConvert(StringBuilder sb, QFilter filter) {
            if (filter.isJoinSQLFilter()) {
                throw new KDBizException("not support join");
            }
            QParameter params = this.getInQParameter(filter.getValue());
            String lcp = filter.getCP();
            if (filter.isExpressValue()) {
                sb.append(this.toAlias(filter.getProperty())).append(' ').append(lcp);
                sb.append(" ?");
                this.values.add(filter.getValue());
            } else if (!lcp.equalsIgnoreCase("in") && !lcp.equalsIgnoreCase("not in")) {
                sb.append(this.toAlias(filter.getProperty())).append(' ').append(lcp);
                sb.append(" ?");
                this.values.add(filter.getValue());
            } else {
                if (params == null) {
                    throw new KDBizException(filter.getProperty() + "  with in condition must input value");
                }
                sb.append(this.toAlias(filter.getProperty())).append(' ').append(lcp);
                Object[] array = params.getParameters();
                ArrayList<String> qms = new ArrayList<String>(array.length);
                sb.append(" (");
                for (Object one : array) {
                    this.values.add(one);
                    qms.add("?");
                }
                sb.append(String.join((CharSequence)", ", qms));
                sb.append(')');
            }
            List nests = filter.getNests(false);
            if (!nests.isEmpty()) {
                this.resloveNests(nests, sb, nest -> {
                    sb.append(' ').append(nest.getOp()).append(' ');
                    QFilter nestQFilter = nest.getFilter();
                    KsqlValues kv = QFilterConverter.of(nestQFilter).entityType(this.entityType).alias(this.tableAlias).convert();
                    sb.append(kv.getKsql());
                    this.values.addAll(kv.getValues());
                    return null;
                });
            }
        }

        private void resloveNests(List<QFilter.QFilterNest> nests, StringBuilder s, Function<QFilter.QFilterNest, Void> nestFun) {
            boolean withOr = false;
            boolean allOr = true;
            for (QFilter.QFilterNest nest : nests) {
                if (nest.isAnd()) {
                    allOr = false;
                    continue;
                }
                withOr = true;
            }
            if (withOr) {
                s.insert(0, '(');
            }
            if (allOr) {
                for (QFilter.QFilterNest nest : nests) {
                    nestFun.apply(nest);
                }
            } else {
                boolean preIsAnd = true;
                for (QFilter.QFilterNest next : nests) {
                    boolean and = next.isAnd();
                    if (!preIsAnd && and) {
                        s.insert(0, '(');
                        s.append(')');
                    }
                    nestFun.apply(next);
                    preIsAnd = and;
                }
            }
            if (withOr) {
                s.append(')');
            }
        }

        private String multiParamsSQL(int c) {
            StringBuilder s = new StringBuilder(c * 2);
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                s.append('?');
            }
            return s.toString();
        }

        private QParameter getInQParameter(Object value) {
            if (value == null) {
                return null;
            }
            Object[] params = QFilterUtil.getWithoutDuplicateInValues((Object)value);
            int c = params.length;
            if (c > 0) {
                String sql = this.multiParamsSQL(c);
                return new QParameter(sql, params);
            }
            return null;
        }

        public KsqlValues convert() {
            this.values = new ArrayList<Object>();
            StringBuilder sb = new StringBuilder();
            this.doConvert(sb, this.baseFilter);
            return new KsqlValues(sb.toString(), this.values);
        }

        public QFilterConverter alias(String alias) {
            this.tableAlias = alias;
            return this;
        }
    }

    private static class KsqlValues {
        String ksql;
        List<Object> values;

        public KsqlValues(String ksql, List<Object> values) {
            this.ksql = ksql;
            this.values = values;
        }

        public String getKsql() {
            return this.ksql;
        }

        public List<Object> getValues() {
            return this.values;
        }
    }
}

