/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.ex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.proxy.Joiner;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtte.common.constants.ExRecordConstants;

public class ExRecordService
implements ExRecordConstants {
    private static final Log LOG = LogFactory.getLog(ExRecordService.class);
    private static String SYSTEMTYPE = "wtc-wtte-formplugin";
    private static Map<String, String> MAP_TIMEUNIT = new HashMap<String, String>(5);

    private ExRecordService() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> getRecordOperations(DynamicObjectCollection entry, Long itemId, Long attributeId) {
        ArrayList<String> operationSet = new ArrayList<String>(4);
        HashMap<Long, DynamicObjectCollection> attItemMap = new HashMap<Long, DynamicObjectCollection>(8);
        HashMap<Long, DynamicObjectCollection> attributeMap = new HashMap<Long, DynamicObjectCollection>(8);
        for (DynamicObject dynamicObject : entry) {
            DynamicObjectCollection attItems = dynamicObject.getDynamicObjectCollection("attitem");
            for (DynamicObject attItem : attItems) {
                attItemMap.put(attItem.getLong("fbasedataid_id"), dynamicObject.getDynamicObjectCollection("action"));
            }
            DynamicObjectCollection attributes = dynamicObject.getDynamicObjectCollection("exattribute");
            for (DynamicObject attribute : attributes) {
                attributeMap.put(attribute.getLong("fbasedataid_id"), dynamicObject.getDynamicObjectCollection("action"));
            }
        }
        DynamicObjectCollection dynsOfAttitem = (DynamicObjectCollection)attItemMap.get(itemId);
        DynamicObjectCollection dynsOfAtttribution = (DynamicObjectCollection)attributeMap.get(attributeId);
        if (itemId > 0L && dynsOfAttitem != null) {
            return dynsOfAttitem.stream().map(dyn -> dyn.getDynamicObject("fbasedataid")).map(dyn -> dyn.getString("number")).sorted().collect(Collectors.toList());
        }
        if (attributeId > 0L && dynsOfAtttribution != null) {
            return dynsOfAtttribution.stream().map(dyn -> dyn.getDynamicObject("fbasedataid")).map(dyn -> dyn.getString("number")).sorted().collect(Collectors.toList());
        }
        return operationSet;
    }

    public static void getRecordOperations(DynamicObjectCollection rows, Map<Long, List<DynamicObject>> exProcessMap) {
        DynamicObjectType dynamicObjectType = rows.getDynamicObjectType();
        dynamicObjectType.registerProperty("exhandlebilltypeid", String.class, (Object)"", false);
        if (!rows.getDynamicObjectType().getProperties().containsKey((Object)"recorddate")) {
            return;
        }
        for (DynamicObject row : rows) {
            DynamicObject exProcess;
            long exProcessBoId;
            List<DynamicObject> exProcessList;
            Date recordDate = row.getDate("recorddate");
            if (recordDate == null || CollectionUtils.isEmpty(exProcessList = exProcessMap.get(exProcessBoId = row.getLong("exprocessid.boid"))) || (exProcess = WTCHisServiceHelper.getHisVersionDy((Date)recordDate, exProcessList)) == null) continue;
            HashMap<Long, DynamicObjectCollection> attItemMap = new HashMap<Long, DynamicObjectCollection>(4);
            HashMap<Long, DynamicObjectCollection> attributeMap = new HashMap<Long, DynamicObjectCollection>(4);
            ExRecordService.initExProcessAction(exProcess, attItemMap, attributeMap);
            long itemId = row.getLong("attitemid.id");
            long exAttributeId = row.getLong("exattributeid.id");
            DynamicObjectCollection dynsOfAttitem = (DynamicObjectCollection)attItemMap.get(itemId);
            DynamicObjectCollection dynsOfAtttribution = (DynamicObjectCollection)attributeMap.get(exAttributeId);
            List billTypeIds = null;
            if (itemId > 0L && CollectionUtils.isNotEmpty((Collection)dynsOfAttitem)) {
                billTypeIds = dynsOfAttitem.stream().map(item -> item.getLong("fbasedataid_id")).collect(Collectors.toList());
            } else if (exAttributeId > 0L && CollectionUtils.isNotEmpty((Collection)dynsOfAtttribution)) {
                billTypeIds = dynsOfAtttribution.stream().map(item -> item.getLong("fbasedataid_id")).collect(Collectors.toList());
            }
            if (!CollectionUtils.isNotEmpty(billTypeIds)) continue;
            String join = Joiner.on((String)",").join(billTypeIds);
            row.set("exhandlebilltypeid", (Object)join);
        }
    }

    private static void initExProcessAction(DynamicObject exProcess, Map<Long, DynamicObjectCollection> attItemMap, Map<Long, DynamicObjectCollection> attributeMap) {
        DynamicObjectCollection handleTypeColl = exProcess.getDynamicObjectCollection("entryentity");
        for (DynamicObject handleType : handleTypeColl) {
            DynamicObjectCollection attItems = handleType.getDynamicObjectCollection("attitem");
            for (DynamicObject attItem : attItems) {
                attItemMap.put(attItem.getLong("fbasedataid_id"), handleType.getDynamicObjectCollection("action"));
            }
            DynamicObjectCollection attributes = handleType.getDynamicObjectCollection("exattribute");
            for (DynamicObject attribute : attributes) {
                attributeMap.put(attribute.getLong("fbasedataid_id"), handleType.getDynamicObjectCollection("action"));
            }
        }
    }

    public static List<String> getRecordOperationIds(DynamicObjectCollection entry, Long itemId, Long attributeId) {
        ArrayList<String> operationSet = new ArrayList<String>(4);
        HashMap<Long, DynamicObjectCollection> attItemMap = new HashMap<Long, DynamicObjectCollection>(8);
        HashMap<Long, DynamicObjectCollection> attributeMap = new HashMap<Long, DynamicObjectCollection>(8);
        for (DynamicObject dynamicObject : entry) {
            DynamicObjectCollection attItems = dynamicObject.getDynamicObjectCollection("attitem");
            for (DynamicObject attItem : attItems) {
                attItemMap.put(attItem.getLong("fbasedataid_id"), dynamicObject.getDynamicObjectCollection("action"));
            }
            DynamicObjectCollection attributes = dynamicObject.getDynamicObjectCollection("exattribute");
            for (DynamicObject attribute : attributes) {
                attributeMap.put(attribute.getLong("fbasedataid_id"), dynamicObject.getDynamicObjectCollection("action"));
            }
        }
        DynamicObjectCollection dynsOfAttitem = (DynamicObjectCollection)attItemMap.get(itemId);
        DynamicObjectCollection dynsOfAtttribution = (DynamicObjectCollection)attributeMap.get(attributeId);
        if (itemId > 0L && dynsOfAttitem != null) {
            return dynsOfAttitem.stream().map(dyn -> dyn.getDynamicObject("fbasedataid")).map(dyn -> String.valueOf(dyn.getLong("id"))).collect(Collectors.toList());
        }
        if (attributeId > 0L && dynsOfAtttribution != null) {
            return dynsOfAtttribution.stream().map(dyn -> dyn.getDynamicObject("fbasedataid")).map(dyn -> String.valueOf(dyn.getLong("id"))).collect(Collectors.toList());
        }
        return operationSet;
    }

    public static void showAttfile(IFormPlugin plugin, String fieldName, DynamicObject exRecord, IFormView view) {
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"personid_name")) {
            Long attFileId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)exRecord, (String)"attfilevid");
            AttFileBusiness.showAttFileDetailForm((IFormView)view, (IFormPlugin)plugin, null, (Object)attFileId);
        }
    }

    public static void setColumnValueByNumber(DynamicObjectCollection rows, String number) {
        DynamicObject dynamicObject;
        DynamicObject dynamicObject2 = dynamicObject = WTCCollectionIndexUtil.getEleFromList((List)rows, (int)0).isPresent() ? (DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)rows, (int)0).get() : null;
        if (dynamicObject == null) {
            return;
        }
        DynamicSimpleProperty columnProp = new DynamicSimpleProperty();
        columnProp.setName(number);
        dynamicObject.getDataEntityType().getProperties().add((Object)columnProp);
    }

    public static void setTimeUnit(DynamicObjectCollection rows) {
        LOG.info("ExRecordService_setTimeUnit rows={}", (Object)rows.size());
        ExRecordService.setColumnValueByNumber(rows, "timeunit");
        rows.forEach(row -> {
            DynamicObjectCollection collection;
            DynamicPropertyCollection p = (DynamicPropertyCollection)row.getDataEntityType().getProperties();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)p.get((Object)"originitemvid");
            if (iDataEntityProperty != null && !(collection = row.getDynamicObjectCollection("originitemvid")).isEmpty()) {
                Set units = collection.stream().map(dyn -> dyn.getDynamicObject("fbasedataid") != null ? dyn.getDynamicObject("fbasedataid").getString("unit") : null).collect(Collectors.toSet());
                if (units.contains(AttitemUnitEnum.SECOND.getUnit())) {
                    row.set("timeunit", (Object)MAP_TIMEUNIT.get(AttitemUnitEnum.SECOND.getUnit()));
                } else if (units.contains(AttitemUnitEnum.MINUTE.getUnit())) {
                    row.set("timeunit", (Object)MAP_TIMEUNIT.get(AttitemUnitEnum.MINUTE.getUnit()));
                } else if (units.contains(AttitemUnitEnum.HOUR.getUnit())) {
                    row.set("timeunit", (Object)MAP_TIMEUNIT.get(AttitemUnitEnum.HOUR.getUnit()));
                } else if (units.contains(AttitemUnitEnum.DAY.getUnit())) {
                    row.set("timeunit", (Object)MAP_TIMEUNIT.get(AttitemUnitEnum.DAY.getUnit()));
                } else if (units.contains(AttitemUnitEnum.TIME.getUnit())) {
                    row.set("timeunit", (Object)MAP_TIMEUNIT.get(AttitemUnitEnum.TIME.getUnit()));
                }
            }
        });
    }

    public static int updateConfirmRecord2Old(List<DynamicObject> confirmDy) {
        if (WTCCollections.isEmpty(confirmDy)) {
            return 0;
        }
        Map<Long, List<DynamicObject>> idAndOldConfirm = ExRecordService.querySameConfirmRecord(confirmDy);
        ArrayList oldDys = new ArrayList(16);
        for (Map.Entry<Long, List<DynamicObject>> idAndOldDyMap : idAndOldConfirm.entrySet()) {
            oldDys.addAll(idAndOldDyMap.getValue());
        }
        for (DynamicObject oldDy : oldDys) {
            oldDy.set("islatest", (Object)Boolean.FALSE);
        }
        HRBaseServiceHelper exConfirmService = new HRBaseServiceHelper("wtte_exrecordconfirm");
        Object[] update = exConfirmService.update(oldDys.toArray(new DynamicObject[0]));
        return update.length;
    }

    public static Map<Long, List<DynamicObject>> querySameConfirmRecord(List<DynamicObject> confirmDyList) {
        if (WTCCollections.isEmpty(confirmDyList)) {
            return Collections.emptyMap();
        }
        Set attPersonIds = confirmDyList.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"personid")).collect(Collectors.toSet());
        Set<Date> dates = confirmDyList.stream().map(dy -> dy.getDate("recorddate")).collect(Collectors.toSet());
        dates = dates.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Date minDate = WTCDateUtils.getMinDate((Date[])dates.toArray(new Date[0]));
        Date maxDate = WTCDateUtils.getMaxDate((Date[])dates.toArray(new Date[0]));
        QFilter personQf = new QFilter("personid", "in", attPersonIds);
        QFilter startDateQf = new QFilter("recorddate", ">=", (Object)minDate);
        QFilter endDateQf = new QFilter("recorddate", "<=", (Object)maxDate);
        HRBaseServiceHelper exConfirmService = new HRBaseServiceHelper("wtte_exrecordconfirm");
        DynamicObject[] oldRecords = exConfirmService.loadDynamicObjectArray(new QFilter[]{personQf, startDateQf, endDateQf});
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : confirmDyList) {
            List oldDys = result.computeIfAbsent(dynamicObject.getLong("id"), key -> new ArrayList(10));
            long personId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"personid");
            long dutyDate = -1L;
            if (dynamicObject.getDate("recorddate") == null) continue;
            dutyDate = dynamicObject.getDate("recorddate").getTime();
            long punchCardPairId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"punchcardpair");
            long attItemId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"attitemid");
            BigDecimal attItemValue = dynamicObject.getBigDecimal("attitemvalue");
            for (DynamicObject oldRecord : oldRecords) {
                boolean matchVal;
                long personIdOld = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)oldRecord, (String)"personid");
                long dutyDateOld = -1L;
                if (dynamicObject.getDate("recorddate") != null) {
                    dutyDateOld = oldRecord.getDate("recorddate").getTime();
                }
                long punchCardPairIdOld = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)oldRecord, (String)"punchcardpair");
                long attItemIdOld = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)oldRecord, (String)"attitemid");
                BigDecimal attItemValueOld = oldRecord.getBigDecimal("attitemvalue");
                boolean bl = matchVal = attItemValue != null && attItemValueOld != null && attItemValue.compareTo(attItemValueOld) == 0;
                if (personId != personIdOld || dutyDate == -1L || dutyDate != dutyDateOld || punchCardPairId != punchCardPairIdOld || attItemId != attItemIdOld || !matchVal || oldRecord.getLong("id") == dynamicObject.getLong("id")) continue;
                oldDys.add(oldRecord);
            }
        }
        return result;
    }

    static {
        MAP_TIMEUNIT.put("second", ResManager.loadKDString((String)"\u79d2", (String)"ExRecordService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        MAP_TIMEUNIT.put("minute", ResManager.loadKDString((String)"\u5206\u949f", (String)"ExRecordService_1", (String)"wtc-wtte-business", (Object[])new Object[0]));
        MAP_TIMEUNIT.put("hour", ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"ExRecordService_2", (String)"wtc-wtte-business", (Object[])new Object[0]));
        MAP_TIMEUNIT.put("day", ResManager.loadKDString((String)"\u5929", (String)"ExRecordService_3", (String)"wtc-wtte-business", (Object[])new Object[0]));
        MAP_TIMEUNIT.put("time", ResManager.loadKDString((String)"\u6b21", (String)"ExRecordService_4", (String)"wtc-wtte-business", (Object[])new Object[0]));
    }
}

