/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.ex;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.ex.ExRecordKDStringHelper;

public class ExUrgingService {
    private static final Log LOG = LogFactory.getLog(ExUrgingService.class);
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_exrecord");
    private static HRBaseServiceHelper exPushRecordServiceHelper = new HRBaseServiceHelper("wtte_expushrecord");
    private static HRBaseServiceHelper urgingRecordServiceHelper = new HRBaseServiceHelper("wtte_exurgingrecord");
    private static ExUrgingService exUrgingService;

    public static ExUrgingService getInstance() {
        if (exUrgingService == null) {
            exUrgingService = new ExUrgingService();
        }
        return exUrgingService;
    }

    public boolean checkExit(Set<Long> idSet) {
        DynamicObject[] collection = serviceHelper.query("id", new QFilter[]{new QFilter("id", "in", idSet)});
        return collection != null && collection.length == idSet.size();
    }

    public List<Map<String, Object>> checkSingle(Long exRecordId) {
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)1);
        ArrayList exRecordIdList = Lists.newArrayListWithExpectedSize((int)1);
        exRecordIdList.add(exRecordId);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)1);
        ArrayList successRecordIdList = Lists.newArrayListWithExpectedSize((int)1);
        this.check(exRecordIdList, personIdSet, list, successRecordIdList);
        return list;
    }

    public void urging(IFormView view, List<Long> exRecordIdList, DynamicObject msgTemplateDy) {
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)exRecordIdList.size());
        ArrayList list = Lists.newArrayListWithExpectedSize((int)exRecordIdList.size());
        ArrayList successRecordIdList = Lists.newArrayListWithExpectedSize((int)exRecordIdList.size());
        DynamicObject[] collection = this.check(exRecordIdList, personIdSet, list, successRecordIdList);
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        if (list.isEmpty()) {
            map.put("failreason", ExRecordKDStringHelper.notExit());
            view.returnDataToParent((Object)map);
            view.close();
            return;
        }
        Map<Long, Long> personIdToUserIdMap = this.getUser(personIdSet);
        ArrayList exPushDyList = Lists.newArrayListWithExpectedSize((int)list.size());
        int successNum = this.emptyExPushRecordAssignment(exPushDyList, list, personIdToUserIdMap, msgTemplateDy.getLong("id"));
        if (!exPushDyList.isEmpty()) {
            this.sendMessage(exPushDyList);
            this.urgingCount(collection, successRecordIdList);
        }
        map.put("alldata", list);
        map.put("successnum", successNum);
        view.returnDataToParent((Object)map);
        view.close();
    }

    private void urgingCount(DynamicObject[] collection, List<Long> successRecordIdList) {
        ArrayList urgingIdList = Lists.newArrayListWithExpectedSize((int)successRecordIdList.size());
        for (DynamicObject dy : collection) {
            if (!successRecordIdList.contains(dy.getLong("id"))) continue;
            urgingIdList.add(dy.getLong("exurgingrecord.id"));
        }
        HashSet exitKeySet = Sets.newHashSetWithExpectedSize((int)collection.length);
        DynamicObject[] urgingRecords = urgingRecordServiceHelper.query("id,urgingcount,attfilevid.id,attitemid.id,attitemvalue,punchcardpair.id,punchcardpoint,recorddate", new QFilter[]{new QFilter("id", "in", (Object)urgingIdList)});
        if (urgingRecords != null && urgingRecords.length > 0) {
            for (DynamicObject urgingDy : urgingRecords) {
                String key = this.getKey(urgingDy);
                exitKeySet.add(key);
                urgingDy.set("urgingcount", (Object)(urgingDy.getInt("urgingcount") + 1));
            }
        }
        ArrayList insertUrgingList = Lists.newArrayListWithExpectedSize((int)collection.length);
        ArrayList updateExRecordList = Lists.newArrayListWithExpectedSize((int)collection.length);
        long[] ids = ID.genLongIds((int)collection.length);
        for (int index = 0; index < collection.length; ++index) {
            DynamicObject exRecordDy = collection[index];
            String key = this.getKey(exRecordDy);
            if (exitKeySet.contains(key)) continue;
            long id = ids[index];
            DynamicObject urgingDy = urgingRecordServiceHelper.generateEmptyDynamicObject();
            urgingDy.set("id", (Object)id);
            urgingDy.set("personid", exRecordDy.get("personid"));
            urgingDy.set("attfilevid", exRecordDy.get("attfilevid"));
            urgingDy.set("recorddate", exRecordDy.get("recorddate"));
            urgingDy.set("attitemid", exRecordDy.get("attitemid"));
            urgingDy.set("attitemvalue", exRecordDy.get("attitemvalue"));
            urgingDy.set("punchcardpair", exRecordDy.get("punchcardpair"));
            urgingDy.set("punchcardpoint", (Object)exRecordDy.getString("punchcardpoint"));
            urgingDy.set("urgingcount", (Object)1);
            insertUrgingList.add(urgingDy);
            exRecordDy.set("exurgingrecord", (Object)id);
            updateExRecordList.add(exRecordDy);
        }
        if (urgingRecords != null && urgingRecords.length > 0) {
            urgingRecordServiceHelper.update(urgingRecords);
        }
        urgingRecordServiceHelper.save(insertUrgingList.toArray(new DynamicObject[0]));
        serviceHelper.update(updateExRecordList.toArray(new DynamicObject[0]));
    }

    private String getKey(DynamicObject dy) {
        String exRecordDateStr = DateUtils.formatDate((Date)dy.getDate("recorddate"), (Object[])new Object[]{"yyyy-MM-dd"});
        return dy.getString("attfilevid.id") + dy.getString("attitemid.id") + dy.getString("punchcardpair.id") + dy.getString("punchcardpoint") + exRecordDateStr;
    }

    private void sendMessage(List<DynamicObject> exPushDyList) {
        HashMap data;
        List idList = exPushDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] exPushRecords = exPushRecordServiceHelper.loadDynamicObjectArray(new QFilter("id", "in", idList).toArray());
        HashSet sysUserIds = Sets.newHashSetWithExpectedSize((int)exPushRecords.length);
        for (DynamicObject dynamicObject : exPushRecords) {
            DynamicObject receiverDy = dynamicObject.getDynamicObject("receiver");
            if (receiverDy == null) continue;
            sysUserIds.add(receiverDy.getLong("id"));
        }
        HRBaseServiceHelper sysUser = new HRBaseServiceHelper("bos_user");
        DynamicObject[] userDataArr = sysUser.query("id", new QFilter[]{new QFilter("id", "in", (Object)sysUserIds)});
        HashSet sysUserIdSet = Sets.newHashSetWithExpectedSize((int)exPushRecords.length);
        for (DynamicObject dynamicObject : userDataArr) {
            sysUserIdSet.add(dynamicObject.getLong("id"));
        }
        String string = ExUrgingService.buildRapidProcessUrl();
        ArrayList messageInfoList = Lists.newArrayListWithExpectedSize((int)exPushRecords.length);
        HashMap refMap = Maps.newHashMapWithExpectedSize((int)exPushRecords.length);
        long[] longs = ID.genLongIds((int)exPushRecords.length);
        String empty = "";
        for (int index = 0; index < exPushRecords.length; ++index) {
            DynamicObject receiverDy;
            DynamicObject exPushRecord = exPushRecords[index];
            MessageInfo message = new MessageInfo();
            message.setType("message");
            String msgChannel = exPushRecord.getString("msgtemplate.msgchannel");
            message.setNotifyType(msgChannel);
            if (HRStringUtils.equals((String)"mcenter", (String)msgChannel)) {
                exPushRecord.set("pushstatus", (Object)"1");
            }
            if ((receiverDy = exPushRecord.getDynamicObject("receiver")) == null || !sysUserIdSet.contains(receiverDy.getLong("id"))) {
                exPushRecord.set("pushstatus", (Object)"2");
            }
            message.setTemplateNumber(exPushRecord.getString("msgtemplate.number"));
            String name1 = receiverDy != null ? receiverDy.getString("name") : empty;
            String number1 = receiverDy != null ? receiverDy.getString("number") : empty;
            LocaleString messContent = new LocaleString();
            messContent.setLocaleValue(ExRecordKDStringHelper.messageContent(name1, number1, exPushRecord.getString("exinfo")));
            message.setMessageContent((ILocaleString)messContent);
            message.setBizDataId(Long.valueOf(exPushRecord.getLong("id")));
            message.setEntityNumber("wtte_expushrecord");
            ArrayList<Long> userIds = new ArrayList<Long>(10);
            userIds.add(exPushRecord.getLong("receiver.id"));
            message.setUserIds(userIds);
            message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
            message.setTag(ExRecordKDStringHelper.urging());
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(ExRecordKDStringHelper.urging());
            message.setMessageTag((ILocaleString)localeString);
            message.setTitle(ExRecordKDStringHelper.urging());
            message.setContentUrl(string);
            long ll = longs[index];
            message.setId(Long.valueOf(ll));
            refMap.put(exPushRecord.getLong("id"), ll);
            String number = exPushRecord.getString("number");
            String newNumber = number.replaceAll("__", "_" + exPushRecord.getString("receiver.number") + "_");
            exPushRecord.set("number", (Object)newNumber);
            message.setNestBillno("wtte_expushrecord");
            messageInfoList.add(message);
        }
        Map stringObjectMap = MessageCenterServiceHelper.batchSendMessages((List)messageInfoList);
        ArrayList successId = Lists.newArrayListWithExpectedSize((int)exPushRecords.length);
        if (stringObjectMap != null && stringObjectMap.get("success") != null && ((Boolean)stringObjectMap.get("success")).booleanValue() && (data = (HashMap)stringObjectMap.get("data")) != null) {
            successId = (ArrayList)data.get("successMsgIds");
        }
        for (int index = 0; index < exPushRecords.length; ++index) {
            DynamicObject exPushRecord = exPushRecords[index];
            long id = exPushRecord.getLong("id");
            Long msgId = (Long)refMap.get(id);
            if (msgId != null && successId.contains(msgId)) {
                exPushRecord.set("msgid", (Object)msgId);
                continue;
            }
            exPushRecord.set("pushstatus", (Object)"2");
        }
        exPushRecordServiceHelper.update(exPushRecords);
    }

    private static String buildRapidProcessUrl() {
        StringBuilder stringBuilder = new StringBuilder();
        char equ = '=';
        char and = '&';
        stringBuilder.append(UrlService.getDomainContextUrl()).append("/?");
        stringBuilder.append("formId").append(equ).append("wtbs_rapidprocess").append(and);
        stringBuilder.append("type").append(equ).append("base").append(and);
        stringBuilder.append("openStyle").append(equ).append("modal").append(and);
        stringBuilder.append("appName").append(equ).append("wtss").append(and);
        stringBuilder.append("entityNumber").append(equ).append("wtss_pcpersonhome");
        return stringBuilder.toString();
    }

    private int emptyExPushRecordAssignment(List<DynamicObject> exPushDyList, List<Map<String, Object>> list, Map<Long, Long> personIdToUserIdMap, long msgTemplateId) {
        int successNum = list.size();
        HashMap successMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (Map<String, Object> map : list) {
            Object reason = map.get("failreason");
            if (reason != null) {
                --successNum;
                continue;
            }
            String key = String.valueOf(map.get("attfileid"));
            List subList = (List)successMap.get(key);
            if (subList == null) {
                subList = Lists.newArrayListWithExpectedSize((int)4);
            }
            subList.add(map);
            successMap.put(key, subList);
        }
        if (successMap.isEmpty()) {
            return 0;
        }
        Set entries = successMap.entrySet();
        for (Map.Entry next : entries) {
            List value = (List)next.getValue();
            DynamicObject exPushDy = ExUrgingService.getExPushDy(value, personIdToUserIdMap, msgTemplateId);
            if (exPushDy == null) continue;
            exPushDyList.add(exPushDy);
        }
        if (!exPushDyList.isEmpty()) {
            exPushRecordServiceHelper.save(exPushDyList.toArray(new DynamicObject[0]));
        }
        return successNum;
    }

    private static DynamicObject getExPushDy(List<Map<String, Object>> list, Map<Long, Long> personIdToUserIdMap, long msgTemplateId) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Map<String, Object> map1 = list.get(0);
        Long personId = (Long)map1.get("personid");
        Long receiver = personIdToUserIdMap.get(personId);
        if (receiver == null || receiver == 0L) {
            return null;
        }
        DynamicObject exPushRecord = exPushRecordServiceHelper.generateEmptyDynamicObject();
        exPushRecord.set("name", (Object)ExRecordKDStringHelper.exPushName((String)map1.get("name")));
        exPushRecord.set("rectype", (Object)"A");
        exPushRecord.set("receiver", (Object)receiver);
        exPushRecord.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"wtte_expushrecord", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtte_expushrecord"), null));
        exPushRecord.set("msgtemplate", (Object)msgTemplateId);
        exPushRecord.set("pushstatus", (Object)"0");
        exPushRecord.set("bizcreator", (Object)(UserServiceHelper.getCurrentUser((String)"name").getString("name") + "-" + UserServiceHelper.getCurrentUser((String)"number").getString("number")));
        Date date = new Date();
        exPushRecord.set("pushtime", (Object)date);
        exPushRecord.set("createtime", (Object)date);
        HashMap<Date, Map> exRecordMap = new HashMap<Date, Map>(16);
        for (Map<String, Object> stringObjectMap : list) {
            Date recordDate = (Date)stringObjectMap.get("exdate");
            Map keyToCountMap = exRecordMap.computeIfAbsent(recordDate, key -> new HashMap(16));
            String recordDateStr = (String)stringObjectMap.get("recorddate");
            String exName = (String)stringObjectMap.get("extypename");
            String sign = recordDateStr + "\uff1a" + exName;
            Integer count = (Integer)keyToCountMap.get(sign);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            keyToCountMap.put(sign, count);
        }
        HashMap exRecordSortMap = new HashMap(16);
        exRecordMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).forEachOrdered(param -> {
            Map cfr_ignored_0 = (Map)exRecordSortMap.put(param.getKey(), param.getValue());
        });
        Set entries = exRecordSortMap.entrySet();
        Iterator iterator = entries.iterator();
        StringBuilder exRecordMsg = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            Map value = (Map)next.getValue();
            if (value == null) continue;
            Set entries1 = value.entrySet();
            for (Map.Entry next1 : entries1) {
                String key2 = (String)next1.getKey();
                exRecordMsg.append(key2);
                Integer count = (Integer)next1.getValue();
                if (count != null && count > 1) {
                    exRecordMsg.append(ExRecordKDStringHelper.count(count));
                }
                exRecordMsg.append('\n');
            }
        }
        exPushRecord.set("exinfo", (Object)exRecordMsg.toString());
        return exPushRecord;
    }

    private Map<Long, Long> getUser(Set<Long> personIdSet) {
        HashMap personIdToUserId = Maps.newHashMapWithExpectedSize((int)personIdSet.size());
        ArrayList<Long> pids = new ArrayList<Long>(10);
        HashMap<String, ArrayList<Long>> idMaps = new HashMap<String, ArrayList<Long>>(16);
        pids.addAll(personIdSet);
        idMaps.put("person", pids);
        LOG.info("ExUrgingService.getUser invokeHRMPService");
        Map userMap = (Map)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (userMap == null) {
            LOG.info("ExUrgingService.getUser invokeHRMPService result is null");
            return personIdToUserId;
        }
        Map userAllInfoMap = (Map)userMap.get("data");
        if (userAllInfoMap != null) {
            Set userEntries = userAllInfoMap.entrySet();
            for (Map.Entry userEntry : userEntries) {
                Long personId = (Long)userEntry.getKey();
                Map userInfo = (Map)userEntry.getValue();
                personIdToUserId.put(personId, userInfo.get("user"));
            }
        }
        return personIdToUserId;
    }

    private DynamicObject[] check(List<Long> exRecordIdList, Set<Long> personIdSet, List<Map<String, Object>> list, List<Long> successRecordIdList) {
        DynamicObject[] collection = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", exRecordIdList)});
        if (collection == null || collection.length == 0) {
            return collection;
        }
        HashMap recordMap = Maps.newHashMapWithExpectedSize((int)exRecordIdList.size());
        HashSet attBoIdSet = Sets.newHashSetWithExpectedSize((int)exRecordIdList.size());
        for (DynamicObject record : collection) {
            attBoIdSet.add(record.getLong("attfileid.boid"));
            recordMap.put(record.getLong("id"), record);
        }
        ArrayList<Long> attFileBoIdList = new ArrayList<Long>(attBoIdSet);
        Map<Long, List<DynamicObject>> attFileMap = this.getPerAttInfo(attFileBoIdList);
        Map<Long, Map<String, Object>> attStateInfoMap = this.getAttStateInfo(attFileBoIdList);
        for (Long id : exRecordIdList) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)exRecordIdList.size());
            map.put("id", id);
            DynamicObject record = (DynamicObject)recordMap.get(id);
            if (record == null) continue;
            long attFileBoId = record.getLong("attfileid.boid");
            Date recordDate = record.getDate("recorddate");
            DynamicObject attItemDy = record.getDynamicObject("attitemid");
            if (HRStringUtils.equals((String)"1", (String)record.getString("confirmstatus"))) {
                map.put("failreason", ExRecordKDStringHelper.sure());
                map.put("tips", ExRecordKDStringHelper.sureTips());
            } else if (HRObjectUtils.isEmpty((Object)attItemDy)) {
                map.put("failreason", ExRecordKDStringHelper.notResultReason());
                map.put("tips", ExRecordKDStringHelper.notResultTips());
            } else if (!this.havePer(attFileMap, attFileBoId, recordDate)) {
                map.put("failreason", ExRecordKDStringHelper.notPer());
                map.put("tips", ExRecordKDStringHelper.notPerTips());
            } else {
                boolean checkResult = this.checkAttState(attStateInfoMap, attFileBoId, recordDate, map);
                if (checkResult) {
                    personIdSet.add(record.getDynamicObject("personid").getLong("id"));
                    successRecordIdList.add(record.getLong("id"));
                }
            }
            map.put("personid", record.getLong("personid.id"));
            map.put("attfileid", record.getLong("attfileid.id"));
            map.put("attitemid", record.getLong("attitemid.id"));
            map.put("name", record.getString("personid.name"));
            map.put("number", record.getString("personid.number"));
            map.put("shiftdate", record.getDate("shiftdate"));
            map.put("extypename", record.getString("exattributeid.name"));
            map.put("attitemvalue", record.getBigDecimal("attitemvalue").setScale(2, RoundingMode.HALF_DOWN));
            map.put("timeunit", record.getString("attitemvid.unit"));
            map.put("confirmstatus", record.getString("confirmstatus"));
            map.put("boid", attFileBoId);
            map.put("exdate", recordDate);
            map.put("recorddate", WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)recordDate));
            map.put("extypeid", record.getLong("exattributeid.id"));
            list.add(map);
        }
        return collection;
    }

    private boolean checkAttState(Map<Long, Map<String, Object>> attStatMap, Long attFileBoId, Date recordDate, Map<String, Object> map) {
        Map<String, Object> stateMap = attStatMap.get(attFileBoId);
        if (stateMap == null || stateMap.isEmpty()) {
            return false;
        }
        boolean checkResult = false;
        Date frozenStartDate = (Date)stateMap.get("frozenstartdate");
        Date frozenEndDate = (Date)stateMap.get("frozenenddate");
        Date lockTo = (Date)stateMap.get("lockto");
        Date storageTo = (Date)stateMap.get("storageto");
        if (Objects.nonNull(frozenStartDate) && Objects.nonNull(frozenEndDate) && WTCDateUtils.betweenDay((Date)recordDate, (Date)frozenStartDate, (Date)frozenEndDate)) {
            map.put("failreason", ExRecordKDStringHelper.freeze());
            map.put("tips", ExRecordKDStringHelper.freezeTips());
        } else if (Objects.nonNull(storageTo) && recordDate.compareTo(storageTo) <= 0) {
            map.put("failreason", ExRecordKDStringHelper.seal());
            map.put("tips", ExRecordKDStringHelper.sealTips());
        } else if (Objects.nonNull(lockTo) && recordDate.compareTo(lockTo) <= 0) {
            map.put("failreason", ExRecordKDStringHelper.lock());
            map.put("tips", ExRecordKDStringHelper.lockTips());
        } else {
            checkResult = true;
        }
        return checkResult;
    }

    private Map<Long, Map<String, Object>> getAttStateInfo(List<Long> attFileBoIdList) {
        return (Map)WTCServiceHelper.invokeWtcWtpBizService((String)"IAttStateInfoService", (String)"queryAttStateInfoByFileBoId", (Object[])new Object[]{attFileBoIdList});
    }

    private boolean havePer(Map<Long, List<DynamicObject>> attFileMap, Long attFileBoId, Date recordDate) {
        List<DynamicObject> attFileList = attFileMap.get(attFileBoId);
        if (attFileList == null) {
            return false;
        }
        for (DynamicObject attFileDy : attFileList) {
            Date bsed = attFileDy.getDate("bsed");
            Date bsled = attFileDy.getDate("bsled");
            if (recordDate == null || bsed == null || bsled == null || bsed.compareTo(recordDate) > 0 || recordDate.compareTo(bsled) > 0) continue;
            return true;
        }
        return false;
    }

    private Map<Long, List<DynamicObject>> getPerAttInfo(List<Long> attFileBoIdList) {
        HasPermOrgResult allPermOrg = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrg(UserServiceHelper.getCurrentUserId(), "wtte", "wtte_exrecord", "47150e89000000ac");
        AttFileQueryParam havePer = new AttFileQueryParam(false);
        if (!allPermOrg.hasAllOrgPerm()) {
            List hasPermOrgs = allPermOrg.getHasPermOrgs();
            HashSet orgSetIds = Sets.newHashSetWithExpectedSize((int)hasPermOrgs.size());
            orgSetIds.addAll(hasPermOrgs);
            havePer.setOrgSetIds((Set)orgSetIds);
        }
        QFilter dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), "wtte", "wtte_exrecord", "attfilevid", "47150e89000000ac", null);
        QFilter selectId = new QFilter("boid", "in", attFileBoIdList);
        if (dataRuleForBdProp != null) {
            selectId.and(dataRuleForBdProp);
        }
        havePer.setqFilter(selectId);
        havePer.setAuthCheck(Boolean.FALSE);
        havePer.setBeCurrent(Boolean.FALSE);
        havePer.setProperties("id,boid,number,name,bsed,bsled");
        List havePerAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(havePer);
        HashMap map = Maps.newHashMapWithExpectedSize((int)havePerAttFileList.size());
        for (DynamicObject dy : havePerAttFileList) {
            long boId = dy.getLong("boid");
            List list = (List)map.get(boId);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)16);
            }
            list.add(dy);
            map.put(boId, list);
        }
        return map;
    }
}

