/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.fieldscheme;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.fieldscheme.AbstractShowTreeNode;
import kd.wtc.wtte.common.model.BuildTreeNodeBean;

public class BuildTreeNodeHandler {
    private AbstractShowTreeNode absShowTreeNode;
    private BuildTreeNodeBean buildTreeNodeBean;
    private Map<String, BuildTreeNodeFunction<BuildTreeNodeBean>> consumerMap = Maps.newHashMapWithExpectedSize((int)2);

    public BuildTreeNodeHandler(AbstractShowTreeNode absShowTreeNode, BuildTreeNodeBean buildTreeNodeBean) {
        this.consumerMap.put("wtte_adddisplayfield", this::showFunction);
        this.consumerMap.put("wtte_addsortfield", this::sortFunction);
        this.absShowTreeNode = absShowTreeNode;
        this.buildTreeNodeBean = buildTreeNodeBean;
    }

    private List<TreeNode> showFunction(BuildTreeNodeBean bean) {
        return this.absShowTreeNode.buildShowTree(bean.getFromSourceViewId());
    }

    private List<TreeNode> sortFunction(BuildTreeNodeBean bean) {
        return this.absShowTreeNode.buildSortTree(bean.getFromSourceViewId());
    }

    public List<TreeNode> buildTreeNode() {
        BuildTreeNodeFunction<BuildTreeNodeBean> function = this.consumerMap.get(this.buildTreeNodeBean.getOpenChildViewId());
        if (null == function) {
            return Collections.emptyList();
        }
        return function.buildFunction(this.buildTreeNodeBean);
    }

    @FunctionalInterface
    private static interface BuildTreeNodeFunction<A> {
        public List<TreeNode> buildFunction(A var1);
    }
}

