/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.fieldscheme;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.common.constants.DisplayFieldConstants;

public class DisplayFieldHelper
implements DisplayFieldConstants {
    public static void searchTreeNode(String searchText, IFormView iFormView, boolean isSelected) {
        List<Object> treeNodes;
        boolean flag;
        WTCPageCache swcPageCache = new WTCPageCache(iFormView);
        String rootNode = (String)swcPageCache.get("CACHE_ROOT_NODE", String.class);
        if (rootNode == null) {
            return;
        }
        List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNode);
        IPageCache pageCache = (IPageCache)iFormView.getService(IPageCache.class);
        String searchNodesCacheKey = iFormView.getPageId() + "_searchNodes";
        String matchNodesCacheKey = iFormView.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = iFormView.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = iFormView.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = flag = (oldSearchText == null || oldSearchText.equals(searchText)) && !HRStringUtils.isEmpty((String)matchNodesCache);
        if (flag) {
            String treeViewNode = pageCache.get(searchNodesCacheKey);
            treeNodes = HRStringUtils.isEmpty((String)treeViewNode) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)treeViewNode, TreeNode.class);
        } else {
            treeNodes = DisplayFieldHelper.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        TreeView treeView = (TreeView)iFormView.getControl("treeviewap");
        if (treeNodes.isEmpty()) {
            treeNodes = DisplayFieldHelper.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u7b26\u5408\u6761\u4ef6\u4fe1\u606f\u3002", (String)"DisplayFieldHelper_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        } else {
            if (HRStringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    if (isSelected) {
                        DisplayFieldHelper.keyWordSearchSelected(treeView, iFormView, pageCache, searchIndexCacheKey, indexCache, treeNode);
                    }
                } else {
                    iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"DisplayFieldHelper_1", (String)"wtc-wtte-business", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    public static void searchFieldName(String searchText, IFormView iFormView) {
        if (searchText.isEmpty()) {
            return;
        }
        int minSequenceNo = 0;
        int maxSequenceNo = 0;
        DynamicObjectCollection entryColl = iFormView.getModel().getEntryEntity("entryentity");
        LinkedHashMap fieldNameSeqMap = Maps.newLinkedHashMapWithExpectedSize((int)entryColl.size());
        for (DynamicObject entryObj : entryColl) {
            String fieldName = entryObj.getString("fieldname");
            if (!fieldName.contains(searchText)) continue;
            int sequenceNo = entryObj.getInt("seq");
            fieldNameSeqMap.put(fieldName, sequenceNo);
            if (fieldNameSeqMap.size() == 1) {
                minSequenceNo = sequenceNo;
                continue;
            }
            maxSequenceNo = sequenceNo;
        }
        if (fieldNameSeqMap.isEmpty()) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u7b26\u5408\u6761\u4ef6\u4fe1\u606f\u3002", (String)"DisplayFieldHelper_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        int[] rows = proxy.getEntryState("entryentity").getSelectedRows();
        int len = rows.length;
        boolean isSelected = true;
        if (0 == len) {
            isSelected = false;
        }
        EntryGrid grid = (EntryGrid)iFormView.getControl("entryentity");
        for (Map.Entry entry : fieldNameSeqMap.entrySet()) {
            int sequenceNo = (Integer)entry.getValue();
            if (!isSelected || sequenceNo - 1 > rows[rows.length - 1]) {
                grid.selectRows(sequenceNo - 1, true);
                return;
            }
            if (sequenceNo != maxSequenceNo) continue;
            grid.selectRows(minSequenceNo - 1, true);
            return;
        }
    }

    private static List<TreeNode> getNodes(List<TreeNode> rootNodes, String searchText) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (TreeNode rootNode : rootNodes) {
            nodes.addAll(rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16));
        }
        return nodes;
    }

    private static void keyWordSearchSelected(TreeView treeView, IFormView iFormView, IPageCache pageCache, String searchIndexCacheKey, int indexCache, TreeNode treeNode) {
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        TreeView tree = (TreeView)iFormView.getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        treeView.uncheckNodes(checkedNodeIds);
        treeView.checkNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
    }
}

