/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.fieldscheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtte.business.fieldscheme.IBuildShowFields;
import kd.wtc.wtte.business.fieldscheme.IBuildSortFields;

public class FieldSchemeService
extends HRBaseServiceHelper
implements IBuildShowFields,
IBuildSortFields {
    public static final String ATTITEM_SUFFIX = "_attitemid";
    private HRBaseServiceHelper attItemDao = new HRBaseServiceHelper("wtbd_attitem");
    private Object orgId;

    public FieldSchemeService(String entityName) {
        super(entityName);
    }

    @Override
    public List<TreeNode> getShowFieldList(String schemeNumber) {
        DynamicObject[] byFieldUse;
        ArrayList resultNodes = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject field : byFieldUse = this.getByFieldUse(schemeNumber, "A")) {
            this.buildTree(field, resultNodes);
        }
        TreeNode attItemNode = this.buildAttItem(schemeNumber);
        resultNodes.add(attItemNode);
        return resultNodes;
    }

    public DynamicObject[] getAttItems(Set<Long> attItemIds) {
        QFilter filter = new QFilter("id", "in", attItemIds);
        return this.attItemDao.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getFieldSchemeByIds(Set<Long> ids) {
        String select = "id,name,number,longnumber,level,index,isleaf,parent";
        if (WTCCollections.isNotEmpty(ids)) {
            QFilter idQf = new QFilter("id", "in", ids);
            return this.query(select, new QFilter[]{idQf});
        }
        return this.query(select, null);
    }

    private DynamicObject[] getByFieldUse(String condition, String use) {
        QFilter all = new QFilter("showscheme", "like", (Object)("%" + condition + "%"));
        QFilter qField = new QFilter("fielduse", "=", (Object)use);
        return this.query("id,name,number,longnumber,level,index,isleaf,parent", new QFilter[]{all, qField}, "level,index asc");
    }

    @Override
    public List<TreeNode> getSortFieldList(String schemeNumber) {
        DynamicObject[] byFieldUse;
        ArrayList resultNodes = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject field : byFieldUse = this.getByFieldUse(schemeNumber, "B")) {
            this.buildTree(field, resultNodes);
        }
        return resultNodes;
    }

    private TreeNode buildAttItem(String schemeNumber) {
        QFilter qStatus = new QFilter("status", "=", (Object)"C");
        QFilter qItemType = new QFilter("itemtype", "in", (Object)(HRStringUtils.equals((String)schemeNumber, (String)"A") ? Lists.newArrayList((Object[])new String[]{"1", "2"}) : Lists.newArrayList((Object[])new String[]{"2", "3"})));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_attitem", (Long)Long.parseLong(String.valueOf(this.orgId)));
        QFilter qCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableStatus = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] attItems = this.attItemDao.query(new QFilter[]{qStatus, qItemType, baseDataFilter, qCurrent, enableStatus}, "number asc");
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u8003\u52e4\u9879\u76ee", (String)"FieldSchemeService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        String parentId = "1";
        root.setId(parentId);
        root.setIsOpened(false);
        root.setParentid("");
        for (DynamicObject attItem : attItems) {
            TreeNode children = new TreeNode();
            String text = attItem.getString("name") + "/" + attItem.getString("number");
            children.setText(text);
            String attItemId = String.valueOf(attItem.getLong("id"));
            children.setId(attItemId);
            children.setParentid(parentId);
            children.setLongNumber("attitem." + attItem.getString("number"));
            children.setLeaf(true);
            root.addChild(children);
        }
        return root;
    }

    private void buildTree(DynamicObject field, List<TreeNode> roots) {
        long parentId = field.getLong("parent.id");
        if (parentId == 0L) {
            roots.add(this.buildTreeNode(field));
        } else {
            for (TreeNode root : roots) {
                if (HRStringUtils.equals((String)root.getId(), (String)String.valueOf(parentId))) {
                    root.addChild(this.buildTreeNode(field));
                    continue;
                }
                List children = root.getChildren();
                if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
                this.buildTree(field, children);
            }
        }
    }

    private TreeNode buildTreeNode(DynamicObject field) {
        TreeNode treeNode = new TreeNode();
        treeNode.setText(field.getString("name"));
        treeNode.setId(String.valueOf(field.getLong("id")));
        long parentId = field.getLong("parent.id");
        treeNode.setParentid(parentId == 0L ? "" : String.valueOf(parentId));
        treeNode.setLongNumber(field.getString("longnumber"));
        treeNode.setLeaf(field.getBoolean("isleaf"));
        return treeNode;
    }

    public void setOrgId(Object orgId) {
        this.orgId = orgId;
    }
}

