/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.qt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtte.common.constants.QTCalculateConstants;

public class QTCalculateService
implements QTCalculateConstants {
    public static QFilter filterAccountModeOfGenChainAndFullChain() {
        return new QFilter("accountmode", "=", (Object)"C");
    }

    public static QFilter filterAccountModeOfDeductChain() {
        return new QFilter("accountmode", "=", (Object)"B");
    }

    public static Map<String, Object> dynToReqMap(DynamicObject dyn, Long taskId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("number", taskId);
        paramMap.put("name", ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTCalculateService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        paramMap.put("saveStep", dyn.getBoolean("savestep"));
        paramMap.put("planId", dyn.getLong("planid.id"));
        paramMap.put("tiePlanId", dyn.getLong("tieplanid.id"));
        List qtTypeIds = dyn.getDynamicObjectCollection("qttype").stream().map(att -> att.getLong("fbasedataid.id")).collect(Collectors.toList());
        paramMap.put("qttype", qtTypeIds);
        List dyQtTypeIds = dyn.getDynamicObjectCollection("dyqttype").stream().map(att -> att.getLong("fbasedataid.id")).collect(Collectors.toList());
        paramMap.put("dyqttype", dyQtTypeIds);
        return paramMap;
    }

    public static void showQTCalculateLog(Long rowId, String accountMode, String tabKey, String version, IFormView formView) {
        DynamicObject dyn = QTAccountModeHelper.getDaoByAccountMode((String)accountMode).loadDynamicObject(new QFilter("id", "=", (Object)rowId));
        String caption = null;
        if (dyn != null) {
            caption = accountMode.equals("C") ? ResManager.loadKDString((String)"\u5b9a\u989d\u751f\u6210-%s", (String)"QTCalculateService_1", (String)"wtc-wtte-business", (Object[])new Object[]{version}) : (accountMode.equals("B") ? ResManager.loadKDString((String)"\u5b9a\u989d\u6263\u51cf-%s", (String)"QTCalculateService_3", (String)"wtc-wtte-business", (Object[])new Object[]{version}) : ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97-%s", (String)"QTCalculateService_2", (String)"wtc-wtte-business", (Object[])new Object[]{version}));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (QTAccountModeHelper.isDeductChain((String)accountMode)) {
            parameter.setFormId("wtte_qtdccaldetail");
        } else {
            parameter.setFormId("wtte_qtcaldetail");
        }
        if (caption == null) {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)"wtte_qtcaldetail");
            if (formConfig != null) {
                parameter.setCaption(formConfig.getCaption().getLocaleValue() + "-" + version);
            }
        } else {
            parameter.setCaption(caption);
        }
        parameter.setCustomParam("tabKey", (Object)tabKey);
        parameter.setCustomParam("taskid", (Object)rowId);
        parameter.setCustomParam("calVersion", (Object)version);
        parameter.setCustomParam("accountmode", (Object)accountMode);
        parameter.setPageId(formView.getPageId() + "wtte_qtcaldetail" + rowId);
        parameter.setAppId("wtte");
        formView.showForm(parameter);
    }

    @Deprecated
    public static void showQTCalculateLog(Long rowId, String tabKey, String version, IFormView formView) {
        QTCalculateService.showQTCalculateLog(rowId, QTAccountModeHelper.judgeAccountModeByTaskId((long)rowId), tabKey, version, formView);
    }
}

