/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.qt;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.formtask.TaskFormProcessorService;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.license.WTCCertCommonHelper;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtte.business.attcalculate.AttCalculateService;
import kd.wtc.wtte.business.qt.QTCalculateService;
import kd.wtc.wtte.business.qt.task.QtTaskHelper;

public class QTTaskFormProcessorService
implements TaskFormProcessorService {
    private static final String CERT_INFO = "certInfo";
    private static final Log LOG = LogFactory.getLog(QTTaskFormProcessorService.class);

    public void beforeGenTaskForm(Object param) {
    }

    public WTCTaskForm genTaskForm(Object param) {
        Map map = (Map)param;
        String enterType = (String)map.get("enterType");
        WTCTaskForm taskForm = null;
        if ("listRecalculation".equals(enterType)) {
            taskForm = this.recalculation(map);
        } else if ("detailRecalculationAll".equals(enterType)) {
            taskForm = this.recalculation(map);
        } else if ("detailRecalculationPart".equals(enterType)) {
            taskForm = this.recalculation(map);
        } else if ("addCalculate".equals(enterType)) {
            taskForm = this.newCalculation(map);
        }
        if (taskForm == null || taskForm.getTaskRequest() == null) {
            throw new IllegalStateException("taskForm can not be null");
        }
        taskForm.setClickClassName("kd.wtc.wtte.formplugin.web.qtcal.QTCalTaskClick");
        if (WTCCollections.isEmpty((Collection)taskForm.getTaskRequest().getDetail())) {
            HashMap errMsg = Maps.newHashMapWithExpectedSize((int)2);
            errMsg.put("msgType", "notAttFiles");
            errMsg.put("msg", ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u5185\u672a\u627e\u5230\u6743\u9650\u4e0b\u7684\u8003\u52e4\u6863\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6838\u7b97\u4eba\u5458\u3002", (String)"TieTaskFormProcessorService_1", (String)"wtc-wtte-business", (Object[])new Object[0]));
            taskForm.setErrMsg(SerializationUtils.toJsonString((Object)errMsg));
        }
        if (WTCStringUtils.isNotEmpty((String)taskForm.getErrMsg())) {
            return taskForm;
        }
        try {
            this.checkCert(taskForm);
        }
        catch (KDBizException ex) {
            HashMap<String, Object> exMap = new HashMap<String, Object>(3);
            HashMap<String, String> msgMap = new HashMap<String, String>(1);
            exMap.put("msgType", CERT_INFO);
            exMap.put("isforbidden", Boolean.TRUE);
            msgMap.put("message", ex.getMessage());
            exMap.put("msg", msgMap);
            taskForm.setErrMsg(SerializationUtils.toJsonString(exMap));
        }
        if (WTCStringUtils.isNotEmpty((String)taskForm.getErrMsg())) {
            return taskForm;
        }
        WTCTaskRequestStd taskRequest = (WTCTaskRequestStd)taskForm.getTaskRequest();
        this.newAndSaveCalResult(map, taskRequest);
        List subTaskDispatchRequestList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)taskRequest);
        taskForm.setTaskRequest((WTCTaskRequest)taskRequest);
        taskForm.setSubTaskDispatchRequestList(subTaskDispatchRequestList);
        return taskForm;
    }

    private void newAndSaveCalResult(Map<String, Object> map, WTCTaskRequestStd taskRequest) {
        DynamicObject resultObject = QTTaskFormProcessorService.genQtCalResultDy(taskRequest, map);
        QTAccountModeHelper.getDaoByAccountMode((String)((String)map.get("accountmode"))).saveOne(resultObject);
    }

    private void checkCert(WTCTaskForm taskForm) {
        Map mapOfNumCheck = HRCertCommonHelper.verifyCertCount((String)"1C8H4/N38LCY", (String)"wtte_attcalculate");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        if (StringUtils.equals((CharSequence)((CharSequence)mapOfNumCheck.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            resultMap.put("result", Boolean.FALSE);
            resultMap.put("datas", Collections.emptyList());
            resultMap.put("msg", mapOfNumCheck);
            mapOfNumCheck.put("showMessageType", "1");
            resultMap.put("isforbidden", Boolean.TRUE);
            resultMap.put("msgType", CERT_INFO);
            LOG.info("TieTaskFormProcessorService.checkCert resultMap: {}", (Object)JSON.toJSONString((Object)resultMap));
            taskForm.setErrMsg(SerializationUtils.toJsonString((Object)resultMap));
            return;
        }
        resultMap.put("result", Boolean.TRUE);
        resultMap.put("datas", Collections.emptyList());
        resultMap.put("msg", mapOfNumCheck);
        mapOfNumCheck.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)((String)mapOfNumCheck.get("infoType"))));
        resultMap.put("isforbidden", Boolean.FALSE);
        resultMap.put("msgType", CERT_INFO);
        taskForm.setWarnMsg(SerializationUtils.toJsonString((Object)resultMap));
        Map<String, List<Long>> certCheckIdMap = this.getNeedDealIdMap(taskForm);
        Map<String, Object> checkCertReturnMsg = AttCalculateService.checkCertReturnMsg("1C8H4/N38LCY", "wtte_attcalculate", certCheckIdMap);
        Map msg = (Map)checkCertReturnMsg.get("msg");
        checkCertReturnMsg.put("msgType", CERT_INFO);
        if (Boolean.TRUE.equals(checkCertReturnMsg.get("isforbidden"))) {
            taskForm.setErrMsg(SerializationUtils.toJsonString(checkCertReturnMsg));
        } else if (HRStringUtils.equals((String)String.valueOf(msg.get("showMessage")), (String)"true")) {
            taskForm.setWarnMsg(SerializationUtils.toJsonString(checkCertReturnMsg));
        }
    }

    private Map<String, List<Long>> getNeedDealIdMap(WTCTaskForm taskForm) {
        WTCTaskRequest taskRequest = taskForm.getTaskRequest();
        List detail = taskRequest.getDetail();
        HashSet attfileBoIds = new HashSet(detail.size());
        detail.stream().forEach(map -> {
            Long attfileBoId = (Long)map.get("attFileBoId");
            attfileBoIds.add(attfileBoId);
        });
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(attfileBoIds);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setProperties("attperson.id,atttag.attendstatus,startdate,enddate,bsed,bsled,usablestatus");
        List attfiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return CertService.getCertIdMap((List)attfiles);
    }

    private String getTaskVersionByAccountMode(String accountMode, String version) {
        if (version != null) {
            return version;
        }
        if ("B".equals(accountMode)) {
            return QtTaskHelper.getDeductTaskVersion();
        }
        return QtTaskHelper.getTaskVersion();
    }

    private WTCTaskForm recalculation(Map<String, Object> map) {
        long oldComputingBillId;
        Long oldTaskId = (Long)map.get("oldTaskId");
        CloseCallBack closeCallBack = (CloseCallBack)map.get("closeCallBack");
        String clickClassName = (String)map.getOrDefault("clickClassName", "");
        String desc = (String)map.get("desc");
        String accountMode = (String)map.get("accountmode");
        List details = map.getOrDefault("detail", null);
        long taskId = DB.genGlobalLongId();
        DynamicObject calResult = QTAccountModeHelper.getDaoByAccountMode((String)accountMode).loadDynamicObject(new QFilter("id", "=", (Object)oldTaskId));
        Map<String, Object> paramMap = QTCalculateService.dynToReqMap(calResult, taskId);
        String billNo = null;
        if (QTAccountModeHelper.isDeductChain((String)accountMode) && (oldComputingBillId = calResult.getLong("computingbillid")) != 0L) {
            paramMap.put("computingBillId", oldComputingBillId);
            billNo = calResult.getString("version");
        }
        paramMap.put("accountmode", accountMode);
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setTaskId(taskId);
        request.setTrial(false);
        request.setTaskId(taskId);
        request.setSource(WTCSource.MANUAL.getCode());
        request.setVersion(this.getTaskVersionByAccountMode(accountMode, billNo));
        request.setDesc(desc);
        request.setAppId("wtte");
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setCategory("wtte_qttie");
        request.setStartDate(calResult.getDate("begindate"));
        request.setEndDate(calResult.getDate("enddate"));
        request.setParams(paramMap);
        if (WTCCollections.isEmpty((Collection)details)) {
            details = WTCTaskServiceHelper.batchTaskDetailByTaskIdToMap((String)"wtte_qttie", (long)oldTaskId);
        }
        request.setDetail(details);
        long orgId = calResult.getLong("org.id");
        long planId = calResult.getLong("planid.id");
        long tiePlanId = calResult.getLong("tieplanid.id");
        map.put("orgId", orgId);
        map.put("planid", planId);
        map.put("tieplanid", tiePlanId);
        boolean isSaveStep = calResult.getBoolean("savestep");
        map.put("savestep", isSaveStep);
        map.put("desc", desc);
        return QTTaskFormProcessorService.genWTCTaskForm(request, closeCallBack, clickClassName);
    }

    private WTCTaskForm newCalculation(Map<String, Object> map) {
        List<DynamicObject> mergeAllFiles = this.getMergeAttFile(map, null);
        HashMap filePersonMap = new HashMap(mergeAllFiles.size());
        mergeAllFiles.forEach(file -> filePersonMap.put(file.getLong("boid"), HRAuthUtil.getAuthFieldByAttFileDyn((DynamicObject)file)));
        ArrayList<Map<String, Object>> personInfoList = new ArrayList<Map<String, Object>>(filePersonMap.values());
        CloseCallBack closeCallBack = (CloseCallBack)map.get("closeCallBack");
        String clickClassName = (String)map.getOrDefault("clickClassName", "");
        WTCTaskRequestStd req = this.buildTaskReq(map, personInfoList);
        return QTTaskFormProcessorService.genWTCTaskForm(req, closeCallBack, clickClassName);
    }

    public List<DynamicObject> getMergeAttFile(Map<String, Object> map, QFilter attfileQFilter) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        QFilter qFilter = null;
        String conditionJson = (String)map.get("configJson");
        if (WTCStringUtils.isNotEmpty((String)conditionJson)) {
            RuleConditionInfo ruleCondition = JudgeConditionService.getRuleCondition((String)conditionJson);
            Map qFilters = JudgeConditionService.packageQFilter((RuleConditionInfo)ruleCondition, (String)"attfile.wtp_attfilebase");
            qFilter = JudgeConditionService.parseQFilter((Map)qFilters, (String)ruleCondition.getConditionExpressStr());
        }
        ArrayList cacheAttFiles = new ArrayList();
        if (qFilter != null) {
            if (attfileQFilter != null) {
                qFilter.and(attfileQFilter);
            }
            attFileQueryParam.setUsableStatus(WTCCollections.modifiableSet((Object[])new String[]{"0", "-1"}));
            attFileQueryParam.setqFilter(qFilter);
            attFileQueryParam.setProperties((String)map.get("needQueryColumn"));
            List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
            Date endDate = (Date)map.get("enddate");
            Date startDate = (Date)map.get("startdate");
            List queryResFiles = attFiles.stream().filter(dyn -> {
                boolean statusCheckRes = HRStringUtils.equals((String)dyn.getString("atttag.attendstatus"), (String)AttStatusEnum.ATT_NORMAL.getCode());
                boolean hasIntersectionLCRC = startDate == null ? dyn.getDate("bsed").compareTo(endDate) <= 0 : WTCDateUtils.hasIntersectionLCRC((Date)startDate, (Date)endDate, (Date)dyn.getDate("bsed"), (Date)dyn.getDate("bsled"));
                return statusCheckRes && hasIntersectionLCRC;
            }).collect(Collectors.toList());
            cacheAttFiles.addAll(queryResFiles);
            LOG.info("TieTaskFormProcessorService batchSelectFiles:{}", (Object)queryResFiles.size());
        }
        if (map.get("ids") != null) {
            Set ids = (Set)map.get("ids");
            QFilter selectId = new QFilter("id", "in", new ArrayList(ids));
            attFileQueryParam.setUsableStatus(WTCCollections.modifiableSet((Object[])new String[]{"0", "-1"}));
            attFileQueryParam.setqFilter(selectId);
            List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
            cacheAttFiles.addAll(attFiles);
            LOG.info("TieTaskFormProcessorService idSelectFiles:{},IDS:{}", (Object)attFiles.size(), (Object)ids);
        }
        return cacheAttFiles.stream().sorted(Comparator.comparing(dyn -> dyn.getDate("bsed"))).collect(Collectors.toList());
    }

    private WTCTaskRequestStd buildTaskReq(Map<String, Object> map, List<Map<String, Object>> details) {
        long taskId = DB.genGlobalLongId();
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setAppId("wtte");
        request.setTaskId(taskId);
        request.setTrial(false);
        request.setSource(WTCSource.MANUAL.getCode());
        request.setTaskId(taskId);
        request.setVersion(this.getTaskVersionByAccountMode((String)map.get("accountmode"), null));
        String desc = (String)map.get("desc");
        request.setDesc(desc);
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setCategory("wtte_qttie");
        Date startDate = (Date)map.get("startdate");
        request.setStartDate(startDate);
        Date endDate = (Date)map.get("enddate");
        request.setEndDate(endDate);
        Boolean isSaveStep = (Boolean)map.get("savestep");
        Long planId = (Long)map.get("planid");
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)6);
        paramMap.put("number", taskId);
        paramMap.put("name", ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTCalculateService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        paramMap.put("saveStep", isSaveStep);
        paramMap.put("planId", planId);
        paramMap.put("accountmode", map.get("accountmode"));
        paramMap.put("qttype", map.get("qttype"));
        paramMap.put("dyqttype", map.get("dyqttype"));
        Object tiePlanIdObj = map.get("tieplanid");
        if (null != tiePlanIdObj) {
            paramMap.put("tiePlanId", (Long)tiePlanIdObj);
        }
        request.setParams((Map)paramMap);
        request.setDetail(details);
        return request;
    }

    public void afterGenTaskForm(Object param) {
    }

    public static WTCTaskForm genWTCTaskForm(WTCTaskRequestStd request, CloseCallBack closeCallBack, String clickClassName) {
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setCaption(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTCalculateService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanStop(false);
        taskForm.setCanBackground(true);
        taskForm.setTaskRequest((WTCTaskRequest)request);
        taskForm.setClickClassName(clickClassName);
        return taskForm;
    }

    private static Date eraseMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static DynamicObject genQtCalResultDy(WTCTaskRequestStd request, Map<String, Object> map) {
        Object computingBillId;
        DynamicObject resultObject = QTAccountModeHelper.getEmptyDynByAccountMode((String)((String)map.get("accountmode")));
        if (QTAccountModeHelper.isDeductChain((String)((String)map.get("accountmode"))) && (computingBillId = request.getParam("computingBillId")) != null) {
            resultObject.set("computingbillid", computingBillId);
        }
        Boolean isSaveStep = (Boolean)map.get("savestep");
        Long orgId = (Long)map.get("orgId");
        Long planId = (Long)map.get("planid");
        String desc = (String)map.get("desc");
        resultObject.set("qttype", map.get("qttype"));
        resultObject.set("dyqttype", map.get("dyqttype"));
        resultObject.set("savestep", (Object)isSaveStep);
        resultObject.set("org", (Object)orgId);
        resultObject.set("planid", (Object)planId);
        resultObject.set("desc", (Object)desc);
        resultObject.set("creator", (Object)request.getCreatorId());
        resultObject.set("createtime", (Object)new Date());
        resultObject.set("taskid", (Object)request.getTaskId());
        resultObject.set("id", (Object)request.getTaskId());
        resultObject.set("enddate", (Object)QTTaskFormProcessorService.eraseMillis(request.getEndDate()));
        resultObject.set("begindate", (Object)request.getStartDate());
        resultObject.set("version", (Object)request.getVersion());
        DataEntityPropertyCollection propertyCollection = resultObject.getDataEntityType().getProperties();
        MulBasedataProp mulBasedataProp = (MulBasedataProp)propertyCollection.get((Object)"qttype");
        DynamicObjectType mulType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        DynamicObjectCollection qtTypes = new DynamicObjectCollection();
        for (Long qtTypeId : (List)request.getParam("qttype")) {
            DynamicObject dynamicObject = new DynamicObject(mulType);
            dynamicObject.set("fbasedataid_id", (Object)qtTypeId);
            qtTypes.add((Object)dynamicObject);
        }
        resultObject.set("qttype", (Object)qtTypes);
        DynamicObjectCollection dyQtTypes = new DynamicObjectCollection();
        for (Long qtTypeId : (List)request.getParam("dyqttype")) {
            DynamicObject dynamicObject = new DynamicObject(mulType);
            dynamicObject.set("fbasedataid_id", (Object)qtTypeId);
            dyQtTypes.add((Object)dynamicObject);
        }
        resultObject.set("dyqttype", (Object)dyQtTypes);
        if (null != map.get("tieplanid")) {
            resultObject.set("tieplanid", (Object)((Long)map.get("tieplanid")));
        }
        return resultObject;
    }

    public static void handleMsg4callback(HRPageCache cache, IFormView view, boolean closeViewIfNecessary) {
        Map checkErrorInfo = (Map)cache.get("errMsg", Map.class);
        Map checkWarnInfo = (Map)cache.get("warnMsg", Map.class);
        Long taskId = (Long)cache.get("taskId", Long.class);
        cache.remove("errMsg");
        cache.remove("warnMsg");
        cache.remove("taskId");
        if (checkWarnInfo != null && CERT_INFO.equals(checkWarnInfo.get("msgType"))) {
            CertService.showWarnInfoByCertMsg((Map)checkWarnInfo, (IFormView)view);
        }
        if (checkErrorInfo != null) {
            if ("notAttFiles".equals(checkErrorInfo.get("msgType"))) {
                view.showErrorNotification(checkErrorInfo.get("msg").toString());
            } else if (CERT_INFO.equals(checkErrorInfo.get("msgType"))) {
                CertService.showErrorInfoByCertMsg((Map)checkErrorInfo, (IFormView)view);
            }
            return;
        }
        QTTaskFormProcessorService.toCalOverView(taskId, closeViewIfNecessary, view);
    }

    private static void toCalOverView(Long taskId, boolean closeViewIfNecessary, IFormView view) {
        WTCCalTaskEntity wtcTaskEntity;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtte_qtcaloverview");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("taskid", (Object)taskId);
        if (closeViewIfNecessary) {
            formShowParameter.setCustomParam("parentPageId", (Object)view.getPageId());
        }
        if ((wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_qttie", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION)).getTaskStatus().isEnd()) {
            view.showForm(formShowParameter);
        } else if (closeViewIfNecessary) {
            view.close();
        }
    }
}

