/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.quota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class QuotaDetailService {
    private static final HRBaseServiceHelper QUOTA_DETAIL_SERVICE_HELPER = new HRBaseServiceHelper("wtte_quotadetail");
    private static final HRBaseServiceHelper QUOTA_DETAIL_SERVICE_HIS_HELPER = new HRBaseServiceHelper("wtte_quotadetahis");
    private static final HRBaseServiceHelper QUOTA_DETAIL_ADD_HELPER = new HRBaseServiceHelper("wtte_quotadetailadd");
    private static final HRBaseServiceHelper QUOTA_DETAIL_MODFY_HELPER = new HRBaseServiceHelper("wtte_quotadetailmdfy");
    private static final HRBaseServiceHelper QUOTA_DETAIL_EXTENSION_HELPER = new HRBaseServiceHelper("wtte_qtdetailextension");
    private static final HRBaseServiceHelper QUOTA_DETAIL_CARRYAJ_HELPER = new HRBaseServiceHelper("wtte_qtdetailcarryaj");
    private static final HRBaseServiceHelper QUOTA_DATAJSON_SERVICE_HELPER = new HRBaseServiceHelper("wtte_quotadatajson");

    public static void deleteAllDealByFileBoId(Collection<Long> fileBoIds) {
        QUOTA_DETAIL_SERVICE_HELPER.deleteByFilter(new QFilter("attfileid", "in", fileBoIds).toArray());
        QUOTA_DETAIL_SERVICE_HIS_HELPER.deleteByFilter(new QFilter("attfileid", "in", fileBoIds).toArray());
        QUOTA_DATAJSON_SERVICE_HELPER.deleteByFilter(new QFilter("attfileid", "in", fileBoIds).toArray());
        QuotaDetailService.deletDeialAdd(fileBoIds);
        HashSet<String> useStes = new HashSet<String>();
        useStes.add("0");
        useStes.add("-1");
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setSetBoIds(new HashSet<Long>(fileBoIds));
        queryParam.setProperties("id");
        queryParam.setUsableStatus(useStes);
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        if (attFileDys == null || attFileDys.isEmpty()) {
            return;
        }
        ArrayList<Long> attFileVIdList = new ArrayList<Long>(attFileDys.size());
        for (DynamicObject attFileDy : attFileDys) {
            attFileVIdList.add(attFileDy.getLong("id"));
        }
        QUOTA_DETAIL_MODFY_HELPER.deleteByFilter(new QFilter("attfileid", "in", attFileVIdList).toArray());
        QUOTA_DETAIL_EXTENSION_HELPER.deleteByFilter(new QFilter("attfileid", "in", attFileVIdList).toArray());
        QUOTA_DETAIL_CARRYAJ_HELPER.deleteByFilter(new QFilter("attfileid", "in", attFileVIdList).toArray());
    }

    private static void deletDeialAdd(Collection<Long> fileBoIds) {
        DynamicObject[] dysByFileBoId = QUOTA_DETAIL_ADD_HELPER.query("id,entryentity.id,entryentity.attfilebase", new QFilter("entryentity.attfilebase.boid", "in", fileBoIds).toArray());
        if (dysByFileBoId == null || dysByFileBoId.length == 0) {
            return;
        }
        List pks = Arrays.stream(dysByFileBoId).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ArrayList deletPks = Lists.newArrayListWithCapacity((int)pks.size());
        DynamicObjectCollection saveDy = new DynamicObjectCollection();
        for (int i = 0; i < dysByFileBoId.length; ++i) {
            DynamicObject dy2 = dysByFileBoId[i];
            DynamicObjectCollection dynamicObjects = dy2.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection removeDys = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!fileBoIds.contains(dynamicObject.getLong("attfilebase.boid"))) continue;
                removeDys.add((Object)dynamicObject);
            }
            dynamicObjects.removeAll((Collection)removeDys);
            if (dynamicObjects.size() == 0) {
                deletPks.add(dy2.getLong("id"));
                continue;
            }
            saveDy.add((Object)dy2);
        }
        QUOTA_DETAIL_ADD_HELPER.delete(deletPks.toArray());
        if (saveDy.size() > 0) {
            QUOTA_DETAIL_ADD_HELPER.save(saveDy);
        }
    }

    public static Set<Long> getDisCardAttFile(ExtendedDataEntity[] dataEntities) {
        HashSet attFileIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            attFileIds.add(dynamicObject.getLong("attfileid.boid"));
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("boid,number,usablestatus");
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetBoIds((Set)attFileIds);
        HashSet usableStatus = Sets.newHashSetWithExpectedSize((int)2);
        usableStatus.add("-1");
        attFileQueryParam.setUsableStatus((Set)usableStatus);
        List attFileBoDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return attFileBoDyList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
    }
}

