/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtte.common.model.BillQFilterModel;

public class AttRecordSumListRFService {
    private static final Log log = LogFactory.getLog(AttRecordSumListRFService.class);

    public static BillQFilterModel getEvaBillFilterModel(Map<String, Object> qFilters) {
        DynamicObjectCollection attFileCollection;
        DynamicObjectCollection orgCollection;
        DynamicObjectCollection departmentCollection;
        BillQFilterModel billQFilterModel = new BillQFilterModel();
        List<Date> filterDateList = AttRecordSumListRFService.getFilterDateList(qFilters);
        if (filterDateList.isEmpty()) {
            return billQFilterModel;
        }
        Date ownDateEnd = filterDateList.get(filterDateList.size() - 1);
        billQFilterModel.setAuditDate(ownDateEnd);
        DynamicObjectCollection companyCollection = (DynamicObjectCollection)qFilters.get("company");
        if (!companyCollection.isEmpty()) {
            Set companySet = companyCollection.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            billQFilterModel.setCompanySet(companySet);
        }
        if (!(departmentCollection = (DynamicObjectCollection)qFilters.get("department")).isEmpty()) {
            Set departmentSet = departmentCollection.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            billQFilterModel.setAdminOrgSet(departmentSet);
        }
        if (!(orgCollection = (DynamicObjectCollection)qFilters.get("orgid")).isEmpty()) {
            Set orgSet = orgCollection.stream().map(org -> org.getLong("id")).collect(Collectors.toSet());
            billQFilterModel.setOrgSet(orgSet);
        }
        if (!(attFileCollection = (DynamicObjectCollection)qFilters.get("attperinf")).isEmpty()) {
            Set attPersonSet = attFileCollection.stream().map(attPerson -> attPerson.getLong("attperson.id")).collect(Collectors.toSet());
            billQFilterModel.setAttPersonSet(attPersonSet);
        }
        return billQFilterModel;
    }

    public static List<Date> getFilterDateList(Map<String, Object> qFilters) {
        ArrayList dateList = Lists.newArrayListWithExpectedSize((int)2);
        Date ownDateStart = (Date)qFilters.get("owndatestart");
        Date ownDateEnd = (Date)qFilters.get("owndateend");
        if (qFilters.get("attperiodentry") != null) {
            DynamicObject attPeriod = (DynamicObject)qFilters.get("attperiodentry");
            Date attPeriodStartDate = attPeriod.getDate("begindate");
            Date attPeriodEndDate = attPeriod.getDate("enddate");
            if (ownDateStart == null || attPeriodStartDate.after(ownDateStart)) {
                ownDateStart = attPeriodStartDate;
            }
            if (ownDateEnd == null || attPeriodEndDate.before(ownDateEnd)) {
                ownDateEnd = attPeriodEndDate;
            }
        }
        if (ownDateStart.after(ownDateEnd)) {
            return dateList;
        }
        dateList.add(ownDateStart);
        dateList.add(ownDateEnd);
        return dateList;
    }
}

