/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.utils.WTCSheetUtil;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.common.constants.RevisionCommonConstants;
import kd.wtc.wtte.common.enums.RevisionFunEnum;

public class RevisionBatchViewService
implements RevisionCommonConstants {
    private static final Log LOG = LogFactory.getLog(RevisionBatchViewService.class);
    private static final BigDecimal TRIM_MAX_VALUE = BigDecimal.valueOf(999999.99);
    private static final BigDecimal TRIM_MIN_VALUE = BigDecimal.valueOf(-999999.99);
    private static Map<String, String> MAP = null;

    public static RevisionBatchViewService getInstance() {
        return Instance.INSTANCE;
    }

    public void setOrgBatchPage(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            view.getModel().setValue("org", parentView.getModel().getValue("org"));
        }
    }

    private String countNumKey(String page) {
        return page + "_subindex";
    }

    private String dynamicFlex(Integer index, IFormView view) {
        Container flexPanel = (Container)view.getControl("batchflex");
        String key = "subflex" + index;
        FlexPanelAp childFlex = this.getFlexPanelAp(key);
        flexPanel.insertControls(index.intValue(), Collections.singletonList(childFlex.createControl()));
        return key;
    }

    private FlexPanelAp getFlexPanelAp(String key) {
        FlexPanelAp childFlex = new FlexPanelAp();
        childFlex.setKey(key);
        Margin margin = new Margin();
        margin.setBottom("-2px");
        Style style = new Style();
        style.setMargin(margin);
        childFlex.setStyle(style);
        return childFlex;
    }

    public String getSubPageActionId(int idx) {
        return "subattitem" + idx;
    }

    public int closeIndex(String actionId) {
        if (actionId.startsWith("subattitem")) {
            return Integer.parseInt(actionId.substring("subattitem".length()));
        }
        return -1;
    }

    public void addSubPage(IFormView view, IFormPlugin plugin) {
        String page = view.getEntityId();
        String subPage = MAP.get(page);
        WTCPageCache pageCache = new WTCPageCache(view);
        Integer count = (Integer)pageCache.get(this.countNumKey(page), Integer.class);
        pageCache.put(this.countNumKey(page), (Object)(count + 1));
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        DynamicObject org = (DynamicObject)view.getModel().getValue("org");
        long orgId = org != null ? org.getLong("id") : 0L;
        map.put("org", String.valueOf(orgId));
        this.openItemPage(view, page, plugin, subPage, count, map, pageCache);
    }

    private void openItemPage(IFormView view, String page, IFormPlugin plugin, String subPage, Integer index, HashMap<String, Object> map, WTCPageCache pageCache) {
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)this.dynamicFlex(index, view), (String)subPage, (CloseCallBack)new CloseCallBack(plugin, this.getSubPageActionId(index)), map, (OperationStatus)view.getFormShowParameter().getStatus());
        view.showForm(parameter);
        Map pageIdMap = (Map)pageCache.get(page, Map.class);
        if (pageIdMap == null) {
            pageIdMap = Maps.newHashMapWithExpectedSize((int)1);
        }
        pageIdMap.put(String.valueOf(index), parameter.getPageId());
        pageCache.put(page, (Object)pageIdMap);
    }

    public void openSubPage(IFormView view, IFormPlugin plugin) {
        String page = view.getEntityId();
        String subPage = MAP.get(page);
        WTCPageCache pageCache = new WTCPageCache(view);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("new", "new");
        DynamicObject org = (DynamicObject)view.getModel().getValue("org");
        long orgId = org != null ? org.getLong("id") : 0L;
        map.put("org", String.valueOf(orgId));
        pageCache.put(this.countNumKey(page), (Object)1);
        this.openItemPage(view, page, plugin, subPage, 0, map, pageCache);
        ListShowParameter evaParam = new ListShowParameter();
        pageCache.put("personpageid", (Object)evaParam.getPageId());
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setCustomParam("id", (Object)Lists.newArrayListWithExpectedSize((int)0));
        evaParam.setBillFormId("wtte_reattfilebasequery");
        evaParam.setFormId("wtte_reattfilebaquerylist");
        evaParam.setShowFilter(false);
        evaParam.setHasRight(true);
        view.showForm((FormShowParameter)evaParam);
    }

    public void buildSuppleAttFileCache(Object[] attFileIds, WTCPageCache pageCache) {
        if (attFileIds == null || attFileIds.length == 0) {
            return;
        }
        Set idSet = (Set)pageCache.get("person_id", Set.class);
        if (idSet == null) {
            idSet = Sets.newHashSetWithExpectedSize((int)16);
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        for (Object object : attFileIds) {
            if (idSet.contains(object)) continue;
            ids.add(object);
        }
        List boidList = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(WTCStringUtils.joinOnComma((String[])new String[]{"boid"}), new ArrayList(ids)).stream().map(ob -> ob.getLong("boid")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)idSet)) {
            pageCache.put("person_id", boidList);
        } else {
            idSet.addAll(boidList);
            pageCache.put("person_id", (Object)idSet);
        }
    }

    public void deletePerson(IFormView view) {
        WTCPageCache pageCache = new WTCPageCache(view);
        String pageId = (String)pageCache.get("personpageid", String.class);
        IListView subPersonView = (IListView)view.getView(pageId);
        if (HRObjectUtils.isEmpty((Object)subPersonView) || subPersonView.getSelectedRows().isEmpty()) {
            view.showTipNotification(RevisionKDStringHelper.chooseData());
            return;
        }
        pageCache.remove("chooseperson");
        List<Long> delIdList = subPersonView.getSelectedRows().stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        Set idSet = (Set)pageCache.get("person_id", Set.class);
        delIdList.forEach(idSet::remove);
        pageCache.put("person_id", (Object)idSet);
        ListShowParameter evaParam = new ListShowParameter();
        pageCache.put("personpageid", (Object)evaParam.getPageId());
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setCustomParam("id", (Object)idSet);
        evaParam.setBillFormId("wtte_reattfilebasequery");
        evaParam.setFormId("wtte_reattfilebaquerylist");
        evaParam.setHasRight(true);
        view.showForm((FormShowParameter)evaParam);
    }

    public boolean checkAttItemInfo(IFormView view) {
        List<String> list = this.getPageIDList(view);
        String subPage = MAP.get(view.getEntityId());
        for (String pageId : list) {
            DynamicObject attItem;
            IFormView subView = view.getView(pageId);
            if (subView == null) continue;
            DynamicObject dataEntity = subView.getModel().getDataEntity();
            if (HRStringUtils.equals((String)"wtte_moveiteminfo", (String)subPage) || HRStringUtils.equals((String)"wtte_periodmoveiteminfo", (String)subPage)) {
                String unit2;
                String unit;
                long boId;
                attItem = dataEntity.getDynamicObject("attitem");
                if (HRObjectUtils.isEmpty((Object)attItem)) {
                    view.showErrorNotification(RevisionKDStringHelper.attItemEmpty());
                    return false;
                }
                DynamicObject attItemTo = dataEntity.getDynamicObject("attitemto");
                if (HRObjectUtils.isEmpty((Object)attItemTo)) {
                    view.showErrorNotification(RevisionKDStringHelper.attItemToEmpty());
                    return false;
                }
                long toBoId = attItemTo.getLong("boid");
                if (toBoId == (boId = attItem.getLong("boid"))) {
                    view.showErrorNotification(RevisionKDStringHelper.sameItem());
                }
                if (!HRStringUtils.equals((String)(unit = attItem.getString("unit")), (String)(unit2 = attItemTo.getString("unit")))) {
                    view.showErrorNotification(RevisionKDStringHelper.notSameUnit());
                    return false;
                }
            } else {
                attItem = dataEntity.getDynamicObjectCollection("attitem");
                if (attItem.isEmpty()) {
                    view.showErrorNotification(RevisionKDStringHelper.itemEmpty());
                    return false;
                }
                HashSet unitSet = Sets.newHashSetWithExpectedSize((int)attItem.size());
                for (DynamicObject dy : attItem) {
                    unitSet.add(dy.getString("fbasedataid.unit"));
                }
                if (unitSet.size() > 1) {
                    view.showErrorNotification(RevisionKDStringHelper.notSameAttItemUnit());
                    return false;
                }
            }
            BigDecimal value = dataEntity.getBigDecimal("value");
            String entityId = view.getEntityId();
            if (value == null) {
                if (HRStringUtils.equals((String)"wtte_batchdaydetailtrim", (String)entityId) || HRStringUtils.equals((String)"wtte_batchperiodtrim", (String)entityId)) {
                    view.showErrorNotification(RevisionKDStringHelper.valueEmpty());
                } else if (HRStringUtils.equals((String)"wtte_batchdaydetailreset", (String)entityId) || HRStringUtils.equals((String)"wtte_batchperiodreset", (String)entityId)) {
                    view.showErrorNotification(RevisionKDStringHelper.reSetValueEmpty());
                } else {
                    view.showErrorNotification(RevisionKDStringHelper.moveValueEmpty());
                }
                return false;
            }
            RevisionFunEnum revisionFunEnum = RevisionFunEnum.getByOpenPage((String)view.getParentView().getEntityId());
            if (revisionFunEnum == RevisionFunEnum.RESET || revisionFunEnum == RevisionFunEnum.PERIODRESET) {
                if (value.compareTo(TRIM_MIN_VALUE) >= 0 && value.compareTo(TRIM_MAX_VALUE) <= 0) continue;
                view.showErrorNotification(RevisionKDStringHelper.valueScopeError(revisionFunEnum));
                return false;
            }
            if (value.compareTo(BigDecimal.ZERO) > 0 && value.compareTo(TRIM_MAX_VALUE) <= 0) continue;
            view.showErrorNotification(RevisionKDStringHelper.valueScopeError(revisionFunEnum));
            return false;
        }
        return true;
    }

    public List<DynamicObject> getAttItemInfo(IFormView view) {
        List<String> list = this.getPageIDList(view);
        ArrayList attItemDyList = Lists.newArrayListWithExpectedSize((int)list.size());
        for (String pageId : list) {
            IFormView subView = view.getView(pageId);
            if (subView == null) continue;
            IDataModel subModel = subView.getModel();
            attItemDyList.add(subModel.getDataEntity());
        }
        return attItemDyList;
    }

    private List<String> getPageIDList(IFormView view) {
        WTCPageCache pageCache = new WTCPageCache(view);
        String page = view.getEntityId();
        Map pageIdMap = (Map)pageCache.get(page, Map.class);
        if (pageIdMap == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)pageIdMap.size());
        Set entries = pageIdMap.entrySet();
        for (Map.Entry next : entries) {
            list.add(next.getValue());
        }
        return list;
    }

    public void closeSub(String actionId, IFormView view) {
        if (this.closeIndex(actionId) > 0) {
            int index = this.closeIndex(actionId);
            WTCPageCache pageCache = new WTCPageCache(view);
            String page = view.getEntityId();
            Map pageIdMap = (Map)pageCache.get(page, Map.class);
            pageIdMap.remove(String.valueOf(index));
            pageCache.put(page, (Object)pageIdMap);
            Container flexPanel = (Container)view.getControl("batchflex");
            flexPanel.deleteControls(new String[]{"subflex" + index});
        }
    }

    static {
        MAP = Maps.newHashMapWithExpectedSize((int)6);
        MAP.put("wtte_batchdaydetailtrim", "wtte_trimiteminfo");
        MAP.put("wtte_batchdaydetailreset", "wtte_resetiteminfo");
        MAP.put("wtte_batchdaydetailmove", "wtte_moveiteminfo");
        MAP.put("wtte_batchperiodtrim", "wtte_periodtrimiteminfo");
        MAP.put("wtte_batchperiodreset", "wtte_periodresetiteminfo");
        MAP.put("wtte_batchperiodmove", "wtte_periodmoveiteminfo");
    }

    private static class Instance {
        private static RevisionBatchViewService INSTANCE = new RevisionBatchViewService();

        private Instance() {
        }
    }
}

