/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.common.constants.RevisionCommonConstants;

public class RevisionViewService
implements RevisionCommonConstants {
    public static final Set<String> MOVE_ITEM_SET;
    private static final Set<String> TRIM_SET;
    private static final Set<String> SET;
    private static final Set<String> PERIOD_SET;
    private static final Map<String, String> MAP;

    public static RevisionViewService getInstance() {
        return Instance.instance;
    }

    public boolean isPeriod(String pageNumber) {
        return PERIOD_SET.contains(pageNumber);
    }

    public void setOrg(IFormView view, String pageId) {
        String select_org_id = (String)view.getFormShowParameter().getCustomParam("SELECT_ORG_ID");
        long orgId = HRStringUtils.isNotEmpty((String)select_org_id) ? Long.parseLong(select_org_id) : HRAuthService.getInstance().getUserHasPerOrgId(pageId, "wtte");
        view.getModel().setValue("org", (Object)orgId);
    }

    public void registerListener(IFormView view, BeforeF7SelectListener listener) {
        String entityId = view.getEntityId();
        if (SET.contains(entityId)) {
            BasedataEdit attItemTo;
            BasedataEdit attItem = (BasedataEdit)view.getControl("attitem");
            if (attItem != null) {
                attItem.addBeforeF7SelectListener(listener);
            }
            if ((attItemTo = (BasedataEdit)view.getControl("attitemto")) != null) {
                attItemTo.addBeforeF7SelectListener(listener);
            }
        } else {
            MulBasedataEdit attItem = (MulBasedataEdit)view.getControl("attitem");
            if (attItem != null) {
                attItem.addBeforeF7SelectListener(listener);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)"attitem", (String)key) || HRStringUtils.equals((String)"attitemto", (String)key)) {
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
            int entryCurrentRowIndex = view.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject row = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
            Date startDate = row.getDate("startdate");
            Date endDate = row.getDate("enddate");
            if (startDate == null || endDate == null) {
                view.showErrorNotification(RevisionKDStringHelper.dateEmpty());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String entityId = view.getEntityId();
            boolean isDayDetail = false;
            if (HRStringUtils.equals((String)"wtte_daydetailtrim", (String)entityId) || HRStringUtils.equals((String)"wtte_daydetailreset", (String)entityId) || HRStringUtils.equals((String)"wtte_daydetailmove", (String)entityId)) {
                isDayDetail = true;
            }
            beforeF7SelectEvent.addCustomQFilter(this.getItemQFilter(startDate, endDate, isDayDetail));
        }
    }

    public QFilter getItemQFilter(Date startDate, Date endDate, boolean isDayDetail) {
        QFilter itemType = null;
        itemType = isDayDetail ? new QFilter("itemtype", "!=", (Object)"3") : new QFilter("itemtype", "!=", (Object)"1");
        itemType.and(new QFilter("isorginattitem", "=", (Object)"0"));
        itemType.and(new QFilter("issave", "=", (Object)"1"));
        if (startDate != null) {
            itemType.and(new QFilter("firstbsed", "<=", (Object)startDate));
        }
        if (endDate != null) {
            itemType.and(new QFilter("bsled", ">=", (Object)endDate));
        }
        return itemType;
    }

    public void propertyChanged(IFormView view, String changeKey) {
        String entityId = view.getEntityId();
        if (HRStringUtils.equals((String)"value", (String)changeKey)) {
            int entryCurrentRowIndex;
            if (!TRIM_SET.contains(entityId)) {
                return;
            }
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
            DynamicObject row = (DynamicObject)entryEntity.get(entryCurrentRowIndex = view.getModel().getEntryCurrentRowIndex("entryentity"));
            BigDecimal bigDecimal = row.getBigDecimal("value");
            if (bigDecimal == null) {
                return;
            }
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                view.showErrorNotification(RevisionKDStringHelper.notZero());
            }
            return;
        }
        if (!HRStringUtils.equals((String)"attitem", (String)changeKey) && !HRStringUtils.equals((String)"attitemto", (String)changeKey)) {
            return;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        int entryCurrentRowIndex = view.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject row = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        if (SET.contains(entityId)) {
            this.propertyChangedOfMove(row, view, changeKey);
        } else {
            this.propertyChanged(row, view, changeKey);
        }
    }

    private void propertyChangedOfMove(DynamicObject row, IFormView view, String changeKey) {
        if (HRStringUtils.equals((String)"attitem", (String)changeKey) || HRStringUtils.equals((String)"attitemto", (String)changeKey)) {
            DynamicObject attItem = row.getDynamicObject("attitem");
            if (!HRObjectUtils.isEmpty((Object)attItem)) {
                view.getModel().setValue("itemunit", (Object)attItem.getString("unit"));
            }
            DynamicObject attItemTo = row.getDynamicObject("attitemto");
            if (!HRObjectUtils.isEmpty((Object)attItem) && !HRObjectUtils.isEmpty((Object)attItemTo)) {
                long boId;
                long toBoId;
                String unit2;
                String unit = attItem.getString("unit");
                if (!HRStringUtils.equals((String)unit, (String)(unit2 = attItemTo.getString("unit")))) {
                    view.showErrorNotification(RevisionKDStringHelper.notSameUnit());
                }
                if ((toBoId = attItemTo.getLong("boid")) == (boId = attItem.getLong("boid"))) {
                    view.showErrorNotification(RevisionKDStringHelper.sameItem());
                }
            }
        }
    }

    private void propertyChanged(DynamicObject row, IFormView view, String changeKey) {
        DynamicObjectCollection attItem;
        if (HRStringUtils.equals((String)"attitem", (String)changeKey) && (attItem = row.getDynamicObjectCollection("attitem")) != null && !attItem.isEmpty()) {
            HashSet unitSet = Sets.newHashSetWithExpectedSize((int)attItem.size());
            for (DynamicObject dy : attItem) {
                unitSet.add(dy.getString("fbasedataid.unit"));
            }
            if (unitSet.size() > 1) {
                view.showTipNotification(RevisionKDStringHelper.notSameAttItemUnit());
                return;
            }
            view.getModel().setValue("itemunit", WTCCollectionIndexUtil.getEleFromList((List)attItem, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)attItem, (int)0).get()).get("fbasedataid.unit") : null);
        }
    }

    public void openBatchPage(IFormView view, CloseCallBack closeCallBack) {
        Object value = view.getModel().getValue("org");
        if (value == null) {
            view.showErrorNotification(RevisionKDStringHelper.attOrgEmpty());
            return;
        }
        String entityId = view.getEntityId();
        String formId = MAP.get(entityId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("customHREntityNumber", (Object)entityId);
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"attfilebase.affiliateadminorg");
        view.showForm(formShowParameter);
    }

    public void closedCallBackOfBatch(IFormView view, Object returnData) {
        Map map = (Map)returnData;
        List attItem = (List)map.get("attitem");
        List attFile = (List)map.get("attfile");
        Date startDate = (Date)map.get("startdate");
        Date endDate = (Date)map.get("enddate");
        String entityId = view.getEntityId();
        int count = attItem.size() * attFile.size();
        IDataModel model = view.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int curNum = entryEntity.size();
        model.batchCreateNewEntryRow("entryentity", count);
        DateRangeEdit dateRangeEdit = (DateRangeEdit)view.getControl("daterangefield");
        String startDateFieldKey = dateRangeEdit.getStartDateFieldKey();
        String endDateFieldKey = dateRangeEdit.getEndDateFieldKey();
        for (DynamicObject attFileDy : attFile) {
            for (DynamicObject attItemDy : attItem) {
                String type;
                model.setValue("attfilebase", (Object)attFileDy.getLong("boid"), curNum);
                model.setValue("attitem", attItemDy.get("attitem"), curNum);
                if (SET.contains(entityId)) {
                    model.setValue("attitemto", attItemDy.get("attitemto"), curNum);
                }
                BigDecimal value = attItemDy.getBigDecimal("value");
                if ((HRStringUtils.equals((String)"wtte_daydetailtrim", (String)entityId) || HRStringUtils.equals((String)"wtte_periodtrim", (String)entityId)) && HRStringUtils.equals((String)"reduce", (String)(type = attItemDy.getString("type")))) {
                    value = value.negate();
                }
                model.setValue("value", (Object)value, curNum);
                model.setValue("itemunit", attItemDy.get("itemunit"), curNum);
                DateEdit dateEdit = (DateEdit)view.getControl("datefield");
                if (dateEdit != null) {
                    model.setValue("datefield", (Object)startDate, curNum);
                }
                model.setValue(startDateFieldKey, (Object)startDate, curNum);
                model.setValue(endDateFieldKey, (Object)endDate, curNum);
                ++curNum;
            }
        }
        model.endInit();
        view.updateView("entryentity");
    }

    public void showResult(IFormView view, List<DynamicObject> failDyList, int sumNum, String page) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)failDyList.size());
        for (DynamicObject dy : failDyList) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)8);
            DynamicObject attFileDy = dy.getDynamicObject("attfilebase");
            map.put("name", attFileDy.getString("name"));
            map.put("number", attFileDy.getString("number"));
            map.put("attpersonnumber", attFileDy.getString("attperson.number"));
            map.put("daterange", WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)dy.getDate("startdate")) + "-" + WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)dy.getDate("enddate")));
            if (HRStringUtils.equals((String)"wtte_daydetailmove", (String)page) || HRStringUtils.equals((String)"wtte_periodmove", (String)page)) {
                map.put("moveitemname", dy.getString("attitem.name"));
                map.put("moveitemtoname", dy.getString("attitemto.name"));
            } else {
                DynamicObjectCollection coll = dy.getDynamicObjectCollection("attitem");
                List collect = coll.stream().map(dd -> {
                    Object obj = dd.get("fbasedataid.name");
                    if (obj instanceof OrmLocaleValue) {
                        OrmLocaleValue olv = (OrmLocaleValue)obj;
                        return olv.getLocaleValue();
                    }
                    return "";
                }).collect(Collectors.toList());
                map.put("itemname", String.join((CharSequence)"\u3001", collect));
            }
            map.put("value", dy.get("value"));
            map.put("itemunit", dy.getString("itemunit"));
            map.put("failreason", dy.getString("failreason"));
            list.add(map);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtte_revisionresult");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("sumnum", (Object)sumNum);
        showParameter.setCustomParam("failnum", (Object)failDyList.size());
        showParameter.setCustomParam("faildata", (Object)list);
        showParameter.setCustomParam("page", (Object)page);
        view.showForm(showParameter);
    }

    static {
        SET = Sets.newHashSetWithExpectedSize((int)2);
        SET.add("wtte_daydetailmove");
        SET.add("wtte_periodmove");
        TRIM_SET = Sets.newHashSetWithExpectedSize((int)2);
        TRIM_SET.add("wtte_daydetailtrim");
        TRIM_SET.add("wtte_periodtrim");
        MOVE_ITEM_SET = Sets.newHashSetWithExpectedSize((int)2);
        MOVE_ITEM_SET.add("wtte_moveiteminfo");
        MOVE_ITEM_SET.add("wtte_periodmoveiteminfo");
        MAP = Maps.newHashMapWithExpectedSize((int)8);
        MAP.put("wtte_daydetailtrim", "wtte_batchdaydetailtrim");
        MAP.put("wtte_daydetailreset", "wtte_batchdaydetailreset");
        MAP.put("wtte_daydetailmove", "wtte_batchdaydetailmove");
        MAP.put("wtte_periodtrim", "wtte_batchperiodtrim");
        MAP.put("wtte_periodmove", "wtte_batchperiodmove");
        MAP.put("wtte_periodreset", "wtte_batchperiodreset");
        PERIOD_SET = Sets.newHashSetWithExpectedSize((int)3);
        PERIOD_SET.add("wtte_periodtrim");
        PERIOD_SET.add("wtte_periodmove");
        PERIOD_SET.add("wtte_periodreset");
    }

    private static class Instance {
        private static RevisionViewService instance = new RevisionViewService();

        private Instance() {
        }
    }
}

