/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision.valite.imp;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.RevisionViewService;
import kd.wtc.wtte.business.revision.valite.IRevisionValite;
import kd.wtc.wtte.business.utils.RevisionHelp;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

@SingletonBean
public class RevisionAcrossAttFileVailteImp<T extends RevisionValiteReq>
implements IRevisionValite<T> {
    @Override
    public boolean valite(List<String> errorMsg, T object) {
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return true;
        }
        this.setObject(object);
        List attFileBaseInfoList = object.getAttFileBaseInfo();
        if (CollectionUtils.isEmpty((Collection)attFileBaseInfoList)) {
            return true;
        }
        boolean isValite = true;
        boolean isPeriod = RevisionViewService.getInstance().isPeriod(object.getRevisionFunEnum().getOpenPage());
        Map<Long, List<DynamicObject>> attFileBaseInfoMap = attFileBaseInfoList.stream().collect(Collectors.groupingBy(ob -> ob.getLong("boid")));
        for (DynamicObject dynamicObject : revisionVoList) {
            Long attfileBoid = dynamicObject.getLong("attfilebase.boid");
            List<DynamicObject> attFileBaseInfos = attFileBaseInfoMap.get(attfileBoid);
            if (CollectionUtils.isEmpty(attFileBaseInfos)) continue;
            DynamicObject attFileBaseInfo = attFileBaseInfos.get(0);
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("enddate");
            Date attFileStartDate = attFileBaseInfo.getDate("startdate");
            Date attFileEndDate = attFileBaseInfo.getDate("enddate");
            if (attFileStartDate == null || attFileEndDate == null || startDate == null || endDate == null || startDate.compareTo(attFileStartDate) >= 0 && endDate.compareTo(attFileEndDate) <= 0) continue;
            String err = isPeriod ? RevisionKDStringHelper.attFileBaseValiditye(attFileStartDate) : RevisionKDStringHelper.attFileBaseValiditye(attFileStartDate, attFileEndDate);
            dynamicObject.set("failreason", (Object)err);
            errorMsg.add(err);
            isValite = false;
        }
        return isValite;
    }

    private void setObject(T object) {
        if (object.getAttFileBaseInfo() == null) {
            List revisionVoList = object.getRevisionVoList();
            Set<Long> fileBoIds = revisionVoList.stream().map(ob -> ob.getLong("attfilebase.boid")).collect(Collectors.toSet());
            object.setAttFileBaseInfo(RevisionHelp.queryAttFileBaseData(fileBoIds));
        }
    }
}

