/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision.valite.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.valite.IRevisionValite;
import kd.wtc.wtte.common.enums.RevisionFunEnum;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

public class RevisionAttFilePerValiteImp<T extends RevisionValiteReq>
implements IRevisionValite<T> {
    private static final Log LOG = LogFactory.getLog(RevisionAttFilePerValiteImp.class);

    @Override
    public boolean valite(List<String> errorMsg, T object) {
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return true;
        }
        boolean isValite = true;
        RevisionFunEnum revisionFunEnum = object.getRevisionFunEnum();
        String openPage = revisionFunEnum.getOpenPage();
        Map<Long, List<DynamicObject>> map = this.getNotPerAttFileMap(revisionVoList, openPage);
        for (DynamicObject dy : revisionVoList) {
            DynamicObject attFile = dy.getDynamicObject("attfilebase");
            Date startDate = dy.getDate("startdate");
            Date endDate = dy.getDate("enddate");
            long boId = attFile.getLong("boid");
            List<DynamicObject> list = map.get(boId);
            if (list == null || list.isEmpty()) continue;
            ArrayList errorList = Lists.newArrayListWithExpectedSize((int)list.size());
            for (DynamicObject notPerAttFile : list) {
                boolean hasIntersectionLCRC = WTCDateUtils.hasIntersectionLCRC((Date)startDate, (Date)endDate, (Date)notPerAttFile.getDate("bsed"), (Date)notPerAttFile.getDate("bsled"));
                if (!hasIntersectionLCRC) continue;
                isValite = false;
                Date bsed = notPerAttFile.getDate("bsed");
                Date bsled = notPerAttFile.getDate("bsled");
                Date startDateShow = startDate.compareTo(bsed) < 0 ? bsed : startDate;
                Date endDateShow = endDate.compareTo(bsled) > 0 ? bsled : endDate;
                String startDateStr = WTCDateUtils.date2Str((Date)startDateShow, (String)"yyyy-MM-dd");
                String endDateStr = WTCDateUtils.date2Str((Date)endDateShow, (String)"yyyy-MM-dd");
                errorList.add(RevisionKDStringHelper.to(startDateStr, endDateStr));
            }
            if (errorList.isEmpty()) continue;
            String dateStr = String.join((CharSequence)"\u3001", errorList);
            String errMsg = RevisionKDStringHelper.norAttFilePer(attFile.getString("name"), dateStr);
            errorMsg.add(errMsg);
            dy.set("failreason", (Object)errMsg);
        }
        return isValite;
    }

    private Map<Long, List<DynamicObject>> getNotPerAttFileMap(List<DynamicObject> revisionVoList, String openPage) {
        AttFileQueryParam all = new AttFileQueryParam(false);
        all.setBeCurrent(Boolean.FALSE);
        List collect = revisionVoList.stream().map(dy -> dy.getLong("attfilebase.boid")).collect(Collectors.toList());
        QFilter selectId = new QFilter("boid", "in", new ArrayList(collect));
        all.setqFilter(selectId);
        all.setProperties("boid" + "," + "id" + "," + "bsed" + "," + "bsled");
        List allAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(all);
        Set allIdSet = allAttFileList.stream().map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        LOG.info("RevisionAttFilePerValiteImp_getNotPerAttFileMap_allIdSet: {}", allIdSet);
        HasPermOrgResult allPermOrg = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrg(UserServiceHelper.getCurrentUserId(), "wtte", openPage, "47150e89000000ac");
        AttFileQueryParam havePer = new AttFileQueryParam(false);
        if (!allPermOrg.hasAllOrgPerm()) {
            List hasPermOrgs = allPermOrg.getHasPermOrgs();
            HashSet orgSetIds = Sets.newHashSetWithExpectedSize((int)hasPermOrgs.size());
            orgSetIds.addAll(hasPermOrgs);
            havePer.setOrgSetIds((Set)orgSetIds);
        }
        havePer.setqFilter(selectId);
        havePer.setBeCurrent(Boolean.FALSE);
        havePer.setAuthCheck(Boolean.FALSE);
        QFilter dataRuleForBdProp = HRAuthService.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), "wtte", openPage, "attfilebase", "47150e89000000ac", null);
        havePer.setqFilter(dataRuleForBdProp);
        havePer.setProperties("id");
        List havePerAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(havePer);
        Set havePerSet = havePerAttFileList.stream().map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        LOG.info("RevisionAttFilePerValiteImp_getNotPerAttFileMap_havePerSet: {}", havePerSet);
        allIdSet.removeAll(havePerSet);
        HashMap map = Maps.newHashMapWithExpectedSize((int)allAttFileList.size());
        for (DynamicObject dy2 : allAttFileList) {
            long boId = dy2.getLong("boid");
            long id = dy2.getLong("id");
            if (!allIdSet.contains(id)) continue;
            List list = (List)map.get(boId);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)16);
            }
            list.add(dy2);
            map.put(boId, list);
        }
        return map;
    }
}

