/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision.valite.imp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.valite.IRevisionValite;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

public class RevisionAttFileTagValiteImp<T extends RevisionValiteReq>
implements IRevisionValite<T> {
    @Override
    public boolean valite(List<String> errorMsg, T object) {
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return true;
        }
        boolean isValite = true;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_attendtag");
        DynamicObject[] tagArr = hrBaseServiceHelper.query("id", new QFilter[]{new QFilter("attendstatus", "=", (Object)AttStatusEnum.ATT_STOP.getCode())});
        Set stopTagSet = Arrays.stream(tagArr).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject dy : revisionVoList) {
            Date stopDate;
            DynamicObject attFile = dy.getDynamicObject("attfilebase");
            Date endDate = dy.getDate("enddate");
            long attTagId = attFile.getLong("atttag.id");
            if (!stopTagSet.contains(attTagId) || (stopDate = attFile.getDate("bsed")).getTime() > endDate.getTime()) continue;
            isValite = false;
            String stopDateStr = WTCDateUtils.date2Str((Date)stopDate, (String)"yyyy-MM-dd");
            String errMsg = RevisionKDStringHelper.stopAttTag(stopDateStr);
            dy.set("failreason", (Object)errMsg);
            errorMsg.add(errMsg);
        }
        return isValite;
    }
}

