/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision.valite.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.valite.IRevisionValite;
import kd.wtc.wtte.common.enums.RevisionFunEnum;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

@SingletonBean
public class RevisionAttItemValiteImp<T extends RevisionValiteReq>
implements IRevisionValite<T> {
    @Override
    public boolean valite(List<String> errorMsg, T object) {
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return true;
        }
        RevisionFunEnum revisionFunEnum = object.getRevisionFunEnum();
        String revisionFunEnumKey = revisionFunEnum.getKey();
        if (HRStringUtils.equals((String)"move", (String)revisionFunEnumKey)) {
            return this.checkMoveUnit(revisionVoList, errorMsg);
        }
        return this.checkUnit(revisionVoList, errorMsg);
    }

    private boolean checkUnit(List<DynamicObject> revisionVoList, List<String> errorMsg) {
        boolean isValite = true;
        Map<Long, Date> map = this.getBoIdToDate(revisionVoList, false);
        for (DynamicObject dy : revisionVoList) {
            Date startDate = dy.getDate("startdate");
            DynamicObjectCollection attItemList = dy.getDynamicObjectCollection("attitem");
            HashSet unitSet = Sets.newHashSetWithExpectedSize((int)attItemList.size());
            for (DynamicObject attItem : attItemList) {
                long boId = attItem.getLong("fbasedataid.boid");
                Date bred = map.get(boId);
                if (bred != null && startDate.compareTo(bred) < 0) {
                    String err = RevisionKDStringHelper.notBred(attItem.getString("fbasedataid.name"));
                    errorMsg.add(err);
                    dy.set("failreason", (Object)err);
                    isValite = false;
                    continue;
                }
                unitSet.add(attItem.getString("fbasedataid.unit"));
            }
            if (unitSet.size() <= 1) continue;
            String err = RevisionKDStringHelper.notSameAttItemUnit();
            errorMsg.add(err);
            dy.set("failreason", (Object)err);
            isValite = false;
        }
        return isValite;
    }

    private boolean checkMoveUnit(List<DynamicObject> revisionVoList, List<String> errorMsg) {
        boolean isValite = true;
        Map<Long, Date> map = this.getBoIdToDate(revisionVoList, true);
        for (DynamicObject dy : revisionVoList) {
            String unit2;
            long boId;
            Date startDate = dy.getDate("startdate");
            DynamicObject attItem = dy.getDynamicObject("attitem");
            long boIdA = attItem.getLong("boid");
            Date bredA = map.get(boIdA);
            if (bredA != null && startDate.compareTo(bredA) < 0) {
                String err = RevisionKDStringHelper.notBred(attItem.getString("name"));
                errorMsg.add(err);
                dy.set("failreason", (Object)err);
                isValite = false;
                continue;
            }
            DynamicObject attItemTo = dy.getDynamicObject("attitemto");
            long boIdB = attItem.getLong("boid");
            Date bredB = map.get(boIdB);
            if (bredB != null && startDate.compareTo(bredB) < 0) {
                isValite = false;
                String err = RevisionKDStringHelper.notBred(attItem.getString("name"));
                errorMsg.add(err);
                dy.set("failreason", (Object)err);
                continue;
            }
            long toBoId = attItemTo.getLong("boid");
            if (toBoId == (boId = attItem.getLong("boid"))) {
                String err = RevisionKDStringHelper.sameItem();
                errorMsg.add(err);
                dy.set("failreason", (Object)err);
                isValite = false;
                continue;
            }
            String unit = attItem.getString("unit");
            if (HRStringUtils.equals((String)unit, (String)(unit2 = attItemTo.getString("unit")))) continue;
            String err = RevisionKDStringHelper.notSameUnit();
            errorMsg.add(err);
            dy.set("failreason", (Object)err);
            isValite = false;
        }
        return isValite;
    }

    private Map<Long, Date> getBoIdToDate(List<DynamicObject> revisionVoList, boolean isMove) {
        DynamicObject[] query;
        ArrayList attItemBoLdList = Lists.newArrayListWithCapacity((int)revisionVoList.size());
        for (DynamicObject dy : revisionVoList) {
            DynamicObject attItem;
            if (isMove) {
                attItem = dy.getDynamicObject("attitem");
                DynamicObject attItemTo = dy.getDynamicObject("attitemto");
                attItemBoLdList.add(attItem.getLong("boid"));
                attItemBoLdList.add(attItemTo.getLong("boid"));
                continue;
            }
            attItem = dy.getDynamicObjectCollection("attitem");
            List collect = attItem.stream().map(dd -> dd.getLong("fbasedataid.boid")).collect(Collectors.toList());
            attItemBoLdList.addAll(collect);
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)revisionVoList.size());
        HRBaseServiceHelper service = new HRBaseServiceHelper("wtbd_attitem");
        QFilter dataStatus = WTCHisServiceHelper.dataStatusValidQFilter();
        QFilter boIdQFilter = new QFilter("boid", "in", (Object)attItemBoLdList);
        for (DynamicObject dy : query = service.query("id,firstbsed,bsed,bred,boid", new QFilter[]{dataStatus, boIdQFilter})) {
            long boId = dy.getLong("boid");
            Date bred = dy.getDate("bsed");
            Date date = (Date)map.get(boId);
            if (date == null) {
                map.put(boId, bred);
                continue;
            }
            if (bred.compareTo(date) >= 0) continue;
            map.put(boId, bred);
        }
        return map;
    }
}

