/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision.valite.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.enums.WTTESystemParamEnum;
import kd.wtc.wtbs.common.util.WTTESystemParamQueryUtil;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.valite.IRevisionValite;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

@SingletonBean
public class RevisionFreezeValiteImp<T extends RevisionValiteReq>
implements IRevisionValite<T> {
    @Override
    public boolean valite(List<String> errorMsg, T object) {
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return true;
        }
        this.setObject(object);
        Map attStateInfoMap = object.getAttStateInfoMap();
        if (CollectionUtils.isEmpty((Map)attStateInfoMap)) {
            return true;
        }
        boolean freezeSystemParam = WTTESystemParamQueryUtil.getFreezeSystemParam((WTTESystemParamEnum)WTTESystemParamEnum.ADJUSTMENT_ATT_ITEM);
        if (!freezeSystemParam) {
            return true;
        }
        boolean isValite = true;
        for (DynamicObject dynamicObject : revisionVoList) {
            Long attfileBoid = dynamicObject.getLong("attfilebase.boid");
            AttStateInfoBO attStateInfoBO = (AttStateInfoBO)attStateInfoMap.get(attfileBoid);
            if (attStateInfoBO == null) continue;
            Date frozenStartDate = attStateInfoBO.getFrozenStartDate();
            Date frozenEndDate = attStateInfoBO.getFronzenEnDate();
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("enddate");
            if (frozenStartDate == null || frozenEndDate == null || startDate == null || endDate == null || startDate.compareTo(frozenEndDate) > 0 || endDate.compareTo(frozenStartDate) < 0) continue;
            String err = RevisionKDStringHelper.archivesFreeze(frozenStartDate, frozenEndDate);
            dynamicObject.set("failreason", (Object)err);
            errorMsg.add(err);
            isValite = false;
        }
        return isValite;
    }

    private void setObject(T object) {
        if (object.getAttStateInfoMap() == null) {
            List revisionVoList = object.getRevisionVoList();
            Set fileBoIds = revisionVoList.stream().map(ob -> ob.getLong("attfilebase.boid")).collect(Collectors.toSet());
            List attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList(fileBoIds));
            HashMap<Long, AttStateInfoBO> attStateInfoBOMap = new HashMap<Long, AttStateInfoBO>(attStateInfoBOS.size());
            for (AttStateInfoBO attStateInfoBO : attStateInfoBOS) {
                attStateInfoBOMap.put(attStateInfoBO.getFileBoid(), attStateInfoBO);
            }
            object.setAttStateInfoMap(attStateInfoBOMap);
        }
    }
}

