/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision.valite.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.RevisionViewService;
import kd.wtc.wtte.business.revision.valite.IRevisionValite;
import kd.wtc.wtte.business.revision.valite.imp.RevisionAttFilePerValiteImp;
import kd.wtc.wtte.business.utils.RevisionHelp;
import kd.wtc.wtte.business.utils.RevisionInitData;
import kd.wtc.wtte.common.enums.RevisionFunEnum;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

@SingletonBean
public class RevisionResetValiteImp<T extends RevisionValiteReq>
implements IRevisionValite<T> {
    private static final Log LOG = LogFactory.getLog(RevisionAttFilePerValiteImp.class);

    @Override
    public boolean valite(List<String> errorMsg, T object) {
        LOG.info("time0:{}", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return true;
        }
        if (object.getResetMapList() == null && !this.valiteCurBill(object, errorMsg)) {
            return false;
        }
        LOG.info("time1:{}", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.setObject(object);
        LOG.info("time2:{}", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (!this.valiteAllElseBiLL(object, errorMsg)) {
            return false;
        }
        LOG.info("time7:{}", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        return true;
    }

    private void setObject(T object) {
        if (object.getResetMapList() == null) {
            RevisionInitData revisionInitData = RevisionInitData.of(Lists.newArrayList((Object[])new DynamicObject[]{object.getSingleDynamicObject()}), object.getRevisionFunEnum());
            object.setResetMapList(revisionInitData.getResetMapList());
        }
    }

    private boolean valiteAllElseBiLL(T object, List<String> errorMsg) {
        boolean isValite = true;
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return isValite;
        }
        List resetMapList = object.getResetMapList();
        String errName = this.getErrorName(object.getRevisionFunEnum());
        for (DynamicObject dynamicObject : revisionVoList) {
            Long attfileBaseBoId;
            Date endDate;
            Date startDate;
            if (this.valiteAllBill(errName, resetMapList, dynamicObject, startDate = dynamicObject.getDate("startdate"), endDate = dynamicObject.getDate("enddate"), attfileBaseBoId = Long.valueOf(dynamicObject.getLong("attfilebase.boid")), errorMsg)) continue;
            isValite = false;
        }
        return isValite;
    }

    private String getErrorName(RevisionFunEnum revisionFunEnum) {
        if (HRStringUtils.equals((String)"day", (String)revisionFunEnum.getCode())) {
            return RevisionFunEnum.RESET.getValue();
        }
        return RevisionFunEnum.PERIODRESET.getValue();
    }

    private boolean valiteAllBill(String errName, List<Map<String, Object>> resetMapList, DynamicObject dynamicObject, Date curStartDate, Date curEndDate, Long attfileBaseboId, List<String> errorMsg) {
        boolean isValite = true;
        StringBuilder errMsg = new StringBuilder();
        for (Map<String, Object> resetDy : resetMapList) {
            String number = (String)resetDy.get("number");
            Date startDate = (Date)resetDy.get("entryentity.startdate");
            Date endDate = (Date)resetDy.get("entryentity.enddate");
            if (startDate == null || endDate == null || this.isFail(attfileBaseboId, resetDy, dynamicObject, startDate, endDate, curStartDate, curEndDate, number, errMsg)) continue;
            isValite = false;
        }
        if (!isValite) {
            String errStr = RevisionKDStringHelper.reseptAllDetail(errName, errMsg.substring(0, errMsg.lastIndexOf("\u3001")));
            errorMsg.add(errStr);
            dynamicObject.set("failreason", (Object)errStr);
        }
        return isValite;
    }

    private boolean valiteCurBill(T object, List<String> errorMsg) {
        RevisionFunEnum revisionFunEnum = object.getRevisionFunEnum();
        String openPage = revisionFunEnum.getOpenPage();
        boolean isPeriod = RevisionViewService.getInstance().isPeriod(openPage);
        List revisionVoList = object.getRevisionVoList();
        boolean isValite = true;
        if (revisionFunEnum == RevisionFunEnum.PERIODRESET || revisionFunEnum == RevisionFunEnum.RESET) {
            Map<Long, Map<Object, List<DynamicObject>>> resetMap = this.geneResetMap(revisionVoList);
            for (DynamicObject dynamicObject : revisionVoList) {
                if (this.valiteCurRowIndex(dynamicObject, resetMap, errorMsg, isPeriod)) continue;
                isValite = false;
            }
        }
        return isValite;
    }

    private Map<Long, Map<Object, List<DynamicObject>>> geneResetMap(List<DynamicObject> revisionVoList) {
        HashMap resetMap = Maps.newHashMapWithExpectedSize((int)revisionVoList.size());
        for (DynamicObject curDynamicObject : revisionVoList) {
            Long curAttPersionId = curDynamicObject.getLong("attfilebase.boid");
            Map map = resetMap.computeIfAbsent(curAttPersionId, key -> new HashMap());
            Set<Object> attItemIds = RevisionHelp.getAttItemIds(curDynamicObject);
            for (Object attItemId : attItemIds) {
                List dynamicObjectList = map.computeIfAbsent(attItemId, key -> new ArrayList());
                dynamicObjectList.add(curDynamicObject);
            }
        }
        return resetMap;
    }

    private boolean valiteCurRowIndex(DynamicObject curDynamicObject, Map<Long, Map<Object, List<DynamicObject>>> resetMap, List<String> errorMsg, boolean isPeriod) {
        boolean isValite = true;
        StringBuilder errMsg = new StringBuilder();
        Long curAttPersionId = curDynamicObject.getLong("attfilebase.boid");
        Map<Object, List<DynamicObject>> dyMap = resetMap.get(curAttPersionId);
        Set<Object> curAttItemIds = RevisionHelp.getAttItemIds(curDynamicObject);
        for (Object attItemId : curAttItemIds) {
            List<DynamicObject> dyList = dyMap.get(attItemId);
            for (DynamicObject dynamicObject : dyList) {
                if (dynamicObject == curDynamicObject) continue;
                Date startDate = dynamicObject.getDate("startdate");
                Date endDate = dynamicObject.getDate("enddate");
                Date curStartDate = curDynamicObject.getDate("startdate");
                Date curEndDate = curDynamicObject.getDate("enddate");
                if (startDate == null || endDate == null || curStartDate == null || curEndDate == null || this.isCurIndexFail(curDynamicObject, startDate, endDate, curStartDate, curEndDate, errMsg, isPeriod)) continue;
                isValite = false;
            }
        }
        if (!isValite) {
            String errStr = errMsg.toString();
            errorMsg.add(errStr);
            curDynamicObject.set("failreason", (Object)errStr);
        }
        return isValite;
    }

    private boolean isFail(Long attfileBaseBoId, Map<String, Object> resetMap, DynamicObject curDynamicObject, Date startDate, Date endDate, Date curStartDate, Date curEndDate, String number, StringBuilder failMsg) {
        Set<Object> curAttItemIds;
        if (attfileBaseBoId.equals(resetMap.get("entryentity.attfilebase.boid")) && startDate.compareTo(curEndDate) <= 0 && endDate.compareTo(curStartDate) >= 0 && (curAttItemIds = RevisionHelp.getAttItemIds(curDynamicObject)).contains(resetMap.get("entryentity.attitem.fbasedataid.boid"))) {
            failMsg.append(number).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isCurIndexFail(DynamicObject curDynamicObject, Date startDate, Date endDate, Date curStartDate, Date curEndDate, StringBuilder failMsg, boolean isPeriod) {
        if (startDate.compareTo(curEndDate) <= 0 && endDate.compareTo(curStartDate) >= 0) {
            if (isPeriod) {
                failMsg.append(RevisionKDStringHelper.resetDetail(curDynamicObject.getString("attfilebase.name"), startDate));
            } else {
                failMsg.append(RevisionKDStringHelper.reseptDetail(curDynamicObject.getString("attfilebase.name"), startDate, endDate));
            }
            return false;
        }
        return true;
    }
}

