/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.revision.valite.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.valite.IRevisionValite;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

@SingletonBean
public class RevisionStopValiteImp<T extends RevisionValiteReq>
implements IRevisionValite<T> {
    @Override
    public boolean valite(List<String> errorMsg, T object) {
        List revisionVoList = object.getRevisionVoList();
        if (CollectionUtils.isEmpty((Collection)revisionVoList)) {
            return true;
        }
        this.setObject(object);
        Map attStateInfoMap = object.getAttStateInfoMap();
        if (CollectionUtils.isEmpty((Map)attStateInfoMap)) {
            return true;
        }
        boolean isValite = true;
        for (DynamicObject dynamicObject : revisionVoList) {
            Long attfileBoid = dynamicObject.getLong("attfilebase.boid");
            AttStateInfoBO attStateInfoBO = (AttStateInfoBO)attStateInfoMap.get(attfileBoid);
            if (attStateInfoBO == null) continue;
            Date stopAgeToDate = attStateInfoBO.getStorageTo();
            Date startDate = dynamicObject.getDate("startdate");
            if (stopAgeToDate == null || startDate == null || startDate.compareTo(stopAgeToDate) > 0) continue;
            String errMsg = RevisionKDStringHelper.stopTo(stopAgeToDate);
            errorMsg.add(errMsg);
            dynamicObject.set("failreason", (Object)errMsg);
            isValite = false;
        }
        return isValite;
    }

    private void setObject(T object) {
        if (object.getAttStateInfoMap() == null) {
            List revisionVoList = object.getRevisionVoList();
            Set fileBoIds = revisionVoList.stream().map(ob -> ob.getLong("attfilebase.boid")).collect(Collectors.toSet());
            List attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList(fileBoIds));
            HashMap<Long, AttStateInfoBO> attStateInfoBOMap = new HashMap<Long, AttStateInfoBO>(attStateInfoBOS.size());
            for (AttStateInfoBO attStateInfoBO : attStateInfoBOS) {
                attStateInfoBOMap.put(attStateInfoBO.getFileBoid(), attStateInfoBO);
            }
            object.setAttStateInfoMap(attStateInfoBOMap);
        }
    }
}

