/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attperiod.AttPeriodService;
import kd.wtc.wtte.business.settle.AttSettleService;
import kd.wtc.wtte.common.enums.attsettle.LockModeEnum;

public class AttSettleServiceImpl
implements AttSettleService {
    private AttSettleServiceImpl() {
    }

    public static AttSettleServiceImpl getInstance() {
        return AttFileSettleInstance.singleton;
    }

    public static List<Long> getSubAdminOrg(List<Long> adminOrgList) {
        List adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg(adminOrgList, new Date());
        List<Long> subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
        subOrgIdList.addAll(adminOrgList);
        return subOrgIdList;
    }

    @Override
    public Object showAttFileInfoDetails(DynamicObject dynamicObject) {
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet excludeAttFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet includeAttFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        this.getSelectAdminOrgAndExcludeAttFile(dynamicObject, adminOrgIds, excludeAttFileBoIds, includeAttFileBoIds);
        Page<DynamicObject> dynamicObjectPage = this.queryAttFileF7(adminOrgIds, excludeAttFileBoIds, includeAttFileBoIds);
        return this.getListShowParameter(dynamicObjectPage);
    }

    protected ListShowParameter getListShowParameter(Page<DynamicObject> dynamicObjectPage) {
        List listRecords = dynamicObjectPage.getListRecords();
        List ids = listRecords.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("ids", ids);
        parameter.setBillFormId("wtp_settlefilequerylist");
        parameter.setHasRight(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1000");
        styleCss.setHeight("600");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        return parameter;
    }

    public Page<DynamicObject> queryAttFileF7(Set<Long> adminOrgIds, Set<Long> excludeAttFileBoIds, Set<Long> includeBoIds) {
        AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam(false);
        attFileF7QueryParam.setProperties("id, affiliateadminorg, boid");
        attFileF7QueryParam.setAffiliateAdminOrgSetIds(adminOrgIds);
        attFileF7QueryParam.setBoDelSetIds(excludeAttFileBoIds);
        attFileF7QueryParam.setSetBoIds(includeBoIds);
        attFileF7QueryParam.setFormId("wtte_settletaskdetail");
        attFileF7QueryParam.setAppId("wtte");
        attFileF7QueryParam.setPermField("attfile");
        attFileF7QueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        return AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileF7QueryParam, 0, 1000000);
    }

    public void getSelectAdminOrgAndExcludeAttFile(DynamicObject dataEntity, Set<Long> adminOrgIds, Set<Long> excludeAttFileBoIds, Set<Long> includeAttFileBoIds) {
        DynamicObjectCollection orgColl = dataEntity.getDynamicObjectCollection("orgentry");
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            adminOrgIds.add(0L);
            return;
        }
        for (DynamicObject entryOrgDy : orgColl) {
            if (!"haos_adminorghr".equals(entryOrgDy.getString("orgtype"))) continue;
            adminOrgIds.add(entryOrgDy.getLong("orgclass.id"));
            DynamicObjectCollection excludePersonColl = entryOrgDy.getDynamicObjectCollection("experson");
            if (CollectionUtils.isEmpty((Collection)excludePersonColl)) continue;
            excludePersonColl.forEach(excludePersonDy -> {
                long attFileBoId;
                DynamicObject dynamicObject = excludePersonDy.getDynamicObject("fbasedataid");
                if (dynamicObject != null && !includeAttFileBoIds.contains(attFileBoId = dynamicObject.getLong("boid"))) {
                    excludeAttFileBoIds.add(attFileBoId);
                }
            });
        }
        if (!this.isLockBySpecifyDateSettle(dataEntity)) {
            long settlePeriodId = dataEntity.getLong("settleperiod.id");
            Map periodFileMap = AttPeriodService.getPeriodEntryFileIdMapByPeriodEntryId((Set)Sets.newHashSet((Object[])new Long[]{settlePeriodId}));
            if (WTCCollections.isNotEmpty((Map)periodFileMap)) {
                includeAttFileBoIds.addAll((Collection)periodFileMap.get(settlePeriodId));
            } else {
                includeAttFileBoIds.add(0L);
            }
        }
    }

    public boolean isLockBySpecifyDateSettle(DynamicObject pageDy) {
        DataEntityPropertyCollection properties = pageDy.getDataEntityType().getProperties();
        return properties.containsKey((Object)"lockway") && LockModeEnum.BYEXACTDATE.getLockMode().equals(pageDy.getString("lockway"));
    }

    private static class AttFileSettleInstance {
        private static final AttSettleServiceImpl singleton = new AttSettleServiceImpl();

        private AttFileSettleInstance() {
        }
    }
}

