/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriodParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtte.business.settle.AttSettleServiceImpl;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.common.constants.AttSettleConstants;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.LockModeEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleModeEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleTaskReqVo;

public class SettleFormService {
    private static Log LOG = LogFactory.getLog(SettleCheckEntity.class);
    private static final TaskRepository TASKREPOSITORY = TaskRepositoryImpl.getInstance();
    private static final MainTaskDetector MTDETECTOR = new MainTaskDetectorImpl(TASKREPOSITORY);

    private static Set<Long> getSelectPerson(DynamicObject dataEntity, String property) {
        DynamicObjectCollection extraPersonColl = dataEntity.getDynamicObjectCollection("personentry");
        if (CollectionUtils.isEmpty((Collection)extraPersonColl)) {
            return new HashSet<Long>();
        }
        return extraPersonColl.stream().map(item -> item.getDynamicObject("attfilebase").getLong(property)).collect(Collectors.toSet());
    }

    public static void getSelectAdminOrgAndExcludeAttFile(DynamicObject dataEntity, Set<Long> adminOrgIds, Set<Long> excludeAttFileBoIds, Set<Long> includeAttFileBoIds) {
        DynamicObjectCollection orgColl = dataEntity.getDynamicObjectCollection("orgentry");
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            return;
        }
        for (DynamicObject entryOrgDy : orgColl) {
            String orgType = entryOrgDy.getString("orgtype");
            long orgClassId = entryOrgDy.getLong("orgclass.id");
            if (!"haos_adminorghr".equals(orgType)) continue;
            adminOrgIds.add(orgClassId);
            DynamicObjectCollection excludePersonColl = entryOrgDy.getDynamicObjectCollection("experson");
            if (CollectionUtils.isEmpty((Collection)excludePersonColl)) continue;
            excludePersonColl.forEach(excludePersonDy -> {
                DynamicObject dynamicObject = excludePersonDy.getDynamicObject("fbasedataid");
                if (dynamicObject != null && !includeAttFileBoIds.contains(dynamicObject.getLong("boid"))) {
                    excludeAttFileBoIds.add(dynamicObject.getLong("boid"));
                }
            });
        }
    }

    public static List<Long> getSubAdminOrg(List<Long> adminOrgList) {
        List adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg(adminOrgList, new Date());
        List<Long> subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
        subOrgIdList.addAll(adminOrgList);
        return subOrgIdList;
    }

    public static SettleFormService getInstance() {
        return (SettleFormService)WTCAppContextHelper.getBean(SettleFormService.class);
    }

    public String getCodeRuleNumber() {
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        MainEntityType wttePairTimeType = MetadataServiceHelper.getDataEntityType((String)"wtte_settle");
        DynamicObject pairTimeDynamicObject = new DynamicObject((DynamicObjectType)wttePairTimeType);
        return coderule.getNumber("wtte_settle", pairTimeDynamicObject, null);
    }

    public WTCTaskForm genSettleWTCTaskForm(SettleTaskReqVo settleTaskReqVo, String caption, CloseCallBack settleCloseCallBack, boolean canStop, boolean canBackground, String clickClassName) {
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setType("wtte_settle");
        taskForm.setCaption(caption);
        taskForm.setCloseCallBack(settleCloseCallBack);
        taskForm.setCanStop(canStop);
        taskForm.setCanBackground(canBackground);
        taskForm.setClickClassName(clickClassName);
        HashMap params = Maps.newHashMapWithExpectedSize((int)10);
        params.put("SettleTaskReqVo", SerializationUtils.serializeToBase64((Object)settleTaskReqVo));
        taskForm.setCustomParams((Map)params);
        return taskForm;
    }

    public FormShowParameter genShowAttSettleFormPage(String formId, SettleTypeEnum settleTypeEnum, long orgId, CloseCallBack closeCallBack) {
        FormShowParameter parameter = DataBaseEditService.getFormShowParameter((String)formId, (ShowType)ShowType.MainNewTabPage);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCaption(new LocaleString(WTCStringUtils.joinStr((String[])new String[]{AttSettleKDString.getAttSettleAddCaption(), "-", settleTypeEnum.getMsg().loadKDString()})).toString());
        parameter.setCustomParam("settletype", (Object)JSON.toJSONString((Object)settleTypeEnum));
        parameter.setCustomParam("org", (Object)orgId);
        return parameter;
    }

    public void genShowTaskProgress(IFormPlugin plugin, IFormView view, Set<Long> fileVidSet, DynamicObject settleDy, String description) {
        SettleTaskReqVo settleTaskReqVo = SettleFormService.getInstance().getSettleTaskReqVoBySettleDy(fileVidSet, settleDy, description, null);
        String caption = AttSettleKDString.getAttSettleText() + "-" + settleTaskReqVo.getVersion();
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "task");
        WTCTaskForm taskForm = SettleFormService.getInstance().genSettleWTCTaskForm(settleTaskReqVo, caption, closeCallBack, true, true, "kd.wtc.wtte.formplugin.web.settle.SettleTaskClick");
        WTCDistributeTaskHelper.showProgress((IFormView)view, (CloseCallBack)closeCallBack, (String)caption, (String)"wtte_settle", (Object)taskForm);
    }

    public SettleTaskReqVo getSettleTaskReqVoBySettleDy(Set<Long> vidSet, DynamicObject settleDy, String description, IPageCache cache) {
        Date specifyDate;
        Map cacheMap;
        SettleTaskReqVo settleTaskReqVo = new SettleTaskReqVo();
        settleTaskReqVo.setDescription(description);
        settleTaskReqVo.setAttFileVersionIds(vidSet);
        settleTaskReqVo.setTaskId(Long.valueOf(settleDy.getLong("task")));
        settleTaskReqVo.setVersion(settleDy.getString("number"));
        settleTaskReqVo.setSettleTypeEnum(SettleTypeEnum.getSettleTypeEnumBySettleType((String)settleDy.getString("settletype")));
        settleTaskReqVo.setLockEndDate(settleDy.getDate("specifydate"));
        settleTaskReqVo.setPeriod(Long.valueOf(settleDy.getLong("settleperiod.id")));
        String settleType = new PerAttPeriodParam(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)settleDy, (String)"org")).getSettleType();
        settleTaskReqVo.setBeSettleCut("2".equals(settleType));
        if (cache != null && (cacheMap = cache.getAll()).containsKey("affiliateadminorg") && cacheMap.containsKey("attfile")) {
            List affiliateAdminOrgList = JSON.parseArray((String)((String)cacheMap.get("affiliateadminorg")), Long.class);
            List attFileList = JSON.parseArray((String)((String)cacheMap.get("attfile")), Long.class);
            if (!CollectionUtils.isEmpty((Collection)affiliateAdminOrgList) && !CollectionUtils.isEmpty((Collection)attFileList)) {
                settleTaskReqVo.setAffiliateAdminOrgSet(new HashSet(affiliateAdminOrgList));
                settleTaskReqVo.setAttFileBoIdByOrgSet(new HashSet(attFileList));
            }
        }
        if ((specifyDate = settleDy.getDate("specifydate")) != null) {
            if (SettleTypeEnum.LOCK == settleTaskReqVo.getSettleTypeEnum()) {
                settleTaskReqVo.setEndDate(specifyDate);
            } else if (SettleTypeEnum.UNLOCK == settleTaskReqVo.getSettleTypeEnum()) {
                settleTaskReqVo.setStartDate(specifyDate);
            }
        } else {
            DynamicObject settlePeriodDy = settleDy.getDynamicObject("settleperiod");
            settleTaskReqVo.setStartDate(settlePeriodDy.getDate("begindate"));
            settleTaskReqVo.setEndDate(settlePeriodDy.getDate("enddate"));
        }
        LOG.info("SettleFormService.getSettleTaskReqVoBySettleDy.settleTaskReqVo:{}", (Object)settleTaskReqVo.toString());
        return settleTaskReqVo;
    }

    public DynamicObject reExecute(IFormPlugin plugin, IFormView view, Object wtteSettlePkValue, IPageCache cache) {
        Map<String, DynamicObject> settleMap = this.saveWtteSettleByReExecute(wtteSettlePkValue);
        DynamicObject oldSettleDy = settleMap.get("oldSettleDy");
        Set fileVidSet = this.getFileVidSetByTaskId(oldSettleDy);
        if (!this.concurrentProcessingVerification(fileVidSet, view, cache, null)) {
            return null;
        }
        fileVidSet = (Set)JSON.parseObject((String)cache.get("attfileid"), Set.class);
        DynamicObject dy = settleMap.get("newSettleDy");
        if (dy == null) {
            return null;
        }
        new HRBaseServiceHelper("wtte_settle").saveOne(dy);
        this.genShowTaskProgress(plugin, view, fileVidSet, dy, this.getReExecuteDescription(oldSettleDy.getString("number")));
        return dy;
    }

    public DynamicObject reExecuteSelected(IFormPlugin plugin, IFormView view, Object wtteSettlePkValue, Set<Long> selectedFileVid, IPageCache cache) {
        Map<String, DynamicObject> settleMap = this.saveWtteSettleByReExecute(wtteSettlePkValue);
        String description = this.getReExecuteDescription(settleMap.get("oldSettleDy").getString("number"));
        if (!this.concurrentProcessingVerification(selectedFileVid, view, cache, null)) {
            return null;
        }
        selectedFileVid = (Set)JSON.parseObject((String)cache.get("attfileid"), Set.class);
        DynamicObject dy = settleMap.get("newSettleDy");
        if (dy == null) {
            return null;
        }
        new HRBaseServiceHelper("wtte_settle").saveOne(dy);
        this.genShowTaskProgress(plugin, view, selectedFileVid, dy, description);
        return dy;
    }

    public static void attFileBeforeB7(IFormView view, IFormPlugin plugin, BeforeF7SelectEvent beforeF7SelectEvent, QFilter qFilter) {
        String attFileClickType = view.getPageCache().get("attfile_clicktype");
        if ("byperson".equals(attFileClickType)) {
            long orgId = view.getModel().getDataEntity().getLong("org.id");
            if (orgId == 0L) {
                view.showTipNotification(AttSettleKDString.getOrgIsEmptyErrorTips());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            beforeF7SelectEvent.addCustomQFilter(new QFilter("org", "=", (Object)orgId));
            Set fileBoIdSet = view.getModel().getEntryEntity("personentry").stream().map(dy -> dy.getLong("attfilebase.boid")).collect(Collectors.toSet());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("boid", "not in", fileBoIdSet));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(true);
            if (qFilter != null) {
                beforeF7SelectEvent.addCustomQFilter(qFilter);
            }
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "newentry_person"));
            formShowParameter.setCustomParam("orgAppId", (Object)"wtte");
            formShowParameter.setCustomParam("orgEntityId", (Object)"wtte_settletaskdetail");
            formShowParameter.setCustomParam("orgField", (Object)"attfile.affiliateadminorg");
        }
        AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm(beforeF7SelectEvent.getFormShowParameter(), "wtte_settletaskdetail", "wtte");
    }

    public Map<String, DynamicObject> saveWtteSettleByReExecute(Object wtteSettlePkValue) {
        HRBaseServiceHelper wtteSettleHelper = new HRBaseServiceHelper("wtte_settle");
        DynamicObject oldSettleDy = wtteSettleHelper.queryOne(wtteSettlePkValue);
        DynamicObject newSettleDy = this.getCopyWtteSettleDy(oldSettleDy);
        LinkedHashMap settleMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        settleMap.put("oldSettleDy", oldSettleDy);
        settleMap.put("newSettleDy", newSettleDy);
        return settleMap;
    }

    private String getReExecuteDescription(String taskNumber) {
        return AttSettleKDString.getReExecuteDescription() + taskNumber;
    }

    private DynamicObject getCopyWtteSettleDy(DynamicObject oldSettleDy) {
        DynamicObject newSettleDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_settle"));
        newSettleDy.set("number", (Object)this.getCodeRuleNumber());
        newSettleDy.set("task", (Object)DB.genGlobalLongId());
        newSettleDy.set("settlestatus", (Object)SettleStatusEnum.INSETTLEMENT.getSettleStatus());
        newSettleDy.set("org", oldSettleDy.get("org"));
        newSettleDy.set("settletype", oldSettleDy.get("settletype"));
        newSettleDy.set("settlemode", (Object)SettleModeEnum.BYPERSON.getSettleMode());
        newSettleDy.set("settleperiod", oldSettleDy.get("settleperiod"));
        newSettleDy.set("specifydate", oldSettleDy.get("specifydate"));
        newSettleDy.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        return newSettleDy;
    }

    public void showViewSettle(Long rowId, String tabKey, IFormView formView) {
        IFormView view;
        if (this.hyperLinkClickCheck(formView)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)tabKey)) {
            tabKey = "accounttab";
        }
        if ((view = formView.getView(formView.getPageId() + rowId)) != null) {
            Tab tab = (Tab)view.getControl("tabap");
            tab.activeTab(tabKey);
            formView.sendFormAction(view);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtte_viewsettle");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settle");
        DynamicObject settle = helper.queryOne((Object)rowId);
        parameter.setCustomParam("taskid", (Object)settle.getLong("task.id"));
        parameter.setCustomParam("settleId", (Object)rowId);
        parameter.setCustomParam("tabap", (Object)tabKey);
        parameter.setCaption(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u8003\u52e4\u7ed3\u7b97-%s", (String)"SettleFormService_1", (String)"wtc-wtte-business", (Object[])new Object[0]), settle.getString("number")));
        parameter.setPageId(formView.getPageId() + "wtte_viewsettle" + rowId);
        formView.showForm(parameter);
    }

    public boolean hyperLinkClickCheck(IFormView formView) {
        if (!(formView instanceof IListView)) {
            return false;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settle");
        Object focusRowPkId = ((IListView)formView).getFocusRowPkId();
        DynamicObject dy = helper.queryOriginalOne("task.taskstatus", focusRowPkId);
        if (dy != null) {
            String taskStatus = dy.getString("task.taskstatus");
            if (WTCTaskStatus.RUNNING.getCode().equals(taskStatus) || HRStringUtils.isEmpty((String)taskStatus)) {
                formView.showTipNotification(AttSettleKDString.getTaskRunningTips());
                return true;
            }
            if (WTCTaskStatus.TERMINATING.getCode().equals(taskStatus)) {
                formView.showTipNotification(AttSettleKDString.getTaskTerminatingTips());
                return true;
            }
        }
        return false;
    }

    public void showViewSettleByTaskId(long taskId, String tabKey, IFormView formView) {
        if (taskId != 0L) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_settle");
            DynamicObject settleDy = serviceHelper.queryOne("id", new QFilter[]{new QFilter("task.id", "=", (Object)taskId)});
            if (settleDy != null) {
                this.showViewSettle(settleDy.getLong("id"), tabKey, formView);
            }
        }
    }

    private Set<Long> getFileVidSetByTaskId(DynamicObject oldSettleDy) {
        QFilter taskQFilter = new QFilter("taskid", "=", (Object)oldSettleDy.getLong("task.id"));
        QFilter detailStatusQFilter = new QFilter("taskdetailstate", "=", (Object)WTCTaskDetailStatus.FAIL.getCode());
        DynamicObject[] wtcTaskDetailDys = new HRBaseServiceHelper("wtte_settletaskdetail").queryOriginalArray("attfile.boid", new QFilter[]{taskQFilter, detailStatusQFilter});
        Set attFileBoidSet = Arrays.stream(wtcTaskDetailDys).map(wtcTaskDetailDy -> wtcTaskDetailDy.getLong("attfile.boid")).collect(Collectors.toSet());
        AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam(false);
        attFileF7QueryParam.setSetBoIds(attFileBoidSet);
        attFileF7QueryParam.setPermField("attfile");
        attFileF7QueryParam.setAppId("wtte");
        attFileF7QueryParam.setFormId("wtte_settleinfo");
        attFileF7QueryParam.setProperties("id");
        attFileF7QueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        Page dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileF7QueryParam, 0, 1000000);
        return dynamicObjectPage.getListRecords().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public void showSettleProcessCase(IFormView formView) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtte_settleprocesscase");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPageId(formView.getPageId() + "wtte_settleprocesscase");
        formView.showForm(parameter);
    }

    public void getPeriodF7Param(IFormPlugin plugin, IFormView view) {
        long orgId = view.getModel().getDataEntity().getLong("org.id");
        if (orgId == 0L) {
            view.showTipNotification(AttSettleKDString.getOrgIsEmptyErrorTips());
            return;
        }
        ListShowParameter parameter = DataBaseEditService.getListShowParameter((String)"wtp_attperiodentry", (String)"wtp_attperiodtreelistf7", (ShowType)ShowType.Modal);
        DataBaseEditService.setListDefaultWidthAndHeight((FormShowParameter)parameter);
        parameter.setLookUp(true);
        if (orgId != 0L) {
            parameter.setCustomParam("useorg", (Object)orgId);
        }
        parameter.setCloseCallBack(new CloseCallBack(plugin, "newentry_period"));
        Set periodEntryIdList = view.getModel().getEntryEntity("periodentry").stream().map(dy -> dy.getLong("periodnumber.id")).collect(Collectors.toSet());
        List qFilters = parameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "not in", periodEntryIdList));
        view.showForm((FormShowParameter)parameter);
    }

    public String byPersonOpValidate(DynamicObject pageDy, SettleTypeEnum settleType, String errMsg) {
        if (AttSettleConstants.lockAndUnLock.contains(settleType.getSettleType())) {
            String lockWay = pageDy.getString("lockway");
            if (LockModeEnum.BYPERIOD.getLockMode().equals(lockWay) && pageDy.get("settleperiod") == null) {
                errMsg = AttSettleKDString.getPeriodEntryIsEmptyTips();
            } else if (LockModeEnum.BYEXACTDATE.getLockMode().equals(lockWay)) {
                if (SettleTypeEnum.LOCK == settleType && pageDy.get("lockenddate") == null) {
                    errMsg = AttSettleKDString.getLockEndDateIsEmptyTips();
                } else if (SettleTypeEnum.UNLOCK == settleType && pageDy.get("lockbegindate") == null) {
                    errMsg = AttSettleKDString.getLockBeginDateIsEmptyTips();
                }
            }
        } else if (pageDy.get("settleperiod") == null) {
            errMsg = AttSettleKDString.getPeriodEntryIsEmptyTips();
        }
        return errMsg;
    }

    public Set<Long> getSettleFileVid(DynamicObject pageDy, IPageCache cache) {
        HashSet<Long> includeAttFileBoIds = new HashSet<Long>();
        Set<Long> includeAttFileVids = new HashSet<Long>();
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet excludeAttFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        boolean isByOrg = pageDy.getBoolean("byorg");
        if (isByOrg) {
            AttSettleServiceImpl.getInstance().getSelectAdminOrgAndExcludeAttFile(pageDy, adminOrgIds, excludeAttFileBoIds, includeAttFileBoIds);
        } else {
            adminOrgIds.add(0L);
        }
        boolean isByPerson = pageDy.getBoolean("byperson");
        if (isByPerson) {
            boolean isEmptyData;
            boolean bl = isEmptyData = (CollectionUtils.isEmpty((Collection)adminOrgIds) || adminOrgIds.stream().allMatch(adminOrgId -> adminOrgId == 0L)) && CollectionUtils.isEmpty((Collection)excludeAttFileBoIds);
            if (!isEmptyData) {
                excludeAttFileBoIds.addAll(SettleFormService.getSelectPerson(pageDy, "boid"));
            }
            includeAttFileVids = SettleFormService.getSelectPerson(pageDy, "id");
        }
        includeAttFileVids.addAll(this.getAttFileVidByCurrentData(adminOrgIds, excludeAttFileBoIds, cache, includeAttFileBoIds));
        return includeAttFileVids;
    }

    private Set<Long> getAttFileVidByCurrentData(Set<Long> adminOrgIds, Set<Long> excludeAttFileBoIds, IPageCache cache, Set<Long> includePeriodAttFileBoIds) {
        Page<DynamicObject> attFileList = AttSettleServiceImpl.getInstance().queryAttFileF7(adminOrgIds, excludeAttFileBoIds, includePeriodAttFileBoIds);
        Set attFileBoIdSet = attFileList.getListRecords().stream().map(attFile -> attFile.getLong("boid")).collect(Collectors.toSet());
        if (cache != null) {
            cache.put("affiliateadminorg", JSON.toJSONString(adminOrgIds));
            cache.put("attfile", JSON.toJSONString(attFileBoIdSet));
        }
        return attFileList.getListRecords().stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
    }

    public static void orgClassChanged(PropertyChangedArgs args, IFormView view) {
        ChangeData changeData = args.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel dataModel = view.getModel();
        dataModel.setValue("experson", null, rowIndex);
    }

    private static Set<Object> removeDuplicateAttFile(Set<Object> attFileVIds, Set<Long> selectAttFileVids) {
        HashSet allAttFileVid = Sets.newHashSet(attFileVIds);
        if (!CollectionUtils.isEmpty(selectAttFileVids) && !CollectionUtils.isEmpty(attFileVIds)) {
            allAttFileVid.addAll(selectAttFileVids);
            AttFileQueryServiceImpl attFileQueryService = AttFileQueryServiceImpl.getInstance();
            List dynamicObjects = attFileQueryService.queryAttFileByIds(WTCStringUtils.joinOnComma((String[])new String[]{"id", "boid"}), (List)Lists.newArrayList((Iterable)allAttFileVid));
            Map<Object, Object> vidBoIdMap = dynamicObjects.stream().collect(Collectors.toMap(item -> item.get("id"), item -> item.get("boid"), (key1, key2) -> key2));
            HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)vidBoIdMap.size());
            HashSet repeatedVIds = Sets.newHashSetWithExpectedSize((int)vidBoIdMap.size());
            attFileVIds.forEach(vid -> {
                if (attFileBoIds.add(vidBoIdMap.get(vid))) {
                    repeatedVIds.add(vid);
                }
            });
            selectAttFileVids.forEach(vid -> {
                if (attFileBoIds.add(vidBoIdMap.get(vid))) {
                    repeatedVIds.add(vid);
                }
            });
            return repeatedVIds;
        }
        return attFileVIds;
    }

    public void settleAddOpValidate(IFormView view, BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (!AttSettleConstants.ADDOPLIST.contains(operateKey)) {
            return;
        }
        long orgId = view.getModel().getDataEntity().getLong("org.id");
        if (orgId == 0L) {
            view.showTipNotification(AttSettleKDString.getOrgIsEmptyErrorTips());
            args.setCancel(true);
            return;
        }
        DynamicObject pageDy = view.getModel().getDataEntity(true);
        String settleWay = pageDy.getString("settlemode");
        SettleTypeEnum settleType = (SettleTypeEnum)JSON.parseObject((String)((String)view.getFormShowParameter().getCustomParam("settletype")), SettleTypeEnum.class);
        String errMsg = "";
        if (SettleModeEnum.BYPERIOD.getSettleMode().equals(settleWay)) {
            DynamicObjectCollection periodEntryDys = pageDy.getDynamicObjectCollection("periodentry");
            boolean allMatch = periodEntryDys.stream().allMatch(periodEntryDy -> HRObjectUtils.isEmpty((Object)periodEntryDy.get("periodnumber")));
            if (periodEntryDys.isEmpty() || allMatch) {
                errMsg = AttSettleKDString.getPeriodEntryIsEmptyTips();
            }
        } else if (SettleModeEnum.BYPERSON.getSettleMode().equals(settleWay)) {
            errMsg = this.byPersonOpValidate(pageDy, settleType, errMsg);
        }
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            args.setCancel(true);
            view.showTipNotification(errMsg);
        }
    }

    public void personF7CloseCallback(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        List selectedRows = (List)closedCallBackEvent.getReturnData();
        Set<Object> primaryIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        EntryGrid orgEntry = (EntryGrid)view.getControl("orgentry");
        int currentIndex = orgEntry.getSelectRows()[0];
        DynamicObject dataEntity = orgEntry.getEntryData().getDataEntitys()[currentIndex];
        DynamicObjectCollection excPersonColl = dataEntity.getDynamicObjectCollection("experson");
        Set<Object> selectAttFileVids = Sets.newHashSetWithExpectedSize((int)excPersonColl.size());
        if (!CollectionUtils.isEmpty((Collection)excPersonColl)) {
            selectAttFileVids = excPersonColl.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        }
        Set<Object> repeatedVids = SettleFormService.removeDuplicateAttFile(primaryIds, selectAttFileVids);
        view.getModel().setValue("experson", (Object)repeatedVids.toArray(), currentIndex);
    }

    public void newEntryOrgCloseCallBack(ClosedCallBackEvent event, IFormView view) {
        Object returnData = event.getReturnData();
        if (returnData != null) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"orgtype", "orgclass"});
            for (ListSelectedRow selectedRow : selectedRows) {
                tableValueSetter.addRow(new Object[]{"haos_adminorghr", selectedRow.getPrimaryKeyValue()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("orgentry", tableValueSetter);
            model.endInit();
            view.updateView("orgentry");
        }
    }

    public String getSettleModeStr(String settletype, String settlemode) {
        String name = "";
        switch (settletype) {
            case "1": {
                name = this.packageName(name, settlemode, ResManager.loadKDString((String)"\u6309\u671f\u95f4\u51bb\u7ed3", (String)"SettleFormService_4", (String)"wtc-wtte-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u4eba\u5458\u51bb\u7ed3", (String)"SettleFormService_5", (String)"wtc-wtte-business", (Object[])new Object[0]));
                break;
            }
            case "2": {
                name = this.packageName(name, settlemode, ResManager.loadKDString((String)"\u6309\u671f\u95f4\u89e3\u51bb", (String)"SettleFormService_6", (String)"wtc-wtte-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u4eba\u5458\u89e3\u51bb", (String)"SettleFormService_7", (String)"wtc-wtte-business", (Object[])new Object[0]));
                break;
            }
            case "3": {
                name = this.packageName(name, settlemode, ResManager.loadKDString((String)"\u6309\u671f\u95f4\u5c01\u5b58", (String)"SettleFormService_8", (String)"wtc-wtte-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u4eba\u5458\u5c01\u5b58", (String)"SettleFormService_9", (String)"wtc-wtte-business", (Object[])new Object[0]));
                break;
            }
            case "4": {
                name = this.packageName(name, settlemode, ResManager.loadKDString((String)"\u6309\u671f\u95f4\u89e3\u5c01", (String)"SettleFormService_10", (String)"wtc-wtte-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u4eba\u5458\u89e3\u5c01", (String)"SettleFormService_11", (String)"wtc-wtte-business", (Object[])new Object[0]));
                break;
            }
            case "5": {
                name = this.packageName(name, settlemode, ResManager.loadKDString((String)"\u6309\u671f\u95f4\u9501\u5b9a", (String)"SettleFormService_12", (String)"wtc-wtte-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u4eba\u5458\u9501\u5b9a", (String)"SettleFormService_13", (String)"wtc-wtte-business", (Object[])new Object[0]));
                break;
            }
            case "6": {
                name = this.packageName(name, settlemode, ResManager.loadKDString((String)"\u6309\u671f\u95f4\u89e3\u9501", (String)"SettleFormService_14", (String)"wtc-wtte-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u4eba\u5458\u89e3\u9501", (String)"SettleFormService_15", (String)"wtc-wtte-business", (Object[])new Object[0]));
            }
        }
        return name;
    }

    private String packageName(String name, String settlemode, String name1, String name2) {
        if (HRStringUtils.equals((String)settlemode, (String)SettleModeEnum.BYPERIOD.getSettleMode())) {
            name = name1;
        } else if (HRStringUtils.equals((String)settlemode, (String)SettleModeEnum.BYPERSON.getSettleMode())) {
            name = name2;
        }
        return name;
    }

    public void settleTaskEndCloseBack(IPageCache pageCache, IFormView view, IFormPlugin plugin, boolean isList) {
        String errMsg = pageCache.get("errMsg");
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            view.showTipNotification(errMsg);
            return;
        }
        String taskIdStr = pageCache.get("taskId");
        if (HRStringUtils.isEmpty((String)taskIdStr)) {
            return;
        }
        long taskId = Long.parseLong(taskIdStr);
        HRBaseServiceHelper settleHRBaseServiceHelper = new HRBaseServiceHelper("wtte_settletask");
        String[] taskStatusArr = new String[]{WTCTaskStatus.TERMINATED.code, WTCTaskStatus.ALL_FINISHED.code, WTCTaskStatus.PARTIALLY_FINISHED.code, WTCTaskStatus.ALL_ERROR.code};
        QFilter qFilter = new QFilter("taskstatus", "in", (Object)taskStatusArr);
        qFilter.and(new QFilter("id", "=", (Object)taskId));
        DynamicObject settleTaskDy = settleHRBaseServiceHelper.queryOne("id", new QFilter[]{qFilter});
        if (settleTaskDy != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wtte_settleresultinfo");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "showdetailcallback"));
            formShowParameter.setCustomParam("taskId", (Object)taskId);
            formShowParameter.setShowTitle(false);
            view.showForm(formShowParameter);
        } else if (isList) {
            ((IListView)view).refresh();
        } else {
            view.close();
        }
    }

    public boolean concurrentProcessingVerification(Set<Long> fileVidSet, IFormView view, IPageCache cache, Map<Long, Set<Long>> fileVidMap) {
        if (fileVidSet.isEmpty()) {
            view.showErrorNotification(AttSettleKDString.getNoErrorFileWithAuthErrorTips());
            return false;
        }
        if (fileVidMap != null && fileVidMap.size() > 0) {
            for (Map.Entry<Long, Set<Long>> mapEntry : fileVidMap.entrySet()) {
                Set<Long> values = mapEntry.getValue();
                values.removeIf(value -> !fileVidSet.contains(value));
                fileVidMap.put(mapEntry.getKey(), values);
            }
            cache.put("attfileid", JSON.toJSONString(fileVidMap));
        } else {
            cache.put("attfileid", JSON.toJSONString(fileVidSet));
        }
        return true;
    }

    public void removeFileBoIdInRedis(List<Long> fileBoIdList) {
        AttFileSyncService.getInstance().unLockFileBoIds(new HashSet<Long>(fileBoIdList));
    }

    public void getSettlePermParam(AttFileF7QueryParam param) {
        param.setPermField("attfile");
        param.setAppId("wtte");
        param.setFormId("wtte_settletaskdetail");
    }
}

