/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.enums.attperiod.PeriodCutTypeEnum;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.entity.SettleInfoEntity;

public class SettleSubTaskDataEntity
implements Serializable {
    private static final Log LOG = LogFactory.getLog(SettleSubTaskDataEntity.class);
    private static final long serialVersionUID = 8047764899530356917L;
    @NotNull
    private Long taskId;
    @NotNull
    private Long subTaskId;
    @NotNull
    private List<SettleTaskDetail> settleTaskDetails;
    private List<SettleInfoEntity> settleInfoEntityList;
    @NotNull
    private WTCCalSubTaskEntity wtcCalSubTaskEntity;
    @NotNull
    private SettleCheckEntity settleCheckEntity;
    private List<PerAttPeriod> perPeriodEntityList = Lists.newArrayListWithExpectedSize((int)10);
    private Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap = Maps.newHashMapWithExpectedSize((int)2);

    public SettleSubTaskDataEntity() {
        this.periodCutTypeEnumSetMap.put(PeriodCutTypeEnum.CUT, Sets.newHashSetWithExpectedSize((int)16));
        this.periodCutTypeEnumSetMap.put(PeriodCutTypeEnum.NOT_CUT, Sets.newHashSetWithExpectedSize((int)16));
    }

    public SettleSubTaskDataEntity(Long taskId, Long subTaskId, WTCCalSubTaskEntity wtcCalSubTaskEntity, List<SettleTaskDetail> settleTaskDetails, SettleCheckEntity settleCheckEntity) {
        this.taskId = taskId;
        this.subTaskId = subTaskId;
        if (wtcCalSubTaskEntity != null) {
            this.wtcCalSubTaskEntity = wtcCalSubTaskEntity;
            this.wtcCalSubTaskEntity.setTaskId(taskId.longValue());
            this.wtcCalSubTaskEntity.setId(subTaskId.longValue());
        }
        this.settleTaskDetails = settleTaskDetails;
        this.settleCheckEntity = settleCheckEntity;
        this.periodCutTypeEnumSetMap.put(PeriodCutTypeEnum.CUT, Sets.newHashSetWithExpectedSize((int)16));
        this.periodCutTypeEnumSetMap.put(PeriodCutTypeEnum.NOT_CUT, Sets.newHashSetWithExpectedSize((int)16));
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getSubTaskId() {
        return this.subTaskId;
    }

    public void setSubTaskId(Long subTaskId) {
        this.subTaskId = subTaskId;
    }

    public List<SettleInfoEntity> getSettleInfoEntityList() {
        return this.settleInfoEntityList;
    }

    public void setSettleInfoEntityList(List<SettleInfoEntity> settleInfoEntityList) {
        this.settleInfoEntityList = settleInfoEntityList;
    }

    public WTCCalSubTaskEntity getWtcCalSubTaskEntity() {
        if (this.wtcCalSubTaskEntity == null) {
            this.wtcCalSubTaskEntity = new WTCCalSubTaskEntity();
            this.wtcCalSubTaskEntity.setTaskId(this.taskId.longValue());
            this.wtcCalSubTaskEntity.setId(this.subTaskId.longValue());
        }
        if (this.wtcCalSubTaskEntity.getStartDate() == null) {
            this.wtcCalSubTaskEntity.setStartDate(new Date());
        }
        return this.wtcCalSubTaskEntity;
    }

    public void setWtcCalSubTaskEntity(WTCCalSubTaskEntity wtcCalSubTaskEntity) {
        this.wtcCalSubTaskEntity = wtcCalSubTaskEntity;
    }

    public List<SettleTaskDetail> getSettleTaskDetails() {
        return this.settleTaskDetails;
    }

    public void setSettleTaskDetails(List<SettleTaskDetail> settleTaskDetails) {
        this.settleTaskDetails = settleTaskDetails;
    }

    public SettleCheckEntity getSettleCheckEntity() {
        return this.settleCheckEntity;
    }

    public void setSettleCheckEntity(SettleCheckEntity settleCheckEntity) {
        this.settleCheckEntity = settleCheckEntity;
    }

    public List<PerAttPeriod> getPerPeriodEntityList() {
        return this.perPeriodEntityList;
    }

    public Map<PeriodCutTypeEnum, Set<Long>> getPeriodCutTypeEnumSetMap() {
        return this.periodCutTypeEnumSetMap;
    }
}

