/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.impl.AbstractSettleService;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;

public abstract class AbstractFrozenSettleService
extends AbstractSettleService {
    protected Map<Long, List<PerAttPeriodReport>> perAttPeriodMap;
    protected List<PerAttPeriodReport> currentFilePeriodReportList;
    protected Map<String, Object> periodReportObjectMap;
    protected String errorMsg;
    protected long attFileBoId;

    @Override
    public SettleValidateResult validate(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        this.attFileBoId = settleTaskDetail.getAttFileBoId();
        this.perAttPeriodMap = settleCheckEntity.getPerAttPeriodMap();
        Set<Long> hasPerFileBoId = settleCheckEntity.getHasPerFileId();
        this.currentFilePeriodReportList = this.perAttPeriodMap.get(this.attFileBoId);
        SettleValidateResult settleValidateResult = new SettleValidateResult();
        this.errorMsg = this.checkAttFileIsRunning(this.attFileBoId, settleCheckEntity.getExistsFileBoIds());
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        this.errorMsg = this.checkAttFileIsDiscard(this.attFileBoId, settleCheckEntity.getDiscardFileBoId());
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        this.errorMsg = this.checkAttFileAndPeriodMatch(this.attFileBoId, this.perAttPeriodMap);
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        PerAttPeriodReport earliestNoStoragePeriod = settleCheckEntity.getEarliestNoStoragePeriodMap().get(this.attFileBoId);
        this.errorMsg = this.getAttFileIfHasEarliestNotStoragePeriod(earliestNoStoragePeriod);
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        SettleTypeEnum settleTypeEnum = settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum();
        this.errorMsg = this.checkAllPerAttPeriodHasBeenSettled(this.currentFilePeriodReportList, settleTypeEnum);
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        this.errorMsg = this.checkSelectedPeriodIfEarliestNotStoragePeriod(this.currentFilePeriodReportList, earliestNoStoragePeriod, settleTypeEnum);
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        this.periodReportObjectMap = Maps.newHashMapWithExpectedSize((int)this.currentFilePeriodReportList.size());
        this.errorMsg = super.checkAffiliateAdminOrgAndPerPeriodMatch(this.attFileBoId, this.currentFilePeriodReportList, settleCheckEntity.getSettleTaskReqVo(), false);
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        if (settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            this.errorMsg = this.checkAttFileIfHasEarliestNotStoragePeriodAuth(this.currentFilePeriodReportList, hasPerFileBoId);
            if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
        } else {
            this.errorMsg = this.checkIfAtLeastHasOnePeriodAuth(this.perAttPeriodMap.get(this.attFileBoId), hasPerFileBoId);
            if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
        }
        return settleValidateResult;
    }
}

