/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtte.business.settle.ISettleService;
import kd.wtc.wtte.business.settle.ISettleValidateService;
import kd.wtc.wtte.business.settle.entity.AttStateInfoEntity;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.entity.SettleInfoEntity;
import kd.wtc.wtte.business.settle.entity.SettleSubTaskDataEntity;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.LockStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleTaskReqVo;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;

public abstract class AbstractSettleService
implements ISettleService,
ISettleValidateService {
    private static final Log LOG = LogFactory.getLog(AbstractSettleService.class);

    @Override
    public void executeSettle(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        List<SettleTaskDetail> settleTaskDetails = settleSubTaskDataEntity.getSettleTaskDetails();
        SettleCheckEntity settleCheckEntity = settleSubTaskDataEntity.getSettleCheckEntity();
        ArrayList<SettleInfoEntity> settleInfoEntityList = new ArrayList<SettleInfoEntity>();
        for (SettleTaskDetail settleTaskDetail : settleTaskDetails) {
            try {
                List<SettleInfoEntity> infoEntityList = this.executeSettleDetail(settleTaskDetail, settleCheckEntity);
                if (infoEntityList != null && !infoEntityList.isEmpty()) {
                    settleInfoEntityList.addAll(infoEntityList);
                }
                settleSubTaskDataEntity.setSettleInfoEntityList(settleInfoEntityList);
            }
            catch (Exception exception) {
                String format = WTCStringUtils.format((String)"AbstractSettleService.executeSettletraceId[%s], error:", (Object[])new Object[]{RequestContext.get().getTraceId()});
                LOG.warn(format, (Throwable)exception);
                settleTaskDetail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
                settleTaskDetail.setExInfo(AttSettleKDString.getTaskRunErrorTips());
            }
        }
    }

    @Override
    public List<SettleInfoEntity> executeSettleDetail(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        List<SettleInfoEntity> settleInfoEntityList = null;
        SettleValidateResult settleValidateResult = this.validate(settleTaskDetail, settleCheckEntity);
        SettleTaskDetailStatusEnum detailStatusEnum = settleValidateResult.getDetailStatusEnum();
        settleTaskDetail.setTaskDetailState(this.enumTransformation(detailStatusEnum));
        settleTaskDetail.setExInfo(settleValidateResult.getErrMsg());
        if (settleValidateResult.getRealStartDate() != null || settleValidateResult.getRealEndDate() != null) {
            settleInfoEntityList = this.settleInfoDataProcessing(settleValidateResult, settleTaskDetail, settleCheckEntity);
            this.wtteInfoDataProcessing(settleValidateResult, settleTaskDetail, settleCheckEntity);
        }
        this.processFrozenAndLockDataByStorage(settleInfoEntityList, settleTaskDetail, settleCheckEntity);
        return settleInfoEntityList;
    }

    protected void processFrozenAndLockDataByStorage(List<SettleInfoEntity> settleInfoEntityList, SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        WTCTaskDetailStatus taskDetailState;
        SettleTypeEnum settleTypeEnum = settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum();
        if (SettleTypeEnum.STORAGE == settleTypeEnum && WTCTaskDetailStatus.SUCCESS.equals((Object)settleTaskDetail.getTaskDetailState())) {
            long attFileBoId = settleTaskDetail.getAttFileBoId();
            AttStateInfoEntity stateInfoEntity = settleCheckEntity.getStateInfoEntityMap().get(attFileBoId);
            Date lockTo = stateInfoEntity.getAttStateInfoBO().getLockTo();
            if (lockTo == null || settleTaskDetail.getRealCalEndDate().compareTo(lockTo) > 0) {
                stateInfoEntity.setLockTo(settleTaskDetail.getRealCalEndDate());
            }
            Date frozenStartDate = stateInfoEntity.getAttStateInfoBO().getFrozenStartDate();
            Date frozenEndDate = stateInfoEntity.getAttStateInfoBO().getFronzenEnDate();
            stateInfoEntity.setFrozenStartDate(null);
            stateInfoEntity.setFrozenEndDate(null);
            settleInfoEntityList.forEach(settleInfo -> {
                if (settleInfo.getEndDate() != null && (lockTo == null || lockTo.compareTo(settleInfo.getEndDate()) < 0)) {
                    settleInfo.setLockUser(settleInfo.getStorageUser());
                    settleInfo.setLockStatus(LockStatusEnum.LOCKED);
                    settleInfo.setLockDate(settleInfo.getStorageDate());
                }
                if (frozenStartDate != null && frozenEndDate != null && settleInfo.getStartDate().compareTo(frozenStartDate) >= 0 && settleInfo.getEndDate().compareTo(frozenEndDate) <= 0) {
                    settleInfo.setFrozenDate(settleInfo.getStorageDate());
                    settleInfo.setFrozenStatus(Boolean.FALSE);
                    settleInfo.setFrozenUser(settleInfo.getStorageUser());
                }
            });
            this.copySettleInfoEntity(settleInfoEntityList, settleCheckEntity, settleTaskDetail, frozenStartDate, frozenEndDate);
        } else if (SettleTypeEnum.UNSTORAGE == settleTypeEnum && WTCTaskDetailStatus.SUCCESS.equals((Object)settleTaskDetail.getTaskDetailState()) && WTCTaskDetailStatus.SUCCESS == (taskDetailState = settleTaskDetail.getTaskDetailState())) {
            AttStateInfoEntity stateInfoEntity = settleCheckEntity.getStateInfoEntityMap().get(settleTaskDetail.getAttFileBoId());
            stateInfoEntity.setFrozenStartDate(null);
            stateInfoEntity.setFrozenEndDate(null);
        }
    }

    private void copySettleInfoEntity(List<SettleInfoEntity> settleInfoEntityList, SettleCheckEntity settleCheckEntity, SettleTaskDetail settleTaskDetail, Date frozenStartDate, Date frozenEndDate) {
        SettleInfoEntity settleInfoEntity = settleInfoEntityList.stream().max(Comparator.comparing(SettleInfoEntity::getEndDate)).orElse(null);
        if (settleInfoEntity == null) {
            return;
        }
        Map<Long, List<PerAttPeriodReport>> perAttPeriodMap = settleCheckEntity.getPerAttPeriodMap();
        List<PerAttPeriodReport> perAttPeriodReports = perAttPeriodMap.get(settleTaskDetail.getAttFileBoId());
        List list = perAttPeriodReports.stream().filter(bo -> bo.getPerAttBeginDate().compareTo(settleInfoEntity.getEndDate()) > 0).collect(Collectors.toList());
        for (PerAttPeriodReport perAttPeriodReport : list) {
            if (frozenStartDate == null || frozenEndDate == null || perAttPeriodReport.getPerAttBeginDate().compareTo(frozenStartDate) < 0 || perAttPeriodReport.getPerAttEndDate().compareTo(frozenEndDate) > 0) continue;
            SettleInfoEntity bo2 = new SettleInfoEntity();
            bo2.setPerAttPeriod(perAttPeriodReport.getId());
            bo2.setStartDate(perAttPeriodReport.getPerAttBeginDate());
            bo2.setEndDate(perAttPeriodReport.getPerAttEndDate());
            bo2.setTaskDetailId(settleInfoEntity.getTaskDetailId());
            bo2.setAttPersonId(settleInfoEntity.getAttPersonId());
            bo2.setAttFileId(settleInfoEntity.getAttFileId());
            bo2.setAttPeriod(settleInfoEntity.getAttPeriod());
            bo2.setAttPeriod(settleInfoEntity.getAttPeriod());
            bo2.setFrozenDate(settleInfoEntity.getStorageDate());
            bo2.setFrozenStatus(Boolean.FALSE);
            bo2.setFrozenUser(settleInfoEntity.getStorageUser());
            settleInfoEntityList.add(bo2);
        }
    }

    private void wtteInfoDataProcessing(SettleValidateResult settleValidateResult, SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        long attFileBoId = settleTaskDetail.getAttFileBoId();
        AttStateInfoEntity stateInfoEntity = settleCheckEntity.getStateInfoEntityMap().get(attFileBoId);
        stateInfoEntity.setSettleDetailTaskId(settleTaskDetail.getId());
        SettleTypeEnum settleTypeEnum = settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum();
        switch (settleTypeEnum) {
            case FROZEN: {
                stateInfoEntity.setFrozenStartDate(settleValidateResult.getRealStartDate());
                stateInfoEntity.setFrozenEndDate(settleValidateResult.getRealEndDate());
                break;
            }
            case UNFROZEN: {
                stateInfoEntity.setFrozenStartDate(null);
                stateInfoEntity.setFrozenEndDate(null);
                break;
            }
            case STORAGE: {
                stateInfoEntity.setStorageTo(settleValidateResult.getRealEndDate());
                break;
            }
            case UNSTORAGE: {
                stateInfoEntity.setStorageTo(this.checkFileBeginDate(settleValidateResult, settleCheckEntity.getPerAttPeriodMap().get(settleTaskDetail.getAttFileBoId())));
                break;
            }
            case LOCK: {
                stateInfoEntity.setLockTo(settleValidateResult.getRealEndDate());
                break;
            }
            case UNLOCK: {
                stateInfoEntity.setLockTo(this.checkFileBeginDate(settleValidateResult, settleCheckEntity.getPerAttPeriodMap().get(settleTaskDetail.getAttFileBoId())));
                break;
            }
        }
    }

    private Date checkFileBeginDate(SettleValidateResult settleValidateResult, List<PerAttPeriodReport> perAttPeriodMap) {
        Date date = WTCDateUtils.addDays((Date)settleValidateResult.getRealStartDate(), (int)-1);
        Map periodStatusMap = settleValidateResult.getPeriodStatusMap();
        if (periodStatusMap != null && !CollectionUtils.isEmpty(periodStatusMap.keySet()) && !periodStatusMap.keySet().isEmpty()) {
            String perAttPeriodId = (String)new ArrayList(periodStatusMap.keySet()).get(0);
            PerAttPeriodReport periodReport = perAttPeriodMap.stream().filter(perAttPeriodReport -> HRStringUtils.isNotEmpty((String)perAttPeriodId) && perAttPeriodId.equals(perAttPeriodReport.getId())).findFirst().orElseGet(PerAttPeriodReport::new);
            Date fileStartDate = periodReport.getFileStartDate();
            if (date != null && date.compareTo(fileStartDate) < 0) {
                return null;
            }
        }
        return date;
    }

    protected List<SettleInfoEntity> settleInfoDataProcessing(SettleValidateResult settleValidateResult, SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        Map periodStatusMap = settleValidateResult.getPeriodStatusMap();
        if (periodStatusMap == null) {
            return new ArrayList<SettleInfoEntity>();
        }
        ArrayList settleInfoEntityList = Lists.newArrayListWithExpectedSize((int)periodStatusMap.size());
        Date currentDate = new Date();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        for (Map.Entry<String, Object> entry : periodStatusMap.entrySet()) {
            SettleInfoEntity settleInfoEntity = new SettleInfoEntity();
            List<PerAttPeriodReport> periodReportList = settleCheckEntity.getPerAttPeriodMap().get(settleTaskDetail.getAttFileBoId());
            PerAttPeriodReport perAttPeriodReport = periodReportList.stream().filter(periodReport -> mapEntry.getKey() != null && ((String)mapEntry.getKey()).equals(periodReport.getId())).findFirst().orElse(null);
            this.populateCommonData(settleInfoEntity, settleTaskDetail, perAttPeriodReport);
            this.populateBusinessData(settleInfoEntity, entry, periodReportList);
            this.populateSettleTypeData(settleCheckEntity, currentDate, currentUserId, settleInfoEntity, entry);
            settleInfoEntityList.add(settleInfoEntity);
        }
        settleTaskDetail.setRealCalStartDate(settleValidateResult.getRealStartDate());
        settleTaskDetail.setRealCalEndDate(settleValidateResult.getRealEndDate());
        return settleInfoEntityList;
    }

    private void populateBusinessData(SettleInfoEntity settleInfoEntity, Map.Entry<String, Object> mapEntry, List<PerAttPeriodReport> perAttPeriodReports) {
        String perAttPeriodId = mapEntry.getKey();
        PerAttPeriodReport periodReport = perAttPeriodReports.stream().filter(perAttPeriodReport -> HRStringUtils.isNotEmpty((String)perAttPeriodId) && perAttPeriodId.equals(perAttPeriodReport.getId())).findFirst().orElseGet(PerAttPeriodReport::new);
        settleInfoEntity.setPerAttPeriod(periodReport.getId());
        settleInfoEntity.setAttPeriod(periodReport.getAttPeriodId());
        settleInfoEntity.setStartDate(periodReport.getPerAttBeginDate());
        settleInfoEntity.setEndDate(periodReport.getPerAttEndDate());
        settleInfoEntity.setAttperattperiodpk(periodReport.getPrimaryId());
    }

    public void populateSettleTypeData(SettleCheckEntity settleCheckEntity, Date currentDate, long currentUserId, SettleInfoEntity settleInfoEntity, Map.Entry<String, Object> mapEntry) {
        Object value = mapEntry.getValue();
        switch (settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum()) {
            case FROZEN: 
            case UNFROZEN: {
                if (!(value instanceof Boolean)) break;
                settleInfoEntity.setFrozenStatus((Boolean)value);
                settleInfoEntity.setFrozenUser(currentUserId);
                settleInfoEntity.setFrozenDate(currentDate);
                break;
            }
            case STORAGE: 
            case UNSTORAGE: {
                if (!(value instanceof Boolean)) break;
                settleInfoEntity.setStorageStatus((Boolean)value);
                settleInfoEntity.setStorageUser(currentUserId);
                settleInfoEntity.setStorageDate(currentDate);
                break;
            }
            case LOCK: 
            case UNLOCK: {
                if (!(value instanceof LockStatusEnum)) break;
                settleInfoEntity.setLockStatus((LockStatusEnum)value);
                settleInfoEntity.setLockUser(currentUserId);
                settleInfoEntity.setLockDate(currentDate);
                break;
            }
        }
    }

    private void populateCommonData(SettleInfoEntity settleInfoEntity, SettleTaskDetail settleTaskDetail, PerAttPeriodReport perAttPeriodReport) {
        settleInfoEntity.setAttPersonId(settleTaskDetail.getAttPersonId());
        if (perAttPeriodReport != null) {
            settleInfoEntity.setAttFileId(perAttPeriodReport.getAttFileId());
        }
        settleInfoEntity.setTaskDetailId(settleTaskDetail.getId());
        settleInfoEntity.setOrgId(settleTaskDetail.getOrgId());
    }

    @Override
    public String checkAttFileAndPeriodMatch(long attFileBoId, Map<Long, List<PerAttPeriodReport>> perAttPeriodMap) {
        return perAttPeriodMap.containsKey(attFileBoId) ? "" : AttSettleKDString.getSelectedFileWithinSelectedPeriodErrorTips();
    }

    @Override
    public String getAttFileIfHasEarliestNotStoragePeriod(PerAttPeriodReport periodReport) {
        return periodReport == null ? AttSettleKDString.getSelectedFileHaveEarliestUnsealedPeriodErrorTips() : "";
    }

    @Override
    public String getAttFileIfHaslatestStoragedPeriod(PerAttPeriodReport periodReport, boolean hasPartialStorage) {
        if (periodReport == null && !hasPartialStorage) {
            return AttSettleKDString.getAttFileIfHaslatestStoragedPeriodErrorTips();
        }
        return "";
    }

    @Override
    public String getSelectedPeriodIsLatestStoredPeriod(List<PerAttPeriodReport> periodReportList, PerAttPeriodReport latestStoragedPeriod, boolean hasPartialStorage) {
        List reportList = periodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getLastStoragePeriod())).collect(Collectors.toList());
        return reportList.isEmpty() && !hasPartialStorage ? AttSettleKDString.getSelectedPeriodIsLatesStoredPeriodErrorTips((String)latestStoragedPeriod.getPerAttPeriodName(), (String)latestStoragedPeriod.getPeriodName()) : "";
    }

    protected String getSelectedPeriodIsLatestStoredPeriod(List<PerAttPeriodReport> periodReportList, PerAttPeriodReport latestStoragedPeriod, boolean hasPartialStorage, SettleTypeEnum settleTypeEnum) {
        boolean isFailed;
        List reportList = periodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getLastStoragePeriod())).collect(Collectors.toList());
        boolean bl = isFailed = reportList.isEmpty() && !hasPartialStorage;
        if (!isFailed) {
            return "";
        }
        if (settleTypeEnum == null) {
            return AttSettleKDString.getSelectedPeriodIsLatesStoredPeriodErrorTips((String)latestStoragedPeriod.getPerAttPeriodName(), (String)latestStoragedPeriod.getPeriodName());
        }
        return AttSettleKDString.getSelectedPeriodIsEarliestUnsealedPeriodByUnSealErrorTips((String)latestStoragedPeriod.getPerAttPeriodName(), (String)latestStoragedPeriod.getPeriodName());
    }

    @Override
    public String checkSelectedPeriodIfEarliestNotStoragePeriod(List<PerAttPeriodReport> perAttPeriodList, PerAttPeriodReport earliestNotStoragePeriod) {
        return this.checkSelectedPeriodIfEarliestNotStoragePeriod(perAttPeriodList, earliestNotStoragePeriod, null);
    }

    protected String checkSelectedPeriodIfEarliestNotStoragePeriod(List<PerAttPeriodReport> perAttPeriodList, PerAttPeriodReport earliestNotStoragePeriod, SettleTypeEnum settleTypeEnum) {
        boolean anyMatch = perAttPeriodList.stream().anyMatch(perAttPeriodReport -> earliestNotStoragePeriod.getAttPeriodId().equals(perAttPeriodReport.getAttPeriodId()));
        if (anyMatch) {
            return "";
        }
        if (settleTypeEnum == null) {
            return AttSettleKDString.getSelectedPeriodIsEarliestUnsealedPeriodErrorTips((String)earliestNotStoragePeriod.getPerAttPeriodName(), (String)earliestNotStoragePeriod.getPeriodName());
        }
        switch (settleTypeEnum) {
            case FROZEN: {
                return AttSettleKDString.getSelectedPeriodIsEarliestUnsealedPeriodByFrozenErrorTips((String)earliestNotStoragePeriod.getPerAttPeriodName(), (String)earliestNotStoragePeriod.getPeriodName());
            }
            case UNFROZEN: {
                return AttSettleKDString.getSelectedPeriodIsEarliestUnsealedPeriodByUnFrozenErrorTips((String)earliestNotStoragePeriod.getPerAttPeriodName(), (String)earliestNotStoragePeriod.getPeriodName());
            }
            case LOCK: {
                return AttSettleKDString.getSelectedPeriodIsEarliestUnsealedPeriodByLockedErrorTips((String)earliestNotStoragePeriod.getPerAttPeriodName(), (String)earliestNotStoragePeriod.getPeriodName());
            }
            case STORAGE: {
                return AttSettleKDString.getSelectedPeriodIsEarliestUnsealedPeriodBySealErrorTips((String)earliestNotStoragePeriod.getPerAttPeriodName(), (String)earliestNotStoragePeriod.getPeriodName());
            }
        }
        return "";
    }

    @Override
    public String checkIfAtLeastHasOnePeriodAuth(List<PerAttPeriodReport> periodReportList, Set<Long> hasPerFileVid) {
        List reportList = periodReportList.stream().filter(perAttPeriodReport -> hasPerFileVid.contains(perAttPeriodReport.getFileId())).collect(Collectors.toList());
        return reportList.isEmpty() ? AttSettleKDString.getUserHavePermissionForPeriodToBeFrozenErrorTips() : "";
    }

    @Override
    public String checkAttFileIfHasEarliestNotStoragePeriodAuth(List<PerAttPeriodReport> periodReportList, Set<Long> hasPerFileVid) {
        List reportList = periodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getEarliestNoStoragePeriod())).filter(perAttPeriodReport -> hasPerFileVid.contains(perAttPeriodReport.getFileId())).collect(Collectors.toList());
        return reportList.isEmpty() ? AttSettleKDString.getUserHavePermissionForPeriodToBeFrozenErrorTips() : "";
    }

    @Override
    public String checkAttFileIfHasLatestStoragePeriodAuth(List<PerAttPeriodReport> periodReportList, Set<Long> hasPerFileVid) {
        List reportList = periodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getLastStoragePeriod()) || "3".equals(perAttPeriodReport.getStorageStatus())).filter(perAttPeriodReport -> hasPerFileVid.contains(perAttPeriodReport.getFileId())).collect(Collectors.toList());
        return reportList.isEmpty() ? AttSettleKDString.getUserHavePermissionForPeriodToBeFrozenErrorTips() : "";
    }

    protected boolean checkErrorMsgIsEmpty(String errorMsg, SettleValidateResult settleValidateResult, SettleTaskDetailStatusEnum statusEnum) {
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            settleValidateResult.setErrMsg(errorMsg);
            settleValidateResult.setDetailStatusEnum(statusEnum);
            return true;
        }
        return false;
    }

    private SettleInfoEntity genSettleInfoEntity(SettleValidateResult settleValidateResult) {
        return null;
    }

    private WTCTaskDetailStatus enumTransformation(SettleTaskDetailStatusEnum detailStatusEnum) {
        switch (detailStatusEnum) {
            case SETTLEMENTSUCCEEDED: {
                return WTCTaskDetailStatus.SUCCESS;
            }
            case SETTLEMENTFAILED: {
                return WTCTaskDetailStatus.FAIL;
            }
        }
        return WTCTaskDetailStatus.NOT_ACCOUNT;
    }

    protected void processingResultsAfterSuccessfulCutVerification(List<PerAttPeriodReport> currentFilePeriodReportList, SettleValidateResult settleValidateResult, Map<String, Object> periodReportObjectMap, boolean isAscOder) {
        int i;
        currentFilePeriodReportList = isAscOder ? currentFilePeriodReportList.stream().sorted(Comparator.comparing(currentFilePeriodReport -> currentFilePeriodReport.getPerAttBeginDate().getTime())).collect(Collectors.toList()) : currentFilePeriodReportList.stream().sorted(Comparator.comparing(currentFilePeriodReport -> currentFilePeriodReport.getPerAttBeginDate().getTime(), Comparator.reverseOrder())).collect(Collectors.toList());
        int temp = 0;
        Date realStartDate = null;
        Date realEndDate = null;
        int size = currentFilePeriodReportList.size();
        for (i = 0; i < size; ++i) {
            boolean isContinue;
            if (i == 0) {
                if (isAscOder) {
                    realStartDate = ((PerAttPeriodReport)currentFilePeriodReportList.get(i)).getPerAttBeginDate();
                } else {
                    realEndDate = ((PerAttPeriodReport)currentFilePeriodReportList.get(i)).getPerAttEndDate();
                }
            }
            if (i == size - 1) {
                temp = size - 1;
                if (isAscOder) {
                    realEndDate = ((PerAttPeriodReport)currentFilePeriodReportList.get(i)).getPerAttEndDate();
                    break;
                }
                realStartDate = ((PerAttPeriodReport)currentFilePeriodReportList.get(i)).getPerAttBeginDate();
                break;
            }
            PerAttPeriodReport prePerAttPeriodReport = (PerAttPeriodReport)currentFilePeriodReportList.get(i);
            PerAttPeriodReport nextPerAttPeriodReport = (PerAttPeriodReport)currentFilePeriodReportList.get(i + 1);
            boolean bl = isAscOder ? WTCDateUtils.daysBetween((Date)prePerAttPeriodReport.getPerAttEndDate(), (Date)nextPerAttPeriodReport.getPerAttBeginDate()) == 1 : (isContinue = WTCDateUtils.daysBetween((Date)prePerAttPeriodReport.getPerAttBeginDate(), (Date)nextPerAttPeriodReport.getPerAttEndDate()) == -1);
            if (!isContinue) {
                temp = i;
                if (isAscOder) {
                    realEndDate = ((PerAttPeriodReport)currentFilePeriodReportList.get(i)).getPerAttEndDate();
                    break;
                }
                realStartDate = ((PerAttPeriodReport)currentFilePeriodReportList.get(i)).getPerAttBeginDate();
                break;
            }
            temp = i + 1;
        }
        for (i = 0; i <= temp; ++i) {
            periodReportObjectMap.put(((PerAttPeriodReport)currentFilePeriodReportList.get(i)).getId(), isAscOder);
        }
        settleValidateResult.setRealStartDate(realStartDate);
        settleValidateResult.setRealEndDate(realEndDate);
    }

    protected PerAttPeriodReport getAttFileEarliestNotStoragePeriod(List<PerAttPeriodReport> currentFilePeriodReportList) {
        if (WTCCollections.isNotEmpty(currentFilePeriodReportList)) {
            return currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> "1".equals(currentFilePeriodReport.getEarliestNoStoragePeriod())).findFirst().orElse(null);
        }
        return null;
    }

    protected boolean checkPeriodAuth(Set<Long> hasPerFileIdSet, PerAttPeriodReport periodReport) {
        return hasPerFileIdSet.contains(periodReport.getFileId());
    }

    protected boolean checkIfNoAnyAttFileDateAuth(List<Tuple<Date, Date>> attFileDateAuthList, Date startDate, Date endDate) {
        if (WTCCollections.isNotEmpty(attFileDateAuthList) && startDate != null && endDate != null && startDate.getTime() <= endDate.getTime()) {
            for (Tuple<Date, Date> attFileDateAuth : attFileDateAuthList) {
                if (startDate.getTime() > ((Date)attFileDateAuth.getValue()).getTime() || endDate.getTime() < ((Date)attFileDateAuth.getKey()).getTime()) continue;
                return false;
            }
        }
        return true;
    }

    protected void clearResult(SettleValidateResult settleValidateResult) {
        if (settleValidateResult != null) {
            settleValidateResult.setRealStartDate(null);
            settleValidateResult.setRealEndDate(null);
            settleValidateResult.setPeriodStatusMap(null);
        }
    }

    protected void clearResultWithTargetDate(SettleValidateResult settleValidateResult) {
        if (settleValidateResult != null && WTCCollections.isEmpty((Map)settleValidateResult.getPeriodStatusMap())) {
            settleValidateResult.setRealStartDate(null);
            settleValidateResult.setRealEndDate(null);
        }
    }

    protected boolean checkIfEnyPerAttPeriodReportHaveNoAttTotalBase(List<PerAttPeriodReport> filePeriodReportList, Map<String, Boolean> totalBaseBooleanMap) {
        if (WTCCollections.isEmpty(totalBaseBooleanMap)) {
            return true;
        }
        for (PerAttPeriodReport perAttPeriodReport : filePeriodReportList) {
            Boolean haveAttTotalBase = totalBaseBooleanMap.get(perAttPeriodReport.getId());
            if (haveAttTotalBase != null && haveAttTotalBase.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String checkAttFileIsDiscard(long attFileBoId, Set<Long> discardFileBoId) {
        return discardFileBoId.contains(attFileBoId) ? AttSettleKDString.getAttFileIsDiscardTips() : "";
    }

    public String checkAttFileIsRunning(long attFileBoId, Map<Long, String> existsFileBoIdMap) {
        String code;
        if (existsFileBoIdMap != null && HRStringUtils.isNotEmpty((String)(code = existsFileBoIdMap.get(attFileBoId)))) {
            AttFileTaskCacheInfoEnum infoEnum = AttFileTaskCacheInfoEnum.valueOf((String)code);
            return infoEnum.getMsg().loadKDString();
        }
        return "";
    }

    protected String checkAffiliateAdminOrgAndPerPeriodMatch(long attFileBoId, List<PerAttPeriodReport> periodReportList, SettleTaskReqVo settleTaskReqVo, boolean isUnSeal) {
        Set attFileBoIdByOrgSet = settleTaskReqVo.getAttFileBoIdByOrgSet();
        Set affiliateAdminOrgSet = settleTaskReqVo.getAffiliateAdminOrgSet();
        if (attFileBoIdByOrgSet == null || affiliateAdminOrgSet == null || !attFileBoIdByOrgSet.contains(attFileBoId)) {
            return "";
        }
        List<Object> list = settleTaskReqVo.isBeSettleCut() ? (isUnSeal ? periodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getLastStoragePeriod())).collect(Collectors.toList()) : periodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getEarliestNoStoragePeriod())).collect(Collectors.toList())) : new ArrayList<PerAttPeriodReport>(periodReportList);
        boolean noneMatch = list.stream().noneMatch(periodReport -> affiliateAdminOrgSet.contains(periodReport.getAffiliateAdminOrgId()));
        if (noneMatch) {
            return AttSettleKDString.getAffiliateAdminOrgAndPerPeriodNotMatchTips();
        }
        return "";
    }

    protected String checkAllPerAttPeriodHasBeenSettled(List<PerAttPeriodReport> perAttPeriodReportList, SettleTypeEnum settleTypeEnum) {
        switch (settleTypeEnum) {
            case FROZEN: {
                boolean isAllPerAttPeriodFrozen = perAttPeriodReportList.stream().allMatch(periodReport -> "1".equals(periodReport.getFrozenStatus()));
                if (!isAllPerAttPeriodFrozen) break;
                return AttSettleKDString.getAllPerAttPeriodHasBeenSettleTips();
            }
            case UNFROZEN: {
                boolean isAllPerAttPeriodUnFrozen = perAttPeriodReportList.stream().allMatch(periodReport -> "2".equals(periodReport.getFrozenStatus()));
                if (!isAllPerAttPeriodUnFrozen) break;
                return AttSettleKDString.getAllPerAttPeriodHasBeenUnFrozenTips();
            }
            case LOCK: {
                boolean isAllPerAttPeriodHasBeenLocked = perAttPeriodReportList.stream().allMatch(periodReport -> "1".equals(periodReport.getLockStatus()));
                if (!isAllPerAttPeriodHasBeenLocked) break;
                return AttSettleKDString.getAllPerAttPeriodHasBeenLockedTips();
            }
            case UNLOCK: {
                boolean isAllPerAttPeriodHasBeenUnLocked = perAttPeriodReportList.stream().allMatch(periodReport -> "2".equals(periodReport.getLockStatus()));
                if (!isAllPerAttPeriodHasBeenUnLocked) break;
                return AttSettleKDString.getAllPerAttPeriodHasBeenUnLockedTips();
            }
            case STORAGE: {
                boolean isAllPerAttPeriodHasBeenSealed = perAttPeriodReportList.stream().allMatch(periodReport -> "1".equals(periodReport.getStorageStatus()));
                if (!isAllPerAttPeriodHasBeenSealed) break;
                return AttSettleKDString.getAllPerAttPeriodHasBeenSealedTips();
            }
            case UNSTORAGE: {
                boolean isAllPerAttPeriodHasBeenUnSealed = perAttPeriodReportList.stream().allMatch(periodReport -> "2".equals(periodReport.getStorageStatus()));
                if (!isAllPerAttPeriodHasBeenUnSealed) break;
                return AttSettleKDString.getAllPerAttPeriodHasBeenUnSealedTips();
            }
        }
        return "";
    }
}

