/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.impl.AbstractFrozenSettleService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;

public class FrozenSettleService
extends AbstractFrozenSettleService {
    @Override
    public SettleValidateResult validate(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        SettleValidateResult settleValidateResult = super.validate(settleTaskDetail, settleCheckEntity);
        if (settleValidateResult.getDetailStatusEnum() != null) {
            return settleValidateResult;
        }
        if (settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            this.errorMsg = this.checkEarliestNotStoragePeriodHasBeenFrozen(this.currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            PerAttPeriodReport perAttPeriodReport = this.currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> "1".equals(currentFilePeriodReport.getEarliestNoStoragePeriod())).findFirst().orElse(null);
            if (perAttPeriodReport != null) {
                this.periodReportObjectMap.put(perAttPeriodReport.getId(), Boolean.TRUE);
                settleValidateResult.setRealStartDate(perAttPeriodReport.getPerAttBeginDate());
                settleValidateResult.setRealEndDate(perAttPeriodReport.getPerAttEndDate());
            }
        } else {
            this.errorMsg = this.checkAllPerPeriodHasBeenFrozen(this.currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            this.errorMsg = this.checkAllPerPeriodHasBeenStorage(this.currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            this.currentFilePeriodReportList = this.currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> !"1".equals(currentFilePeriodReport.getStorageStatus())).collect(Collectors.toList());
            this.processingResultsAfterSuccessfulCutVerification(this.currentFilePeriodReportList, settleValidateResult, this.periodReportObjectMap, true);
        }
        this.errorMsg = this.checkAllPerPeriodHasBeenFrozenByResult(this.periodReportObjectMap, this.currentFilePeriodReportList);
        if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            settleValidateResult.setRealStartDate(null);
            settleValidateResult.setRealEndDate(null);
            return settleValidateResult;
        }
        settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
        settleValidateResult.setPeriodStatusMap(this.periodReportObjectMap);
        return settleValidateResult;
    }

    private String checkAllPerPeriodHasBeenFrozenByResult(Map<String, Object> periodStatusMap, List<PerAttPeriodReport> currentFilePeriodReportList) {
        if (periodStatusMap == null) {
            return AttSettleKDString.getPeriodToBeFrozenHasBeenFrozenErrorTips();
        }
        ArrayList<String> list = new ArrayList<String>(periodStatusMap.keySet());
        boolean allMatch = currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> list.contains(currentFilePeriodReport.getId())).allMatch(periodReport -> "1".equals(periodReport.getFrozenStatus()));
        return allMatch ? AttSettleKDString.getPeriodToBeFrozenHasBeenFrozenErrorTips() : "";
    }

    private String checkAllPerPeriodHasBeenStorage(List<PerAttPeriodReport> currentFilePeriodReportList) {
        boolean allMatch = currentFilePeriodReportList.stream().allMatch(perAttPeriodReport -> "1".equals(perAttPeriodReport.getStorageStatus()));
        return allMatch ? AttSettleKDString.getPeriodToBeFrozenHasBeenSealedErrorTips() : "";
    }

    private String checkAllPerPeriodHasBeenFrozen(List<PerAttPeriodReport> currentFilePeriodReportList) {
        boolean allMatch = currentFilePeriodReportList.stream().allMatch(perAttPeriodReport -> "1".equals(perAttPeriodReport.getFrozenStatus()));
        return allMatch ? AttSettleKDString.getPeriodToBeFrozenHasBeenFrozenErrorTips() : "";
    }

    private String checkEarliestNotStoragePeriodHasBeenFrozen(List<PerAttPeriodReport> perAttPeriodReports) {
        boolean match = perAttPeriodReports.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getEarliestNoStoragePeriod())).noneMatch(earliestNotStoragePeriod -> "1".equals(earliestNotStoragePeriod.getFrozenStatus()));
        return match ? "" : AttSettleKDString.getPeriodToBeFrozenHasBeenFrozenErrorTips();
    }
}

