/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.settle.entity.AttStateInfoEntity;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.impl.AbstractSettleService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.LockStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;
import kd.wtc.wtte.common.vo.settle.lock.TargetDateLockTipsVo;

public class LockSettleService
extends AbstractSettleService {
    @Override
    public SettleValidateResult validate(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        ArrayList filePeriodReportList;
        long attFileBoId = settleTaskDetail.getAttFileBoId();
        Map<Long, List<PerAttPeriodReport>> perAttPeriodMap = settleCheckEntity.getPerAttPeriodMap();
        Set<Long> hasPerFileIdSet = settleCheckEntity.getHasPerFileId();
        ArrayList currentFilePeriodReportList = perAttPeriodMap.get(attFileBoId);
        SettleValidateResult settleValidateResult = new SettleValidateResult();
        AttStateInfoEntity attStateInfoEntity = settleCheckEntity.getStateInfoEntityMap().get(attFileBoId);
        Date originLockDate = attStateInfoEntity.getAttStateInfoBO().getLockTo();
        Date calculatedDate = attStateInfoEntity.getAttStateInfoBO().getAccountTo();
        String errorMsg = this.checkAttFileIsRunning(attFileBoId, settleCheckEntity.getExistsFileBoIds());
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        String errorMsgTips = this.checkAttFileIsDiscard(attFileBoId, settleCheckEntity.getDiscardFileBoId());
        if (this.checkErrorMsgIsEmpty(errorMsgTips, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        if (calculatedDate == null) {
            settleValidateResult.setErrMsg(AttSettleKDString.getHaveNoCalculateDate());
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            return settleValidateResult;
        }
        PerAttPeriodReport earliestNoStoragePeriod = settleCheckEntity.getEarliestNoStoragePeriodMap().get(attFileBoId);
        errorMsg = this.getAttFileIfHasEarliestNotStoragePeriod(earliestNoStoragePeriod);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        if (WTCCollections.isEmpty(currentFilePeriodReportList)) {
            settleValidateResult.setErrMsg(AttSettleKDString.getSelectedFileWithinSelectedPeriodErrorTips());
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            return settleValidateResult;
        }
        Date targetLockEndDate = settleCheckEntity.getSettleTaskReqVo().getLockEndDate();
        if (targetLockEndDate == null) {
            SettleTypeEnum settleTypeEnum = settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum();
            errorMsg = this.checkAllPerAttPeriodHasBeenSettled(currentFilePeriodReportList, settleTypeEnum);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
                return settleValidateResult;
            }
            errorMsg = this.checkSelectedPeriodIfEarliestNotStoragePeriod(currentFilePeriodReportList, earliestNoStoragePeriod, settleTypeEnum);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
                return settleValidateResult;
            }
        } else if (targetLockEndDate.getTime() > earliestNoStoragePeriod.getAttPeriodEndDate().getTime()) {
            errorMsg = this.checkAllPerAttPeriodHasBeenSettled(currentFilePeriodReportList, settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum());
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
                return settleValidateResult;
            }
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            settleValidateResult.setErrMsg(AttSettleKDString.getOnlyLockLastNotStoredPeriodErrorTips((String)earliestNoStoragePeriod.getPerAttPeriodName(), (String)earliestNoStoragePeriod.getPeriodName()));
            return settleValidateResult;
        }
        Comparator<PerAttPeriodReport> comparator = Comparator.comparing(PerAttPeriod::getPerAttBeginDate);
        currentFilePeriodReportList.sort(comparator);
        PerAttPeriodReport attFileEarliestNotStoragePeriod = this.getAttFileEarliestNotStoragePeriod(currentFilePeriodReportList);
        Date[] date = this.initDate(settleCheckEntity, currentFilePeriodReportList, attFileEarliestNotStoragePeriod, calculatedDate, originLockDate, targetLockEndDate);
        Date realStartDate = date[0];
        Date realEndDate = date[1];
        if (realStartDate.after(realEndDate)) {
            this.accessErrTips(targetLockEndDate, calculatedDate, originLockDate, settleCheckEntity, settleValidateResult, currentFilePeriodReportList, attFileEarliestNotStoragePeriod);
            return settleValidateResult;
        }
        HashMap periodReportObjectMap = Maps.newHashMapWithExpectedSize((int)currentFilePeriodReportList.size());
        settleValidateResult.setPeriodStatusMap((Map)periodReportObjectMap);
        settleValidateResult.setRealStartDate(realStartDate);
        List<Object> list = targetLockEndDate == null ? currentFilePeriodReportList : currentFilePeriodReportList.stream().filter(periodReport -> realStartDate.compareTo(periodReport.getAttPeriodEndDate()) <= 0 && realEndDate.compareTo(periodReport.getAttPeriodStartDate()) >= 0).collect(Collectors.toList());
        errorMsg = super.checkAffiliateAdminOrgAndPerPeriodMatch(attFileBoId, list, settleCheckEntity.getSettleTaskReqVo(), false);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        if (targetLockEndDate == null && settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            errorMsg = this.checkAttFileIfHasEarliestNotStoragePeriodAuth(currentFilePeriodReportList, hasPerFileIdSet);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                this.clearResult(settleValidateResult);
                return settleValidateResult;
            }
            filePeriodReportList = Lists.newArrayListWithExpectedSize((int)1);
            filePeriodReportList.add(attFileEarliestNotStoragePeriod);
        } else {
            if (targetLockEndDate == null) {
                errorMsg = this.checkIfAtLeastHasOnePeriodAuth(perAttPeriodMap.get(attFileBoId), hasPerFileIdSet);
                if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                    this.clearResult(settleValidateResult);
                    return settleValidateResult;
                }
            } else if (this.checkIfNoAnyAttFileDateAuth(settleCheckEntity.getHasPerFileDateData().get(attFileBoId), realStartDate, realEndDate)) {
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
                settleValidateResult.setErrMsg(AttSettleKDString.getUserHavePermissionForPeriodToBeFrozenErrorTips());
                this.clearResult(settleValidateResult);
                return settleValidateResult;
            }
            filePeriodReportList = currentFilePeriodReportList;
        }
        return this.processLock(filePeriodReportList, earliestNoStoragePeriod, realStartDate, realEndDate, targetLockEndDate, calculatedDate, originLockDate, settleValidateResult, periodReportObjectMap, settleCheckEntity.getTotalBaseBooleanMap());
    }

    private void accessErrTips(Date targetLockEndDate, Date calculatedDate, Date originLockDate, SettleCheckEntity settleCheckEntity, SettleValidateResult settleValidateResult, List<PerAttPeriodReport> currentFilePeriodReportList, PerAttPeriodReport attFileEarliestNotStoragePeriod) {
        if (targetLockEndDate == null && settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            if (originLockDate != null && originLockDate.getTime() >= attFileEarliestNotStoragePeriod.getPerAttEndDate().getTime()) {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)originLockDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getNoNeedLockAgain((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            } else {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calculatedDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getNoCalculateErrTips((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            }
        } else if (targetLockEndDate == null) {
            if (originLockDate != null && originLockDate.getTime() >= currentFilePeriodReportList.get(currentFilePeriodReportList.size() - 1).getPerAttEndDate().getTime()) {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)originLockDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getNoNeedLockAgain((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            } else {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calculatedDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getNoCalculateErrTips((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            }
        } else if (targetLockEndDate.getTime() < attFileEarliestNotStoragePeriod.getFileStartDate().getTime()) {
            String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileEarliestNotStoragePeriod.getFileStartDate());
            settleValidateResult.setErrMsg(AttSettleKDString.getPlanStartDateBeforeAttFileStartDateErrorTips((String)dateStr));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
        } else if (originLockDate != null && originLockDate.getTime() >= targetLockEndDate.getTime()) {
            String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)originLockDate);
            settleValidateResult.setErrMsg(AttSettleKDString.getNoNeedLockAgain((String)dateStr));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
        } else {
            String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calculatedDate);
            settleValidateResult.setErrMsg(AttSettleKDString.getNoCalculateErrTips((String)dateStr));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
        }
    }

    private SettleValidateResult processLock(List<PerAttPeriodReport> filePeriodReportList, PerAttPeriodReport earliestNoStoragePeriod, Date realStartDate, Date realEndDate, Date targetLockEndDate, Date calculatedDate, Date originLockDate, SettleValidateResult settleValidateResult, Map<String, Object> periodReportObjectMap, Map<String, Boolean> totalBaseBooleanMap) {
        boolean ifFindEarliestNoStoragePeriod = false;
        int findContinuity = 0;
        TargetDateLockTipsVo targetDateLockTipsVo = null;
        ArrayList actualFilePeriodReportList = Lists.newArrayListWithExpectedSize((int)filePeriodReportList.size());
        Date continuousMinEndDate = filePeriodReportList.get(0).getPerAttEndDate();
        for (int i = 0; i < filePeriodReportList.size(); ++i) {
            PerAttPeriodReport prePerAttPeriodReport;
            Date preEndDayAddOne;
            PerAttPeriodReport perAttPeriodReport = filePeriodReportList.get(i);
            if (earliestNoStoragePeriod.equals(perAttPeriodReport)) {
                ifFindEarliestNoStoragePeriod = true;
            }
            if (i > 0 && findContinuity > 0 && (preEndDayAddOne = WTCDateUtils.addDays((Date)(prePerAttPeriodReport = filePeriodReportList.get(i - 1)).getPerAttEndDate(), (int)1)).getTime() != perAttPeriodReport.getPerAttBeginDate().getTime()) {
                continuousMinEndDate = prePerAttPeriodReport.getPerAttEndDate();
                if (targetLockEndDate == null) break;
                targetDateLockTipsVo = new TargetDateLockTipsVo();
                targetDateLockTipsVo.setStartDate(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)preEndDayAddOne));
                targetDateLockTipsVo.setEndDate(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.addDays((Date)perAttPeriodReport.getPerAttBeginDate(), (int)-1)));
                break;
            }
            if (!ifFindEarliestNoStoragePeriod) continue;
            if (!realStartDate.after(perAttPeriodReport.getPerAttEndDate()) && !realEndDate.before(perAttPeriodReport.getPerAttBeginDate())) {
                if (calculatedDate.getTime() >= perAttPeriodReport.getPerAttEndDate().getTime()) {
                    if (originLockDate == null || originLockDate.getTime() < perAttPeriodReport.getPerAttEndDate().getTime()) {
                        if (targetLockEndDate == null || targetLockEndDate.getTime() >= perAttPeriodReport.getPerAttEndDate().getTime()) {
                            periodReportObjectMap.put(perAttPeriodReport.getId(), LockStatusEnum.LOCKED);
                            settleValidateResult.setRealEndDate(perAttPeriodReport.getPerAttEndDate());
                        } else {
                            periodReportObjectMap.put(perAttPeriodReport.getId(), LockStatusEnum.LOCK_PART);
                            settleValidateResult.setRealEndDate(targetLockEndDate);
                        }
                        actualFilePeriodReportList.add(perAttPeriodReport);
                    }
                } else if (calculatedDate.getTime() >= perAttPeriodReport.getPerAttBeginDate().getTime() && (originLockDate == null || WTCDateUtils.addDays((Date)originLockDate, (int)1).getTime() < perAttPeriodReport.getPerAttEndDate().getTime())) {
                    periodReportObjectMap.put(perAttPeriodReport.getId(), LockStatusEnum.LOCK_PART);
                    actualFilePeriodReportList.add(perAttPeriodReport);
                    if (targetLockEndDate == null || targetLockEndDate.getTime() > calculatedDate.getTime()) {
                        settleValidateResult.setRealEndDate(calculatedDate);
                    } else {
                        settleValidateResult.setRealEndDate(targetLockEndDate);
                    }
                }
            }
            ++findContinuity;
        }
        if (WTCCollections.isNotEmpty((Collection)actualFilePeriodReportList) && this.checkIfEnyPerAttPeriodReportHaveNoAttTotalBase(actualFilePeriodReportList, totalBaseBooleanMap)) {
            settleValidateResult.setErrMsg(AttSettleKDString.getLockDateRangeHaveNoAttTotalBaseErrorTips());
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            this.clearResult(settleValidateResult);
            return settleValidateResult;
        }
        this.parseSettleValidateResult(filePeriodReportList, calculatedDate, originLockDate, targetLockEndDate, continuousMinEndDate, settleValidateResult, targetDateLockTipsVo);
        return settleValidateResult;
    }

    private void parseSettleValidateResult(List<PerAttPeriodReport> filePeriodReportList, Date calculatedDate, Date originLockDate, Date targetLockEndDate, Date continuousMinEndDate, SettleValidateResult settleValidateResult, TargetDateLockTipsVo targetDateLockTipsVo) {
        PerAttPeriodReport lastPerAttPeriodReport = filePeriodReportList.get(filePeriodReportList.size() - 1);
        Date fileEndDate = lastPerAttPeriodReport.getFileEndDate();
        Date actualEndDate = settleValidateResult.getRealEndDate();
        if (targetDateLockTipsVo != null) {
            this.clearResultWithTargetDate(settleValidateResult);
            settleValidateResult.setErrMsg(AttSettleKDString.getPeriodNotExistErrorTips((String)targetDateLockTipsVo.getStartDate(), (String)targetDateLockTipsVo.getEndDate()));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
        } else if (actualEndDate == null) {
            this.clearResult(settleValidateResult);
            if (originLockDate == null) {
                settleValidateResult.setErrMsg(AttSettleKDString.getLockErrTips());
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            } else {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)originLockDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getNoNeedLockAgain((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            }
        } else if (targetLockEndDate != null) {
            if (actualEndDate.getTime() == targetLockEndDate.getTime() || this.checkIfAfterFileEndDate(lastPerAttPeriodReport, targetLockEndDate, actualEndDate, fileEndDate)) {
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
            } else {
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calculatedDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getLockPartErrorTips((String)dateStr));
            }
        } else if (continuousMinEndDate.getTime() > actualEndDate.getTime()) {
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calculatedDate);
            settleValidateResult.setErrMsg(AttSettleKDString.getLockPartErrorTips((String)dateStr));
        } else {
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
        }
    }

    private boolean checkIfAfterFileEndDate(PerAttPeriodReport lastPerAttPeriodReport, Date targetLockEndDate, Date actualEndDate, Date fileEndDate) {
        return lastPerAttPeriodReport.getPerAttEndDate().getTime() == fileEndDate.getTime() && fileEndDate.getTime() == actualEndDate.getTime() && targetLockEndDate.getTime() > actualEndDate.getTime();
    }

    private Date[] initDate(SettleCheckEntity settleCheckEntity, List<PerAttPeriodReport> currentFilePeriodReportList, PerAttPeriodReport attFileEarliestNotStoragePeriod, Date calculatedDate, Date originLockDate, Date targetLockEndDate) {
        Date realEndDate;
        Date realStartDate;
        Date lastPeriodEndDate = currentFilePeriodReportList.get(currentFilePeriodReportList.size() - 1).getPerAttEndDate();
        Date firstPeriodBeginDate = currentFilePeriodReportList.get(0).getPerAttBeginDate();
        if (targetLockEndDate != null) {
            realStartDate = originLockDate == null ? firstPeriodBeginDate : WTCDateUtils.getMaxDate((Date)WTCDateUtils.addDays((Date)originLockDate, (int)1), (Date)firstPeriodBeginDate);
            realEndDate = WTCDateUtils.getMinDate((Date)calculatedDate, (Date)targetLockEndDate);
        } else if (settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            realStartDate = originLockDate == null ? attFileEarliestNotStoragePeriod.getPerAttBeginDate() : WTCDateUtils.getMaxDate((Date)WTCDateUtils.addDays((Date)originLockDate, (int)1), (Date)attFileEarliestNotStoragePeriod.getPerAttBeginDate());
            realEndDate = WTCDateUtils.getMinDate((Date)attFileEarliestNotStoragePeriod.getPerAttEndDate(), (Date)calculatedDate);
        } else {
            realStartDate = originLockDate == null ? firstPeriodBeginDate : WTCDateUtils.getMaxDate((Date)WTCDateUtils.addDays((Date)originLockDate, (int)1), (Date)firstPeriodBeginDate);
            realEndDate = WTCDateUtils.getMinDate((Date)lastPeriodEndDate, (Date)calculatedDate);
        }
        Date[] date = new Date[]{realStartDate, realEndDate};
        return date;
    }
}

