/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.settle.entity.AttStateInfoEntity;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.impl.AbstractSettleService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;

public class SealSettleService
extends AbstractSettleService {
    @Override
    public SettleValidateResult validate(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        long attFileBoId = settleTaskDetail.getAttFileBoId();
        Map<Long, List<PerAttPeriodReport>> perAttPeriodMap = settleCheckEntity.getPerAttPeriodMap();
        Set<Long> hasPerFileBoId = settleCheckEntity.getHasPerFileId();
        Map<Long, AttStateInfoEntity> stateInfoEntityMap = settleCheckEntity.getStateInfoEntityMap();
        AttStateInfoEntity attStateInfoEntity = stateInfoEntityMap.get(attFileBoId);
        List<PerAttPeriodReport> currentFilePeriodReportList = perAttPeriodMap.get(attFileBoId);
        SettleValidateResult settleValidateResult = new SettleValidateResult();
        String errorMsg = this.checkAttFileIsRunning(attFileBoId, settleCheckEntity.getExistsFileBoIds());
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        String errorMsgTips = this.checkAttFileIsDiscard(attFileBoId, settleCheckEntity.getDiscardFileBoId());
        if (this.checkErrorMsgIsEmpty(errorMsgTips, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        errorMsg = this.checkAttFileAndPeriodMatch(attFileBoId, perAttPeriodMap);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        PerAttPeriodReport earliestNoStoragePeriod = settleCheckEntity.getEarliestNoStoragePeriodMap().get(attFileBoId);
        errorMsg = this.getAttFileIfHasEarliestNotStoragePeriod(earliestNoStoragePeriod);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        SettleTypeEnum settleTypeEnum = settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum();
        errorMsg = this.checkAllPerAttPeriodHasBeenSettled(currentFilePeriodReportList, settleTypeEnum);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        errorMsg = this.checkSelectedPeriodIfEarliestNotStoragePeriod(currentFilePeriodReportList, earliestNoStoragePeriod, settleTypeEnum);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        HashMap periodReportObjectMap = Maps.newHashMapWithExpectedSize((int)currentFilePeriodReportList.size());
        Date accountTo = attStateInfoEntity == null ? null : (attStateInfoEntity.getAttStateInfoBO() == null ? null : attStateInfoEntity.getAttStateInfoBO().getAccountTo());
        errorMsg = super.checkAffiliateAdminOrgAndPerPeriodMatch(attFileBoId, currentFilePeriodReportList, settleCheckEntity.getSettleTaskReqVo(), false);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        if (settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            errorMsg = this.checkAttFileIfHasEarliestNotStoragePeriodAuth(currentFilePeriodReportList, hasPerFileBoId);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            errorMsg = this.checkEarliestNoStoragePeriodHasBeenStorage(currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            PerAttPeriodReport perAttPeriodReport = currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> "1".equals(currentFilePeriodReport.getEarliestNoStoragePeriod())).findFirst().orElse(null);
            errorMsg = this.checkPeriodEndDateHasBeenLateAcountTo(perAttPeriodReport, accountTo);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
                return settleValidateResult;
            }
            Map<String, Boolean> totalBaseBooleanMap = settleCheckEntity.getTotalBaseBooleanMap();
            if (!(perAttPeriodReport == null || totalBaseBooleanMap.get(perAttPeriodReport.getId()) != null && totalBaseBooleanMap.get(perAttPeriodReport.getId()).booleanValue())) {
                settleValidateResult.setErrMsg(AttSettleKDString.getSealDateRangeHaveNoAttTotalBaseErrorTips());
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
                return settleValidateResult;
            }
            if (perAttPeriodReport != null) {
                periodReportObjectMap.put(perAttPeriodReport.getId(), Boolean.TRUE);
                settleValidateResult.setRealStartDate(perAttPeriodReport.getPerAttBeginDate());
                settleValidateResult.setRealEndDate(perAttPeriodReport.getPerAttEndDate());
            }
        } else {
            errorMsg = this.checkIfAtLeastHasOnePeriodAuth(perAttPeriodMap.get(attFileBoId), hasPerFileBoId);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            errorMsg = this.checkAllPeriodHasBeenNotStorage(currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            List<PerAttPeriodReport> effectList = this.sortPerAttPeriodEffect(currentFilePeriodReportList);
            PerAttPeriodReport perAttPeriodReport = effectList.stream().max(Comparator.comparing(PerAttPeriod::getPerAttEndDate)).orElse(null);
            errorMsg = this.checkPeriodEndDateHasBeenLateAcountTo(perAttPeriodReport, accountTo);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
                return settleValidateResult;
            }
            if (this.checkErrorBooleanIsExist(this.checkIfEnyPerAttPeriodReportHaveNoAttTotalBase(currentFilePeriodReportList, settleCheckEntity.getTotalBaseBooleanMap()), settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
                return settleValidateResult;
            }
            List<PerAttPeriodReport> noStoreReport = currentFilePeriodReportList.stream().filter(report -> HRStringUtils.equals((String)report.getStorageStatus(), (String)"2")).collect(Collectors.toList());
            this.processingResultsAfterSuccessfulCutVerification(noStoreReport, settleValidateResult, periodReportObjectMap, true);
        }
        settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
        settleValidateResult.setPeriodStatusMap((Map)periodReportObjectMap);
        return settleValidateResult;
    }

    private List<PerAttPeriodReport> sortPerAttPeriodEffect(List<PerAttPeriodReport> currentFilePeriodReportList) {
        List sortedList = currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> "2".equals(currentFilePeriodReport.getStorageStatus())).sorted(Comparator.comparing(PerAttPeriod::getPerAttBeginDate)).collect(Collectors.toList());
        ArrayList<PerAttPeriodReport> effectList = new ArrayList<PerAttPeriodReport>(sortedList.size());
        Date endDate = null;
        for (PerAttPeriodReport perAttPeriodReport : sortedList) {
            if (endDate == null) {
                endDate = perAttPeriodReport.getPerAttEndDate();
            } else {
                if (WTCDateUtils.getNextDate(endDate).compareTo(perAttPeriodReport.getPerAttBeginDate()) != 0) break;
                endDate = perAttPeriodReport.getPerAttEndDate();
            }
            effectList.add(perAttPeriodReport);
        }
        return effectList;
    }

    private boolean checkErrorBooleanIsExist(boolean ifEnyPerAttPeriodReportHaveNoAttTotalBase, SettleValidateResult settleValidateResult, SettleTaskDetailStatusEnum settlementfailed) {
        if (ifEnyPerAttPeriodReportHaveNoAttTotalBase) {
            settleValidateResult.setErrMsg(AttSettleKDString.getSealDateRangeHaveNoAttTotalBaseErrorTips());
            settleValidateResult.setDetailStatusEnum(settlementfailed);
            return true;
        }
        return false;
    }

    private String checkPeriodEndDateHasBeenLateAcountTo(PerAttPeriodReport perAttPeriodReport, Date accountTo) {
        if (accountTo == null) {
            return AttSettleKDString.getPeriodRealEndDateHasBeenLateAcountTo((Date)accountTo);
        }
        return perAttPeriodReport.getPerAttEndDate().compareTo(accountTo) <= 0 ? "" : AttSettleKDString.getPeriodRealEndDateHasBeenLateAcountTo((Date)accountTo);
    }

    private String checkEarliestNoStoragePeriodHasBeenStorage(List<PerAttPeriodReport> currentFilePeriodReportList) {
        List unStoragePeriodList = currentFilePeriodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getEarliestNoStoragePeriod()) && "1".equals(perAttPeriodReport.getStorageStatus())).collect(Collectors.toList());
        return unStoragePeriodList.isEmpty() ? "" : AttSettleKDString.getPeriodToBeFrozenHasBeenSealedErrorTips();
    }

    private String checkAllPeriodHasBeenNotStorage(List<PerAttPeriodReport> currentFilePeriodReportList) {
        List notStoragePeriodList = currentFilePeriodReportList.stream().filter(perAttPeriodReport -> "2".equals(perAttPeriodReport.getStorageStatus())).collect(Collectors.toList());
        return !notStoragePeriodList.isEmpty() ? "" : AttSettleKDString.getPeriodToBeFrozenHasBeenSealedErrorTips();
    }
}

