/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.impl.AbstractFrozenSettleService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;

public class UnFrozenSettleService
extends AbstractFrozenSettleService {
    @Override
    public SettleValidateResult validate(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        SettleValidateResult settleValidateResult = super.validate(settleTaskDetail, settleCheckEntity);
        if (settleValidateResult.getDetailStatusEnum() != null) {
            return settleValidateResult;
        }
        if (settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            this.errorMsg = this.checkEarliestNotStoragePeriodIsNotFrozen(this.currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
        } else {
            this.errorMsg = this.checkAllPerPeriodIsNotFrozen((List)this.perAttPeriodMap.get(this.attFileBoId));
            if (this.checkErrorMsgIsEmpty(this.errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
        }
        List periodReports = this.currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> "1".equals(currentFilePeriodReport.getFrozenStatus()) || "3".equals(currentFilePeriodReport.getFrozenStatus())).collect(Collectors.toList());
        for (PerAttPeriodReport periodReport : periodReports) {
            this.periodReportObjectMap.put(periodReport.getId(), Boolean.FALSE);
        }
        List periodReportList = periodReports.stream().sorted(Comparator.comparing(PerAttPeriod::getPerAttBeginDate)).collect(Collectors.toList());
        if (!periodReportList.isEmpty()) {
            settleValidateResult.setRealStartDate(WTCCollectionIndexUtil.getEleFromList(periodReportList, (int)0).isPresent() ? ((PerAttPeriodReport)WTCCollectionIndexUtil.getEleFromList(periodReportList, (int)0).get()).getPerAttBeginDate() : null);
            settleValidateResult.setRealEndDate(((PerAttPeriodReport)periodReportList.get(periodReportList.size() - 1)).getPerAttEndDate());
        }
        settleValidateResult.setPeriodStatusMap(this.periodReportObjectMap);
        settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
        return settleValidateResult;
    }

    private String checkEarliestNotStoragePeriodIsNotFrozen(List<PerAttPeriodReport> currentFilePeriodReportList) {
        boolean match = currentFilePeriodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getEarliestNoStoragePeriod())).noneMatch(earliestNotStoragePeriod -> "2".equals(earliestNotStoragePeriod.getFrozenStatus()));
        return match ? "" : AttSettleKDString.getAllPerperiodIsNotFrozenErrorTips();
    }

    private String checkAllPerPeriodIsNotFrozen(List<PerAttPeriodReport> perAttPeriodReports) {
        boolean allMatch = perAttPeriodReports.stream().allMatch(perAttPeriodReport -> "2".equals(perAttPeriodReport.getFrozenStatus()));
        return allMatch ? AttSettleKDString.getAllPerperiodIsNotFrozenErrorTips() : "";
    }
}

