/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.settle.entity.AttStateInfoEntity;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.impl.AbstractSettleService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.LockStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;
import kd.wtc.wtte.common.vo.settle.lock.TargetDateLockTipsVo;

public class UnLockSettleService
extends AbstractSettleService {
    @Override
    public SettleValidateResult validate(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        List<Object> filePeriodReportList;
        long attFileBoId = settleTaskDetail.getAttFileBoId();
        Map<Long, List<PerAttPeriodReport>> perAttPeriodMap = settleCheckEntity.getPerAttPeriodMap();
        Set<Long> hasPerFileIdSet = settleCheckEntity.getHasPerFileId();
        List<PerAttPeriodReport> currentFilePeriodReportList = perAttPeriodMap.get(attFileBoId);
        SettleValidateResult settleValidateResult = new SettleValidateResult();
        String errorMsg = this.checkAttFileIsRunning(attFileBoId, settleCheckEntity.getExistsFileBoIds());
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        String errorMsgTips = this.checkAttFileIsDiscard(attFileBoId, settleCheckEntity.getDiscardFileBoId());
        if (this.checkErrorMsgIsEmpty(errorMsgTips, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        AttStateInfoEntity attStateInfoEntity = settleCheckEntity.getStateInfoEntityMap().get(attFileBoId);
        Date originLockDate = attStateInfoEntity.getAttStateInfoBO().getLockTo();
        Date originStorageDate = attStateInfoEntity.getAttStateInfoBO().getStorageTo();
        if (originLockDate == null) {
            settleValidateResult.setErrMsg(AttSettleKDString.getHaveNoLockDate());
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            return settleValidateResult;
        }
        if (WTCCollections.isEmpty(currentFilePeriodReportList)) {
            settleValidateResult.setErrMsg(AttSettleKDString.getSelectedFileWithinSelectedPeriodErrorTips());
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            return settleValidateResult;
        }
        if (originLockDate.getTime() < currentFilePeriodReportList.get(0).getFileStartDate().getTime()) {
            settleValidateResult.setErrMsg(AttSettleKDString.getHaveNoLockDate());
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            return settleValidateResult;
        }
        Date targetUnLockDate = settleCheckEntity.getSettleTaskReqVo().getLockEndDate();
        PerAttPeriodReport originLockFilePeriodReport = settleCheckEntity.getLatestLockedPeriodMap().get(attFileBoId);
        if (!currentFilePeriodReportList.contains(originLockFilePeriodReport) || targetUnLockDate != null && targetUnLockDate.getTime() < originLockFilePeriodReport.getAttPeriodStartDate().getTime()) {
            if (originLockFilePeriodReport != null) {
                String errMsg = this.checkAllPerAttPeriodHasBeenSettled(currentFilePeriodReportList, settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum());
                if (this.checkErrorMsgIsEmpty(errMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
                    return settleValidateResult;
                }
                settleValidateResult.setErrMsg(AttSettleKDString.getSelectedPeriodIsEarliestUnsealedPeriodByUnLockedErrorTips((String)originLockFilePeriodReport.getPerAttPeriodName(), (String)originLockFilePeriodReport.getPeriodName()));
            } else {
                settleValidateResult.setErrMsg(AttSettleKDString.getUnLockErrTips());
            }
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            return settleValidateResult;
        }
        Comparator<PerAttPeriodReport> comparator = Comparator.comparing(PerAttPeriod::getPerAttBeginDate);
        currentFilePeriodReportList.sort(comparator);
        PerAttPeriodReport firstFilePeriodReport = currentFilePeriodReportList.get(0);
        Date realStartDate = this.initStartDate(settleCheckEntity, currentFilePeriodReportList, originLockFilePeriodReport, originStorageDate, targetUnLockDate);
        Date realEndDate = originLockDate;
        if (realEndDate.before(realStartDate)) {
            this.accessErrTips(settleValidateResult, settleCheckEntity, targetUnLockDate, originLockDate, realStartDate, firstFilePeriodReport, originLockFilePeriodReport);
            return settleValidateResult;
        }
        HashMap periodReportObjectMap = Maps.newHashMapWithExpectedSize((int)currentFilePeriodReportList.size());
        settleValidateResult.setPeriodStatusMap((Map)periodReportObjectMap);
        settleValidateResult.setRealEndDate(realEndDate);
        List<Object> list = targetUnLockDate == null ? currentFilePeriodReportList : currentFilePeriodReportList.stream().filter(periodReport -> realStartDate.compareTo(periodReport.getAttPeriodEndDate()) <= 0 && realEndDate.compareTo(periodReport.getAttPeriodStartDate()) >= 0).collect(Collectors.toList());
        errorMsg = super.checkAffiliateAdminOrgAndPerPeriodMatch(attFileBoId, list, settleCheckEntity.getSettleTaskReqVo(), false);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        if (targetUnLockDate == null && settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            if (!this.checkPeriodAuth(hasPerFileIdSet, originLockFilePeriodReport)) {
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
                settleValidateResult.setErrMsg(AttSettleKDString.getUserHavePermissionForPeriodToBeFrozenErrorTips());
                this.clearResult(settleValidateResult);
                return settleValidateResult;
            }
            filePeriodReportList = Lists.newArrayListWithExpectedSize((int)1);
            filePeriodReportList.add(originLockFilePeriodReport);
        } else {
            if (targetUnLockDate == null) {
                errorMsg = this.checkIfAtLeastHasOnePeriodAuth(perAttPeriodMap.get(attFileBoId), hasPerFileIdSet);
                if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                    this.clearResult(settleValidateResult);
                    return settleValidateResult;
                }
            } else if (this.checkIfNoAnyAttFileDateAuth(settleCheckEntity.getHasPerFileDateData().get(attFileBoId), realStartDate, realEndDate)) {
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
                settleValidateResult.setErrMsg(AttSettleKDString.getUserHaveNoAuthCannotUnLockErrorTips());
                this.clearResult(settleValidateResult);
                return settleValidateResult;
            }
            filePeriodReportList = currentFilePeriodReportList;
        }
        return this.processUnLock(settleValidateResult, filePeriodReportList, originLockFilePeriodReport, originLockDate, originStorageDate, realStartDate, realEndDate, periodReportObjectMap, targetUnLockDate);
    }

    private void accessErrTips(SettleValidateResult settleValidateResult, SettleCheckEntity settleCheckEntity, Date targetUnLockDate, Date originLockDate, Date realStartDate, PerAttPeriodReport firstFilePeriodReport, PerAttPeriodReport originLockFilePeriodReport) {
        if (targetUnLockDate == null && settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            if (originLockDate.getTime() < originLockFilePeriodReport.getPerAttBeginDate().getTime()) {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)realStartDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getNoNeedLockErrorTips((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            } else {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.addDays((Date)realStartDate, (int)-1));
                settleValidateResult.setErrMsg(AttSettleKDString.getPeriodToBeFrozenHasBeenLockedErrorTips((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            }
        } else if (targetUnLockDate == null) {
            if (originLockDate.getTime() < firstFilePeriodReport.getPerAttBeginDate().getTime()) {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)realStartDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getNoNeedLockErrorTips((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
            } else {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.addDays((Date)realStartDate, (int)-1));
                settleValidateResult.setErrMsg(AttSettleKDString.getPeriodToBeFrozenHasBeenLockedErrorTips((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            }
        } else if (originLockDate.getTime() < targetUnLockDate.getTime()) {
            String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)realStartDate);
            settleValidateResult.setErrMsg(AttSettleKDString.getNoNeedLockErrorTips((String)dateStr));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.UNEXECUTED);
        } else {
            String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.addDays((Date)realStartDate, (int)-1));
            settleValidateResult.setErrMsg(AttSettleKDString.getPeriodToBeFrozenHasBeenLockedErrorTips((String)dateStr));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
        }
    }

    private Date initStartDate(SettleCheckEntity settleCheckEntity, List<PerAttPeriodReport> currentFilePeriodReportList, PerAttPeriodReport originLockFilePeriodReport, Date originStorageDate, Date targetUnLockDate) {
        Date realStartDate;
        Date firstPeriodBeginDate = currentFilePeriodReportList.get(0).getPerAttBeginDate();
        Date originLockPeriodBeginDate = originLockFilePeriodReport.getPerAttBeginDate();
        Date originStorageDateAddOne = WTCDateUtils.addDays((Date)originStorageDate, (int)1);
        if (originStorageDate != null) {
            if (targetUnLockDate != null) {
                realStartDate = WTCDateUtils.getMaxDate((Date)firstPeriodBeginDate, (Date)targetUnLockDate);
                realStartDate = WTCDateUtils.getMaxDate((Date)realStartDate, (Date)originStorageDateAddOne);
            } else {
                realStartDate = settleCheckEntity.getSettleTaskReqVo().isBeSettleCut() ? WTCDateUtils.getMaxDate((Date)originStorageDateAddOne, (Date)originLockPeriodBeginDate) : WTCDateUtils.getMaxDate((Date)originStorageDateAddOne, (Date)firstPeriodBeginDate);
            }
        } else {
            realStartDate = targetUnLockDate != null ? WTCDateUtils.getMaxDate((Date)firstPeriodBeginDate, (Date)targetUnLockDate) : (settleCheckEntity.getSettleTaskReqVo().isBeSettleCut() ? originLockPeriodBeginDate : firstPeriodBeginDate);
        }
        return realStartDate;
    }

    private SettleValidateResult processUnLock(SettleValidateResult settleValidateResult, List<PerAttPeriodReport> filePeriodReportList, PerAttPeriodReport originLockFilePeriodReport, Date originLockDate, Date originStorageDate, Date realStartDate, Date realEndDate, Map<String, Object> periodReportObjectMap, Date targetUnLockDate) {
        boolean lockDateInPeriodReport = false;
        int size = filePeriodReportList.size();
        int find = 0;
        TargetDateLockTipsVo targetDateLockTipsVo = null;
        Date continuousMaxStartDate = filePeriodReportList.get(size - 1).getPerAttBeginDate();
        for (int i = size - 1; i >= 0; --i) {
            PerAttPeriodReport perAttPeriodReport = filePeriodReportList.get(i);
            if (originLockFilePeriodReport.equals(perAttPeriodReport)) {
                lockDateInPeriodReport = true;
            }
            if (lockDateInPeriodReport && find > 0) {
                PerAttPeriodReport afterPerAttPeriodReport = filePeriodReportList.get(i + 1);
                Date preEndDayAddOne = WTCDateUtils.addDays((Date)perAttPeriodReport.getPerAttEndDate(), (int)1);
                if (preEndDayAddOne.getTime() != afterPerAttPeriodReport.getPerAttBeginDate().getTime()) {
                    continuousMaxStartDate = afterPerAttPeriodReport.getPerAttBeginDate();
                    if (targetUnLockDate == null) break;
                    targetDateLockTipsVo = new TargetDateLockTipsVo();
                    targetDateLockTipsVo.setStartDate(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)preEndDayAddOne));
                    targetDateLockTipsVo.setEndDate(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.addDays((Date)afterPerAttPeriodReport.getPerAttBeginDate(), (int)-1)));
                    break;
                }
            }
            if (!lockDateInPeriodReport) continue;
            if (!realStartDate.after(perAttPeriodReport.getPerAttEndDate()) && !realEndDate.before(perAttPeriodReport.getPerAttBeginDate())) {
                if (originStorageDate != null && perAttPeriodReport.getPerAttBeginDate().getTime() <= originStorageDate.getTime()) {
                    if (perAttPeriodReport.getPerAttEndDate().getTime() > originStorageDate.getTime() && originLockDate.getTime() > originStorageDate.getTime()) {
                        periodReportObjectMap.put(perAttPeriodReport.getId(), LockStatusEnum.LOCK_PART);
                        settleValidateResult.setRealStartDate(WTCDateUtils.addDays((Date)originStorageDate, (int)1));
                    }
                } else if (originLockDate.getTime() >= perAttPeriodReport.getPerAttBeginDate().getTime()) {
                    if (targetUnLockDate == null || targetUnLockDate.getTime() <= perAttPeriodReport.getPerAttBeginDate().getTime()) {
                        periodReportObjectMap.put(perAttPeriodReport.getId(), LockStatusEnum.UNLOCK);
                        settleValidateResult.setRealStartDate(perAttPeriodReport.getPerAttBeginDate());
                    } else {
                        periodReportObjectMap.put(perAttPeriodReport.getId(), LockStatusEnum.LOCK_PART);
                        settleValidateResult.setRealStartDate(targetUnLockDate);
                    }
                }
            }
            ++find;
        }
        this.parseSettleValidateResult(filePeriodReportList, originStorageDate, realStartDate, targetUnLockDate, continuousMaxStartDate, settleValidateResult, targetDateLockTipsVo);
        return settleValidateResult;
    }

    private void parseSettleValidateResult(List<PerAttPeriodReport> filePeriodReportList, Date originStorageDate, Date realStartDate, Date targetUnlockEndDate, Date continuousMaxStartDate, SettleValidateResult settleValidateResult, TargetDateLockTipsVo targetDateLockTipsVo) {
        PerAttPeriodReport firstPerAttPeriodReport = filePeriodReportList.get(0);
        Date fileStartDate = firstPerAttPeriodReport.getFileStartDate();
        Date actualStartDate = settleValidateResult.getRealStartDate();
        if (targetDateLockTipsVo != null) {
            this.clearResultWithTargetDate(settleValidateResult);
            settleValidateResult.setErrMsg(AttSettleKDString.getPeriodNotExistErrorTips((String)targetDateLockTipsVo.getStartDate(), (String)targetDateLockTipsVo.getEndDate()));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
        } else if (actualStartDate == null) {
            settleValidateResult.setErrMsg(AttSettleKDString.getUnLockErrTips());
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            this.clearResult(settleValidateResult);
        } else if (targetUnlockEndDate != null) {
            if (targetUnlockEndDate.getTime() == actualStartDate.getTime() || this.checkIfBeforeFileStartDate(firstPerAttPeriodReport, targetUnlockEndDate, actualStartDate, fileStartDate)) {
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
            } else {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)originStorageDate);
                settleValidateResult.setErrMsg(AttSettleKDString.getUnLockPartErrorTips((String)dateStr));
                settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
            }
        } else if (actualStartDate.getTime() > continuousMaxStartDate.getTime()) {
            String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)originStorageDate);
            settleValidateResult.setErrMsg(AttSettleKDString.getUnLockPartErrorTips((String)dateStr));
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTFAILED);
        } else {
            settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
        }
    }

    private boolean checkIfBeforeFileStartDate(PerAttPeriodReport firstPerAttPeriodReport, Date targetUnlockEndDate, Date actualStartDate, Date fileStartDate) {
        return firstPerAttPeriodReport.getPerAttBeginDate().getTime() == fileStartDate.getTime() && actualStartDate.getTime() == fileStartDate.getTime() && targetUnlockEndDate.getTime() < fileStartDate.getTime();
    }
}

