/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.impl.AbstractSettleService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.SettleTaskDetailStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleValidateResult;

public class UnsealSettleService
extends AbstractSettleService {
    @Override
    public SettleValidateResult validate(SettleTaskDetail settleTaskDetail, SettleCheckEntity settleCheckEntity) {
        long attFileBoId = settleTaskDetail.getAttFileBoId();
        Map<Long, List<PerAttPeriodReport>> perAttPeriodMap = settleCheckEntity.getPerAttPeriodMap();
        Set<Long> hasPerFileBoId = settleCheckEntity.getHasPerFileId();
        List<PerAttPeriodReport> currentFilePeriodReportList = perAttPeriodMap.get(attFileBoId);
        SettleValidateResult settleValidateResult = new SettleValidateResult();
        String errorMsg = this.checkAttFileIsRunning(attFileBoId, settleCheckEntity.getExistsFileBoIds());
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        String errorMsgTips = this.checkAttFileIsDiscard(attFileBoId, settleCheckEntity.getDiscardFileBoId());
        if (this.checkErrorMsgIsEmpty(errorMsgTips, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        errorMsg = this.checkAttFileAndPeriodMatch(attFileBoId, perAttPeriodMap);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        HashMap periodReportObjectMap = Maps.newHashMapWithExpectedSize((int)currentFilePeriodReportList.size());
        boolean hasPartialStorage = currentFilePeriodReportList.stream().anyMatch(periodReport -> "1".equals(periodReport.getEarliestNoStoragePeriod()) && "3".equals(periodReport.getStorageStatus()));
        PerAttPeriodReport latestStoragedPeriod = settleCheckEntity.getLatestStoragedPeriodMap().get(attFileBoId);
        errorMsg = this.getAttFileIfHaslatestStoragedPeriod(latestStoragedPeriod, hasPartialStorage);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        SettleTypeEnum settleTypeEnum = settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum();
        errorMsg = this.checkAllPerAttPeriodHasBeenSettled(currentFilePeriodReportList, settleTypeEnum);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        errorMsg = this.getSelectedPeriodIsLatestStoredPeriod(currentFilePeriodReportList, latestStoragedPeriod, hasPartialStorage, settleTypeEnum);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        errorMsg = this.checkAttFileAndPeriodMatch(attFileBoId, perAttPeriodMap);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.SETTLEMENTFAILED)) {
            return settleValidateResult;
        }
        errorMsg = super.checkAffiliateAdminOrgAndPerPeriodMatch(attFileBoId, currentFilePeriodReportList, settleCheckEntity.getSettleTaskReqVo(), true);
        if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
            return settleValidateResult;
        }
        if (settleCheckEntity.getSettleTaskReqVo().isBeSettleCut()) {
            errorMsg = this.checkAttFileIfHasLatestStoragePeriodAuth(currentFilePeriodReportList, hasPerFileBoId);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            errorMsg = this.checkLatestStoragePeriodHasNotStore(currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            PerAttPeriodReport perAttPeriodReport = currentFilePeriodReportList.stream().filter(currentFilePeriodReport -> "1".equals(currentFilePeriodReport.getLastStoragePeriod()) || "3".equals(currentFilePeriodReport.getStorageStatus())).findFirst().orElse(null);
            if (perAttPeriodReport != null) {
                periodReportObjectMap.put(perAttPeriodReport.getId(), Boolean.FALSE);
                settleValidateResult.setRealStartDate(perAttPeriodReport.getPerAttBeginDate());
                settleValidateResult.setRealEndDate(perAttPeriodReport.getPerAttEndDate());
            }
        } else {
            errorMsg = this.checkIfAtLeastHasOnePeriodAuth(perAttPeriodMap.get(attFileBoId), hasPerFileBoId);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            errorMsg = this.checkAllPerPeriodHasBeenNotStorage(currentFilePeriodReportList);
            if (this.checkErrorMsgIsEmpty(errorMsg, settleValidateResult, SettleTaskDetailStatusEnum.UNEXECUTED)) {
                return settleValidateResult;
            }
            List<PerAttPeriodReport> periodReports = currentFilePeriodReportList.stream().filter(report -> "1".equals(report.getStorageStatus()) || "3".equals(report.getStorageStatus())).collect(Collectors.toList());
            for (PerAttPeriodReport periodReport2 : periodReports) {
                periodReportObjectMap.put(periodReport2.getId(), Boolean.FALSE);
            }
            this.processingResultsAfterSuccessfulCutVerification(periodReports, settleValidateResult, periodReportObjectMap, false);
        }
        settleValidateResult.setDetailStatusEnum(SettleTaskDetailStatusEnum.SETTLEMENTSUCCEEDED);
        settleValidateResult.setPeriodStatusMap((Map)periodReportObjectMap);
        return settleValidateResult;
    }

    private String checkLatestStoragePeriodHasNotStore(List<PerAttPeriodReport> currentFilePeriodReportList) {
        List frozenPeriodList = currentFilePeriodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getLastStoragePeriod())).filter(earliestNotStoragePeriod -> "2".equals(earliestNotStoragePeriod.getStorageStatus())).collect(Collectors.toList());
        return frozenPeriodList.isEmpty() ? "" : AttSettleKDString.getPeriodToBeUnsealHasBeenSealErrorTips();
    }

    private String checkAllPerPeriodHasBeenNotStorage(List<PerAttPeriodReport> currentFilePeriodReportList) {
        List storagePeriodList = currentFilePeriodReportList.stream().filter(perAttPeriodReport -> "1".equals(perAttPeriodReport.getStorageStatus())).collect(Collectors.toList());
        return !storagePeriodList.isEmpty() ? "" : AttSettleKDString.getPeriodToBeFrozenHasBeenSealedErrorTips();
    }
}

