/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.task;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.WTCTaskObjectFactory;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtte.business.settle.SettleFormService;
import kd.wtc.wtte.business.settle.task.SettleTaskHandleService;
import kd.wtc.wtte.common.vo.settle.SettleTaskReqVo;

public class SettleTaskConsumer
extends WTCShardingAbleTask {
    private static final Log LOG = WTCLogFactory.getLog(SettleTaskConsumer.class);

    protected void execute(RequestContext requestContext, WTCTaskParam taskParams) {
        LOG.info("SettleTaskConsumer execute start");
        try {
            SettleTaskHandleService.getInstance().executeSettleTask(requestContext, taskParams);
        }
        catch (Exception exception) {
            LOG.warn("SettleTaskConsumer.execute Exception", (Throwable)exception);
            this.subTaskExceptionOrTerminated(taskParams, WTCSubTaskStatus.ERROR);
            throw exception;
        }
        finally {
            List taskShardingDetails = taskParams.getTaskShardingDetails();
            List settleTaskDetails = taskShardingDetails.stream().map(SettleTaskDetail.class::cast).collect(Collectors.toList());
            Set fileBoIdSet = settleTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toSet());
            Map existsFileBoIdMap = ((SettleTaskReqVo)SerializationUtils.deSerializeFromBase64((String)String.valueOf(taskParams.getParams().get("SettleTaskReqVo")))).getExistsFileBoIds();
            List<Long> fileBoIdList = fileBoIdSet.stream().filter(fileBoId -> existsFileBoIdMap == null || !existsFileBoIdMap.containsKey(fileBoId)).collect(Collectors.toList());
            SettleFormService.getInstance().removeFileBoIdInRedis(fileBoIdList);
        }
    }

    private void subTaskExceptionOrTerminated(WTCTaskParam taskParams, WTCSubTaskStatus wtcSubTaskStatus) {
        long taskId = taskParams.getTaskId();
        WTCCalSubTaskEntity wtcCalSubTaskEntity = WTCTaskServiceHelper.loadSubTaskById((String)"wtte_settle", (long)taskId);
        wtcCalSubTaskEntity.setSubTaskStatus(wtcSubTaskStatus);
        wtcCalSubTaskEntity.setNotRunAttFile(wtcCalSubTaskEntity.getTotalAttFile());
        wtcCalSubTaskEntity.setNotRunAttPerson(wtcCalSubTaskEntity.getTotalAttPerson());
        wtcCalSubTaskEntity.setRunAttFile(0);
        wtcCalSubTaskEntity.setFailedAttFile(0);
        wtcCalSubTaskEntity.setSucceedAttFile(0);
        wtcCalSubTaskEntity.setRunAttPerson(0);
        wtcCalSubTaskEntity.setFailedAttPerson(0);
        wtcCalSubTaskEntity.setSucceedAttPerson(0);
        WTCTaskServiceHelper.updateTaskSub((String)"wtte_settle", (WTCSubTaskEntity)wtcCalSubTaskEntity);
        List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtte_settle", (long)taskParams.getMainTaskId(), (long)taskParams.getTaskId(), null);
        wtcCalTaskDetailEntities.forEach(d -> d.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT));
        WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId((List)wtcCalTaskDetailEntities, (String)"wtte_settle");
    }

    protected boolean onSubTaskTerminatedBeforeExecute(WTCTaskParam taskParam) {
        this.subTaskExceptionOrTerminated(taskParam, WTCSubTaskStatus.TERMINATED);
        return false;
    }

    protected List<Object> doGetShardingDetailList(long mainTaskId, long subTaskId, String category) {
        WTCTaskObjectFactory objectFactory = WTCTaskInstanceHelper.getObjectFactory((String)category);
        WTCCalTaskRepository repository = (WTCCalTaskRepository)objectFactory.getRepository();
        List detailList = repository.batchLoadTaskDetailByTaskIdAndSubTaskId(mainTaskId, subTaskId, null);
        return detailList.stream().filter(Objects::nonNull).map(this::genSettleTaskDetail).collect(Collectors.toList());
    }

    private SettleTaskDetail genSettleTaskDetail(WTCCalTaskDetailEntity wtcCalTaskDetailEntity) {
        return (SettleTaskDetail)JSON.parseObject((String)JSON.toJSONString((Object)wtcCalTaskDetailEntity), SettleTaskDetail.class);
    }
}

