/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.settle.SettleTaskDetail;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.helper.WTCValidatorHelper;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReportVo;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.business.attperiod.task.PerAttPeriodGenService;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.common.model.attstateinfo.FrozenBO;
import kd.wtc.wtte.business.settle.ISettleService;
import kd.wtc.wtte.business.settle.entity.AttStateInfoEntity;
import kd.wtc.wtte.business.settle.entity.SettleCheckEntity;
import kd.wtc.wtte.business.settle.entity.SettleInfoEntity;
import kd.wtc.wtte.business.settle.entity.SettleSubTaskDataEntity;
import kd.wtc.wtte.business.settle.factory.SettleFactory;
import kd.wtc.wtte.business.settle.task.SettleTaskParamService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.LockStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleTaskReqVo;

public class SettleTaskHandleService {
    private static final String FROZEN_USER_ID = "frozenuser.id";
    private static final String STORAGE_USER_ID = "storageuser.id";
    private static final String LOCK_USER_ID = "lockuser.id";
    private static final Log LOG = WTCLogFactory.getLog(SettleTaskHandleService.class);
    private static String I_ATT_TOTAL_BASE_QUERY_SERVICE = "IAttTotalBaseQueryService";
    private static String QUERY_ATT_TOTAL_BASE_BY_PER_ATT_PERIOD_REPORT = "queryAttTotalBaseByPerAttPeriodReport";
    private static final String properties = WTCStringUtils.joinStr((String[])new String[]{"boid", ",", "bsed", ",", "bsled", ",", "startdate", ",", "enddate"});

    public static SettleTaskHandleService getInstance() {
        return (SettleTaskHandleService)WTCAppContextHelper.getBean(SettleTaskHandleService.class);
    }

    public void executeSettleTask(RequestContext requestContext, WTCTaskParam taskParams) {
        StopWatch stopWatch = StopWatch.createStarted();
        SettleSubTaskDataEntity settleSubTaskDataEntity = this.initSettleSubTaskDataEntity(taskParams);
        stopWatch.stop();
        LOG.info("SettleTaskHandleService.initSettleSubTaskDataEntity consuming {}", (Object)stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        Long taskId = settleSubTaskDataEntity.getTaskId();
        this.reportSettleProgress(taskId, 10);
        this.executeShardingDetail(settleSubTaskDataEntity);
        this.checkDepEmpJob(settleSubTaskDataEntity);
        stopWatch.stop();
        LOG.info("SettleTaskHandleService.executeShardingDetail consuming {}", (Object)stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        this.reportSettleProgress(taskId, 60);
        this.sumAndGenSubTask(settleSubTaskDataEntity);
        this.reportSettleProgress(taskId, 80);
        this.saveSettleData(settleSubTaskDataEntity);
        this.synPerAttPeriodStorageSign(settleSubTaskDataEntity);
        this.reportSettleProgress(taskId, 100);
        LOG.info("SettleTaskHandleService.saveSettleData consuming {}", (Object)stopWatch.getTime());
    }

    public void synPerAttPeriodStorageSign(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        SettleCheckEntity settleCheckEntity = settleSubTaskDataEntity.getSettleCheckEntity();
        Set successFileBoId = settleSubTaskDataEntity.getSettleTaskDetails().stream().filter(d -> WTCTaskDetailStatus.SUCCESS == d.getTaskDetailState()).map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toSet());
        if ((SettleTypeEnum.STORAGE == settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum() || SettleTypeEnum.UNSTORAGE == settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum()) && WTCCollections.isNotEmpty(settleCheckEntity.getStateInfoEntityMap())) {
            List<PerAttPeriod> perPeriodEntityList = settleSubTaskDataEntity.getPerPeriodEntityList();
            HashMap attStateInfoMap = Maps.newHashMapWithExpectedSize((int)settleCheckEntity.getStateInfoEntityMap().size());
            settleCheckEntity.getStateInfoEntityMap().forEach((fileBoId, attStateInfoEntity) -> {
                if (successFileBoId.contains(fileBoId)) {
                    attStateInfoMap.put(fileBoId, attStateInfoEntity.getAttStateInfoBO());
                }
            });
            if (WTCCollections.isNotEmpty((Map)attStateInfoMap)) {
                PerAttPeriodQueryParam perAttPeriodQueryParam = new PerAttPeriodQueryParam();
                perAttPeriodQueryParam.setAttFileBoIdSet(attStateInfoMap.keySet());
                List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(perAttPeriodQueryParam);
                for (PerAttPeriod perAttPeriod : perAttPeriodList) {
                    perAttPeriod.setFirstNotStorage(false);
                    perAttPeriod.setLastStorage(false);
                }
                Map<Long, List<PerAttPeriod>> perAttPeriodFileBoMap = perAttPeriodList.stream().collect(Collectors.groupingBy(d -> d.getFileBoId()));
                attStateInfoMap.forEach((k, v) -> {
                    List perAttPeriodListFile = (List)perAttPeriodFileBoMap.get(k);
                    if (WTCCollections.isNotEmpty((Collection)perAttPeriodListFile)) {
                        PerAttPeriodGenService.getInstance().handleStorageData(perAttPeriodListFile, v);
                        perPeriodEntityList.addAll(perAttPeriodListFile);
                    }
                });
                if (WTCCollections.isNotEmpty(perPeriodEntityList)) {
                    Set pkSet = perPeriodEntityList.stream().map(PerAttPeriod::getPrimaryId).collect(Collectors.toSet());
                    PerAttPeriodQueryParam perAttPeriodQueryParamUpdate = new PerAttPeriodQueryParam();
                    perAttPeriodQueryParamUpdate.setExtendQFilter(new QFilter("id", "in", pkSet));
                    List perAttPeriodListUpdate = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(perAttPeriodQueryParamUpdate);
                    Map handleStoragePerAttPeriodMap = perPeriodEntityList.stream().collect(Collectors.toMap(PerAttPeriod::getPrimaryId, Function.identity(), (a, b) -> a));
                    for (DynamicObject perPeriodDy : perAttPeriodListUpdate) {
                        long pkId = perPeriodDy.getLong("id");
                        PerAttPeriod perAttPeriod = (PerAttPeriod)handleStoragePerAttPeriodMap.get(pkId);
                        if (perAttPeriod == null) continue;
                        perPeriodDy.set("firstnotstorage", (Object)perAttPeriod.isFirstNotStorage());
                        perPeriodDy.set("laststorage", (Object)perAttPeriod.isLastStorage());
                    }
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiod");
                    helper.update(perAttPeriodListUpdate.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    private SettleSubTaskDataEntity initSettleSubTaskDataEntity(WTCTaskParam taskParams) {
        Date subTaskStartDate = new Date();
        Map params = taskParams.getParams();
        long taskId = taskParams.getTaskId();
        SettleTaskReqVo settleTaskReqVo = SettleTaskParamService.getInstance().getSettleTaskReqVo(params);
        List taskShardingDetails = taskParams.getTaskShardingDetails();
        List<SettleTaskDetail> settleTaskDetails = taskShardingDetails.stream().map(SettleTaskDetail.class::cast).collect(Collectors.toList());
        Set<Long> fileBoId = settleTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toSet());
        SettleCheckEntity settleCheckEntity = this.genSettleDataHandleEntity(fileBoId, settleTaskReqVo);
        WTCCalSubTaskEntity wtcCalSubTaskEntity = new WTCCalSubTaskEntity();
        wtcCalSubTaskEntity.setStartDate(subTaskStartDate);
        taskParams.getParams().put("SettleTaskReqVo", SerializationUtils.serializeToBase64((Object)settleTaskReqVo));
        return new SettleSubTaskDataEntity(taskParams.getMainTaskId(), taskId, wtcCalSubTaskEntity, settleTaskDetails, settleCheckEntity);
    }

    private void checkDepEmpJob(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        List<SettleInfoEntity> settleInfoEntityList = settleSubTaskDataEntity.getSettleInfoEntityList();
        Set fVidSet = settleInfoEntityList.stream().map(SettleInfoEntity::getAttFileId).collect(Collectors.toSet());
        if (WTCCollections.isEmpty(fVidSet)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_depempjob");
        if (LOG.isInfoEnabled()) {
            LOG.info("kd.wtc.wtte.business.settle.task.SettleTaskHandleService.checkDepEmpJob vids:{}", (Object)JSON.toJSONString(fVidSet));
        }
        QFilter filter0 = new QFilter("id", "in", fVidSet);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id,empposorgrel,attperson,boid");
        attFileQueryParam.setqFilter(filter0);
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        HashMap<Long, DynamicObject[]> fvIdBoIdMap = new HashMap<Long, DynamicObject[]>(16);
        HashMap<Long, Long> empposorgrelsMaps = new HashMap<Long, Long>(16);
        for (DynamicObject attFile : attFiles) {
            Long empposorgrel = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFile, (String)"empposorgrel");
            Long fVid = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFile, (String)"id");
            empposorgrelsMaps.put(empposorgrel, fVid);
            DynamicObject[] boId = Long.valueOf(attFile.getLong("boid"));
            fvIdBoIdMap.put(fVid, boId);
        }
        QFilter filter = new QFilter("id", "in", empposorgrelsMaps.keySet());
        filter.and("datastatus", "=", (Object)"-1");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id,attperson", filters);
        HashMap<Long, Long> restMap = new HashMap<Long, Long>(16);
        for (DynamicObject dy : dys) {
            Long dempFid = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id");
            Long vid = (Long)empposorgrelsMaps.get(dempFid);
            restMap.put(vid, dempFid);
        }
        List<SettleTaskDetail> settleTaskDetails = settleSubTaskDataEntity.getSettleTaskDetails();
        for (Map.Entry entry : restMap.entrySet()) {
            Long vid = (Long)entry.getKey();
            Long dempId = (Long)entry.getValue();
            if (!WTCCollections.isNotEmpty(fvIdBoIdMap)) continue;
            Long boId = (Long)fvIdBoIdMap.get(vid);
            for (SettleTaskDetail settleTaskDetail : settleTaskDetails) {
                Long attFileBoId = settleTaskDetail.getAttFileBoId();
                if (!attFileBoId.equals(boId) || null == dempId || 0L == dempId || !WTCTaskDetailStatus.SUCCESS.equals((Object)settleTaskDetail.getTaskDetailState())) continue;
                settleTaskDetail.setExInfo(AttSettleKDString.empDeletedTips());
                LOG.info("sync SettleTaskDetail wtpDepEmpJob tips");
            }
        }
    }

    private SettleCheckEntity genSettleDataHandleEntity(Set<Long> fileBoIdSet, SettleTaskReqVo settleTaskReqVo) {
        Set<Long> hasPerFileId = this.getHasPerFileId(fileBoIdSet);
        AttStateInfoService attStateInfoService = (AttStateInfoService)WTCAppContextHelper.getBean(AttStateInfoService.class);
        List attStateInfoBOS = attStateInfoService.queryAttStateInfoByBoid(new ArrayList<Long>(fileBoIdSet));
        if (CollectionUtils.isEmpty((Collection)attStateInfoBOS)) {
            attStateInfoBOS = Lists.newArrayListWithExpectedSize((int)16);
        }
        Map<Long, AttStateInfoEntity> stateInfoEntityMap = attStateInfoBOS.stream().collect(Collectors.toMap(AttStateInfoBO::getFileBoid, AttStateInfoEntity::new));
        List<PerAttPeriodReport> perAttPeriodReport = this.getPerAttPeriodReports(fileBoIdSet);
        Map<Long, PerAttPeriodReport> earliestNoStoragePeriodMap = perAttPeriodReport.stream().filter(periodReport -> "1".equals(periodReport.getEarliestNoStoragePeriod())).collect(Collectors.toMap(PerAttPeriod::getFileBoId, periodReport -> periodReport, (a, b) -> a));
        Map<Long, PerAttPeriodReport> latestStoragedPeriodMap = perAttPeriodReport.stream().filter(periodReport -> "1".equals(periodReport.getLastStoragePeriod())).collect(Collectors.toMap(PerAttPeriod::getFileBoId, periodReport -> periodReport, (a, b) -> a));
        Map<Long, PerAttPeriodReport> latestLockedPeriodMap = perAttPeriodReport.stream().filter(periodReport -> {
            AttStateInfoEntity attStateInfoEntity = (AttStateInfoEntity)stateInfoEntityMap.get(periodReport.getFileBoId());
            return attStateInfoEntity != null && attStateInfoEntity.getAttStateInfoBO() != null && attStateInfoEntity.getAttStateInfoBO().getLockTo() != null && WTCDateUtils.betweenDay((Date)attStateInfoEntity.getAttStateInfoBO().getLockTo(), (Date)periodReport.getPerAttBeginDate(), (Date)periodReport.getPerAttEndDate());
        }).collect(Collectors.toMap(PerAttPeriod::getFileBoId, periodReport -> periodReport, (a, b) -> a));
        List<PerAttPeriodReport> checkPerAttPeriodReport = this.filterPerAttPeriodReport(settleTaskReqVo, perAttPeriodReport, stateInfoEntityMap, earliestNoStoragePeriodMap);
        Map<Long, List<PerAttPeriodReport>> perAttPeriodMap = checkPerAttPeriodReport.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
        Map<String, Boolean> totalBaseBooleanMap = this.queryAttTotalBaseByPerAttPeriodReport(checkPerAttPeriodReport);
        Date lockEndDate = settleTaskReqVo.getLockEndDate();
        Map<Long, List<Tuple<Date, Date>>> hasPerFileDateDataMap = null;
        if (lockEndDate != null) {
            hasPerFileDateDataMap = this.getHasPerFileDateData(fileBoIdSet);
        }
        Set<Long> discardFileBoId = this.getDiscardFileBoId(fileBoIdSet);
        Map existsFileMap = AttFileSyncService.getInstance().lockFileBoIds(fileBoIdSet, AttFileTaskCacheInfoEnum.ATT_FILE_SETTLE);
        PeriodSyncFormService.getInstance().saveUnDoExistsFileVid(existsFileMap.keySet());
        settleTaskReqVo.setExistsFileBoIds(existsFileMap);
        return SettleCheckEntity.with().perAttPeriodMap(perAttPeriodMap).hasPerFileId(hasPerFileId).settleTaskReqVo(settleTaskReqVo).stateInfoEntityMap(stateInfoEntityMap).hasPerFileDateData(hasPerFileDateDataMap).earliestNoStoragePeriodMap(earliestNoStoragePeriodMap).latestStoragedPeriodMap(latestStoragedPeriodMap).latestLockedPeriodMap(latestLockedPeriodMap).totalBaseBooleanMap(totalBaseBooleanMap).discardFileBoId(discardFileBoId).existsFileBoIds(existsFileMap).build();
    }

    private Set<Long> getDiscardFileBoId(Set<Long> fileBoIdSet) {
        HashSet usableStatusSet = Sets.newHashSet((Object[])new String[]{"-1"});
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setUsableStatus((Set)usableStatusSet);
        queryParam.setSetBoIds(fileBoIdSet);
        queryParam.setBeCurrent(Boolean.valueOf(true));
        queryParam.setProperties("boid");
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam).stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
    }

    private Map<String, Boolean> queryAttTotalBaseByPerAttPeriodReport(List<PerAttPeriodReport> perAttPeriodReportList) {
        if (WTCCollections.isNotEmpty(perAttPeriodReportList)) {
            ArrayList perAttPeriodReportVoList = Lists.newArrayListWithExpectedSize((int)perAttPeriodReportList.size());
            perAttPeriodReportList.forEach(perAttPeriodReport -> {
                PerAttPeriodReportVo perAttPeriodReportVo = new PerAttPeriodReportVo();
                perAttPeriodReportVo.setPerAttPeriodId(perAttPeriodReport.getId());
                perAttPeriodReportVo.setPeriodId(perAttPeriodReport.getAttPeriodId());
                perAttPeriodReportVo.setFileVersionId(perAttPeriodReport.getFileId());
                perAttPeriodReportVoList.add(perAttPeriodReportVo);
            });
            Map map = (Map)WTCServiceHelper.invokeWtcWtctdBizService((String)I_ATT_TOTAL_BASE_QUERY_SERVICE, (String)QUERY_ATT_TOTAL_BASE_BY_PER_ATT_PERIOD_REPORT, (Object[])new Object[]{perAttPeriodReportVoList});
            if (map == null) {
                return Collections.emptyMap();
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private Set<Long> getHasPerFileId(Set<Long> fileBoId) {
        HashSet usableStatusSet = Sets.newHashSet((Object[])new String[]{"0", "-1"});
        AttFileF7QueryParam queryParam = this.getAttFileQueryParam(fileBoId, "id", usableStatusSet);
        return AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(queryParam).stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
    }

    private AttFileF7QueryParam getAttFileQueryParam(Set<Long> fileBoId, String properties, Set<String> usableStatusSet) {
        AttFileF7QueryParam queryParam = new AttFileF7QueryParam(false);
        queryParam.setSetBoIds(fileBoId);
        queryParam.setProperties(properties);
        queryParam.setBeCurrent(Boolean.FALSE);
        queryParam.setAppId("wtte");
        queryParam.setFormId("wtte_settletaskdetail");
        queryParam.setPermField("attfile");
        queryParam.setUsableStatus(usableStatusSet);
        return queryParam;
    }

    private Map<Long, List<Tuple<Date, Date>>> getHasPerFileDateData(Set<Long> fileBoId) {
        HashSet usableStatusSet = Sets.newHashSet((Object[])new String[]{"0", "-1"});
        AttFileF7QueryParam queryParam = this.getAttFileQueryParam(fileBoId, properties, usableStatusSet);
        Map<Long, List<DynamicObject>> collect = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(queryParam).stream().collect(Collectors.groupingBy(d -> d.getLong("boid")));
        HashMap hasPerFileDateData = Maps.newHashMapWithExpectedSize((int)collect.size());
        for (Map.Entry<Long, List<DynamicObject>> entries : collect.entrySet()) {
            hasPerFileDateData.put(entries.getKey(), entries.getValue().stream().map(file -> {
                Date fileBseDate = file.getDate("bsed");
                Date fileBlsDate = file.getDate("bsled");
                Date fileEndDate = file.getDate("enddate");
                if (fileEndDate.before(fileBlsDate)) {
                    return new Tuple((Object)fileBseDate, (Object)fileEndDate);
                }
                return new Tuple((Object)fileBseDate, (Object)fileBlsDate);
            }).collect(Collectors.toList()));
        }
        return hasPerFileDateData;
    }

    private List<PerAttPeriodReport> filterPerAttPeriodReport(SettleTaskReqVo settleTaskReqVo, List<PerAttPeriodReport> perAttPeriodReport, Map<Long, AttStateInfoEntity> stateInfoEntityMap, Map<Long, PerAttPeriodReport> earliestNoStoragePeriodMap) {
        ArrayList checkPerAttPeriodReport = Lists.newArrayListWithExpectedSize((int)perAttPeriodReport.size());
        Date lockEndDate = settleTaskReqVo.getLockEndDate();
        if (lockEndDate == null) {
            checkPerAttPeriodReport.addAll(perAttPeriodReport.stream().filter(periodReport -> settleTaskReqVo.getPeriod() != null && settleTaskReqVo.getPeriod().equals(periodReport.getAttPeriodId())).collect(Collectors.toList()));
        } else {
            SettleTypeEnum settleTypeEnum = settleTaskReqVo.getSettleTypeEnum();
            for (List<PerAttPeriodReport> value : perAttPeriodReport.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId)).values()) {
                this.addPerAttPeriodData(checkPerAttPeriodReport, value, stateInfoEntityMap, settleTypeEnum);
            }
        }
        return checkPerAttPeriodReport;
    }

    private List<PerAttPeriodReport> getPerAttPeriodReports(Set<Long> fileBoId) {
        AttFileQueryServiceImpl attFileQueryService = AttFileQueryServiceImpl.getInstance();
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setSetBoIds(fileBoId);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        PerAttPeriodQueryServiceImpl attPeriodQueryService = PerAttPeriodQueryServiceImpl.getInstance();
        return attPeriodQueryService.getPerAttPeriodReport(arg_0 -> ((AttFileQueryServiceImpl)attFileQueryService).queryAttFiles(arg_0), attFileQueryParam, null, null, null);
    }

    private void addPerAttPeriodData(List<PerAttPeriodReport> checkPerAttPeriodReport, List<PerAttPeriodReport> value, Map<Long, AttStateInfoEntity> stateInfoEntityMap, SettleTypeEnum settleTypeEnum) {
        Date perAttEndDate;
        Date perAttBeginDate;
        Date checkAttPeriodStartDate = null;
        Date checkAttPeriodEndDate = null;
        if (SettleTypeEnum.LOCK == settleTypeEnum) {
            for (PerAttPeriodReport report : value) {
                if (!"1".equals(report.getEarliestNoStoragePeriod())) continue;
                checkAttPeriodStartDate = report.getAttPeriodStartDate();
                checkAttPeriodEndDate = report.getAttPeriodEndDate();
            }
        } else if (SettleTypeEnum.UNLOCK == settleTypeEnum) {
            for (PerAttPeriodReport report : value) {
                perAttBeginDate = report.getPerAttBeginDate();
                perAttEndDate = report.getPerAttEndDate();
                AttStateInfoEntity attStateInfoEntity = stateInfoEntityMap.get(report.getFileBoId());
                if (attStateInfoEntity == null || attStateInfoEntity.getAttStateInfoBO() == null || attStateInfoEntity.getAttStateInfoBO().getLockTo() == null) {
                    return;
                }
                Date lockTo = attStateInfoEntity.getAttStateInfoBO().getLockTo();
                if (perAttBeginDate == null || perAttEndDate == null || perAttBeginDate.compareTo(lockTo) > 0 || perAttEndDate.compareTo(lockTo) < 0) continue;
                checkAttPeriodStartDate = report.getAttPeriodStartDate();
                checkAttPeriodEndDate = report.getAttPeriodEndDate();
            }
        }
        if (checkAttPeriodStartDate != null && checkAttPeriodEndDate != null) {
            for (PerAttPeriodReport report : value) {
                perAttBeginDate = report.getPerAttBeginDate();
                perAttEndDate = report.getPerAttEndDate();
                if (perAttBeginDate.compareTo(checkAttPeriodEndDate) > 0 || perAttEndDate.compareTo(checkAttPeriodStartDate) < 0) continue;
                checkPerAttPeriodReport.add(report);
            }
        }
    }

    private void executeShardingDetail(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        ISettleService settleService = ((SettleFactory)WTCAppContextHelper.getBean(SettleFactory.class)).getSettleServiceByType(settleSubTaskDataEntity.getSettleCheckEntity().getSettleTaskReqVo().getSettleTypeEnum());
        settleService.executeSettle(settleSubTaskDataEntity);
    }

    private void sumAndGenSubTask(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        WTCValidatorHelper.verify((Object)settleSubTaskDataEntity);
        List<SettleTaskDetail> settleTaskDetails = settleSubTaskDataEntity.getSettleTaskDetails();
        WTCCalSubTaskEntity wtcCalSubTaskEntity = settleSubTaskDataEntity.getWtcCalSubTaskEntity();
        WTCTaskServiceHelper.sumAttPersonCalSubTask(settleTaskDetails, (WTCCalSubTaskEntity)wtcCalSubTaskEntity);
        wtcCalSubTaskEntity.setSubTaskStatus(WTCSubTaskStatus.FINISHED);
    }

    private void saveSettleData(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        List<SettleTaskDetail> settleTaskDetails = settleSubTaskDataEntity.getSettleTaskDetails();
        if (CollectionUtils.isEmpty(settleTaskDetails)) {
            return;
        }
        boolean stop = WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)settleSubTaskDataEntity.getSubTaskId());
        if (stop) {
            this.settleSubTaskStop(settleSubTaskDataEntity);
            return;
        }
        Date currentDate = new Date();
        WTCCalSubTaskEntity wtcCalSubTaskEntity = settleSubTaskDataEntity.getWtcCalSubTaskEntity();
        List<SettleInfoEntity> settleInfoEntityList = settleSubTaskDataEntity.getSettleInfoEntityList();
        List wtcCalTaskDetailEntityList = settleTaskDetails.stream().map(SettleTaskDetail::getWTCCalTaskDetailEntity).collect(Collectors.toList());
        this.setSubTaskDate(wtcCalSubTaskEntity, currentDate);
        SettleCheckEntity settleCheckEntity = settleSubTaskDataEntity.getSettleCheckEntity();
        List<AttStateInfoEntity> attStateInfoEntityList = settleCheckEntity.getStateInfoEntityMap().values().stream().filter(AttStateInfoEntity::isUpdate).collect(Collectors.toList());
        SettleTypeEnum settleTypeEnum = settleCheckEntity.getSettleTaskReqVo().getSettleTypeEnum();
        HRBaseServiceHelper attStateRecordServiceHelper = new HRBaseServiceHelper("wtte_attstaterecord");
        DynamicObjectCollection saveAttStateRecord = this.getSaveAttStateRecord(currentDate, attStateInfoEntityList, attStateRecordServiceHelper);
        this.updateAttStateInfo(attStateInfoEntityList, settleTypeEnum);
        try (TXHandle tx = TX.required();){
            try {
                WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(wtcCalTaskDetailEntityList, (String)"wtte_settle");
                WTCTaskServiceHelper.updateTaskSub((String)"wtte_settle", (WTCSubTaskEntity)wtcCalSubTaskEntity);
                this.updateSettleData(settleInfoEntityList, currentDate);
                attStateRecordServiceHelper.save(saveAttStateRecord);
                this.clearFrozenStatus(settleSubTaskDataEntity);
            }
            catch (Exception exception) {
                tx.markRollback();
                LOG.warn("saveSettleData error", (Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private void clearFrozenStatus(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        SettleTaskReqVo settleTaskReqVo = settleSubTaskDataEntity.getSettleCheckEntity().getSettleTaskReqVo();
        if (settleTaskReqVo == null) {
            return;
        }
        if (SettleTypeEnum.UNSTORAGE == settleTaskReqVo.getSettleTypeEnum()) {
            SettleCheckEntity settleCheckEntity = settleSubTaskDataEntity.getSettleCheckEntity();
            if (settleCheckEntity == null) {
                return;
            }
            Map<Long, PerAttPeriodReport> earliestNoStoragePeriodMap = settleCheckEntity.getEarliestNoStoragePeriodMap();
            if (WTCCollections.isEmpty(earliestNoStoragePeriodMap)) {
                return;
            }
            List<SettleTaskDetail> settleTaskDetails = settleSubTaskDataEntity.getSettleTaskDetails();
            if (WTCCollections.isEmpty(settleTaskDetails)) {
                // empty if block
            }
            List attFileBoIds = settleSubTaskDataEntity.getSettleTaskDetails().stream().filter(entity -> WTCTaskDetailStatus.SUCCESS == entity.getTaskDetailState()).map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toList());
            Set perAttPeriodIds = earliestNoStoragePeriodMap.entrySet().stream().filter(map -> attFileBoIds.contains(map.getKey())).map(map -> ((PerAttPeriodReport)map.getValue()).getId()).collect(Collectors.toSet());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_settleinfo");
            DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("perattperiod", "in", perAttPeriodIds).and(new QFilter("frozenstatus", "=", (Object)"1"))});
            Arrays.stream(dynamicObjects).forEach(dy -> dy.set("frozenstatus", null));
            serviceHelper.update(dynamicObjects);
        }
    }

    private DynamicObjectCollection getSaveAttStateRecord(Date currentDate, List<AttStateInfoEntity> attStateInfoEntityList, HRBaseServiceHelper attStateRecordServiceHelper) {
        DynamicObjectCollection attStateRecordDyArr = new DynamicObjectCollection();
        long currUserId = RequestContext.get().getCurrUserId();
        for (AttStateInfoEntity attStateInfoEntity : attStateInfoEntityList) {
            DynamicObject emptyDynamicObject = attStateRecordServiceHelper.generateEmptyDynamicObject();
            AttStateInfoBO attStateInfoBO = attStateInfoEntity.getAttStateInfoBO();
            if (attStateInfoBO == null) continue;
            emptyDynamicObject.set("accountto", (Object)attStateInfoBO.getAccountTo());
            emptyDynamicObject.set("lockto", (Object)attStateInfoBO.getLockTo());
            emptyDynamicObject.set("storageto", (Object)attStateInfoBO.getStorageTo());
            emptyDynamicObject.set("frozenstartdate", (Object)attStateInfoBO.getFrozenStartDate());
            emptyDynamicObject.set("frozenenddate", (Object)attStateInfoBO.getFronzenEnDate());
            emptyDynamicObject.set("taskdetail", (Object)attStateInfoEntity.getSettleDetailTaskId());
            emptyDynamicObject.set("creator", (Object)currUserId);
            emptyDynamicObject.set("createtime", (Object)currentDate);
            attStateRecordDyArr.add((Object)emptyDynamicObject);
        }
        return attStateRecordDyArr;
    }

    private void updateAttStateInfo(List<AttStateInfoEntity> attStateInfoEntityList, SettleTypeEnum settleTypeEnum) {
        AttStateInfoService attStateInfoService = (AttStateInfoService)WTCAppContextHelper.getBean(AttStateInfoService.class);
        switch (settleTypeEnum) {
            case LOCK: {
                Map lockMapParam = attStateInfoEntityList.stream().collect(HashMap::new, (map, item) -> map.put(item.getAttStateInfoBO().getFileBoid(), item.getAttStateInfoBO().getLockTo()), HashMap::putAll);
                attStateInfoService.lockTo(lockMapParam);
                break;
            }
            case FROZEN: {
                List frozenBOList = attStateInfoEntityList.stream().map(d -> new FrozenBO(d.getAttStateInfoBO().getFileBoid(), d.getAttStateInfoBO().getFrozenStartDate(), d.getAttStateInfoBO().getFronzenEnDate())).collect(Collectors.toList());
                attStateInfoService.frozen(frozenBOList);
                break;
            }
            case STORAGE: {
                Map storageMapParam = attStateInfoEntityList.stream().collect(HashMap::new, (map, item) -> map.put(item.getAttStateInfoBO().getFileBoid(), item.getAttStateInfoBO().getStorageTo()), HashMap::putAll);
                attStateInfoService.storageTo(storageMapParam);
                Map lockMapParam1 = attStateInfoEntityList.stream().collect(HashMap::new, (map, item) -> map.put(item.getAttStateInfoBO().getFileBoid(), item.getAttStateInfoBO().getLockTo()), HashMap::putAll);
                attStateInfoService.lockTo(lockMapParam1);
                List unFrozenBOList1 = attStateInfoEntityList.stream().map(d -> new FrozenBO(d.getAttStateInfoBO().getFileBoid(), d.getAttStateInfoBO().getFrozenStartDate(), d.getAttStateInfoBO().getFronzenEnDate())).collect(Collectors.toList());
                attStateInfoService.unfrozen(unFrozenBOList1);
                break;
            }
            case UNLOCK: {
                Map unLockMapParam = attStateInfoEntityList.stream().collect(HashMap::new, (map, item) -> map.put(item.getAttStateInfoBO().getFileBoid(), item.getAttStateInfoBO().getLockTo()), HashMap::putAll);
                attStateInfoService.unlockTo(unLockMapParam);
                break;
            }
            case UNFROZEN: {
                List unFrozenBOList = attStateInfoEntityList.stream().map(d -> new FrozenBO(d.getAttStateInfoBO().getFileBoid(), d.getAttStateInfoBO().getFrozenStartDate(), d.getAttStateInfoBO().getFronzenEnDate())).collect(Collectors.toList());
                attStateInfoService.unfrozen(unFrozenBOList);
                break;
            }
            case UNSTORAGE: {
                Map unStorageMapParam = attStateInfoEntityList.stream().collect(HashMap::new, (map, item) -> map.put(item.getAttStateInfoBO().getFileBoid(), item.getAttStateInfoBO().getStorageTo()), HashMap::putAll);
                attStateInfoService.unstorageTo(unStorageMapParam);
                List unFrozenBOList2 = attStateInfoEntityList.stream().map(d -> new FrozenBO(d.getAttStateInfoBO().getFileBoid(), d.getAttStateInfoBO().getFrozenStartDate(), d.getAttStateInfoBO().getFronzenEnDate())).collect(Collectors.toList());
                attStateInfoService.unfrozen(unFrozenBOList2);
                break;
            }
        }
    }

    private void settleSubTaskStop(SettleSubTaskDataEntity settleSubTaskDataEntity) {
        Date currentDate = new Date();
        List<SettleTaskDetail> settleTaskDetails = settleSubTaskDataEntity.getSettleTaskDetails();
        WTCCalSubTaskEntity wtcCalSubTaskEntity = settleSubTaskDataEntity.getWtcCalSubTaskEntity();
        Set personCollect = settleTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttPersonId).collect(Collectors.toSet());
        int attPersonSize = personCollect.size();
        Set fileCollect = settleTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttFileId).collect(Collectors.toSet());
        int attFileSize = fileCollect.size();
        wtcCalSubTaskEntity.setTotalAttPerson(attPersonSize);
        wtcCalSubTaskEntity.setNotRunAttPerson(attPersonSize);
        wtcCalSubTaskEntity.setTotalAttFile(attFileSize);
        wtcCalSubTaskEntity.setNotRunAttFile(attFileSize);
        wtcCalSubTaskEntity.setRunAttFile(0);
        wtcCalSubTaskEntity.setFailedAttFile(0);
        wtcCalSubTaskEntity.setSucceedAttFile(0);
        wtcCalSubTaskEntity.setRunAttPerson(0);
        wtcCalSubTaskEntity.setFailedAttPerson(0);
        wtcCalSubTaskEntity.setSucceedAttPerson(0);
        wtcCalSubTaskEntity.setSubTaskStatus(WTCSubTaskStatus.TERMINATED);
        this.setSubTaskDate(wtcCalSubTaskEntity, currentDate);
        for (SettleTaskDetail settleTaskDetail : settleTaskDetails) {
            if (settleTaskDetail.getRealCalStartDate() == null) {
                settleTaskDetail.setRealCalStartDate(currentDate);
            }
            settleTaskDetail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT);
            settleTaskDetail.setRealCalEndDate(currentDate);
        }
        List wtcCalTaskDetailEntityList = settleTaskDetails.stream().map(SettleTaskDetail::getWTCCalTaskDetailEntity).collect(Collectors.toList());
        try (TXHandle tx = TX.required();){
            try {
                WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(wtcCalTaskDetailEntityList, (String)"wtte_settle");
                WTCTaskServiceHelper.updateTaskSub((String)"wtte_settle", (WTCSubTaskEntity)wtcCalSubTaskEntity);
            }
            catch (Exception exception) {
                tx.markRollback();
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private void updateSettleData(List<SettleInfoEntity> settleInfoEntityList, Date currentDate) {
        if (CollectionUtils.isEmpty(settleInfoEntityList)) {
            return;
        }
        HRBaseServiceHelper settleInfoHisHRBaseServiceHelper = new HRBaseServiceHelper("wtte_settleinfohis");
        HRBaseServiceHelper settleInfoHRBaseServiceHelper = new HRBaseServiceHelper("wtte_settleinfo");
        ArrayList settleInfoHisList = Lists.newArrayListWithExpectedSize((int)settleInfoEntityList.size());
        ArrayList settleInfoCurrentList = Lists.newArrayListWithExpectedSize((int)settleInfoEntityList.size());
        Set stringSet = settleInfoEntityList.stream().map(SettleInfoEntity::getPerAttPeriod).collect(Collectors.toSet());
        DynamicObject[] dynamicObjects = settleInfoHRBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("perattperiod", "in", stringSet)});
        Map existSettleInfoMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(d -> d.getString("perattperiod"), Function.identity(), (a, b) -> a));
        for (SettleInfoEntity settleInfoEntity : settleInfoEntityList) {
            DynamicObject settleInfoHisDy = settleInfoHisHRBaseServiceHelper.generateEmptyDynamicObject();
            String perAttPeriodIdStr = settleInfoEntity.getPerAttPeriod();
            long attFileId = settleInfoEntity.getAttFileId();
            if (existSettleInfoMap.get(perAttPeriodIdStr) != null) {
                DynamicObject existSettleInfo = (DynamicObject)existSettleInfoMap.get(perAttPeriodIdStr);
                this.copySettleCorePro(settleInfoHisDy, existSettleInfo);
                this.setSettleInfo(settleInfoEntity, settleInfoHisDy, perAttPeriodIdStr, attFileId, currentDate);
                this.setModifyMsg(existSettleInfo, currentDate);
                this.reSetSettleResInfoCorePro(settleInfoEntity, existSettleInfo);
                existSettleInfo.set("attfile", (Object)settleInfoEntity.getAttFileId());
                settleInfoCurrentList.add(existSettleInfo);
            } else {
                DynamicObject addSettleInfoDy = settleInfoHRBaseServiceHelper.generateEmptyDynamicObject();
                this.setSettleInfo(settleInfoEntity, addSettleInfoDy, perAttPeriodIdStr, attFileId, currentDate);
                this.setSettleInfo(settleInfoEntity, settleInfoHisDy, perAttPeriodIdStr, attFileId, currentDate);
                settleInfoCurrentList.add(addSettleInfoDy);
            }
            settleInfoHisList.add(settleInfoHisDy);
        }
        if (!CollectionUtils.isEmpty((Collection)settleInfoHisList)) {
            settleInfoHisHRBaseServiceHelper.save(settleInfoHisList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)settleInfoCurrentList)) {
            settleInfoHRBaseServiceHelper.save(settleInfoCurrentList.toArray(new DynamicObject[0]));
        }
    }

    private void copySettleCorePro(DynamicObject settleInfoHisDy, DynamicObject existSettleInfo) {
        settleInfoHisDy.set("frozenstatus", existSettleInfo.get("frozenstatus"));
        settleInfoHisDy.set("frozendate", existSettleInfo.get("frozendate"));
        settleInfoHisDy.set("frozenuser", (Object)existSettleInfo.getLong(FROZEN_USER_ID));
        settleInfoHisDy.set("lockstatus", existSettleInfo.get("lockstatus"));
        settleInfoHisDy.set("lockdate", existSettleInfo.get("lockdate"));
        settleInfoHisDy.set("lockuser", (Object)existSettleInfo.getLong(LOCK_USER_ID));
        settleInfoHisDy.set("storagestatus", existSettleInfo.get("storagestatus"));
        settleInfoHisDy.set("storagedate", existSettleInfo.get("storagedate"));
        settleInfoHisDy.set("storageuser", (Object)existSettleInfo.getLong(STORAGE_USER_ID));
    }

    private void setSettleInfo(SettleInfoEntity settleInfoEntity, DynamicObject settleInfoDy, String perAttPeriodIdStr, long attFileId, Date currentDate) {
        this.reSetSettleResInfoCorePro(settleInfoEntity, settleInfoDy);
        this.setSettleBusPro(settleInfoEntity, settleInfoDy, perAttPeriodIdStr, attFileId);
        this.setCreateMsg(settleInfoDy, currentDate);
        this.setModifyMsg(settleInfoDy, currentDate);
    }

    private void setSettleBusPro(SettleInfoEntity settleInfoEntity, DynamicObject settleInfoDy, String perAttPeriodIdStr, long attFileId) {
        settleInfoDy.set("attperattperiodpk", (Object)settleInfoEntity.getAttperattperiodpk());
        settleInfoDy.set("taskdetail", (Object)settleInfoEntity.getTaskDetailId());
        settleInfoDy.set("org", (Object)settleInfoEntity.getOrgId());
        settleInfoDy.set("perattperiod", (Object)perAttPeriodIdStr);
        settleInfoDy.set("attfile", (Object)attFileId);
        settleInfoDy.set("attperson", (Object)settleInfoEntity.getAttPersonId());
        settleInfoDy.set("attperiod", (Object)settleInfoEntity.getAttPeriod());
        settleInfoDy.set("startdate", (Object)settleInfoEntity.getStartDate());
        settleInfoDy.set("enddate", (Object)settleInfoEntity.getEndDate());
        settleInfoDy.set("busstatus", (Object)"1");
    }

    private void setCreateMsg(DynamicObject dynamicObject, Date date) {
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)date);
    }

    private void setModifyMsg(DynamicObject dynamicObject, Date date) {
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)date);
    }

    private void reSetSettleResInfoCorePro(SettleInfoEntity settleInfoEntity, DynamicObject addSettleInfoDy) {
        addSettleInfoDy.set("attperattperiodpk", (Object)settleInfoEntity.getAttperattperiodpk());
        if (settleInfoEntity.getFrozenStatus() != null) {
            addSettleInfoDy.set("frozenstatus", (Object)(Boolean.TRUE.equals(settleInfoEntity.getFrozenStatus()) ? "1" : "0"));
        } else if (addSettleInfoDy.get("frozenstatus") == null) {
            addSettleInfoDy.set("frozenstatus", (Object)"0");
        }
        if (settleInfoEntity.getFrozenDate() != null) {
            addSettleInfoDy.set("frozendate", (Object)settleInfoEntity.getFrozenDate());
        }
        if (settleInfoEntity.getFrozenUser() != null) {
            addSettleInfoDy.set("frozenuser", (Object)RequestContext.get().getCurrUserId());
        }
        if (settleInfoEntity.getLockStatus() != null) {
            addSettleInfoDy.set("lockstatus", (Object)settleInfoEntity.getLockStatus().getLockStatusCode());
        } else if (addSettleInfoDy.get("lockstatus") == null) {
            addSettleInfoDy.set("lockstatus", (Object)LockStatusEnum.UNLOCK.getLockStatusCode());
        }
        if (settleInfoEntity.getLockDate() != null) {
            addSettleInfoDy.set("lockdate", (Object)settleInfoEntity.getLockDate());
        }
        if (settleInfoEntity.getLockUser() != null) {
            addSettleInfoDy.set("lockuser", (Object)settleInfoEntity.getLockUser());
        }
        if (settleInfoEntity.getStorageStatus() != null) {
            addSettleInfoDy.set("storagestatus", (Object)(Boolean.TRUE.equals(settleInfoEntity.getStorageStatus()) ? "1" : "0"));
        } else if (addSettleInfoDy.get("storagestatus") == null) {
            addSettleInfoDy.set("storagestatus", (Object)"0");
        }
        if (settleInfoEntity.getStorageDate() != null) {
            addSettleInfoDy.set("storagedate", (Object)settleInfoEntity.getStorageDate());
        }
        if (settleInfoEntity.getStorageUser() != null) {
            addSettleInfoDy.set("storageuser", (Object)settleInfoEntity.getStorageUser());
        }
    }

    private Set<String> getIgnoreProperties() {
        HashSet ignoreProperties = Sets.newHashSetWithExpectedSize((int)16);
        ignoreProperties.add("id");
        ignoreProperties.add("creator");
        ignoreProperties.add("createtime");
        ignoreProperties.add("modifier");
        ignoreProperties.add("modifytime");
        return ignoreProperties;
    }

    private void setSubTaskDate(WTCCalSubTaskEntity wtcCalSubTaskEntity, Date currentDate) {
        wtcCalSubTaskEntity.setRefreshTime(currentDate);
        wtcCalSubTaskEntity.setEndDate(currentDate);
    }

    private void reportSettleProgress(long subTaskId, int process) {
        try {
            WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)subTaskId, (int)process);
        }
        catch (Exception exception) {
            LOG.error("SettleTaskHandleService.reportProgress error");
        }
    }

    public void terminateSettleTask(long taskId) {
        WTCDistributeTaskHelper.terminateTask((long)taskId, (String)"wtte_settle");
    }

    public void updateSettleStatus(String category, Long bizTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_settle");
        DynamicObject settleDy = serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("task.id", "=", (Object)bizTaskId)});
        if (settleDy != null) {
            WTCTaskBusinessStatusEnum wtcTaskBusinessStatusEnum = WTCTaskServiceHelper.getWTCTaskBusinessStatusEnumByTaskId((String)category, (long)bizTaskId);
            SettleStatusEnum inSettlement = SettleStatusEnum.getBySign((String)wtcTaskBusinessStatusEnum.getSign());
            settleDy.set("settlestatus", (Object)inSettlement.getSettleStatus());
            serviceHelper.updateOne(settleDy);
        } else {
            LOG.info("SettleTaskHandleService.updateSettleStatus err, settleDy not exist");
        }
    }
}

