/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.settle.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.helper.WTCValidatorHelper;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtte.common.vo.settle.SettleTaskReqVo;

public class SettleTaskParamService {
    private static final Log LOG = WTCLogFactory.getLog(SettleTaskParamService.class);
    private static final int BATCH_SIZE = 5000;

    public static SettleTaskParamService getInstance() {
        return (SettleTaskParamService)WTCAppContextHelper.getBean(SettleTaskParamService.class);
    }

    public WTCTaskRequestStd genSettleTaskRequest(SettleTaskReqVo settleTaskReqVo) {
        WTCValidatorHelper.verify((Object)settleTaskReqVo);
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setTaskId(settleTaskReqVo.getTaskId().longValue());
        request.setVersion(settleTaskReqVo.getVersion());
        request.setCategory("wtte_settle");
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setSource(WTCSource.MANUAL.code);
        request.setTrial(false);
        request.setStartDate(settleTaskReqVo.getStartDate());
        request.setEndDate(settleTaskReqVo.getEndDate());
        request.setAppId("wtte");
        request.setParams(Collections.emptyMap());
        List<Map<String, Object>> authFieldByAttFileDynBatch = this.batchQuerySettleFile(settleTaskReqVo);
        request.setDetail(authFieldByAttFileDynBatch);
        request.setDesc(settleTaskReqVo.getDescription());
        return request;
    }

    private List<Map<String, Object>> batchQuerySettleFile(SettleTaskReqVo settleTaskReqVo) {
        StopWatch stopWatch = StopWatch.createStarted();
        ArrayList fileVersionIds = new ArrayList(settleTaskReqVo.getAttFileVersionIds());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        attFileQueryParam.setProperties(String.join((CharSequence)",", "id", "boid", "attperson.id", "atttag.id", "empposorgrel.id", "org.id"));
        ArrayList authFieldByAttFileDynBatch = Lists.newArrayListWithExpectedSize((int)16);
        WTCBatchHandleUtils.batchHandleCollection((Collection)authFieldByAttFileDynBatch, fileVersionIds, (int)5000, (Object)attFileQueryParam, this::querySettleAttFiles);
        stopWatch.stop();
        LOG.info("batchQuerySettleFile consuming {}", (Object)stopWatch.getTime());
        return authFieldByAttFileDynBatch;
    }

    private List<Map<String, Object>> querySettleAttFiles(List<Long> fileVersionIds, AttFileQueryParam attFileQueryParam) {
        attFileQueryParam.setqFilter(new QFilter("id", "in", fileVersionIds));
        List files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return HRAuthUtil.getAuthFieldByAttFileDynBatch((List)files);
    }

    public SettleTaskReqVo getSettleTaskReqVo(Map<String, Object> customParams) {
        if (customParams == null || customParams.get("SettleTaskReqVo") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u7ed3\u7b97\u4efb\u52a1\u3002", (String)"SettleFormService_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
        }
        Object settleTaskReqVoData = customParams.get("SettleTaskReqVo");
        return (SettleTaskReqVo)SerializationUtils.deSerializeFromBase64((String)((String)settleTaskReqVoData));
    }
}

