/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.tietask;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtte.business.tietask.TieTaskResp;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.attcalculate.AttCalculateService;
import kd.wtc.wtte.business.tietask.TieTaskHelper;
import kd.wtc.wtte.business.tietask.enums.TieTaskErrorCode;
import kd.wtc.wtte.business.tietask.model.TieTaskRespImpl;

public abstract class AbsTieTimingTask
extends AbstractTask {
    protected static final Log log = LogFactory.getLog(AbsTieTimingTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.executeRetTaskId(requestContext, map);
    }

    protected TieTaskResp executeRetTaskId(RequestContext requestContext, Map<String, Object> map) {
        TieTaskResp tieTaskResp = this.beforeGenTask(requestContext, map);
        if (!tieTaskResp.getStatus()) {
            return tieTaskResp;
        }
        return this.genTask(requestContext, map);
    }

    protected TieTaskResp beforeGenTask(RequestContext requestContext, Map<String, Object> map) {
        return new TieTaskRespImpl();
    }

    protected String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private TieTaskResp genTask(RequestContext requestContext, Map<String, Object> map) {
        String className = this.getClassName();
        log.info("TieTimingTaskAbs_task_start{}_{}_{}", new Object[]{className, requestContext.getCurrUserId(), map});
        Date expectStartDate = this.getExpectStartDate(map);
        Date expectEndDate = this.getExpectEndDate(map);
        List<DynamicObject> preDateUsableAttFileList = this.getAccountFileBoNewestVersion(expectStartDate, expectEndDate);
        if (preDateUsableAttFileList.isEmpty()) {
            log.info("{} can not find any preDateUsableAttFiles, now terminate timingTask.", (Object)className);
            return new TieTaskRespImpl(TieTaskErrorCode.ERROR_CODE_006);
        }
        String taskVersion = TieTaskHelper.generateTaskVersion();
        log.info("TieTimingTaskAbs_cal_version_{}", (Object)taskVersion);
        DynamicObject calResultDy = this.genCalResultDy(taskVersion, map);
        Date today = new Date();
        calResultDy.set("createtime", (Object)today);
        long taskId = AttCalculateService.saveOneCalResult(calResultDy);
        WTCTaskRequestStd request = this.getEvaluateRequest(map, taskVersion, taskId, preDateUsableAttFileList);
        String errMsg = this.certCheck(request.getDetail());
        List subTaskDispatchReqList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)request);
        this.dealRequest(request, errMsg, subTaskDispatchReqList, today, className);
        return new TieTaskRespImpl(taskId);
    }

    protected List<DynamicObject> getAccountFileBoNewestVersion(Date expectStartDate, Date expectEndDate) {
        List<DynamicObject> preDateUsableAttFileList = this.getAllAttFileByDate(expectStartDate, expectEndDate);
        return TieTaskHelper.filterManyAttFileBoNewestVersion(preDateUsableAttFileList);
    }

    private List<DynamicObject> getAllAttFileByDate(Date expectStartDate, Date expectEndDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setStartDate(expectStartDate);
        attFileQueryParam.setEndDate(expectEndDate);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setProperties(HRAuthUtil.ATT_FILE_SHARD_TASK_PROPERTY);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    private DynamicObject genCalResultDy(String version, Map<String, Object> map) {
        Long id = DB.genGlobalLongId();
        DynamicObject resultObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_calresult"));
        resultObject.set("id", (Object)id);
        resultObject.set("taskid", (Object)id);
        resultObject.set("version", (Object)version);
        resultObject.set("begindate", (Object)this.getExpectStartDate(map));
        resultObject.set("enddate", (Object)this.getExpectEndDate(map));
        resultObject.set("savestep", (Object)this.getSaveStep(map));
        resultObject.set("planid", (Object)this.getPlanId(map));
        resultObject.set("desc", (Object)this.getDesc(map));
        RequestContext context = RequestContext.get();
        resultObject.set("creator", (Object)(context.getCurrUserId() == 0L ? 1L : context.getCurrUserId()));
        resultObject.set("createtime", (Object)new Date());
        long orgId = this.getOrgId(map);
        if (0L != orgId) {
            RequestContext.get().setOrgId(orgId);
        }
        if (0L == (orgId = WTCBizDataPermissionServiceImpl.getInstance().getUserHasPerOrgId("wtte_attcalculate", AppMetadataCache.getAppInfo((String)"wtte").getId()))) {
            orgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        }
        resultObject.set("org", (Object)orgId);
        resultObject.set("evaproperty", (Object)"2");
        return resultObject;
    }

    private WTCTaskRequestStd getEvaluateRequest(Map<String, Object> map, String taskVersion, long taskId, List<DynamicObject> usableAttFileList) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("number", taskId);
        paramMap.put("name", this.getTaskName(map));
        paramMap.put("saveStep", this.getSaveStep(map));
        paramMap.put("planId", this.getPlanId(map));
        paramMap.put("checkAuth", this.getCheckAuth(map));
        List personInfoList = HRAuthUtil.getAuthFieldByAttFileDynBatch(usableAttFileList);
        WTCTaskRequestStd request = TieTaskHelper.getEvaluateRequest(this.getExpectStartDate(map), this.getExpectEndDate(map), taskVersion, this.getDesc(map), WTCSource.SCHEDULE, false, personInfoList);
        request.setTaskId(taskId);
        request.setAppId("wtte");
        RequestContext context = RequestContext.get();
        request.setCreatorId(context.getCurrUserId() == 0L ? 1L : context.getCurrUserId());
        request.setParams((Map)paramMap);
        return request;
    }

    private String certCheck(List<Map<String, Object>> attFiles) {
        Map mapOfNumCheck = HRCertCommonHelper.verifyCertCount((String)"1C8H4/N38LCY", (String)"wtte_attcalculate");
        if (WTCStringUtils.equals((String)((String)mapOfNumCheck.get("infoType")), (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            mapOfNumCheck.put("showMessageType", "1");
            return (String)mapOfNumCheck.get("message");
        }
        Map<String, List<Long>> certCheckIdMap = this.getCertIdMap(attFiles);
        try {
            Map<String, Object> checkCertReturnMsg = AttCalculateService.checkCertReturnMsg("1C8H4/N38LCY", "wtte_attcalculate", certCheckIdMap);
            Map msg = (Map)checkCertReturnMsg.get("msg");
            if (Boolean.TRUE.equals(checkCertReturnMsg.get("isforbidden"))) {
                List datas = (List)checkCertReturnMsg.get("datas");
                if (datas == null || datas.size() <= 0) {
                    return (String)msg.get("message");
                }
                return CertService.getFailureMsg(checkCertReturnMsg);
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    private Map<String, List<Long>> getCertIdMap(List<Map<String, Object>> attFiles) {
        HashSet attfileBoIds = new HashSet(attFiles.size());
        attFiles.forEach(map -> {
            Long attFileBoId = (Long)map.get("attFileBoId");
            attfileBoIds.add(attFileBoId);
        });
        QFilter qFilterOfNow = new QFilter("bsled", ">=", (Object)WTCDateUtils.getDayBegin());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setqFilter(qFilterOfNow);
        attFileQueryParam.setSetBoIds(attfileBoIds);
        attFileQueryParam.setProperties("attperson.id,atttag.attendstatus,startdate,enddate,bsed,bsled,usablestatus");
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        List attfiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return CertService.getCertIdMap((List)attfiles);
    }

    private void dealRequest(WTCTaskRequestStd request, String errMsg, List<WTCTaskDispatchRequest> subTaskDispatchReqList, Date date, String className) {
        if (HRStringUtils.isEmpty((String)errMsg)) {
            JobInfo mainTaskExecutorJobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo((WTCTaskRequest)request, subTaskDispatchReqList);
            log.info("{} all ready to execute WTCMainTaskExecutor={}.", (Object)className, (Object)mainTaskExecutorJobInfo.getTaskClassname());
            ScheduleServiceHelper.dispatch((JobInfo)mainTaskExecutorJobInfo);
        } else {
            QFilter countingStatus = new QFilter("taskdetailstate", "=", (Object)WTCTaskDetailStatus.ACCOUNTING.code);
            List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtte_tie", (long)request.getTaskId(), (long)0L, (QFilter)countingStatus);
            wtcCalTaskDetailEntities.forEach(detail -> detail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT));
            WTCTaskServiceHelper.batchUpdateTaskDetailById((List)wtcCalTaskDetailEntities, (String)"wtte_tie");
            List wtcCalSubTaskEntities = WTCTaskServiceHelper.batchLoadSubTaskByTaskId((String)"wtte_tie", (long)request.getTaskId(), null);
            Map<Long, WTCCalSubTaskEntity> subTaskId2SubTask = wtcCalSubTaskEntities.stream().collect(Collectors.groupingBy(WTCSubTaskEntity::getId, Collectors.collectingAndThen(Collectors.toList(), value -> (WTCCalSubTaskEntity)value.get(0))));
            subTaskDispatchReqList.forEach(req -> {
                WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
                subTask.setId(req.getShardingTask().getSubTaskId());
                subTask.setTaskId(req.getShardingTask().getTaskId());
                subTask.setSubTaskStatus(WTCSubTaskStatus.ERROR);
                subTask.setStartDate(date);
                subTask.setEndDate(date);
                subTask.setRefreshTime(date);
                WTCCalSubTaskEntity wtcCalSubTaskEntity = (WTCCalSubTaskEntity)subTaskId2SubTask.get(req.getShardingTask().getSubTaskId());
                subTask.setSucceedAttFile(0);
                subTask.setFailedAttFile(0);
                subTask.setRunAttFile(0);
                subTask.setNotRunAttFile(wtcCalSubTaskEntity.getTotalAttFile());
                subTask.setSucceedAttPerson(0);
                subTask.setFailedAttPerson(0);
                subTask.setRunAttPerson(0);
                subTask.setNotRunAttPerson(wtcCalSubTaskEntity.getTotalAttPerson());
                WTCTaskStateTransfer.transferToSpecialStateSub((Long)subTask.getId(), (Long)subTask.getTaskId(), (WTCSubTaskEntity)subTask, (String)"wtte_tie");
            });
            Objects.requireNonNull(TaskConfig.getMainTaskLifeCycleCallBack((String)"wtte_tie")).onMainTaskEnd(Long.valueOf(request.getTaskId()), "wtte_tie", WTCTaskStatus.ALL_FINISHED, Collections.emptyList());
            WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository((String)"wtte_tie");
            WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_tie", (long)request.getTaskId(), (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
            wtcTaskEntity.setStartDate(date);
            wtcTaskEntity.setErrCause(errMsg);
            repository.updateTask((WTCTaskEntity)wtcTaskEntity);
        }
    }

    protected long getOrgId(Map<String, Object> paramMap) {
        long orgId = 0L;
        if (null != paramMap.get("org")) {
            orgId = (Long)paramMap.get("org");
        }
        return orgId;
    }

    protected String getTaskName(Map<String, Object> paramMap) {
        Object name = paramMap.get("name");
        if (name == null) {
            name = ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"TieTimingTask_0", (String)"wtc-wtte-business", (Object[])new Object[0]);
        }
        return name.toString();
    }

    protected Boolean getSaveStep(Map<String, Object> paramMap) {
        Boolean saveStep = (Boolean)paramMap.get("saveStep");
        if (saveStep == null) {
            saveStep = Boolean.FALSE;
        }
        return saveStep;
    }

    protected String getDesc(Map<String, Object> paramMap) {
        String desc = (String)paramMap.get("taskdesc");
        if (desc == null) {
            desc = "";
        }
        return desc;
    }

    protected Long getPlanId(Map<String, Object> paramMap) {
        Long planId = (Long)paramMap.get("planId");
        if (planId == null) {
            return AccountPlanUtil.queryDefaultPlanId();
        }
        return planId;
    }

    protected Boolean getCheckAuth(Map<String, Object> paramMap) {
        Boolean checkAuth = (Boolean)paramMap.get("checkAuth");
        if (null == checkAuth) {
            return Boolean.FALSE;
        }
        return checkAuth;
    }

    protected Date getExpectStartDate(Map<String, Object> paramMap) {
        Date startDate = (Date)paramMap.get("startdate");
        if (null == startDate) {
            return null;
        }
        return WTCDateUtils.getZeroDate((Date)startDate);
    }

    protected Date getExpectEndDate(Map<String, Object> paramMap) {
        Date endDate = (Date)paramMap.get("enddate");
        if (null == endDate) {
            return null;
        }
        return WTCDateUtils.getDayLastDate((Date)endDate);
    }
}

