/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.tietask;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.sdk.wtc.wtte.business.tietask.TieTaskReq;
import kd.sdk.wtc.wtte.business.tietask.TieTaskResp;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.tietask.AbsTieTimingTask;
import kd.wtc.wtte.business.tietask.TieTaskHelper;
import kd.wtc.wtte.business.tietask.enums.TieTaskErrorCode;
import kd.wtc.wtte.business.tietask.model.TieTaskRespImpl;

public class TieTaskGenerator
extends AbsTieTimingTask {
    private Map<String, Object> paramMap;
    private List<Long> attFileBoIds;

    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (WTCCollections.isNotEmpty(map)) {
            try {
                this.execute(this.buildReqParam(map));
            }
            catch (Exception e) {
                throw new WTCException((Throwable)e);
            }
        }
    }

    private TieTaskReq buildReqParam(Map<String, Object> map) throws ParseException {
        Object endDate;
        Object startDate;
        Object saveStep;
        Map orgIdMap;
        Object orgIdInfo;
        Map planObj;
        Object planIdInfo;
        TieTaskReq req = new TieTaskReq();
        req.setAttFileBoIds(JSONObject.parseArray((String)map.get("attFileBoIds").toString(), Long.class));
        Object taskDesc = map.get("taskdesc");
        if (null != taskDesc && WTCStringUtils.isNotEmpty((String)taskDesc.toString())) {
            req.setDesc(taskDesc.toString());
        }
        if (null != (planIdInfo = map.get("planId")) && WTCStringUtils.isNotEmpty((String)planIdInfo.toString()) && null != (planObj = (Map)JSONObject.parseObject((String)planIdInfo.toString(), Map.class)) && null != planObj.get("id")) {
            req.setTiePlanId(Long.parseLong(planObj.get("id").toString()));
        }
        if (null != (orgIdInfo = map.get("org")) && WTCStringUtils.isNotEmpty((String)orgIdInfo.toString()) && null != (orgIdMap = (Map)JSONObject.parseObject((String)orgIdInfo.toString(), Map.class)) && null != orgIdMap.get("id")) {
            req.setOrg(Long.valueOf(Long.parseLong(orgIdMap.get("id").toString())));
        }
        if (null != (saveStep = map.get("saveStep")) && WTCStringUtils.isNotEmpty((String)saveStep.toString())) {
            req.setSaveStep(Boolean.parseBoolean(saveStep.toString()));
        }
        if (null != (startDate = map.get("startdate")) && WTCStringUtils.isNotEmpty((String)startDate.toString())) {
            req.setExpectStartDate(WTCDateUtils.parseDate((String)startDate.toString(), (String)"yyyy-MM-dd"));
        }
        if (null != (endDate = map.get("enddate")) && WTCStringUtils.isNotEmpty((String)endDate.toString())) {
            req.setExpectEndDate(WTCDateUtils.parseDate((String)endDate.toString(), (String)"yyyy-MM-dd"));
        }
        return req;
    }

    private void init(TieTaskReq req) {
        this.paramMap = Maps.newHashMapWithExpectedSize((int)16);
        this.paramMap.put("planId", req.getTiePlanId());
        this.paramMap.put("saveStep", req.isSaveStep());
        String desc = req.getDesc();
        if (WTCStringUtils.isNotEmpty((String)desc) && desc.length() > 200) {
            desc = desc.substring(0, 200);
        }
        this.paramMap.put("taskdesc", desc);
        this.paramMap.put("org", req.getOrg());
        this.paramMap.put("startdate", req.getExpectStartDate());
        this.paramMap.put("enddate", req.getExpectEndDate());
        this.attFileBoIds = req.getAttFileBoIds();
    }

    public TieTaskResp execute(TieTaskReq req) {
        try {
            this.init(req);
            TieTaskResp tieTaskResp = super.executeRetTaskId(RequestContext.get(), this.paramMap);
            log.info("TieTaskGenerator_execute_result_{}", (Object)tieTaskResp);
            return tieTaskResp;
        }
        catch (Exception e) {
            log.warn("TieTaskGenerator.execute.error", (Throwable)e);
            return new TieTaskRespImpl(TieTaskErrorCode.ERROR_CODE_007);
        }
    }

    @Override
    protected TieTaskResp beforeGenTask(RequestContext requestContext, Map<String, Object> map) {
        Date expectEndDate = this.getExpectEndDate(map);
        if (null == expectEndDate) {
            return new TieTaskRespImpl(TieTaskErrorCode.ERROR_CODE_001);
        }
        Long planId = (Long)map.get("planId");
        if (null == planId || 0L == planId) {
            return new TieTaskRespImpl(TieTaskErrorCode.ERROR_CODE_002);
        }
        if (WTCCollections.isEmpty(this.attFileBoIds)) {
            return new TieTaskRespImpl(TieTaskErrorCode.ERROR_CODE_004);
        }
        Date expectStartDate = this.getExpectStartDate(map);
        if (null != expectStartDate && expectStartDate.getTime() > expectEndDate.getTime()) {
            return new TieTaskRespImpl(TieTaskErrorCode.ERROR_CODE_005);
        }
        return new TieTaskRespImpl();
    }

    @Override
    protected List<DynamicObject> getAccountFileBoNewestVersion(Date expectStartDate, Date expectEndDate) {
        if (WTCCollections.isEmpty(this.attFileBoIds)) {
            return Collections.emptyList();
        }
        return TieTaskHelper.getAttFileBoNewestVersionList(new HashSet<Long>(this.attFileBoIds));
    }

    @Override
    protected String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected Boolean getCheckAuth(Map<String, Object> paramMap) {
        return Boolean.TRUE;
    }
}

