/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.tietask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;

public final class TieTaskHelper {
    private static final String COMMA = ",";
    private static final String sortFileProperty = "boid,bsed,attperson.number,number";

    public static String generateTaskVersion() {
        return CodeRuleServiceHelper.getNumber((String)"wtte_calresult", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtte_calresult"), null);
    }

    public static List<DynamicObject> getAttFileBoNewestVersionList(Set<Long> attFileBoId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties(HRAuthUtil.ATT_FILE_SHARD_TASK_PROPERTY);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setSetBoIds(attFileBoId);
        List visibleAllAttFileVersion = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map<Long, List<DynamicObject>> visibleAttFileBoCluster = visibleAllAttFileVersion.stream().collect(Collectors.groupingBy(attFile -> attFile.getLong("boid")));
        ArrayList<DynamicObject> visibleAttFileBoNewestVersionList = new ArrayList<DynamicObject>(visibleAttFileBoCluster.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : visibleAttFileBoCluster.entrySet()) {
            List<DynamicObject> sameBoAttFileList = entry.getValue();
            DynamicObject boLastVersion = TieTaskHelper.filterAttFileBoNewestVersion(sameBoAttFileList);
            visibleAttFileBoNewestVersionList.add(boLastVersion);
        }
        return visibleAttFileBoNewestVersionList;
    }

    public static List<DynamicObject> getVisibleAttFileBoNewestVersionList(Collection<Object> attFileBoIdCollection) {
        List visibleAllAttFileVersion;
        if (WTCCollections.isEmpty(attFileBoIdCollection)) {
            return Collections.emptyList();
        }
        if (attFileBoIdCollection == null) {
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
            attFileQueryParam.setProperties(sortFileProperty);
            attFileQueryParam.setAuthCheck(Boolean.FALSE);
            visibleAllAttFileVersion = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        } else {
            if (attFileBoIdCollection.isEmpty()) {
                return Collections.emptyList();
            }
            Set boIdSet = attFileBoIdCollection.stream().map(boId -> Long.parseLong(boId.toString())).collect(Collectors.toSet());
            AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam();
            attFileF7QueryParam.setProperties(sortFileProperty);
            attFileF7QueryParam.setSetBoIds(boIdSet);
            attFileF7QueryParam.setFormId("wtte_tietaskdetail");
            attFileF7QueryParam.setAppId("wtte");
            attFileF7QueryParam.setPermField("attfile");
            visibleAllAttFileVersion = AttFileQueryServiceImpl.getInstance().queryAttFiles((AttFileQueryParam)attFileF7QueryParam);
        }
        Map<Long, List<DynamicObject>> visibleAttFileBoCluster = visibleAllAttFileVersion.stream().collect(Collectors.groupingBy(attFile -> attFile.getLong("boid")));
        ArrayList<DynamicObject> visibleAttFileBoNewestVersionList = new ArrayList<DynamicObject>(visibleAttFileBoCluster.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : visibleAttFileBoCluster.entrySet()) {
            List<DynamicObject> sameBoAttFileList = entry.getValue();
            DynamicObject boLastVersion = TieTaskHelper.filterAttFileBoNewestVersion(sameBoAttFileList);
            visibleAttFileBoNewestVersionList.add(boLastVersion);
        }
        return visibleAttFileBoNewestVersionList;
    }

    public static List<DynamicObject> filterManyAttFileBoNewestVersion(List<DynamicObject> manyBoAttFileList) {
        Map<Long, List<DynamicObject>> visibleAttFileBoCluster = manyBoAttFileList.stream().collect(Collectors.groupingBy(attFile -> attFile.getLong("boid")));
        ArrayList<DynamicObject> visibleAttFileBoNewestVersionList = new ArrayList<DynamicObject>(visibleAttFileBoCluster.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : visibleAttFileBoCluster.entrySet()) {
            List<DynamicObject> sameBoAttFileList = entry.getValue();
            DynamicObject boLastVersion = TieTaskHelper.filterAttFileBoNewestVersion(sameBoAttFileList);
            visibleAttFileBoNewestVersionList.add(boLastVersion);
        }
        return visibleAttFileBoNewestVersionList;
    }

    public static DynamicObject filterAttFileBoNewestVersion(List<DynamicObject> sameBoAttFileList) {
        if (sameBoAttFileList == null) {
            return null;
        }
        DynamicObject boLastVersion = null;
        for (DynamicObject attFile : sameBoAttFileList) {
            if (boLastVersion == null) {
                boLastVersion = attFile;
                continue;
            }
            if (!boLastVersion.getDate("bsed").before(attFile.getDate("bsed"))) continue;
            boLastVersion = attFile;
        }
        return boLastVersion;
    }

    public static WTCTaskRequestStd getEvaluateRequest(Date expectStartDate, Date expectEndDate, String taskVersion, String desc, WTCSource source, boolean trail, List<Map<String, Object>> personInfoList) {
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setVersion(taskVersion);
        request.setCategory("wtte_tie");
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setDesc(desc);
        request.setSource(source.getCode());
        request.setTrial(trail);
        request.setStartDate(expectStartDate);
        request.setEndDate(expectEndDate);
        request.setDetail(personInfoList);
        return request;
    }
}

