/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.timedtask;

import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.auth.IWTCBizDataPermissionService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtte.business.qt.task.QtTaskHelper;
import kd.wtc.wtte.business.tietask.TieTaskHelper;
import kd.wtc.wtte.business.timedtask.QTTimingTaskHelper;

public class QTDCTieTimingTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(QTDCTieTimingTask.class);
    private static final HRBaseServiceHelper QTTYPE_HELPER = new HRBaseServiceHelper("wtp_qttype");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.genTask(requestContext, map);
    }

    private long genTask(RequestContext requestContext, Map<String, Object> map) {
        Date now = new Date();
        long orgId = requestContext.getOrgId() == 0L ? WTCOrgUnitServiceHelper.getHRDefaultRootOrgId() : RequestContext.get().getOrgId();
        requestContext.setOrgId(orgId);
        LOG.info("QtTimingTask_begin_currUserId_{}_orgId_{}_param_{}", new Object[]{requestContext.getCurrUserId(), requestContext.getOrgId(), map});
        long attOrgId = this.getAttOrgId();
        String name = ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QtTimingTask_0", (String)"wtc-wtte-business", (Object[])new Object[0]);
        Boolean saveStep = Boolean.parseBoolean(map.getOrDefault("savestep", Boolean.FALSE).toString());
        String desc = (String)map.getOrDefault("desc", "");
        String qtTypeNumbers = (String)map.getOrDefault("qtTypeNumber", "");
        ArrayList<Long> qtTypeIds = new ArrayList<Long>();
        ArrayList<Long> dyQtTypeIds = new ArrayList<Long>();
        this.fillQTTypeIdList(attOrgId, qtTypeNumbers, qtTypeIds, dyQtTypeIds);
        Date expectStartDate = this.getExpectStartDate();
        Date expectEndDate = this.getExpectEndDate();
        if (expectStartDate == null || expectEndDate == null || expectStartDate.after(expectEndDate)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("QtTimingTask terminate, \u6838\u7b97\u65e5\u671f\u8303\u56f4\u6709\u8bef, expectStartDate:{}, expectEndDate:{}, qtTypeIds:{}, dyQtTypeIds:{}, attOrgId:{}", new Object[]{expectStartDate, expectEndDate, qtTypeIds, dyQtTypeIds, attOrgId});
            }
            return 0L;
        }
        List<DynamicObject> preDateUsableAttFileList = this.getAccountFileBoNewestVersion(expectStartDate, expectEndDate);
        if ((preDateUsableAttFileList = TieTaskHelper.filterManyAttFileBoNewestVersion(preDateUsableAttFileList)).isEmpty()) {
            LOG.info("QtTimingTask can not find any preDateUsableAttFiles, now terminate timingTask.");
            return 0L;
        }
        String taskVersion = QtTaskHelper.getDeductTaskVersion();
        DynamicObject calResultDy = QTDCTieTimingTask.genQtCalResultDy(qtTypeIds, dyQtTypeIds, saveStep, desc, expectStartDate, expectEndDate, taskVersion, now, attOrgId);
        DynamicObject resultDy = (DynamicObject)QTAccountModeHelper.getDeductChainDao().saveOne(calResultDy);
        long taskId = resultDy.getLong("id");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("number", taskId);
        paramMap.put("name", name);
        paramMap.put("saveStep", saveStep);
        paramMap.put("planId", AccountPlanUtil.queryQuotaDefaultDeductPlanId());
        paramMap.put("tiePlanId", AccountPlanUtil.queryDefaultPlanId());
        long tiePlanId = SystemParamQueryUtil.getDefaultTiePlanId();
        if (0L != tiePlanId) {
            paramMap.put("tiePlanId", tiePlanId);
        }
        paramMap.put("accountmode", "B");
        paramMap.put("qttype", qtTypeIds);
        paramMap.put("dyqttype", dyQtTypeIds);
        this.fillParamMap(paramMap);
        List personInfoList = HRAuthUtil.getAuthFieldByAttFileDynBatch(preDateUsableAttFileList);
        WTCTaskRequestStd request = QTDCTieTimingTask.getEvaluateRequest(paramMap, desc, expectStartDate, expectEndDate, taskVersion, taskId, personInfoList);
        String errMsg = QTTimingTaskHelper.certCheck(personInfoList);
        List subTaskDispatchReqList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)request);
        this.dealRequest(request, errMsg, subTaskDispatchReqList, now);
        return taskId;
    }

    protected void startTaskSuccess(long taskId) {
    }

    private void dealRequest(WTCTaskRequestStd request, String errMsg, List<WTCTaskDispatchRequest> subTaskDispatchReqList, Date date) {
        if (HRStringUtils.isEmpty((String)errMsg)) {
            JobInfo mainTaskExecutorJobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo((WTCTaskRequest)request, subTaskDispatchReqList);
            LOG.info("QtTimingTask already to execute WTCMainTaskExecutor={}.", (Object)mainTaskExecutorJobInfo.getTaskClassname());
            ScheduleServiceHelper.dispatch((JobInfo)mainTaskExecutorJobInfo);
            this.startTaskSuccess(request.getTaskId());
        } else {
            QTTimingTaskHelper.taskErrorHandle(request, errMsg, subTaskDispatchReqList, date);
        }
    }

    private static WTCTaskRequestStd getEvaluateRequest(Map<String, Object> paramMap, String desc, Date expectStartDate, Date expectEndDate, String taskVersion, long taskId, List<Map<String, Object>> personInfoList) {
        WTCTaskRequestStd request = QtTaskHelper.getEvaluateRequest(expectStartDate, expectEndDate, taskVersion, desc, WTCSource.SCHEDULE, false, personInfoList);
        request.setParams(paramMap);
        request.setTaskId(taskId);
        request.setAppId("wtte");
        RequestContext context = RequestContext.get();
        request.setCreatorId(context.getCurrUserId() == 0L ? 1L : context.getCurrUserId());
        return request;
    }

    protected void fillParamMap(Map<String, Object> paramMap) {
    }

    protected List<DynamicObject> getAccountFileBoNewestVersion(Date expectStartDate, Date expectEndDate) {
        List<DynamicObject> preDateUsableAttFileList = QTDCTieTimingTask.getAllAttFileByDate(expectStartDate, expectEndDate);
        return TieTaskHelper.filterManyAttFileBoNewestVersion(preDateUsableAttFileList);
    }

    private static List<DynamicObject> getAllAttFileByDate(Date expectStartDate, Date expectEndDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setStartDate(expectStartDate);
        attFileQueryParam.setEndDate(expectEndDate);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setProperties(HRAuthUtil.ATT_FILE_SHARD_TASK_PROPERTY);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    protected void fillQTTypeIdList(long attOrgId, String qtTypeNumbers, List<Long> qtTypeIds, List<Long> dyQtTypeIds) {
        this.getQtType(dyQtTypeIds, qtTypeIds, qtTypeNumbers, attOrgId);
    }

    private void getQtType(List<Long> dyQtTypeIds, List<Long> fixedQtTypeIds, String qtTypeStr, long attOrgId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        if (StringUtils.isEmpty((CharSequence)qtTypeStr)) {
            qFilter.and(new QFilter("useorg", "=", (Object)attOrgId).or("ctrlstrategy", "in", (Object)"5"));
        } else {
            String[] splitNumbers = StringUtils.split((String)qtTypeStr, (String)",");
            qFilter.and(new QFilter("number", "in", (Object)splitNumbers));
        }
        String properties = "gentype";
        DynamicObject[] query = QTTYPE_HELPER.query(properties, new QFilter[]{qFilter});
        Arrays.stream(query).forEach(qtTypeDyn -> {
            if (StringUtils.equals((CharSequence)qtTypeDyn.getString("gentype"), (CharSequence)"B")) {
                dyQtTypeIds.add(qtTypeDyn.getLong("id"));
            } else {
                fixedQtTypeIds.add(qtTypeDyn.getLong("id"));
            }
        });
    }

    protected Date getExpectStartDate() {
        LocalDate firstDayOfYear = LocalDate.now().with(TemporalAdjusters.firstDayOfYear());
        return WTCDateUtils.toDate((LocalDate)firstDayOfYear);
    }

    protected Date getExpectEndDate() {
        LocalDate lastDayOfYear = LocalDate.now().with(TemporalAdjusters.lastDayOfYear());
        return WTCDateUtils.toDate((LocalDate)lastDayOfYear);
    }

    protected long getAttOrgId() {
        IWTCBizDataPermissionService wtcBizDataPermissionService = (IWTCBizDataPermissionService)WTCAppContextHelper.getBean(WTCBizDataPermissionServiceImpl.class);
        long attOrgId = wtcBizDataPermissionService.getUserHasPerOrgId("wtte_qtdccalculate", AppMetadataCache.getAppInfo((String)"wtte").getId());
        if (0L == attOrgId) {
            attOrgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        }
        return attOrgId;
    }

    private static DynamicObject genQtCalResultDy(List<Long> qtTypeIds, List<Long> dyQtTypeIds, Boolean isSaveStep, String desc, Date expectStartDate, Date expectEndDate, String version, Date today, long attOrgId) {
        DynamicObject resultObject = QTAccountModeHelper.getEmptyDynByAccountMode((String)"B");
        resultObject.set("org", (Object)attOrgId);
        resultObject.set("savestep", (Object)isSaveStep);
        resultObject.set("planid", (Object)AccountPlanUtil.queryQuotaDefaultDeductPlanId());
        resultObject.set("tieplanid", (Object)AccountPlanUtil.queryDefaultPlanId());
        resultObject.set("desc", (Object)desc);
        resultObject.set("enddate", (Object)expectEndDate);
        resultObject.set("begindate", (Object)expectStartDate);
        resultObject.set("version", (Object)version);
        RequestContext context = RequestContext.get();
        resultObject.set("creator", (Object)(context.getCurrUserId() == 0L ? 1L : context.getCurrUserId()));
        resultObject.set("createtime", (Object)new Date());
        Long taskId = DB.genGlobalLongId();
        resultObject.set("taskid", (Object)taskId);
        resultObject.set("id", (Object)taskId);
        resultObject.set("createtime", (Object)today);
        DataEntityPropertyCollection propertyCollection = resultObject.getDataEntityType().getProperties();
        MulBasedataProp mulBasedataProp = (MulBasedataProp)propertyCollection.get((Object)"qttype");
        DynamicObjectType mulType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        DynamicObjectCollection qtTypes = new DynamicObjectCollection();
        for (Long qtTypeId : qtTypeIds) {
            DynamicObject dynamicObject = new DynamicObject(mulType);
            dynamicObject.set("fbasedataid_id", (Object)qtTypeId);
            qtTypes.add((Object)dynamicObject);
        }
        resultObject.set("qttype", (Object)qtTypes);
        DynamicObjectCollection dyQtTypes = new DynamicObjectCollection();
        for (Long qtTypeId : dyQtTypeIds) {
            DynamicObject dynamicObject = new DynamicObject(mulType);
            dynamicObject.set("fbasedataid_id", (Object)qtTypeId);
            dyQtTypes.add((Object)dynamicObject);
        }
        resultObject.set("dyqttype", (Object)dyQtTypes);
        return resultObject;
    }
}

