/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.timedtask;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.sdk.wtc.wtbs.common.lang.NotNull;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.task.base.MainTaskLifeCycleCallBack;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtte.business.attcalculate.AttCalculateService;

public class QTTimingTaskHelper {
    private static final Log LOG = LogFactory.getLog(QTTimingTaskHelper.class);

    public static void taskErrorHandle(WTCTaskRequestStd request, String errMsg, List<WTCTaskDispatchRequest> subTaskDispatchReqList, Date date) {
        QFilter countingStatus = new QFilter("taskdetailstate", "=", (Object)WTCTaskDetailStatus.ACCOUNTING.code);
        List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtte_qttie", (long)request.getTaskId(), (long)0L, (QFilter)countingStatus);
        wtcCalTaskDetailEntities.forEach(detail -> detail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT));
        WTCTaskServiceHelper.batchUpdateTaskDetailById((List)wtcCalTaskDetailEntities, (String)"wtte_qttie");
        List wtcCalSubTaskEntities = WTCTaskServiceHelper.batchLoadSubTaskByTaskId((String)"wtte_qttie", (long)request.getTaskId(), null);
        Map<Long, WTCCalSubTaskEntity> subTaskId2SubTask = wtcCalSubTaskEntities.stream().collect(Collectors.groupingBy(WTCSubTaskEntity::getId, Collectors.collectingAndThen(Collectors.toList(), value -> (WTCCalSubTaskEntity)value.get(0))));
        subTaskDispatchReqList.forEach(req -> {
            WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
            subTask.setId(req.getShardingTask().getSubTaskId());
            subTask.setTaskId(req.getShardingTask().getTaskId());
            subTask.setSubTaskStatus(WTCSubTaskStatus.ERROR);
            subTask.setStartDate(date);
            subTask.setEndDate(date);
            subTask.setRefreshTime(date);
            WTCCalSubTaskEntity wtcCalSubTaskEntity = (WTCCalSubTaskEntity)subTaskId2SubTask.get(req.getShardingTask().getSubTaskId());
            subTask.setSucceedAttFile(0);
            subTask.setFailedAttFile(0);
            subTask.setRunAttFile(0);
            subTask.setNotRunAttFile(wtcCalSubTaskEntity.getTotalAttFile());
            subTask.setSucceedAttPerson(0);
            subTask.setFailedAttPerson(0);
            subTask.setRunAttPerson(0);
            subTask.setNotRunAttPerson(wtcCalSubTaskEntity.getTotalAttPerson());
            WTCTaskStateTransfer.transferToSpecialStateSub((Long)subTask.getId(), (Long)subTask.getTaskId(), (WTCSubTaskEntity)subTask, (String)"wtte_qttie");
        });
        MainTaskLifeCycleCallBack mainTaskLifeCycleCallBack = TaskConfig.getMainTaskLifeCycleCallBack((String)"wtte_qttie");
        if (mainTaskLifeCycleCallBack != null) {
            mainTaskLifeCycleCallBack.onMainTaskEnd(Long.valueOf(request.getTaskId()), "wtte_qttie", WTCTaskStatus.ALL_FINISHED, Collections.emptyList());
        }
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository((String)"wtte_qttie");
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_qttie", (long)request.getTaskId(), (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        wtcTaskEntity.setStartDate(date);
        wtcTaskEntity.setErrCause(errMsg);
        repository.updateTask((WTCTaskEntity)wtcTaskEntity);
    }

    public static String certCheck(List<Map<String, Object>> attFiles) {
        Map mapOfNumCheck = HRCertCommonHelper.verifyCertCount((String)"1C8H4/N38LCY", (String)"wtte_attcalculate");
        if (StringUtils.equals((CharSequence)((CharSequence)mapOfNumCheck.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            mapOfNumCheck.put("showMessageType", "1");
            return (String)mapOfNumCheck.get("message");
        }
        Map<String, List<Long>> certCheckIdMap = QTTimingTaskHelper.getCertIdMap(attFiles);
        try {
            Map<String, Object> checkCertReturnMsg = AttCalculateService.checkCertReturnMsg("1C8H4/N38LCY", "wtte_attcalculate", certCheckIdMap);
            Map msg = (Map)checkCertReturnMsg.get("msg");
            if (Boolean.TRUE.equals(checkCertReturnMsg.get("isforbidden"))) {
                List datas = (List)checkCertReturnMsg.get("datas");
                if (datas == null || datas.size() <= 0) {
                    return (String)msg.get("message");
                }
                return CertService.getFailureMsg(checkCertReturnMsg);
            }
        }
        catch (Exception ex) {
            LOG.info("\u5b9a\u989d\u6838\u7b97\u5b9a\u65f6\u4efb\u52a1\u6821\u9a8c\u8bb8\u53ef\u5f02\u5e38\u3002", (Object)ex);
            return ex.getMessage();
        }
        return "";
    }

    @NotNull
    private static Map<String, List<Long>> getCertIdMap(List<Map<String, Object>> attFiles) {
        HashSet attfileBoIds = new HashSet(attFiles.size());
        attFiles.stream().forEach(map -> {
            Long attfileBoId = (Long)map.get("attFileBoId");
            attfileBoIds.add(attfileBoId);
        });
        QFilter qFilterOfNow = new QFilter("bsled", ">=", (Object)WTCDateUtils.getDayBegin());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setqFilter(qFilterOfNow);
        attFileQueryParam.setSetBoIds(attfileBoIds);
        attFileQueryParam.setProperties("attperson.id,atttag.attendstatus,startdate,enddate,bsed,bsled,usablestatus");
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        List attfiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return CertService.getCertIdMap((List)attfiles);
    }
}

