/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.timedtask;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class RecordCleanTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(RecordCleanTask.class);
    private static final HRBaseServiceHelper RECORD_MAIN_HELPER = new HRBaseServiceHelper("wtdtd_attrecordbasehis");
    private static final HRBaseServiceHelper RECORD_DETAIL_HELPER = new HRBaseServiceHelper("wtdtd_attrecorddetailhis");
    private static final HRBaseServiceHelper TOTAL_MAIN_HELPER = new HRBaseServiceHelper("wtctd_atttotalbasehis");
    private static final HRBaseServiceHelper TOTAL_DETAIL_HELPER = new HRBaseServiceHelper("wtctd_atttotaldetailhis");
    private static final HRBaseServiceHelper LOG_HELPER = new HRBaseServiceHelper("wtte_recordcleanlog");
    private static final String CHECKDAYS = "CHECKDAYS";
    private static final String MAX_HIS_VERSION = "maxhisversion";
    private static final String ATTRECORD_IDENTIFY = "checkboxfield";
    private static final String ATTTOTAL_IDENTIFY = "checkboxfield1";
    private static final int UNION_MAX = 50;
    private static final int BATCH_NUM = 999;
    private static final String DAILY_RECORD_GROUP_SQL = "SELECT subquery.fattfileid attfileid, subquery.fowndate owndate, subquery.countNum countNum FROM (  SELECT fattfileid, fowndate,count(*) countNum FROM t_wtdtd_attrecordbasehis  where fowndate >= ? GROUP BY fattfileid,fowndate) AS subquery  WHERE subquery.countNum > ?";
    private static final String DAILY_RECORD_QUERYID_SQL_FORMAT = "select fid id, fowndate owndate from t_wtdtd_attrecordbasehis  twa where fattfileid = %d  and  fowndate = '%s'  order by fcreatetime asc";
    private static final String TOTAL_RECORD_GROUP_SQL = "SELECT subquery.fattfileid attfileid, subquery.fattperattperiodid attperattperiodid, subquery.countNum countNum FROM (  SELECT fattfileid, fattperattperiodid,count(*) countNum FROM t_wtctd_atttotalbasehis where fperperiodbegindate >= ? GROUP BY fattfileid,fattperattperiodid) AS subquery  WHERE subquery.countNum > ?";
    private static final String TOTAL_RECORD_QUERYID_SQL_FORMAT = "select fid id  from t_wtctd_atttotalbasehis  twa where fattfileid = %d  and  fattperattperiodid = '%s'  order by fcreatetime asc";
    private static final int ATT_RECORD = 1;
    private static final int ATT_TOTAL = 2;
    private final List<Long> deleteIds = Lists.newArrayListWithExpectedSize((int)999);
    private final Set<LocalDate> deleteOwnDates = Sets.newHashSetWithExpectedSize((int)999);
    private static final String HIS_RETENTION_MONTH = "hisretentionmonth";
    private static final Integer DEFAULT_HIS_RETENTION_MONTH = 1;
    private static final String TABLE_ATTRECORD_MAIN = "wtdtd_attrecordbasehis";
    private static final String TABLE_ATTRECORD_DETAIL = "wtdtd_attrecorddehis";
    private static final String ATTRECORD_QUERY_FIRST_SQL = "select count(fid) countnum,min(fowndate) minowndate from t_{0} where fowndate < ?";
    private static final String ATTRECORD_DELETE_BY_RANGE_SQL = "delete from t_{0}  where fowndate >= ? and fowndate < ?";
    private static final String TABLE_ATTTOTAL_MAIN = "wtctd_atttotalbasehis";
    private static final String ATTTOTAL_QUERY_ALL_SQL = "select fid id from t_wtctd_atttotalbasehis where fperperiodenddate < ?";
    private static final Integer ATTRECORD_CLEAN_MAX_DELETE_NUM_ONCE = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtte.record.clean.attRecordMaxDeleteNumOnce", Integer.valueOf(30000));
    private static final Integer ATTTOTAL_CLEAN_MAX_DELETE_NUM_ONCE = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtte.record.clean.attTotalMaxDeleteNumOnce", Integer.valueOf(10000));

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Boolean saveRecord = (Boolean)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)ATTRECORD_IDENTIFY);
        Boolean saveTotal = (Boolean)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)ATTTOTAL_IDENTIFY);
        if (!saveRecord.booleanValue() && !saveTotal.booleanValue()) {
            return;
        }
        LOG.info("RecordCleanTask start");
        Integer hisRetentionMonth = (Integer)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)HIS_RETENTION_MONTH);
        if (null == hisRetentionMonth) {
            hisRetentionMonth = DEFAULT_HIS_RETENTION_MONTH;
        }
        this.clearHistoryData(hisRetentionMonth);
        Date startTime = new Date();
        int maxHisVersion = (Integer)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)MAX_HIS_VERSION);
        LocalDate localDate = LocalDate.now().minusMonths(hisRetentionMonth.intValue());
        try {
            this.getDataAndDelete(maxHisVersion, DAILY_RECORD_GROUP_SQL, DAILY_RECORD_QUERYID_SQL_FORMAT, 1, localDate);
            this.getDataAndDelete(maxHisVersion, TOTAL_RECORD_GROUP_SQL, TOTAL_RECORD_QUERYID_SQL_FORMAT, 2, localDate);
            this.saveLog(startTime, maxHisVersion);
        }
        catch (Exception ex) {
            LOG.warn("clear record error", (Throwable)ex);
            throw ex;
        }
        LOG.info("RecordCleanTask end");
    }

    private void saveLog(Date startTime, int maxHisVersion) {
        DynamicObject dy = LOG_HELPER.generateEmptyDynamicObject();
        dy.set("starttime", (Object)startTime);
        dy.set("endtime", (Object)new Date());
        dy.set(MAX_HIS_VERSION, (Object)maxHisVersion);
        LOG_HELPER.saveOne(dy);
    }

    private void getDataAndDelete(int maxHisVersion, String groupSqlFormat, String queryIdSqlFormat, int type, LocalDate localDate) {
        IDataEntityType dataEntityType = type == 1 ? RECORD_MAIN_HELPER.generateEmptyDynamicObject().getDataEntityType() : TOTAL_MAIN_HELPER.generateEmptyDynamicObject().getDataEntityType();
        DataSet rows = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".dealDailyAttRecord"), (DBRoute)DBRoute.of((String)dataEntityType.getDBRouteKey()), (String)groupSqlFormat, (Object[])new Object[]{this.toTimestamp(localDate), maxHisVersion});
        Iterator iterator = rows.iterator();
        DataSet unionDataSet = null;
        ArrayList dataSets = Lists.newArrayListWithExpectedSize((int)50);
        int indexMax = 49;
        int index = 0;
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long attFileId = row.getLong("attfileid");
            Object attperattperiodid = null;
            if (type == 1) {
                attperattperiodid = row.get("owndate");
            } else if (type == 2) {
                attperattperiodid = row.get("attperattperiodid");
            }
            if (null != attperattperiodid) {
                Integer countNum = row.getInteger("countNum");
                String queryIdSql = String.format(queryIdSqlFormat, attFileId, attperattperiodid);
                DataSet idDataSet = this.getTop(maxHisVersion, dataEntityType, queryIdSql, countNum);
                if (unionDataSet == null) {
                    unionDataSet = idDataSet;
                } else {
                    dataSets.add(idDataSet);
                }
                if (index == indexMax) {
                    unionDataSet = unionDataSet.union(dataSets.toArray(new DataSet[0]));
                    this.appendDeleteIds(unionDataSet, type);
                    index = -1;
                    unionDataSet = null;
                    dataSets.clear();
                }
            }
            ++index;
        }
        if (!dataSets.isEmpty() && unionDataSet != null) {
            unionDataSet = unionDataSet.union(dataSets.toArray(new DataSet[0]));
        }
        this.appendDeleteIds(unionDataSet, type);
        this.deleteAttRecord(type);
    }

    private DataSet getTop(int maxHisVersion, IDataEntityType dataEntityType, String queryIdSql, Integer countNum) {
        return DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".dealDailyAttRecord2"), (DBRoute)DBRoute.of((String)dataEntityType.getDBRouteKey()), (String)queryIdSql).top(countNum - maxHisVersion);
    }

    private void appendDeleteIds(DataSet unionDataSet, int type) {
        if (unionDataSet == null) {
            return;
        }
        for (Row next : unionDataSet) {
            this.deleteIds.add(next.getLong("id"));
            if (type == 1 && null != next.getDate("owndate")) {
                this.deleteOwnDates.add(WTCDateUtils.toLocalDate((Date)next.getDate("owndate")));
            }
            if (this.deleteIds.size() < 999) continue;
            this.deleteAttRecord(type);
        }
    }

    private void deleteAttRecord(int type) {
        if (type == 1) {
            RECORD_MAIN_HELPER.delete(this.deleteIds.toArray());
            QFilter qfilter = new QFilter("owndate", "in", this.deleteOwnDates);
            qfilter.and(new QFilter("attmain", "in", this.deleteIds));
            RECORD_DETAIL_HELPER.deleteByFilter(new QFilter[]{qfilter});
        } else if (type == 2) {
            TOTAL_MAIN_HELPER.delete(this.deleteIds.toArray());
            TOTAL_DETAIL_HELPER.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", this.deleteIds)});
        }
        this.deleteIds.clear();
        this.deleteOwnDates.clear();
    }

    private void clearHistoryData(Integer hisRetentionMonth) {
        long startTime;
        LocalDate lastDate = LocalDate.now().minusMonths(hisRetentionMonth.intValue());
        long nowTime = startTime = System.currentTimeMillis();
        this.clearAttRecordHistoryData(lastDate, TABLE_ATTRECORD_MAIN);
        LOG.info("clearHistoryData: {} takes {} ms", (Object)TABLE_ATTRECORD_MAIN, (Object)(System.currentTimeMillis() - nowTime));
        nowTime = System.currentTimeMillis();
        this.clearAttRecordHistoryData(lastDate, TABLE_ATTRECORD_DETAIL);
        LOG.info("clearHistoryData: {} takes {} ms", (Object)TABLE_ATTRECORD_DETAIL, (Object)(System.currentTimeMillis() - nowTime));
        nowTime = System.currentTimeMillis();
        this.clearAttTotalHistoryData(lastDate);
        LOG.info("clearHistoryData: {} takes {} ms", (Object)TABLE_ATTTOTAL_MAIN, (Object)(System.currentTimeMillis() - nowTime));
        LOG.info("clearHistoryData: all takes {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void clearAttRecordHistoryData(LocalDate lastDate, String table) {
        IDataEntityType dataEntityType = RECORD_MAIN_HELPER.generateEmptyDynamicObject().getDataEntityType();
        DBRoute wtcDbRoute = DBRoute.of((String)dataEntityType.getDBRouteKey());
        DataSet countAndFirstRecords = HRDBUtil.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".attRecordHistoryData"), (DBRoute)wtcDbRoute, (String)MessageFormat.format(ATTRECORD_QUERY_FIRST_SQL, table), (Object[])new Object[]{this.toTimestamp(lastDate)}).limit(0, 1);
        if (!countAndFirstRecords.hasNext()) {
            return;
        }
        Row countAndFirstRecord = countAndFirstRecords.next();
        int countNum = countAndFirstRecord.getInteger("countnum");
        Date minDate = countAndFirstRecord.getDate("minowndate");
        LOG.info("clearAttRecordHistoryData: countNum={}, minDate={}", (Object)countNum, (Object)minDate);
        if (countNum == 0 || null == minDate) {
            return;
        }
        LocalDate firstDate = WTCDateUtils.toLocalDate((Date)minDate);
        if (firstDate.compareTo(lastDate) >= 0) {
            return;
        }
        ArrayList deleteParamList = Lists.newArrayListWithExpectedSize((int)16);
        long totalDays = ChronoUnit.DAYS.between(firstDate, lastDate) + 1L;
        long daysPerPart = totalDays * (long)ATTRECORD_CLEAN_MAX_DELETE_NUM_ONCE.intValue() / (long)countNum;
        LOG.info("clearAttRecordHistoryData: table={}, countNum={}, maxDeleteNum={}, totalDay={}, daysPerPart={}", new Object[]{table, countNum, ATTRECORD_CLEAN_MAX_DELETE_NUM_ONCE, totalDays, daysPerPart});
        if (daysPerPart <= 1L) {
            daysPerPart = 1L;
        }
        LocalDate currentDate = firstDate;
        while (currentDate.compareTo(lastDate) < 0) {
            LocalDate endDateForPart = currentDate.plusDays(daysPerPart);
            if (endDateForPart.compareTo(lastDate) >= 0) {
                deleteParamList.add(new Object[]{this.toTimestamp(currentDate), this.toTimestamp(lastDate)});
                break;
            }
            deleteParamList.add(new Object[]{this.toTimestamp(currentDate), this.toTimestamp(endDateForPart)});
            currentDate = endDateForPart;
        }
        this.printDeleteParamList(table, deleteParamList);
        for (Object[] deleteParam : deleteParamList) {
            HRDBUtil.execute((DBRoute)wtcDbRoute, (String)MessageFormat.format(ATTRECORD_DELETE_BY_RANGE_SQL, table), (Object[])deleteParam);
        }
    }

    private void clearAttTotalHistoryData(LocalDate lastDate) {
        IDataEntityType dataEntityType = TOTAL_MAIN_HELPER.generateEmptyDynamicObject().getDataEntityType();
        DBRoute wtcDbRoute = DBRoute.of((String)dataEntityType.getDBRouteKey());
        DataSet matchRecords = HRDBUtil.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".attTotalHistoryData"), (DBRoute)wtcDbRoute, (String)ATTTOTAL_QUERY_ALL_SQL, (Object[])new Object[]{this.toTimestamp(lastDate)}).limit(0, ATTTOTAL_CLEAN_MAX_DELETE_NUM_ONCE.intValue());
        if (!matchRecords.hasNext()) {
            return;
        }
        HashSet<Long> midList = new HashSet<Long>(16);
        for (Row row : matchRecords) {
            Long mid = row.getLong("id");
            midList.add(mid);
        }
        LOG.info("clearAttTotalHistoryData: midList.size {}", (Object)midList.size());
        if (WTCCollections.isNotEmpty(midList)) {
            TOTAL_MAIN_HELPER.delete(midList.toArray());
            TOTAL_DETAIL_HELPER.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", midList)});
            this.clearAttTotalHistoryData(lastDate);
        }
    }

    private Timestamp toTimestamp(LocalDate localDate) {
        return Timestamp.from(localDate.atStartOfDay().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    private void printDeleteParamList(String table, List<Object[]> list) {
        ArrayList<String> contents = new ArrayList<String>(16);
        for (Object[] arr : list) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                sb.append(arr[i]);
                if (i >= arr.length - 1) continue;
                sb.append(",");
            }
            contents.add(sb.toString());
        }
        LOG.info("clearAttRecordHistoryData: printDeleteParamList,table={}, size={}, deleteParamList={}", new Object[]{table, contents.size(), contents});
    }
}

