/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.upgraade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class TieTaskDetailUpgradeImpl
extends AbstractWtcTaskUpgrade {
    private static final Log LOGGER = LogFactory.getLog(TieTaskDetailUpgradeImpl.class);
    private static final String SELECT_TASK_DETAIL_SQL = "select fid,fattfilestartdate,fattfileboid from T_WTTE_TIETASKDETAIL ;";
    private static final List<String> ATT_STATE_SELECT_FILE = Arrays.asList("ffileboid", "faccountto", "flockto", "fallowreaccounttime", "ffileboid");
    private static final String SELECT_ATT_STATE_INFO_SQL = "select " + String.join((CharSequence)",", ATT_STATE_SELECT_FILE) + " from T_WTP_ATTSTATEINFO where ffileboid in  ";
    private static final List<String> ATT_FILE_SELECT_FILE = Arrays.asList("fboid", "fstartdate", "fenddate");
    private static final String SELECT_ATT_FILE_SQL = "select " + String.join((CharSequence)",", ATT_FILE_SELECT_FILE) + " from T_WTP_ATTFILEBASE where fiscurrentversion = ? and  fboid in ";
    private static final String UPDATE_SQL = "update T_WTTE_TIETASKDETAIL set faccountto = ? , flockto = ?, fattfilestartdate = ?, fattfileenddate = ?, fallowreaccounttime = ? where fid = ? ;";
    private final DBRoute wtcRoute = new DBRoute("wtc");
    private final DBRoute wtteRoute = new DBRoute("wtc.wtte");
    private static final int batchSize = 40000;

    protected String getJobId() {
        return "3F/==7TSR38C";
    }

    protected String getScheduleId() {
        return "3F8LYIIZZQ96";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process() {
        LOGGER.info("TieTaskDetailUpgradeImpl.begin");
        try (TXHandle ignored = TX.requiresNew();){
            Throwable throwable = null;
            try (DataSet detailDataSet = HRDBUtil.queryDataSet((String)"TieTaskDetailUpgradeImpl.SELECT_TASK_DETAIL", (DBRoute)this.wtteRoute, (String)SELECT_TASK_DETAIL_SQL, (Object[])new Object[0]);){
                Map<Long, Long> idAndBoIdMap = this.processTaskDetailData(detailDataSet);
                if (WTCCollections.isEmpty(idAndBoIdMap)) {
                    boolean bl = true;
                    return bl;
                }
                Set<Map.Entry<Long, Long>> entries = idAndBoIdMap.entrySet();
                ArrayList<Map.Entry<Long, Long>> entryList = new ArrayList<Map.Entry<Long, Long>>(entries);
                int totalSize = entryList.size();
                int batchCount = (totalSize + 40000 - 1) / 40000;
                int i = 0;
                while (true) {
                    if (i >= batchCount) {
                        ignored.commit();
                        LOGGER.info("TieTaskDetailUpgradeImpl.end");
                        return true;
                    }
                    int startIndex = i * 40000;
                    int endIndex = Math.min(startIndex + 40000, totalSize);
                    List subEntryList = WTCCollections.subList(entryList, (int)startIndex, (int)endIndex);
                    this.processAndSaveData(subEntryList);
                    ++i;
                }
            }
            catch (Exception exception) {
                LOGGER.warn("TieTaskDetailUpgradeImpl.upgradeAction error", (Throwable)exception);
                ignored.markRollback();
                throw new KDBizException((Throwable)exception, new ErrorCode("TieTaskDetailUpgradeImpl.process", exception.getMessage()), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, new ErrorCode("TieTaskDetailUpgradeImpl.process", exception.getMessage()), new Object[0]);
        }
    }

    private void executeUpdate(List<Object[]> paramList) {
        HRDBUtil.executeBatch((DBRoute)this.wtteRoute, (String)UPDATE_SQL, paramList);
    }

    private void processAndSaveData(List<Map.Entry<Long, Long>> idAndBoIdList) {
        Set<Long> boIds = idAndBoIdList.stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Map<Long, Map<String, Object>> attSetMap = this.queryAttSetInfo(boIds, ATT_STATE_SELECT_FILE);
        Map<Long, Map<String, Object>> attFileMap = this.queryAttFileInfo(boIds, ATT_FILE_SELECT_FILE);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(idAndBoIdList.size());
        for (Map.Entry<Long, Long> entry : idAndBoIdList) {
            Long id = entry.getKey();
            Long attFileBoId = entry.getValue();
            Map<String, Object> attSetInfo = attSetMap.get(attFileBoId);
            Map<String, Object> attFileInfo = attFileMap.get(attFileBoId);
            Date accountTo = null;
            Date lockTo = null;
            Date allowReAccountTime = null;
            Date startDate = null;
            Date endDate = null;
            if (null != attSetInfo) {
                accountTo = attSetInfo.get("faccountto") == null ? null : (Date)attSetInfo.get("faccountto");
                lockTo = attSetInfo.get("flockto") == null ? null : (Date)attSetInfo.get("flockto");
                Date date = allowReAccountTime = attSetInfo.get("fallowreaccounttime") == null ? null : (Date)attSetInfo.get("fallowreaccounttime");
            }
            if (null != attFileInfo) {
                startDate = attFileInfo.get("fstartdate") == null ? null : (Date)attFileInfo.get("fstartdate");
                endDate = attFileInfo.get("fenddate") == null ? null : (Date)attFileInfo.get("fenddate");
            }
            paramList.add(new Object[]{accountTo, lockTo, startDate, endDate, allowReAccountTime, id});
        }
        this.executeUpdate(paramList);
    }

    private Map<Long, Map<String, Object>> queryAttSetInfo(Set<Long> attFileBoIds, List<String> files) {
        ArrayList strList = new ArrayList(attFileBoIds.size());
        attFileBoIds.forEach(ruleId -> strList.add("?"));
        String inStr = "(" + String.join((CharSequence)",", strList) + ");";
        try (DataSet attSetInfoDataSet = HRDBUtil.queryDataSet((String)"TieTaskDetailUpgradeImpl.SELECT_ATT_STATE", (DBRoute)this.wtcRoute, (String)(SELECT_ATT_STATE_INFO_SQL + inStr), (Object[])attFileBoIds.toArray());){
            Map<Long, Map<String, Object>> map = this.dateSetToMap(attSetInfoDataSet, "ffileboid", files);
            return map;
        }
    }

    private Map<Long, Map<String, Object>> queryAttFileInfo(Set<Long> attFileBoIds, List<String> files) {
        ArrayList strList = new ArrayList(attFileBoIds.size());
        attFileBoIds.forEach(ruleId -> strList.add("?"));
        String inStr = "(" + String.join((CharSequence)",", strList) + ");";
        ArrayList<Object> param = new ArrayList<Object>(attFileBoIds.size());
        param.add("1");
        param.addAll(attFileBoIds);
        try (DataSet attFileDataSet = HRDBUtil.queryDataSet((String)"TieTaskDetailUpgradeImpl.SELECT_ATT_FILE", (DBRoute)this.wtcRoute, (String)(SELECT_ATT_FILE_SQL + inStr), (Object[])param.toArray());){
            Map<Long, Map<String, Object>> map = this.dateSetToMap(attFileDataSet, "fboid", files);
            return map;
        }
    }

    private Map<Long, Long> processTaskDetailData(DataSet detailDataSet) {
        HashMap idAndBoIdMap = Maps.newHashMapWithExpectedSize((int)16);
        if (detailDataSet.isEmpty()) {
            return idAndBoIdMap;
        }
        while (detailDataSet.hasNext()) {
            Row row = detailDataSet.next();
            if (null != row.getDate("fattfilestartdate")) {
                return Collections.emptyMap();
            }
            idAndBoIdMap.put(row.getLong("fid"), row.getLong("fattfileboid"));
        }
        return idAndBoIdMap;
    }

    private Map<Long, Map<String, Object>> dateSetToMap(DataSet detailDataSet, String fileBoId, List<String> files) {
        HashMap boIdAndRowMap = Maps.newHashMapWithExpectedSize((int)16);
        while (detailDataSet.hasNext()) {
            Row row = detailDataSet.next();
            HashMap<String, Object> info = new HashMap<String, Object>(files.size());
            for (String file : files) {
                info.put(file, row.get(file));
            }
            boIdAndRowMap.put(row.getLong(fileBoId), info);
        }
        return boIdAndRowMap;
    }
}

