/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetailComponent;
import kd.wtc.wtte.common.enums.QuotaAttItemType;

public class QTImportUtils {
    private static final String[] detailIdArr = new String[]{"ownvalueid", "usablevalueid", "freezevalueid", "usedvalueid"};
    public static final HRBaseServiceHelper verticalDetailDao = new HRBaseServiceHelper("wtte_quotadetail");

    private QTImportUtils() {
    }

    public static DynamicObject genUsableValueVerticalDetail(QTLineDetail lineDetail, QTLineDetailComponent component) {
        DynamicObject usableValueDetail = verticalDetailDao.generateEmptyDynamicObject();
        usableValueDetail.set("id", (Object)DB.genGlobalLongId());
        usableValueDetail.set("attfileid", (Object)lineDetail.getAttFileBoId());
        usableValueDetail.set("qttypeid", (Object)lineDetail.getQtTypeId());
        usableValueDetail.set("periodcircleid", (Object)lineDetail.getpCycleId());
        usableValueDetail.set("periodnum", (Object)lineDetail.getPeriodNum());
        usableValueDetail.set("source", (Object)lineDetail.getSource());
        usableValueDetail.set("bid", (Object)lineDetail.getId());
        usableValueDetail.set("type", (Object)QuotaAttItemType.AVAILABLE.code);
        usableValueDetail.set("genstartdate", (Object)lineDetail.getGenStartDate());
        usableValueDetail.set("genenddate", (Object)lineDetail.getGenEndDate());
        usableValueDetail.set("usestartdate", (Object)lineDetail.getUseStartDate());
        usableValueDetail.set("useenddate", (Object)lineDetail.getUseEndDate());
        usableValueDetail.set("attitemvalue", (Object)lineDetail.getUsableValue());
        usableValueDetail.set("attitemvaluestr", (Object)"");
        usableValueDetail.set("version", (Object)"");
        usableValueDetail.set("gentime", (Object)new Date());
        usableValueDetail.set("assigndate", (Object)component.getAssignDate());
        usableValueDetail.set("crossstartdate", null);
        usableValueDetail.set("crossenddate", null);
        usableValueDetail.set("attitemvid", (Object)component.getUsableValueItemId());
        usableValueDetail.set("attfilevid", (Object)lineDetail.getAttFileVid());
        usableValueDetail.set("sourceattitemid", (Object)0L);
        usableValueDetail.set("sourceattitemids", (Object)"");
        return usableValueDetail;
    }

    public static DynamicObject genOwnValueVerticalDetail(QTLineDetail lineDetail, QTLineDetailComponent component) {
        DynamicObject ownValueDetail = verticalDetailDao.generateEmptyDynamicObject();
        ownValueDetail.set("id", (Object)DB.genGlobalLongId());
        ownValueDetail.set("attfileid", (Object)lineDetail.getAttFileBoId());
        ownValueDetail.set("qttypeid", (Object)lineDetail.getQtTypeId());
        ownValueDetail.set("periodcircleid", (Object)lineDetail.getpCycleId());
        ownValueDetail.set("periodnum", (Object)lineDetail.getPeriodNum());
        ownValueDetail.set("source", (Object)lineDetail.getSource());
        ownValueDetail.set("bid", (Object)lineDetail.getId());
        ownValueDetail.set("type", (Object)QuotaAttItemType.DURATION_ENJOYMENT.code);
        ownValueDetail.set("genstartdate", (Object)lineDetail.getGenStartDate());
        ownValueDetail.set("genenddate", (Object)lineDetail.getGenEndDate());
        ownValueDetail.set("usestartdate", (Object)lineDetail.getUseStartDate());
        ownValueDetail.set("useenddate", (Object)lineDetail.getUseEndDate());
        ownValueDetail.set("attitemvalue", (Object)lineDetail.getUsableValue());
        ownValueDetail.set("attitemvaluestr", (Object)"");
        ownValueDetail.set("version", (Object)"");
        ownValueDetail.set("gentime", (Object)new Date());
        ownValueDetail.set("assigndate", (Object)component.getAssignDate());
        ownValueDetail.set("crossstartdate", null);
        ownValueDetail.set("crossenddate", null);
        ownValueDetail.set("attitemvid", (Object)component.getOwnValueItemId());
        ownValueDetail.set("attfilevid", (Object)lineDetail.getAttFileVid());
        ownValueDetail.set("sourceattitemid", (Object)0L);
        ownValueDetail.set("sourceattitemids", (Object)"");
        return ownValueDetail;
    }

    @Deprecated
    public static DynamicObject addLineData(DynamicObject lineData, long lineId, BigDecimal qtValue) {
        DynamicObject dynamicObject = QTLineDetailDBService.lineDetailDao.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)lineData, (DynamicObject)dynamicObject);
        dynamicObject.set("usablevalue", (Object)qtValue);
        dynamicObject.set("genvalue", (Object)qtValue);
        dynamicObject.set("ownvalue", (Object)qtValue);
        dynamicObject.set("source", (Object)"DT-002");
        dynamicObject.set("org", lineData.get("attfileid.org"));
        dynamicObject.set("id", (Object)lineId);
        QTImportUtils.clearProperty(dynamicObject);
        return dynamicObject;
    }

    public static void clearProperty(DynamicObject dynamicObject) {
        dynamicObject.set("ownodvalue", (Object)new BigDecimal(0));
        dynamicObject.set("nousegenvalue", (Object)new BigDecimal(0));
        dynamicObject.set("pastvalue", (Object)new BigDecimal(0));
        dynamicObject.set("balance", (Object)new BigDecimal(0));
        dynamicObject.set("cdedvalue", (Object)new BigDecimal(0));
        dynamicObject.set("freezevalue", (Object)new BigDecimal(0));
        dynamicObject.set("usedvalue", (Object)new BigDecimal(0));
        dynamicObject.set("canbeodvalue", (Object)new BigDecimal(0));
        dynamicObject.set("useodvalue", (Object)new BigDecimal(0));
        dynamicObject.set("frozenodvalue", (Object)BigDecimal.ZERO);
        HRBaseServiceHelper detailServiceHelper = new HRBaseServiceHelper("wtte_quotadetail");
        DynamicObject detailDynamicObject = detailServiceHelper.generateEmptyDynamicObject();
        detailDynamicObject.set("id", (Object)0L);
        dynamicObject.set("genvalueid", (Object)detailDynamicObject);
        dynamicObject.set("ownvalueid", (Object)detailDynamicObject);
        dynamicObject.set("ownodvalueid", (Object)detailDynamicObject);
        dynamicObject.set("nousegenvalueid", (Object)detailDynamicObject);
        dynamicObject.set("genvalueid", (Object)detailDynamicObject);
        dynamicObject.set("pastvalueid", (Object)detailDynamicObject);
        dynamicObject.set("balanceid", (Object)detailDynamicObject);
        dynamicObject.set("usablevalueid", (Object)detailDynamicObject);
        dynamicObject.set("freezevalueid", (Object)detailDynamicObject);
        dynamicObject.set("usedvalueid", (Object)detailDynamicObject);
        dynamicObject.set("canbeodvalueid", (Object)detailDynamicObject);
        dynamicObject.set("useodvalueid", (Object)detailDynamicObject);
        dynamicObject.set("cdedvalueid", (Object)detailDynamicObject);
    }

    @Deprecated
    public static DynamicObject[] addDetail(DynamicObject lineData, DynamicObject newLineData, HRBaseServiceHelper serviceHelper, BigDecimal qtValue) {
        ArrayList detailIds = Lists.newArrayListWithExpectedSize((int)detailIdArr.length);
        for (String identify : detailIdArr) {
            DynamicObject dynamicObject = lineData.getDynamicObject(identify);
            if (dynamicObject == null) continue;
            detailIds.add((Long)dynamicObject.getPkValue());
        }
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)detailIds)});
        DynamicObject[] newDetail = new DynamicObject[dynamicObjects.length];
        long[] ids = DB.genGlobalLongIds((int)dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject detail = dynamicObjects[i];
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)detail, (DynamicObject)dynamicObject);
            long id = ids[i];
            String type = detail.getString("type");
            dynamicObject.set("id", (Object)id);
            if ("LB-003".equals(type)) {
                dynamicObject.set("attitemvalue", (Object)qtValue);
                newLineData.set("usablevalueid", (Object)dynamicObject);
            } else if ("LB-005".equals(type)) {
                dynamicObject.set("attitemvalue", (Object)new BigDecimal(0));
                newLineData.set("usedvalueid", (Object)dynamicObject);
            } else if ("LB-004".equals(type)) {
                dynamicObject.set("attitemvalue", (Object)new BigDecimal(0));
                newLineData.set("freezevalueid", (Object)dynamicObject);
            } else {
                if (!"LB-001".equals(type)) continue;
                dynamicObject.set("attitemvalue", (Object)qtValue);
                newLineData.set("ownvalueid", (Object)dynamicObject);
            }
            dynamicObject.set("version", null);
            dynamicObject.set("source", (Object)"DT-002");
            dynamicObject.set("bid", (Object)newLineData.getLong("id"));
            dynamicObject.set("genStartDate", newLineData.get("genStartDate"));
            dynamicObject.set("genenddate", newLineData.get("genenddate"));
            dynamicObject.set("usestartdate", newLineData.get("usestartdate"));
            dynamicObject.set("useenddate", newLineData.get("useenddate"));
            newDetail[i] = dynamicObject;
        }
        return newDetail;
    }

    public static DynamicObject getLineData(Long attfilebo, Long qttype, Date genstartdate) {
        QFilter[] qFilters = new QFilter[]{new QFilter("attfilebo", "=", (Object)attfilebo), new QFilter("qttype", "=", (Object)qttype), new QFilter("genstartdate", "<=", (Object)genstartdate), new QFilter("genenddate", ">=", (Object)genstartdate), new QFilter("source", "=", (Object)"DT-000")};
        String order = "genenddate desc,genstartdate desc";
        DynamicObject dynamicObject = QTLineDetailDBService.lineDetailDao.queryOriginalOne("id", qFilters, order);
        if (dynamicObject == null) {
            return null;
        }
        return QTLineDetailDBService.lineDetailDao.loadSingle(dynamicObject.get("id"));
    }
}

