/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtte.business.tietask.TieTaskHelper;
import kd.wtc.wtte.business.timedtask.QtTieTimingTask;

public class QTTaskGenerator
extends QtTieTimingTask {
    private boolean fromMethodCall = false;
    private Date calStartDate;
    private Date calEndDate;
    private final Set<Long> fixTypeIds = new HashSet<Long>(16);
    private final Set<Long> dyTypeIds = new HashSet<Long>(16);
    private Set<Long> attFileBoIds = new HashSet<Long>(16);
    private long tiePlanId = 0L;
    private long planId = 0L;
    private boolean calAllFileWhenFileEmpty = false;

    @Override
    protected void beforeGenTask(RequestContext requestContext, Map<String, Object> map) {
        List planIdList;
        Object planIdObj = map.get("planIdStr");
        long tmpPlanId = 0L;
        if (planIdObj != null && WTCStringUtils.isNotEmpty((String)planIdObj.toString())) {
            tmpPlanId = Long.parseLong(planIdObj.toString());
        }
        Object tiePlanIdObj = map.get("tiePlanIdStr");
        long tmpTiePlanId = 0L;
        if (tiePlanIdObj != null && WTCStringUtils.isNotEmpty((String)tiePlanIdObj.toString())) {
            tmpTiePlanId = Long.parseLong(tiePlanIdObj.toString());
        }
        if (!(planIdList = Stream.of(tmpPlanId, tmpTiePlanId).filter(ele -> ele != 0L).collect(Collectors.toList())).isEmpty()) {
            HRBaseServiceHelper accountPlanDao = new HRBaseServiceHelper("wtp_accountplan");
            DynamicObject[] planArr = accountPlanDao.query("id,accounttype", new QFilter("id", "in", planIdList).toArray());
            HashMap<Long, DynamicObject> planMap = new HashMap<Long, DynamicObject>(8);
            for (DynamicObject plan : planArr) {
                planMap.put(plan.getLong("id"), plan);
            }
            DynamicObject plan = (DynamicObject)planMap.get(tmpPlanId);
            if (plan != null && "C".equals(plan.getString("accounttype"))) {
                this.planId = tmpPlanId;
            }
            if ((plan = (DynamicObject)planMap.get(tmpTiePlanId)) != null && "A".equals(plan.getString("accounttype"))) {
                this.tiePlanId = tmpTiePlanId;
            }
        }
        if (!this.fromMethodCall) {
            Object calAllPersonWhenFileEmptyStr;
            Date argCalStartDate = null;
            String calStartDateStr = (String)map.get("calStartDateStr");
            if (WTCStringUtils.isNotEmpty((String)calStartDateStr)) {
                argCalStartDate = WTCDateUtils.str2Date((String)calStartDateStr, (String)"yyyy-MM-dd");
            }
            Date argCalEndDate = null;
            String calEndDateStr = (String)map.get("calEndDateStr");
            if (WTCStringUtils.isNotEmpty((String)calEndDateStr)) {
                argCalEndDate = WTCDateUtils.str2Date((String)calEndDateStr, (String)"yyyy-MM-dd");
            }
            HashSet<Long> argQtTypeIdSet = new HashSet(0);
            String qtTypeIdListStr = (String)map.get("qtTypeIdListStr");
            if (WTCStringUtils.isNotEmpty((String)qtTypeIdListStr)) {
                argQtTypeIdSet = Arrays.stream(qtTypeIdListStr.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            }
            HashSet<Long> argAttFileBoIds = new HashSet(0);
            String attFileBoIdListStr = (String)map.get("attFileBoIdListStr");
            if (WTCStringUtils.isNotEmpty((String)attFileBoIdListStr)) {
                argAttFileBoIds = Arrays.stream(attFileBoIdListStr.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            }
            if ((calAllPersonWhenFileEmptyStr = map.get("calAllFileWhenFileEmptyStr")) != null && WTCStringUtils.isNotEmpty((String)calAllPersonWhenFileEmptyStr.toString())) {
                this.calAllFileWhenFileEmpty = Boolean.parseBoolean(calAllPersonWhenFileEmptyStr.toString());
            }
            this.init(argCalStartDate, argCalEndDate, argQtTypeIdSet, argAttFileBoIds);
        }
    }

    @Override
    protected void fillParamMap(Map<String, Object> paramMap) {
        if (this.tiePlanId != 0L) {
            paramMap.put("tiePlanId", this.tiePlanId);
        }
        if (this.planId != 0L) {
            paramMap.put("planId", this.planId);
        }
    }

    @Override
    protected void fillQTTypeIdList(long attOrgId, String qtTypeNumbers, List<Long> qtTypeIds, List<Long> dyQtTypeIds) {
        qtTypeIds.addAll(this.fixTypeIds);
        dyQtTypeIds.addAll(this.dyTypeIds);
    }

    @Override
    protected Date getExpectStartDate() {
        return this.calStartDate;
    }

    @Override
    protected Date getExpectEndDate() {
        return this.calEndDate;
    }

    @Override
    protected List<DynamicObject> getAccountFileBoNewestVersion(Date expectStartDate, Date expectEndDate) {
        if (this.attFileBoIds.isEmpty()) {
            if (this.calAllFileWhenFileEmpty) {
                return super.getAccountFileBoNewestVersion(expectStartDate, expectEndDate);
            }
            return new ArrayList<DynamicObject>(16);
        }
        return TieTaskHelper.getAttFileBoNewestVersionList(this.attFileBoIds);
    }

    public static long startTaskWithParam(Date expectStartDate, Date expectEndDate, Set<Long> qtTypeIds, Set<Long> attFileBoIds, Map<String, Object> param) {
        QTTaskGenerator taskGenerator = QTTaskGenerator.newTaskGenerator(expectStartDate, expectEndDate, qtTypeIds, attFileBoIds);
        if (taskGenerator != null) {
            return taskGenerator.executeRetTaskId(RequestContext.get(), param);
        }
        return 0L;
    }

    public static QTTaskGenerator newTaskGenerator(Date expectStartDate, Date expectEndDate, Set<Long> qtTypeIdSet, Set<Long> attFileBoIds) {
        if (expectStartDate == null || expectEndDate == null || WTCCollections.isEmpty(qtTypeIdSet) || WTCCollections.isEmpty(attFileBoIds)) {
            return null;
        }
        if (expectStartDate.after(expectEndDate)) {
            return null;
        }
        QTTaskGenerator taskGenerator = new QTTaskGenerator();
        taskGenerator.fromMethodCall = true;
        taskGenerator.init(expectStartDate, expectEndDate, qtTypeIdSet, attFileBoIds);
        return taskGenerator;
    }

    private void init(Date expectStartDate, Date expectEndDate, Set<Long> qtTypeIdSet, Set<Long> attFileBoIdSet) {
        DynamicObject[] qtTypeArr;
        if (expectStartDate == null || expectEndDate == null || WTCCollections.isEmpty(qtTypeIdSet) || WTCCollections.isEmpty(attFileBoIdSet)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_qttype");
        for (DynamicObject qtType : qtTypeArr = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", qtTypeIdSet).toArray())) {
            String genType = qtType.getString("gentype");
            if ("A".equals(genType)) {
                this.fixTypeIds.add(qtType.getLong("id"));
                continue;
            }
            if (!"B".equals(genType)) continue;
            this.dyTypeIds.add(qtType.getLong("id"));
        }
        this.calStartDate = expectStartDate;
        this.calEndDate = expectEndDate;
        this.attFileBoIds = attFileBoIdSet;
    }
}

