/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtte.business.qttask.QTTaskStartReq;
import kd.sdk.wtc.wtte.business.qttask.QTTaskStartRes;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.common.util.MapBuilder;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtte.business.tietask.TieTaskHelper;
import kd.wtc.wtte.business.timedtask.QtTieTimingTask;
import kd.wtc.wtte.common.enums.qt.QTTaskErrorInfo;

public class QTTaskSDKGenerator
extends QtTieTimingTask {
    private boolean fromMethodCall = false;
    private long orgId;
    private String genMode;
    private Date calStartDate;
    private Date calEndDate;
    private long qtTiePlanId;
    private long tiePlanId;
    private boolean saveStep;
    private String desc;
    private List<DynamicObject> attFileBoNewestVersionList;
    private final Set<Long> fixTypeIds = new HashSet<Long>(16);
    private final Set<Long> dyTypeIds = new HashSet<Long>(16);

    private QTTaskStartRes init(QTTaskStartReq req) {
        if (req.getOrgId() != 0L) {
            this.orgId = req.getOrgId();
        }
        if (WTCStringUtils.isEmpty((String)req.getGenMode())) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.GEN_MODE_LACK);
        }
        if (!"A".equals(req.getGenMode()) && !"B".equals(req.getGenMode())) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.GEN_MODE_FORMAT);
        }
        this.genMode = req.getGenMode();
        if (WTCStringUtils.isEmpty((String)req.getCalPeriod())) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.CAL_PERIOD_LACK);
        }
        if ("A".equals(req.getGenMode()) && QTTaskSDKGenerator.matchYYYY(req.getCalPeriod())) {
            this.calStartDate = WTCDateUtils.str2Date((String)req.getCalPeriod(), (String)"yyyy");
        } else if ("B".equals(req.getGenMode()) && QTTaskSDKGenerator.matchYYYYMM(req.getCalPeriod())) {
            this.calStartDate = WTCDateUtils.str2Date((String)req.getCalPeriod(), (String)"yyyy-MM");
        } else {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.CAL_PERIOD_FORMAT);
        }
        this.calEndDate = WTCDateUtils.getEndDayOfYear((Date)this.calStartDate);
        HRBaseServiceHelper planDao = new HRBaseServiceHelper("wtp_accountplan");
        if (req.getQtTiePlanId() == 0L) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.QT_TIE_PLAN_ID_LACK);
        }
        this.qtTiePlanId = planDao.isExists(new QFilter("id", "=", (Object)req.getQtTiePlanId())) ? req.getQtTiePlanId() : AccountPlanUtil.queryQuotaDefaultPlanId().longValue();
        if (req.getTiePlanId() == 0L) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.TIE_PLAN_ID_LACK);
        }
        this.tiePlanId = planDao.isExists(new QFilter("id", "=", (Object)req.getTiePlanId())) ? req.getTiePlanId() : SystemParamQueryUtil.getDefaultTiePlanId();
        this.saveStep = req.isSaveStep();
        this.desc = req.getDesc();
        if (this.desc != null && this.desc.length() > 200) {
            this.desc = this.desc.substring(0, 200);
        }
        if (WTCCollections.isEmpty((Collection)req.getAttFileBoIds())) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.ATT_FILE_BO_ID_LACK);
        }
        this.attFileBoNewestVersionList = TieTaskHelper.getAttFileBoNewestVersionList(req.getAttFileBoIds());
        if (WTCCollections.isEmpty(this.attFileBoNewestVersionList)) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.ATT_FILE_BO_ID_NOT_FOUND);
        }
        if (WTCCollections.isEmpty((Collection)req.getQtTypeIds())) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.QT_TYPE_ID_LACK);
        }
        boolean existQtType = this.initQTType(req.getQtTypeIds());
        if (!existQtType) {
            return QTTaskSDKGenerator.error(QTTaskErrorInfo.QT_TYPE_ID_NOT_MATCH);
        }
        return null;
    }

    public static QTTaskStartRes genAndStartTask(QTTaskStartReq req) {
        QTTaskSDKGenerator generator = new QTTaskSDKGenerator();
        generator.fromMethodCall = true;
        QTTaskStartRes errRes = generator.init(req);
        if (errRes != null) {
            return errRes;
        }
        Map argMap = MapBuilder.newInstance((String)"savestep", (Object)generator.saveStep).setAttribute("desc", (Object)generator.desc).toMap();
        long taskId = generator.executeRetTaskId(RequestContext.get(), argMap);
        QTTaskStartRes res = new QTTaskStartRes();
        res.setSuccess(true);
        res.setTaskId(taskId);
        return res;
    }

    @Override
    protected void beforeGenTask(RequestContext requestContext, Map<String, Object> map) {
        if (!this.fromMethodCall) {
            QTTaskStartRes errInfo;
            String tmpQtTypeIds;
            Object tmpSaveStep;
            JSONObject tiePlanJson;
            String tmpTiePlanId;
            JSONObject qtTiePlanJson;
            JSONObject orgJson;
            QTTaskStartReq req = new QTTaskStartReq();
            String tmpOrgId = (String)map.get("org");
            if (WTCStringUtils.isNotEmpty((String)tmpOrgId) && (orgJson = JSON.parseObject((String)tmpOrgId)).containsKey((Object)"id")) {
                req.setOrgId(orgJson.getLong("id").longValue());
            }
            req.setGenMode((String)map.get("genType"));
            req.setCalPeriod((String)map.get("calPeriod"));
            String tmpQtTiePlanId = (String)map.get("qtTiePlan");
            if (WTCStringUtils.isNotEmpty((String)tmpQtTiePlanId) && (qtTiePlanJson = JSON.parseObject((String)tmpQtTiePlanId)) != null && qtTiePlanJson.containsKey((Object)"id")) {
                req.setQtTiePlanId(qtTiePlanJson.getLong("id").longValue());
            }
            if (WTCStringUtils.isNotEmpty((String)(tmpTiePlanId = (String)map.get("tiePlan"))) && (tiePlanJson = JSON.parseObject((String)tmpTiePlanId)) != null && tiePlanJson.containsKey((Object)"id")) {
                req.setTiePlanId(tiePlanJson.getLong("id").longValue());
            }
            if ((tmpSaveStep = map.get("savestep")) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u50a8\u6838\u7b97\u6b65\u9aa4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QTTaskSDKGenerator_0", (String)"wtc-wtte-business", (Object[])new Object[0]));
            }
            req.setSaveStep(Boolean.parseBoolean(tmpSaveStep.toString()));
            req.setDesc((String)map.get("desc"));
            String tmpAttFileBoIds = (String)map.get("attFileBoIds");
            if (WTCStringUtils.isNotEmpty((String)tmpAttFileBoIds)) {
                Set attFileBoIds = Arrays.stream(tmpAttFileBoIds.split(",")).map(Long::parseLong).collect(Collectors.toSet());
                req.setAttFileBoIds(attFileBoIds);
            }
            if (WTCStringUtils.isNotEmpty((String)(tmpQtTypeIds = (String)map.get("qtTypeIds")))) {
                Set argQtTypeIdSet = Arrays.stream(tmpQtTypeIds.split(",")).map(Long::parseLong).collect(Collectors.toSet());
                req.setQtTypeIds(argQtTypeIdSet);
            }
            if ((errInfo = this.init(req)) != null) {
                throw new KDBizException(errInfo.getErrMsg());
            }
            map.put("savestep", this.saveStep);
            map.put("desc", this.desc);
        }
    }

    @Override
    protected long getAttOrgId() {
        if (this.orgId != 0L) {
            long oldOrgId = RequestContext.get().getOrgId();
            RequestContext.get().setOrgId(this.orgId);
            long retOrgId = super.getAttOrgId();
            RequestContext.get().setOrgId(oldOrgId);
            return retOrgId;
        }
        return super.getAttOrgId();
    }

    private boolean initQTType(Set<Long> argQtTypeIdSet) {
        DynamicObject[] qtTypeArr;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_qttype");
        QFilter filter = new QFilter("id", "in", argQtTypeIdSet).and("gentype", "=", (Object)this.genMode);
        for (DynamicObject qtType : qtTypeArr = serviceHelper.loadDynamicObjectArray(filter.toArray())) {
            String genType = qtType.getString("gentype");
            if ("A".equals(genType)) {
                this.fixTypeIds.add(qtType.getLong("id"));
                continue;
            }
            if (!"B".equals(genType)) continue;
            this.dyTypeIds.add(qtType.getLong("id"));
        }
        return WTCCollections.isNotEmpty(this.fixTypeIds) || WTCCollections.isNotEmpty(this.dyTypeIds);
    }

    @Override
    protected void fillParamMap(Map<String, Object> paramMap) {
        paramMap.put("tiePlanId", this.tiePlanId);
        paramMap.put("planId", this.qtTiePlanId);
    }

    @Override
    protected void fillQTTypeIdList(long attOrgId, String qtTypeNumbers, List<Long> qtTypeIds, List<Long> dyQtTypeIds) {
        qtTypeIds.addAll(this.fixTypeIds);
        dyQtTypeIds.addAll(this.dyTypeIds);
    }

    @Override
    protected Date getExpectStartDate() {
        return this.calStartDate;
    }

    @Override
    protected Date getExpectEndDate() {
        return this.calEndDate;
    }

    @Override
    protected List<DynamicObject> getAccountFileBoNewestVersion(Date expectStartDate, Date expectEndDate) {
        return this.attFileBoNewestVersionList;
    }

    private static QTTaskStartRes error(QTTaskErrorInfo errorInfo) {
        QTTaskStartRes res = new QTTaskStartRes();
        res.setSuccess(false);
        res.setTaskId(0L);
        res.setErrCode(errorInfo.errorCode);
        res.setErrMsg(errorInfo.desc.loadKDString());
        return res;
    }

    private static boolean matchYYYY(String str) {
        char[] chars;
        if (str.length() != 4) {
            return false;
        }
        for (char c : chars = str.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean matchYYYYMM(String str) {
        int i;
        if (str.length() != 7) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!(i != 4 ? c < '0' || c > '9' : c != '-')) continue;
            return false;
        }
        i = (chars[5] - 48) * 10 + (chars[6] - 48);
        return i >= 1 && i <= 12;
    }
}

