/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.utils;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.common.enums.RevisionFunEnum;

public class RevisionHelp {
    public static void openRevisionPage(RevisionFunEnum revisionFunEnum, IFormView view, Object pkId) {
        if (revisionFunEnum == null) {
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("wtte_detailboslist");
        listShowParameter.setBillFormId(revisionFunEnum.getStepPage());
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960");
        styleCss.setHeight("580");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setShowTitle(false);
        listShowParameter.setCaption(revisionFunEnum.getValue() + RevisionKDStringHelper.detail());
        listShowParameter.setHasRight(true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter revisionIdFilter = new QFilter("revisionhisid", "=", pkId);
        listFilterParameter.setFilter(revisionIdFilter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static Date getMaxOrMinDate(List<DynamicObject> dynamicObjectList, boolean isMin) {
        Date date = isMin ? WTCHisServiceHelper.getMaxEndDate() : WTCHisServiceHelper.getMinEndDate();
        for (DynamicObject dynamicObject : dynamicObjectList) {
            Date startDate = dynamicObject.getDate("revisionstartdate");
            Date endDate = dynamicObject.getDate("revisionenddate");
            if (startDate == null || endDate == null) continue;
            if (!isMin && endDate.getTime() >= date.getTime()) {
                date = endDate;
            }
            if (!isMin || startDate.getTime() > date.getTime()) continue;
            date = startDate;
        }
        return date;
    }

    public static Set<Object> getAttItemIds(DynamicObject dynamicObject) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        if (dynamicObject.get("attitem") instanceof DynamicObjectCollection) {
            DynamicObjectCollection attItems = dynamicObject.getDynamicObjectCollection("attitem");
            if (CollectionUtils.isEmpty((Collection)attItems)) {
                return ids;
            }
            for (DynamicObject attItem : attItems) {
                DynamicObject baseData = attItem.getDynamicObject("fbasedataid");
                ids.add(baseData.getLong("boid"));
            }
        } else {
            DynamicObject attItem = dynamicObject.getDynamicObject("attitem");
            if (attItem == null) {
                return ids;
            }
            ids.add(attItem.getLong("boid"));
        }
        return ids;
    }

    public static List<DynamicObject> queryAttFileBaseData(Set<Long> fileBoIds) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        attFileQueryParam.setSetBoIds(fileBoIds);
        attFileQueryParam.setProperties("startdate,enddate,boid");
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }
}

