/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.utils.RevisionHelp;
import kd.wtc.wtte.common.enums.RevisionFunEnum;

public class RevisionInitData {
    protected static final Set<String> STATUS_LIST = Sets.newHashSet((Object[])new String[]{"C", "B"});
    private static final HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("wtte_periodreset");
    private static final HRBaseServiceHelper dayHelper = new HRBaseServiceHelper("wtte_daydetailreset");
    private static final String QUERY_PORP = "id,number,entryentity.startdate,entryentity.enddate,entryentity.attfilebase.boid,entryentity.attitem.fbasedataid.boid";
    private Date startDate;
    private Date endDate;
    private DynamicObject[] resetDyList;
    private List<Map<String, Object>> resetMapList;
    private Set<Long> attfileBoIdSet;

    public static RevisionInitData of(List<DynamicObject> dynamicObjectList, RevisionFunEnum revisionFunEnum) {
        RevisionInitData revisionInitData = new RevisionInitData();
        revisionInitData.startDate = RevisionHelp.getMaxOrMinDate(dynamicObjectList, true);
        revisionInitData.endDate = RevisionHelp.getMaxOrMinDate(dynamicObjectList, false);
        HashSet attfileBoIdSet = Sets.newHashSetWithExpectedSize((int)16);
        dynamicObjectList.forEach(ob -> {
            DynamicObjectCollection dynamicObjectCollection = ob.getDynamicObjectCollection("entryentity");
            attfileBoIdSet.addAll(dynamicObjectCollection.stream().map(cur -> cur.getLong("attfilebase.boid")).collect(Collectors.toSet()));
        });
        revisionInitData.attfileBoIdSet = attfileBoIdSet;
        HRBaseServiceHelper workServiceHelper = HRStringUtils.equals((String)revisionFunEnum.getCode(), (String)"day") ? dayHelper : periodHelper;
        revisionInitData.resetDyList = workServiceHelper.queryOriginalArray(QUERY_PORP, RevisionInitData.getCondition(attfileBoIdSet, revisionInitData.startDate, revisionInitData.endDate, dynamicObjectList));
        revisionInitData.resetMapList = RevisionInitData.dynamicObjectToMap(revisionInitData);
        return revisionInitData;
    }

    private static List<Map<String, Object>> dynamicObjectToMap(RevisionInitData revisionInitData) {
        DynamicObject[] resetDyList;
        ArrayList resetMapList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : resetDyList = revisionInitData.resetDyList) {
            resetMapList.add(WTCDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject));
        }
        return resetMapList;
    }

    private static QFilter[] getCondition(Collection<Long> attfileBoIdSet, Date fromDate, Date toDate, Collection<DynamicObject> dynamicObjects) {
        QFilter attPersonIdsFilter = new QFilter("entryentity.attfilebase", "in", attfileBoIdSet);
        QFilter billStatus = new QFilter("status", "in", STATUS_LIST);
        QFilter dateFilter = new QFilter("entryentity.startdate", "<=", (Object)toDate).and(new QFilter("entryentity.enddate", ">=", (Object)fromDate));
        List pkIds = dynamicObjects.stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
        QFilter noContianPkIdsFilter = new QFilter("id", "not in", pkIds);
        return new QFilter[]{attPersonIdsFilter, dateFilter, billStatus, noContianPkIdsFilter};
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DynamicObject[] getResetDyList() {
        return this.resetDyList;
    }

    public Set<Long> getAttfileBoIdSet() {
        return this.attfileBoIdSet;
    }

    public List<Map<String, Object>> getResetMapList() {
        return this.resetMapList;
    }
}

