/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.viewcalsteps;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportOperationColumn;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtte.business.attrecord.report.AttRecordDailyRptExtPlugin;
import kd.sdk.wtc.wtte.business.attrecord.report.AttRecordRptExtPlugin;
import kd.sdk.wtc.wtte.business.attrecord.report.OnGetBaseQFiltersEvent;
import kd.sdk.wtc.wtte.business.attrecord.report.OnGetBaseSortEvent;
import kd.sdk.wtc.wtte.business.attrecord.report.OnGetDetailQFiltersEvent;
import kd.sdk.wtc.wtte.business.attrecord.report.OnGetDetailSortEvent;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.auth.WTCDataPermissionServiceImpl;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.web.attperiod.AttPeriodDetailService;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.jsondto.AttitemJsonDto;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.viewcalsteps.AttRecordUtils;
import kd.wtc.wtte.common.constants.IAttRecordReportConstants;

public class AttRecordService
implements IAttRecordReportConstants {
    private static final Log log = LogFactory.getLog(AttRecordService.class);
    private static HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("wtte_datajson");
    private static final String WTC_WTTE_BUSINESS = "wtc-wtte-business";
    private static final int ATTPERIOD_MAX_COUNT = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtte.RF.attPeriod.maxCount", Integer.valueOf(100));

    private AttRecordService() {
        throw new IllegalStateException("Utility class");
    }

    private static void convertQfLiter(DynamicObjectCollection filterDyCollection, String attFileId, List<QFilter> qFilterList) {
        if (filterDyCollection == null) {
            return;
        }
        List fileBoIds = filterDyCollection.stream().map(dyn -> dyn.get("boid")).collect(Collectors.toList());
        qFilterList.add(new QFilter(attFileId, "in", fileBoIds));
    }

    public static void genShowPageByLinkClick(IFormPlugin formPlugin, HyperLinkClickEvent event, HRBaseServiceHelper serviceHelper, IFormView view) {
        String fieldName = event.getFieldName();
        DynamicObject rowData = event.getRowData();
        Long rowId = rowData.getLong("id");
        switch (fieldName) {
            case "personid": {
                AttRecordService.genShowAttFilePage(formPlugin, event, view);
                break;
            }
            case "shift": {
                AttRecordService.genShowShiftPage(rowData.getLong("shift.id"), view);
                break;
            }
            case "attitemname": {
                AttRecordService.genShowAttItemPage(rowId, view, serviceHelper);
                break;
            }
        }
    }

    public static void genShowPageByOpareteColumn(String operateKey, IFormView view, HRBaseServiceHelper serviceHelper) {
        switch (operateKey) {
            case "showhistory": {
                AttRecordService.genShowAttRecordHisPage((Long)AttRecordService.getCurrentDataFromCache(view).get("id"), view, serviceHelper);
                break;
            }
            case "showcalculate": {
                AttRecordService.genShowViewCalculateStepPage((Long)AttRecordService.getCurrentDataFromCache(view).get("id"), view, serviceHelper);
                break;
            }
            case "showdetails": {
                AttRecordService.genShowRecordDetails(view, AttRecordService.getCurrentDataFromCache(view));
                break;
            }
            case "showsumhistory": {
                AttRecordService.genShowRecordSumHis(view, AttRecordService.getCurrentDataFromCache(view));
                break;
            }
        }
    }

    public static void cacheCurrentData(IFormView view, DynamicObject rowData) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("personid.id", rowData.getLong("attfile.id"));
        map.put("attperiod.id", rowData.getLong("attperiod.id"));
        map.put("attitemname.id", rowData.getLong("attitemname.id"));
        map.put("id", rowData.getLong("id"));
        map.put("con_org", rowData.get("orgid.id"));
        new WTCPageCache(view).put("currentRowData", (Object)map);
    }

    private static Map<String, Object> getCurrentDataFromCache(IFormView view) {
        Map currentRowData = (Map)new WTCPageCache(view).get("currentRowData", Map.class);
        if (null == currentRowData) {
            return Collections.emptyMap();
        }
        return currentRowData;
    }

    private static void genShowRecordSumHis(IFormView view, Map<String, Object> rowData) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("wtte_attrecordlist");
        parameter.setBillFormId("wtctd_atttotaldetailhis");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800");
        styleCss.setHeight("600");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        qFilters.add(new QFilter("attmain.attfileid", "=", rowData.get("personid.id")));
        qFilters.add(new QFilter("perattperiodid.id", "=", rowData.get("attperiod.id")));
        qFilters.add(new QFilter("attitemvid.id", "=", rowData.get("attitemname.id")));
        parameter.getListFilterParameter().setQFilters((List)qFilters);
        view.showForm((FormShowParameter)parameter);
    }

    private static void genShowViewCalculateStepPage(Long rowId, IFormView view, HRBaseServiceHelper serviceHelper) {
        DynamicObject dynamicObject = serviceHelper.queryOne("attmain.personid,attitemid,attmain.versionid,sourceattitemids,owndate", (Object)rowId);
        if (AttRecordService.checkNullNotice(dynamicObject, view)) {
            return;
        }
        String sourceAttItemIds = dynamicObject.getString("sourceattitemids");
        if (WTCStringUtils.isEmpty((String)sourceAttItemIds) || WTCStringUtils.equals((String)sourceAttItemIds, (String)"0")) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u8003\u52e4\u9879\u76ee\u4e0d\u652f\u6301\u5b58\u50a8\u6838\u7b97\u6b65\u9aa4\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"AttRecordService_12", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0]);
            view.showTipNotification(message);
            return;
        }
        String[] split = sourceAttItemIds.split(",");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("parentIds", Arrays.stream(split).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList()));
        params.put("personid", dynamicObject.getLong("attmain.personid.id"));
        params.put("attitemid", dynamicObject.getLong("attitemid.id"));
        params.put("owndate", dynamicObject.getDate("owndate"));
        params.put("versionid", dynamicObject.getString("attmain.versionid"));
        DynamicObject[] query = hrServiceHelper.query(new QFilter[]{new QFilter("personid", "=", (Object)dynamicObject.getLong("attmain.personid.id")), new QFilter("owndate", "=", (Object)dynamicObject.getDate("owndate")), new QFilter("version", "=", (Object)dynamicObject.getString("attmain.versionid"))});
        if (query.length == 0) {
            String message = ResManager.loadKDString((String)"\u672a\u5728\u8003\u52e4\u6838\u7b97\u4efb\u52a1\u4e2d\u5f00\u542f\u201c\u5b58\u50a8\u6838\u7b97\u6b65\u9aa4\u201d\uff0c\u65e0\u6cd5\u67e5\u770b\u6838\u7b97\u6b65\u9aa4\u3002", (String)"AttRecordService_1", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0]);
            view.showTipNotification(message);
            return;
        }
        if (query.length > 1) {
            String message = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u6838\u7b97\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u4efb\u52a1\u62a5\u544a\u3002", (String)"AttRecordService_2", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0]);
            view.showErrorNotification(message);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtte_viewcalculatestep");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParams(params);
        String personname = dynamicObject.getString("attmain.personid.name");
        String message = ResManager.loadKDString((String)"\u6838\u7b97\u6b65\u9aa4-", (String)"AttRecordService_3", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0]);
        formShowParameter.setCaption(message + personname);
        view.showForm(formShowParameter);
    }

    private static void genShowAttRecordHisPage(Long rowId, IFormView view, HRBaseServiceHelper serviceHelper) {
        DynamicObject dynamicObject = serviceHelper.queryOne("attmain.personid,owndate,attitemtype,attitemid", (Object)rowId);
        if (AttRecordService.checkNullNotice(dynamicObject, view)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Integer personId = dynamicObject.getDynamicObject("attmain.personid") == null ? Integer.valueOf(0) : dynamicObject.getDynamicObject("attmain.personid").getPkValue();
        params.put("personid", personId);
        params.put("owndate", dynamicObject.getDate("owndate"));
        Integer attItemId = dynamicObject.getDynamicObject("attitemid") == null ? Integer.valueOf(0) : dynamicObject.getDynamicObject("attitemid").getPkValue();
        params.put("attitemid", attItemId);
        params.put("attitemtype", dynamicObject.getString("attitemtype"));
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("wtte_attrecordlist");
        parameter.setBillFormId("wtdtd_attrecorddetailhis");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800");
        styleCss.setHeight("600");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.setMultiSelect(true);
        parameter.setCustomParams(params);
        view.showForm((FormShowParameter)parameter);
    }

    private static void genShowAttItemPage(Long rowId, IFormView view, HRBaseServiceHelper serviceHelper) {
        DynamicObject attItem = serviceHelper.queryOne("attitemid", new QFilter[]{new QFilter("id", "=", (Object)rowId)});
        if (AttRecordService.checkNullNotice(attItem, view)) {
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("wtbd_attitem");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        Object attItemId = attItem.getDynamicObject("attitemid").getPkValue();
        parameter.setPageId(view.getPageId() + "-" + attItemId);
        parameter.setPkId(attItemId);
        parameter.setCustomParam("checkRightAppId", (Object)"wtp");
        view.showForm((FormShowParameter)parameter);
    }

    private static void genShowShiftPage(Long pkId, IFormView view) {
        if (AttRecordService.checkNullNotice(pkId, view)) {
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("wtbd_shift");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPageId(view.getPageId() + "-" + pkId);
        parameter.setPkId((Object)pkId);
        parameter.setCustomParam("checkRightAppId", (Object)"wtp");
        view.showForm((FormShowParameter)parameter);
    }

    public static void genShowAttFilePage(IFormPlugin formplugin, HyperLinkClickEvent event, IFormView view) {
        DynamicObject rowData = event.getRowData();
        long attFileVid = "wtte_dailydetailslist".equals(rowData.getDataEntityType().getName()) ? rowData.getLong("attfilevid") : rowData.getLong("attfilevid_id");
        List dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(AttFileQueryParam.usuallyProperties, Collections.singletonList(attFileVid));
        if (WTCCollections.isNotEmpty((Collection)dynamicObjects)) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            if (dynamicObject == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6c47\u603b\u8bb0\u5f55\u4eba\u5458\u7684\u5386\u53f2\u6863\u6848\u3002", (String)"AttRecordService_4", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0]));
            } else {
                Long attFileId = dynamicObject.getLong("id");
                AttFileBusiness.showAttFileDetailForm((IFormView)view, (IFormPlugin)formplugin, null, (Object)attFileId);
            }
        }
    }

    private static void genShowRecordDetails(IFormView view, Map<String, Object> rowData) {
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("wtte_recordreport");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.addFilterItem("con_attperiod", rowData.get("attperiod.id"));
        filterInfo.addFilterItem("con_attperson", rowData.get("personid.id"));
        filterInfo.addFilterItem("con_org", rowData.get("con_org"));
        try {
            DynamicObject dy = new HRBaseServiceHelper("wtbd_attitem").queryOriginalOne("boid", new QFilter("id", "=", rowData.get("attitemname.id")));
            long boId = dy.getLong("boid");
            filterInfo.addFilterItem("con_attitem", (Object)boId);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filterInfo);
        reportShowParameter.setQueryParam(queryParam);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }

    public static String genAttItemStr(List<AttitemJsonDto> attItemJsonDtoList) {
        StringBuilder sBuilder = new StringBuilder();
        DynamicObject[] attItemDys = AttRecordService.queryAttItemName(attItemJsonDtoList);
        for (AttitemJsonDto attItemJsonDto : attItemJsonDtoList) {
            int tempSeconds = null != attItemJsonDto.getSecondDecimal() ? attItemJsonDto.getSecondDecimal().intValue() : attItemJsonDto.getSeconds();
            String dateStr = WTCDateUtils.secondToTime((long)tempSeconds, (String)"h:m:s");
            Arrays.stream(attItemDys).filter(attItemDy -> attItemDy.getPkValue().equals(attItemJsonDto.getAttitemId())).forEach(attItemDy -> AttRecordService.bulitStr(sBuilder, attItemDy, dateStr, attItemJsonDto));
        }
        return sBuilder.toString();
    }

    private static void bulitStr(StringBuilder sBuilder, DynamicObject dynamicObject, String dateStr, AttitemJsonDto attItemJsonDto) {
        sBuilder.append(ResManager.loadKDString((String)"\u7f16\u7801\uff1a", (String)"AttRecordService_5", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])).append(attItemJsonDto.getNumber()).append(",".toCharArray()).append(ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0\uff1a", (String)"AttRecordService_6", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])).append(dynamicObject.getString("name")).append(",".toCharArray()).append(ResManager.loadKDString((String)"\u65f6\u957f\uff1a", (String)"AttRecordService_7", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])).append(dateStr).append(",".toCharArray()).append(ResManager.loadKDString((String)"\u5929\u6570\uff1a", (String)"AttRecordService_8", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])).append(attItemJsonDto.getDay().setScale(6, 4).stripTrailingZeros().toPlainString()).append("\uff1b".toCharArray()).append('\n');
    }

    private static DynamicObject[] queryAttItemName(List<AttitemJsonDto> attItemJsonDtoList) {
        ArrayList attItemIds = Lists.newArrayListWithCapacity((int)attItemJsonDtoList.size());
        attItemJsonDtoList.forEach(attitemJsonDto -> attItemIds.add(attitemJsonDto.getAttitemId()));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_attitem");
        return helper.query("name", new QFilter[]{new QFilter("id", "in", (Object)attItemIds)});
    }

    public static void genShowDailyRecord(HyperLinkClickEvent event, IFormView view) {
        DynamicObject rowData = event.getRowData();
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("wtte_dailydetailslist");
        FilterInfo filterInfo = new FilterInfo();
        AttRecordService.setAttFileF7Data(rowData, filterInfo);
        filterInfo.addFilterItem("attperiodentry", rowData.get("perattperiodid"));
        filterInfo.addFilterItem("con_showplan", (Object)view.getModel().getDataEntity().getLong("con_showplan.dailydetscheme.id"));
        filterInfo.addFilterItem("frozen", (Object)"0");
        filterInfo.addFilterItem("lock", (Object)"0");
        filterInfo.addFilterItem("con_org", rowData.get("orgid.id"));
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filterInfo);
        reportShowParameter.setQueryParam(queryParam);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }

    public static void setAttFileF7Data(DynamicObject rowData, FilterInfo filterInfo) {
        filterInfo.addFilterItem("attperinf", (Object)rowData.getLong("attfileid"));
    }

    public static void genShowRecordSum(IFormView view, FilterInfo filterInfo) {
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("wtte_recordsumreport");
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filterInfo);
        reportShowParameter.setQueryParam(queryParam);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }

    public static void genShowRecord(IFormView view, FilterInfo filterInfo) {
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("wtte_recordreport");
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filterInfo);
        reportShowParameter.setQueryParam(queryParam);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }

    public static void setColumnFreezeAndHide(ReportColumn rColumn, List<AbstractReportColumn> columns, int seq) {
        String key;
        switch (key = rColumn.getFieldKey()) {
            case "calculatedate": {
                rColumn.setFieldType("date");
                DateFormatObject dateFormatObject = new DateFormatObject();
                dateFormatObject.setDateFormat("yyyy-MM-dd HH:mm:ss");
                FormatObject formatObject = new FormatObject();
                formatObject.setDateFormat(dateFormatObject);
                rColumn.setUserFormat(formatObject);
                break;
            }
            case "personid": 
            case "attpersonnumber": 
            case "attperiod": 
            case "ascriptionyear": 
            case "ascriptionmonth": 
            case "owndate": {
                rColumn.setFreeze(true);
                columns.set(seq, (AbstractReportColumn)rColumn);
                break;
            }
            case "showsumhistory": {
                if (AttRecordService.isSaveSumHis("checkboxfield1")) break;
                rColumn.setHide(true);
                columns.set(seq, (AbstractReportColumn)rColumn);
                break;
            }
            case "showhistory": {
                if (AttRecordService.isSaveSumHis("checkboxfield")) break;
                rColumn.setHide(true);
                columns.set(seq, (AbstractReportColumn)rColumn);
                break;
            }
        }
    }

    public static boolean isSaveSumHis(String key) {
        long orgId = RequestContext.get().getOrgId();
        String appId = AppMetadataCache.getAppInfo((String)"wtte").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        Boolean isSaveSumHis = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
        return isSaveSumHis == null ? false : isSaveSumHis;
    }

    public static void operationColumn(AbstractReportColumn column) {
        if (((ReportOperationColumn)column).getFieldKey().equals("operationcolumnap")) {
            ReportOperationColumn operationColumn = (ReportOperationColumn)column;
            ArrayList colItems = Lists.newArrayList();
            if (AttRecordService.isSaveSumHis("checkboxfield")) {
                OperationColItem showHistory = new OperationColItem();
                showHistory.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u5386\u53f2", (String)"AttRecordService_9", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])));
                showHistory.setOperationKey("showhistory");
                showHistory.setId("showhistory");
                colItems.add(showHistory);
            }
            OperationColItem showCalculate = new OperationColItem();
            showCalculate.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u6b65\u9aa4", (String)"AttRecordService_10", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])));
            showCalculate.setOperationKey("showcalculate");
            showCalculate.setId("showcalculate");
            colItems.add(showCalculate);
            if (CollectionUtils.isEmpty((Collection)colItems)) {
                operationColumn.setHide(true);
            } else {
                operationColumn.setOperationColItems((List)colItems);
            }
        }
    }

    public static void sumOperationColumn(AbstractReportColumn column) {
        if (((ReportOperationColumn)column).getFieldKey().equals("operationcolumnap")) {
            ReportOperationColumn operationColumn = (ReportOperationColumn)column;
            ArrayList colItems = Lists.newArrayList();
            OperationColItem showCalculate = new OperationColItem();
            showCalculate.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u660e\u7ec6\u9879\u76ee", (String)"AttRecordService_11", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])));
            showCalculate.setOperationKey("showdetails");
            showCalculate.setId("showdetails");
            colItems.add(showCalculate);
            if (AttRecordService.isSaveSumHis("checkboxfield1")) {
                OperationColItem showHistory = new OperationColItem();
                showHistory.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u5386\u53f2", (String)"AttRecordService_9", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0])));
                showHistory.setOperationKey("showsumhistory");
                showHistory.setId("showsumhistory");
                colItems.add(showHistory);
            }
            if (CollectionUtils.isEmpty((Collection)colItems)) {
                operationColumn.setHide(true);
            } else {
                operationColumn.setOperationColItems((List)colItems);
            }
        }
    }

    private static boolean checkNullNotice(Object dyn, IFormView view) {
        if (dyn == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e\u3002", (String)"AttRecordService_0", (String)WTC_WTTE_BUSINESS, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static List<QFilter> getBaseFilter(boolean sum, ReportQueryParam reportQueryParam, String entityNumber, WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin) {
        FilterInfo filter = reportQueryParam.getFilter();
        List<Object> qFilterList = Lists.newArrayListWithCapacity((int)7);
        DynamicObject periodDy = filter.getDynamicObject("con_attperiod");
        if (periodDy != null) {
            AttRecordUtils.addQFilter(periodDy.getLong("id"), "perattperiodid", (List<QFilter>)qFilterList);
            if (!sum) {
                Date periodEndDate;
                Date periodBeginDate = periodDy.getDate("begindate");
                if (null != periodBeginDate) {
                    qFilterList.add(new QFilter("owndate", ">=", (Object)periodBeginDate));
                }
                if (null != (periodEndDate = periodDy.getDate("enddate"))) {
                    qFilterList.add(new QFilter("owndate", "<=", (Object)periodEndDate));
                }
            }
        }
        Date beginDate = filter.getDate("con_begindate");
        Date endDate = filter.getDate("con_enddate");
        if (!sum) {
            if (beginDate != null) {
                qFilterList.add(new QFilter("owndate", ">=", (Object)beginDate));
            }
            if (endDate != null) {
                qFilterList.add(new QFilter("owndate", "<=", (Object)endDate));
            }
        }
        if (sum && beginDate != null && endDate != null) {
            AttRecordService.addAttPeriodFilter(beginDate, endDate, filter.getDynamicObject("con_org"), qFilterList);
        }
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filter, DynamicObject.class, "con_org"), "orgid", (List<QFilter>)qFilterList);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_adminorg"), "attfilevid.adminorg", (List<QFilter>)qFilterList);
        AttRecordService.convertQfLiter(AttRecordUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_attperson"), "attfileid", qFilterList);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_affiliateadminorg"), "attfilevid.affiliateadminorg", (List<QFilter>)qFilterList);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_empgroup"), "attfilevid.empgroup", (List<QFilter>)qFilterList);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = HRAuthService.getInstance().getDataRule(Long.valueOf(currUserId), "wtte", entityNumber, "orgid", "47150e89000000ac", Collections.emptyMap());
        if (null != dataQFilter) {
            qFilterList.add(dataQFilter);
        }
        String commFilterEntityName = sum ? "wtte_attrecordsum_query" : "wtte_attrecord_query";
        QFilter commFilter = (QFilter)filter.getCommFilter().get(commFilterEntityName);
        if (null != commFilter) {
            qFilterList.add(commFilter);
        }
        qFilterList.remove(null);
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins())) {
            qFilterList = AttRecordService.getExtBaseQFilters(extPlugin, qFilterList, reportQueryParam);
        }
        return qFilterList;
    }

    private static void addAttPeriodFilter(Date beginDate, Date endDate, DynamicObject orgDynamicObject, List<QFilter> qFilterList) {
        List attPeriodList = AttRecordService.getAttPeriodsByDateRangeAndOrg(beginDate, endDate, orgDynamicObject.getLong("id"));
        if (CollectionUtils.isEmpty(attPeriodList)) {
            qFilterList.add(new QFilter("perattperiodid", "=", (Object)-1L));
        } else {
            if (attPeriodList.size() > ATTPERIOD_MAX_COUNT) {
                attPeriodList = WTCCollections.subList(attPeriodList, (int)0, (int)ATTPERIOD_MAX_COUNT);
            }
            qFilterList.add(new QFilter("perattperiodid", "in", (Object)attPeriodList));
        }
    }

    private static List<Long> getAttPeriodsByDateRangeAndOrg(Date beginDate, Date endDate, Long orgId) {
        List attPeriodIds = AttPeriodDetailService.getInstance().getAttPeriodIdsByOrgId(orgId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        QFilter[] qFilterArr = new QFilter[]{new QFilter("begindate", "<=", (Object)endDate), new QFilter("enddate", ">=", (Object)beginDate), new QFilter("masterid", "in", (Object)attPeriodIds)};
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", qFilterArr);
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static List<QFilter> getDetailFilter(boolean sum, ReportQueryParam reportQueryParam, WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin) {
        FilterInfo filter = reportQueryParam.getFilter();
        List<Object> qFilterList = Lists.newArrayListWithCapacity((int)7);
        DynamicObject periodDy = filter.getDynamicObject("con_attperiod");
        if (periodDy != null) {
            if (!sum) {
                Date periodBeginDate;
                Date periodEndDate = periodDy.getDate("enddate");
                if (null != periodEndDate) {
                    qFilterList.add(new QFilter("owndate", "<=", (Object)periodEndDate));
                }
                if (null != (periodBeginDate = periodDy.getDate("begindate"))) {
                    qFilterList.add(new QFilter("owndate", ">=", (Object)periodBeginDate));
                }
            } else {
                AttRecordUtils.addQFilter(periodDy.getLong("id"), "perattperiodid", (List<QFilter>)qFilterList);
            }
        }
        Date endDate = filter.getDate("con_enddate");
        Date beginDate = filter.getDate("con_begindate");
        if (!sum) {
            if (endDate != null) {
                qFilterList.add(new QFilter("owndate", "<=", (Object)endDate));
            }
            if (beginDate != null) {
                qFilterList.add(new QFilter("owndate", ">=", (Object)beginDate));
            }
        }
        if (sum && beginDate != null && endDate != null) {
            AttRecordService.addAttPeriodFilter(beginDate, endDate, filter.getDynamicObject("con_org"), (List<QFilter>)qFilterList);
        }
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_attitem"), "attitemid", (List<QFilter>)qFilterList);
        String orginItem = filter.getString("con_orginitem");
        if ("1".equals(orginItem)) {
            qFilterList.add(new QFilter("attitemtype", "=", (Object)"0"));
        } else if ("2".equals(orginItem)) {
            qFilterList.add(new QFilter("attitemtype", "=", (Object)"1"));
        }
        String value = filter.getString("con_value");
        if ("1".equals(value)) {
            qFilterList.add(new QFilter("valuelong", "!=", (Object)0));
        } else if ("2".equals(value)) {
            qFilterList.add(new QFilter("valuelong", "=", (Object)0));
        } else if ("3".equals(value)) {
            String maxValue;
            String minValue = filter.getString("con_minvalue");
            if (WTCStringUtils.isNotEmpty((String)minValue)) {
                qFilterList.add(new QFilter("valuelong", ">=", (Object)new BigDecimal(minValue)));
            }
            if (WTCStringUtils.isNotEmpty((String)(maxValue = filter.getString("con_maxvalue")))) {
                qFilterList.add(new QFilter("valuelong", "<=", (Object)new BigDecimal(maxValue)));
            }
        }
        qFilterList.remove(null);
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins())) {
            qFilterList = AttRecordService.getExtDetailQFilters(extPlugin, (List<QFilter>)qFilterList, reportQueryParam);
        }
        return qFilterList;
    }

    public static String getAliasStr(Set<String> fields, String filed) {
        if (fields.contains(filed)) {
            return filed;
        }
        if ("attmain".equals(filed)) {
            return "fmid";
        }
        return "f" + filed;
    }

    public static List<QFilter> attDayRecordDetailQFilters(ReportQueryParam queryParam, WTCPluginProxy<AttRecordDailyRptExtPlugin> extPlugin) {
        Date ownEndDate;
        Date ownStartDate;
        List<QFilter> qFilters = new ArrayList<QFilter>();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject periodDy = filterInfo.getDynamicObject("attperiodentry");
        if (null != periodDy) {
            qFilters.add(new QFilter("owndate", ">=", (Object)periodDy.getDate("begindate")));
            qFilters.add(new QFilter("owndate", "<=", (Object)periodDy.getDate("enddate")));
        }
        if (null != (ownStartDate = filterInfo.getDate("owndatestart"))) {
            qFilters.add(new QFilter("owndate", ">=", (Object)ownStartDate));
        }
        if (null != (ownEndDate = filterInfo.getDate("owndateend"))) {
            qFilters.add(new QFilter("owndate", "<=", (Object)ownEndDate));
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins())) {
            qFilters = AttRecordService.getExtDetailQFilters(extPlugin, qFilters, queryParam);
        }
        return qFilters;
    }

    public static List<QFilter> attDayRecordBaseQFilters(ReportQueryParam queryParam, WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin) {
        Date ownEndDate;
        Date ownStartDate;
        List<QFilter> qFilters = new ArrayList<QFilter>();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject periodDy = filterInfo.getDynamicObject("attperiodentry");
        if (null != periodDy) {
            qFilters.add(new QFilter("owndate", ">=", (Object)periodDy.getDate("begindate")));
            qFilters.add(new QFilter("owndate", "<=", (Object)periodDy.getDate("enddate")));
            qFilters.add(new QFilter("perattperiodid", "=", periodDy.getPkValue()));
        }
        if (null != (ownStartDate = filterInfo.getDate("owndatestart"))) {
            qFilters.add(new QFilter("owndate", ">=", (Object)ownStartDate));
        }
        if (null != (ownEndDate = filterInfo.getDate("owndateend"))) {
            qFilters.add(new QFilter("owndate", "<=", (Object)ownEndDate));
        }
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObject.class, "con_org"), "orgid", qFilters);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "con_adminorg"), "attfilevid.adminorg", qFilters);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "con_affiliateadminorg"), "attfilevid.affiliateadminorg", qFilters);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "con_empgroup"), "attfilevid.empgroup", qFilters);
        AttRecordService.convertQfLiter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "attperinf"), "attfileid", qFilters);
        QFilter commFilter = (QFilter)filterInfo.getCommFilter().get("wtte_attrecord_query");
        if (null != commFilter) {
            qFilters.add(commFilter);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = WTCDataPermissionServiceImpl.getInstance().getDataRule(Long.valueOf(currUserId), "wtte", "wtdtd_attrecordbase", "orgid", "47150e89000000ac", Collections.emptyMap());
        if (null != dataQFilter) {
            qFilters.add(dataQFilter);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins())) {
            qFilters = AttRecordService.getExtBaseQFilters(extPlugin, qFilters, queryParam);
        }
        return qFilters;
    }

    public static List<QFilter> attPeriodSumBaseQFilters(ReportQueryParam queryParam, WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin) {
        List<QFilter> qFilters = new ArrayList<QFilter>();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject periodDy = filterInfo.getDynamicObject("attperiodentry");
        if (null != periodDy) {
            qFilters.add(new QFilter("perattperiodid", "=", periodDy.getPkValue()));
        }
        Date beginDate = filterInfo.getDate("owndatestart");
        Date endDate = filterInfo.getDate("owndateend");
        if (beginDate != null && endDate != null) {
            AttRecordService.addAttPeriodFilter(beginDate, endDate, filterInfo.getDynamicObject("con_org"), qFilters);
        }
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObject.class, "con_org"), "orgid", qFilters);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "con_adminorg"), "attfilevid.adminorg", qFilters);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "con_affiliateadminorg"), "attfilevid.affiliateadminorg", qFilters);
        AttRecordUtils.addQFilter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "con_empgroup"), "attfilevid.empgroup", qFilters);
        AttRecordService.convertQfLiter(AttRecordUtils.filterDyCollection(filterInfo, DynamicObjectCollection.class, "attperinf"), "attfileid", qFilters);
        QFilter commFilter = (QFilter)filterInfo.getCommFilter().get("wtte_attrecordsum_query");
        if (null != commFilter) {
            qFilters.add(commFilter);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = WTCDataPermissionServiceImpl.getInstance().getDataRule(Long.valueOf(currUserId), "wtte", "wtctd_atttotalbase", "orgid", "47150e89000000ac", Collections.emptyMap());
        if (null != dataQFilter) {
            qFilters.add(dataQFilter);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins())) {
            qFilters = AttRecordService.getExtBaseQFilters(extPlugin, qFilters, queryParam);
        }
        return qFilters;
    }

    public static List<QFilter> attPeriodSumDetailQFilters(ReportQueryParam queryParam, WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin) {
        List<QFilter> qFilters = new ArrayList<QFilter>();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject periodDy = filterInfo.getDynamicObject("attperiodentry");
        if (null != periodDy) {
            qFilters.add(new QFilter("perattperiodid", "=", periodDy.getPkValue()));
        }
        Date beginDate = filterInfo.getDate("owndatestart");
        Date endDate = filterInfo.getDate("owndateend");
        if (beginDate != null && endDate != null) {
            AttRecordService.addAttPeriodFilter(beginDate, endDate, filterInfo.getDynamicObject("con_org"), qFilters);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins())) {
            qFilters = AttRecordService.getExtDetailQFilters(extPlugin, qFilters, queryParam);
        }
        return qFilters;
    }

    public static List<QFilter> getExtDetailQFilters(WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin, List<QFilter> detailFilter, ReportQueryParam reportQueryParam) {
        OnGetDetailQFiltersEvent onGetDetailQFiltersEvent = new OnGetDetailQFiltersEvent(detailFilter, reportQueryParam);
        extPlugin.invokeReplace(service -> service.onGetDetailQFilters(onGetDetailQFiltersEvent));
        List customDefaultQFilterList = onGetDetailQFiltersEvent.getDefaultDetailQFilterList();
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)customDefaultQFilterList)) {
            detailFilter = customDefaultQFilterList;
        }
        return detailFilter;
    }

    public static List<QFilter> getExtBaseQFilters(WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin, List<QFilter> qFilters, ReportQueryParam reportQueryParam) {
        OnGetBaseQFiltersEvent onGetBaseQFiltersEvent = new OnGetBaseQFiltersEvent(qFilters, reportQueryParam);
        extPlugin.invokeReplace(service -> service.onGetBaseQFilters(onGetBaseQFiltersEvent));
        List customBaseQFilterList = onGetBaseQFiltersEvent.getDefaultBaseQFilterList();
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)customBaseQFilterList)) {
            qFilters = customBaseQFilterList;
        }
        return qFilters;
    }

    public static String getExtBaseSort(WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin, String defBaseSort) {
        OnGetBaseSortEvent onGetBaseSortEvent = new OnGetBaseSortEvent(defBaseSort);
        extPlugin.invokeReplace(service -> service.getBaseSort(onGetBaseSortEvent));
        String customBaseSort = onGetBaseSortEvent.getDefBaseSort();
        return customBaseSort;
    }

    public static String getExtDetailSort(WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin, String defDetailSort) {
        OnGetDetailSortEvent onGetDetailSortEvent = new OnGetDetailSortEvent(defDetailSort);
        extPlugin.invokeReplace(service -> service.getDetailSort(onGetDetailSortEvent));
        String customDetailSort = onGetDetailSortEvent.getDefDetailSort();
        return customDetailSort;
    }
}

