/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.ex;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.id.IDService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtte.common.enums.ExConfirmOperateTypeEnum;
import kd.wtc.wtte.business.ex.ExRecordService;
import kd.wtc.wtte.opplugin.web.ex.validator.ExRecordCancelConfirmValidator;

public class ExRecordCancelConfirmOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().addAll(Lists.newArrayList((Object[])new String[]{"recorddate", "punchcardpair", "calversion", "personid", "attitemvalue", "attitemid", "shiftdate", "id", "confirmstatus"}));
    }

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        super.onAddValidators(eventArgs);
        eventArgs.addValidator((AbstractValidator)new ExRecordCancelConfirmValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        for (DynamicObject entity : args.getDataEntities()) {
            entity.set("confirmstatus", (Object)"0");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs event) {
        HRBaseServiceHelper exRecordConfirmService = new HRBaseServiceHelper("wtte_exrecordconfirm");
        DynamicObject[] dataEntities = event.getDataEntities();
        long[] genLongIds = IDService.get().genLongIds(dataEntities.length);
        int idIndex = 0;
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection confirmCollection = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dataEntities) {
            long id = genLongIds[idIndex++];
            DynamicObject confirmDyn = exRecordConfirmService.generateEmptyDynamicObject();
            confirmDyn.set("confirmpeople", (Object)userId);
            confirmDyn.set("confirmtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            confirmDyn.set("recorddate", dynamicObject.get("recorddate"));
            confirmDyn.set("punchcardpair", dynamicObject.get("punchcardpair"));
            confirmDyn.set("calversion", dynamicObject.get("calversion"));
            confirmDyn.set("personid", dynamicObject.get("personid"));
            confirmDyn.set("attitemvalue", dynamicObject.get("attitemvalue"));
            confirmDyn.set("attitemid", dynamicObject.get("attitemid"));
            confirmDyn.set("shiftdate", dynamicObject.get("shiftdate"));
            confirmDyn.set("id", (Object)id);
            confirmDyn.set("islatest", (Object)Boolean.TRUE);
            confirmDyn.set("operatetype", (Object)ExConfirmOperateTypeEnum.CANCEL_CONFIRM.getCode());
            confirmCollection.add((Object)confirmDyn);
        }
        exRecordConfirmService.save(confirmCollection);
        ExRecordService.updateConfirmRecord2Old((List)confirmCollection);
    }
}

